/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.util.cel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import shohaku.core.collections.Parameters;
import shohaku.core.util.cel.DateTimeExpression;
import shohaku.core.util.cel.Expression;
import shohaku.core.util.cel.ListExpression;
import shohaku.core.util.cel.Literal;
import shohaku.core.util.cel.MapExpression;
import shohaku.core.util.cel.ObjectCreateExpression;
import shohaku.core.util.cel.PrimitiveExpression;
import shohaku.core.util.cel.RegexPatternExpression;
import shohaku.core.util.cel.SetExpression;
import shohaku.core.util.cel.StringExpression;

public class CELBinder {
    private final Map expressionMap;
    private final Expression[] expressions;
    private final Locale locale;
    private static final Literal NO_SERIAL = new Literal('\u0000', '\u0000');
    private static final Expression[] baseTypeCreationExpressions;
    private static final CELBinder baseTypeCreationBinder;
    private static final Expression[] collectionCreationExpressions;
    private static final CELBinder collectionCreationBinder;
    private static final Expression[] objectCreationExpressions;
    private static final CELBinder objectCreationBinder;

    static {
        ArrayList<Expression> exps = new ArrayList<Expression>();
        exps.add(new PrimitiveExpression());
        exps.add(new StringExpression());
        exps.add(new DateTimeExpression());
        exps.add(new RegexPatternExpression());
        baseTypeCreationExpressions = exps.toArray(new Expression[0]);
        baseTypeCreationBinder = new CELBinder(baseTypeCreationExpressions);
        exps = new ArrayList();
        exps.add(new PrimitiveExpression());
        exps.add(new StringExpression());
        exps.add(new DateTimeExpression());
        exps.add(new RegexPatternExpression());
        exps.add(new ListExpression());
        exps.add(new SetExpression());
        exps.add(new MapExpression());
        collectionCreationExpressions = exps.toArray(new Expression[0]);
        collectionCreationBinder = new CELBinder(collectionCreationExpressions);
        exps = new ArrayList();
        exps.add(new PrimitiveExpression());
        exps.add(new StringExpression());
        exps.add(new DateTimeExpression());
        exps.add(new RegexPatternExpression());
        exps.add(new ListExpression());
        exps.add(new SetExpression());
        exps.add(new MapExpression());
        exps.add(new ObjectCreateExpression());
        objectCreationExpressions = exps.toArray(new Expression[0]);
        objectCreationBinder = new CELBinder(objectCreationExpressions);
    }

    public CELBinder() {
        this(Locale.getDefault(), new Expression[0]);
    }

    public CELBinder(Expression[] exps) {
        this(Locale.getDefault(), exps, CELBinder.toMappingExpressions(exps));
    }

    public CELBinder(Locale locale, Expression[] exps) {
        this(locale, exps, CELBinder.toMappingExpressions(exps));
    }

    private CELBinder(Locale locale, Expression[] exps, Map fsm) {
        this.expressions = exps;
        this.locale = locale;
        this.expressionMap = fsm;
    }

    public Expression[] getExpressions() {
        return (Expression[])this.expressions.clone();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Object getValue(String expression) {
        return this.getValue(expression, null);
    }

    public Object getValue(String expression, Parameters args) {
        return this.getValue(expression, 0, expression.length(), args);
    }

    public Object getValue(String expression, int begin, int end, Parameters args) {
        return this.executeValue(expression, begin, end, args);
    }

    private Object executeValue(String expression, int begin, int end, Parameters values) {
        char endLiteral;
        char beginLiteral = expression.charAt(begin);
        Literal literal = new Literal(beginLiteral, endLiteral = expression.charAt(end - 1));
        Expression exp = (Expression)this.expressionMap.get(literal);
        if (exp == null) {
            exp = (Expression)this.expressionMap.get(NO_SERIAL);
            return exp.execute(this, NO_SERIAL, expression, begin, end, values);
        }
        return exp.execute(this, literal, expression, begin + 1, end - 1, values);
    }

    public int findNextIndex(String expression, int begin) {
        char beginLiteral = expression.charAt(begin);
        Iterator i = this.expressionMap.entrySet().iterator();
        while (i.hasNext()) {
            Expression exp;
            int end;
            Map.Entry e = i.next();
            Literal literal = (Literal)e.getKey();
            if (beginLiteral != literal.begin || -1 >= (end = (exp = (Expression)e.getValue()).findNextIndex(this, literal, expression, begin))) continue;
            return end;
        }
        Expression exp = (Expression)this.expressionMap.get(NO_SERIAL);
        return exp.findNextIndex(this, NO_SERIAL, expression, begin);
    }

    private static Map toMappingExpressions(Expression[] exps) {
        HashMap<Literal, Expression> m = new HashMap<Literal, Expression>((int)((double)exps.length * 1.5));
        int i = 0;
        while (i < exps.length) {
            Literal[] literals = exps[i].getLiteral();
            int j = 0;
            while (j < literals.length) {
                m.put(literals[j], exps[i]);
                ++j;
            }
            ++i;
        }
        return Collections.unmodifiableMap(m);
    }

    public static CELBinder getBaseTypeCreationBinder() {
        return baseTypeCreationBinder;
    }

    public static CELBinder getCollectionCreationBinder() {
        return collectionCreationBinder;
    }

    public static CELBinder getObjectCreationBinder() {
        return objectCreationBinder;
    }
}

