/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.lang;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import shohaku.core.lang.Eval;

public class Seek {
    public static int skipTo(CharSequence cs, char c, int begin) {
        int inx = begin;
        while (inx < cs.length()) {
            if (cs.charAt(inx) != c) break;
            ++inx;
        }
        return inx;
    }

    public static int skipTo(CharSequence cs, char[] chars, int begin) {
        int inx = begin;
        while (inx < cs.length()) {
            char c = cs.charAt(inx);
            boolean hit = false;
            int i = 0;
            while (i < chars.length) {
                if (c == chars[i]) {
                    hit = true;
                    break;
                }
                ++i;
            }
            if (!hit) break;
            ++inx;
        }
        return inx;
    }

    public static int count(Collection c, Object o) {
        if (c instanceof Set) {
            return c.contains(o) ? 1 : 0;
        }
        int count = 0;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            if (!Eval.isEquals(i.next(), o)) continue;
            ++count;
        }
        return count;
    }

    public static Collection getAll(Collection c, Object o) {
        ArrayList a = new ArrayList();
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Object e = i.next();
            if (!Eval.isEquals(e, o)) continue;
            a.add(e);
        }
        return a;
    }

    public static int indexOf(List list, Object o, int begin, int end) {
        Seek.checkIndexOfException(list, begin, end);
        if (o == null) {
            int i = begin;
            while (i <= end) {
                if (list.get(i) == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = begin;
            while (i <= end) {
                if (o.equals(list.get(i))) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(List list, Object o, int begin, int end) {
        Seek.checkIndexOfException(list, begin, end);
        if (o == null) {
            int i = end;
            while (i >= begin) {
                if (list.get(i) == null) {
                    return i;
                }
                --i;
            }
        } else {
            int i = end;
            while (i >= begin) {
                if (o.equals(list.get(i))) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    public static int indexOf(Object[] a, Object o, int begin, int end) {
        Seek.checkIndexOfException(a, begin, end);
        if (o == null) {
            int i = begin;
            while (i <= end) {
                if (a[i] == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = begin;
            while (i <= end) {
                if (o.equals(a[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(Object[] a, Object o, int begin, int end) {
        Seek.checkIndexOfException(a, begin, end);
        if (o == null) {
            int i = end;
            while (i >= begin) {
                if (a[i] == null) {
                    return i;
                }
                --i;
            }
        } else {
            int i = end;
            while (i >= begin) {
                if (o.equals(a[i])) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    public static int indexOf(boolean[] a, boolean e, int begin, int end) {
        Seek.checkIndexOfException(a, begin, end);
        int i = begin;
        while (i <= end) {
            if (e == a[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int lastIndexOf(boolean[] a, boolean e, int begin, int end) {
        Seek.checkIndexOfException(a, begin, end);
        int i = end;
        while (i >= begin) {
            if (e == a[i]) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static int indexOf(char[] a, char e, int begin, int end) {
        Seek.checkIndexOfException(a, begin, end);
        int i = begin;
        while (i <= end) {
            if (e == a[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int lastIndexOf(char[] a, char e, int begin, int end) {
        Seek.checkIndexOfException(a, begin, end);
        int i = end;
        while (i >= begin) {
            if (e == a[i]) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static int indexOf(byte[] a, byte e, int begin, int end) {
        Seek.checkIndexOfException(a, begin, end);
        int i = begin;
        while (i <= end) {
            if (e == a[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int lastIndexOf(byte[] a, byte e, int begin, int end) {
        Seek.checkIndexOfException(a, begin, end);
        int i = end;
        while (i >= begin) {
            if (e == a[i]) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static int indexOf(short[] a, short e, int begin, int end) {
        Seek.checkIndexOfException(a, begin, end);
        int i = begin;
        while (i <= end) {
            if (e == a[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int lastIndexOf(short[] a, short e, int begin, int end) {
        Seek.checkIndexOfException(a, begin, end);
        int i = end;
        while (i >= begin) {
            if (e == a[i]) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static int indexOf(int[] a, int e, int begin, int end) {
        Seek.checkIndexOfException(a, begin, end);
        int i = begin;
        while (i <= end) {
            if (e == a[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int lastIndexOf(int[] a, int e, int begin, int end) {
        Seek.checkIndexOfException(a, begin, end);
        int i = end;
        while (i >= begin) {
            if (e == a[i]) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static int indexOf(long[] a, long e, int begin, int end) {
        Seek.checkIndexOfException(a, begin, end);
        int i = begin;
        while (i <= end) {
            if (e == a[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int lastIndexOf(long[] a, long e, int begin, int end) {
        Seek.checkIndexOfException(a, begin, end);
        int i = end;
        while (i >= begin) {
            if (e == a[i]) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static int indexOf(float[] a, float e, int begin, int end) {
        Seek.checkIndexOfException(a, begin, end);
        int i = begin;
        while (i <= end) {
            if (e == a[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int lastIndexOf(float[] a, float e, int begin, int end) {
        Seek.checkIndexOfException(a, begin, end);
        int i = end;
        while (i >= begin) {
            if (e == a[i]) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static int indexOf(double[] a, double e, int begin, int end) {
        Seek.checkIndexOfException(a, begin, end);
        int i = begin;
        while (i <= end) {
            if (e == a[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int lastIndexOf(double[] a, double e, int begin, int end) {
        Seek.checkIndexOfException(a, begin, end);
        int i = end;
        while (i >= begin) {
            if (e == a[i]) {
                return i;
            }
            --i;
        }
        return -1;
    }

    private static void checkIndexOfException(List list, int begin, int end) {
        if (list == null) {
            throw new NullPointerException("list is null.");
        }
        if (!Eval.isRange(list, begin) || !Eval.isRange(list, end)) {
            throw new IndexOutOfBoundsException("begin:" + begin + ", end:" + end + ", size:" + list.size());
        }
    }

    private static void checkIndexOfException(Object a, int begin, int end) {
        if (a == null) {
            throw new NullPointerException("a is null.");
        }
        if (!Eval.isArray(a)) {
            throw new IllegalArgumentException("is not Array:" + a);
        }
        if (!Eval.isRange(a, begin) || !Eval.isRange(a, end)) {
            throw new IndexOutOfBoundsException("begin:" + begin + ", end:" + end + ", size:" + Array.getLength(a));
        }
    }
}

