/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.collections;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;
import shohaku.core.collections.wrapper.UnmodifiableIterator;
import shohaku.core.collections.wrapper.WrappedIterator;
import shohaku.core.lang.Eval;

public class IteratorUtils {
    public static final Iterator EMPTY_ITERATOR = new Iterator(){

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }
    };

    public static Iterator arrayIterator(Object array) {
        return new ArrayIterator(array);
    }

    public static Iterator unmodifiableIterator(Iterator iterator) {
        return new UnmodifiableIterator(iterator);
    }

    public static Iterator wrappedIterator(Iterator iterator) {
        return new WrappedIterator(iterator);
    }

    private static class ArrayIterator
    implements Iterator {
        private final Object a;
        private final int size;
        private int index = -1;

        public ArrayIterator(Object a) {
            if (a == null) {
                throw new NullPointerException();
            }
            if (!Eval.isArray(a)) {
                throw new IllegalArgumentException("is not Array:" + a);
            }
            this.a = a;
            this.size = Array.getLength(a);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            if (this.index + 1 < this.size) {
                ++this.index;
                return true;
            }
            return false;
        }

        public Object next() {
            if (this.index < 0) {
                throw new IllegalStateException();
            }
            if (this.index < this.size) {
                return Array.get(this.a, this.index);
            }
            throw new NoSuchElementException();
        }
    }
}

