/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.beans;

import shohaku.core.beans.FeatureInfo;
import shohaku.core.beans.ParameterInfo;

public class ParametersInfo
extends FeatureInfo {
    private Class[] parameterTypes;
    private Object[] parameterValues;
    private ParameterInfo[] parameteres;

    public ParametersInfo() {
    }

    public ParametersInfo(ParameterInfo[] params) {
        this.setParameteres(params);
    }

    public ParametersInfo(Class type, Object value) {
        this.setParameteres(new Class[]{type}, new Object[]{value});
    }

    public ParametersInfo(Class[] types, Object[] values) {
        this.setParameteres(types, values);
    }

    public Object[] getParameterValues() {
        return this.parameterValues;
    }

    public Class[] getParameterTypes() {
        return this.parameterTypes;
    }

    public ParameterInfo[] getParameteres() {
        return this.parameteres;
    }

    public void setParameteres(ParameterInfo[] params) {
        this.checkUnmodifiable();
        if (params == null) {
            throw new NullPointerException("argument is null.");
        }
        Class[] types = new Class[params.length];
        Object[] values = new Object[params.length];
        int i = 0;
        while (i < params.length) {
            if (params[i].getType() == null) {
                throw new NullPointerException("argument params[i].types is null.");
            }
            types[i] = params[i].getType();
            values[i] = params[i].getValue();
            ++i;
        }
        this.parameterTypes = types;
        this.parameterValues = values;
        this.parameteres = params;
    }

    public void setParameteres(Class[] types, Object[] values) {
        this.checkUnmodifiable();
        if (types == null || values == null) {
            throw new NullPointerException("argument is null.");
        }
        if (types.length != values.length) {
            throw new IllegalArgumentException("types.length != values.length.");
        }
        ParameterInfo[] params = new ParameterInfo[types.length];
        int i = 0;
        while (i < params.length) {
            if (types[i] == null) {
                throw new NullPointerException("argument params[i].types is null.");
            }
            params[i] = new ParameterInfo(types[i], values[i]);
            ++i;
        }
        this.parameterTypes = types;
        this.parameterValues = values;
        this.parameteres = params;
    }
}

