/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shohaku.core.beans.ClassInfo;
import shohaku.core.beans.InvocationBeansException;
import shohaku.core.lang.Boxing;
import shohaku.core.lang.Eval;
import shohaku.core.util.Format;
import shohaku.core.util.cel.CELBinder;

public class BeanUtilities {
    private static final String nodesSpecifier;
    private static final Pattern nodesPattern;
    private static final String argumentsSpecifier;
    private static final Pattern argumentsPattern;

    static {
        StringBuffer sb = new StringBuffer();
        sb.append("(?:");
        sb.append("(?:^|\\.)([_a-z-A-Z]\\w+\\((?:\"(?>\\\\\"|[^\"])*\"|'.'|[^)]+)?\\))");
        sb.append("|");
        sb.append("(?:^|\\.)([_a-z-A-Z]\\w+)");
        sb.append("|");
        sb.append("(\\[[0-9]+\\])");
        sb.append(")");
        nodesSpecifier = sb.toString();
        nodesPattern = Pattern.compile(nodesSpecifier);
        sb = new StringBuffer();
        sb.append("(?:^|\\s*,)\\s*");
        sb.append("(");
        sb.append("\"(?>\\\\\"|[^\"])*\"");
        sb.append("|");
        sb.append("[-+]?[0-9A-Fa-f.]+[BSILFD]?");
        sb.append("|");
        sb.append("true");
        sb.append("|");
        sb.append("false");
        sb.append("|");
        sb.append("null");
        sb.append("|");
        sb.append("'(?:.|\\\\'|\\\\u(?:[0-9A-Fa-f]){4})'");
        sb.append("|");
        sb.append("\\|(?:[-0-9 :.]{5,23})\\|");
        sb.append("|");
        sb.append("%\\d+");
        sb.append(")");
        sb.append("\\s*(?:,\\s*|$)");
        argumentsSpecifier = sb.toString();
        argumentsPattern = Pattern.compile(argumentsSpecifier);
    }

    public static Map getProperties(Object bean) throws InvocationBeansException {
        if (bean == null) {
            throw new NullPointerException("argument is null.");
        }
        try {
            HashMap<String, Object> props = new HashMap<String, Object>();
            PropertyDescriptor[] ds = BeanUtilities.getPropertyDescriptors(bean);
            int i = 0;
            while (i < ds.length) {
                Method method = ds[i].getReadMethod();
                if (method != null) {
                    props.put(ds[i].getName(), method.invoke(bean, null));
                }
                ++i;
            }
            return props;
        }
        catch (IllegalArgumentException e) {
            throw new InvocationBeansException(e);
        }
        catch (IllegalAccessException e) {
            throw new InvocationBeansException(e);
        }
        catch (InvocationTargetException e) {
            throw new InvocationBeansException(e);
        }
    }

    public static String toBeanString(Object bean) throws InvocationBeansException {
        if (bean == null) {
            throw new NullPointerException("argument is null.");
        }
        try {
            StringBuffer sb = new StringBuffer();
            PropertyDescriptor[] ds = BeanUtilities.getPropertyDescriptors(bean);
            int i = 0;
            while (i < ds.length) {
                Method method = ds[i].getReadMethod();
                if (method != null) {
                    sb.append(ds[i].getName());
                    sb.append(':');
                    sb.append(Format.toString(method.invoke(bean, null)));
                    sb.append(',');
                }
                ++i;
            }
            if (sb.length() != 0) {
                sb.insert(0, '{');
                sb.deleteCharAt(sb.length() - 1);
                sb.append('}');
            }
            return sb.toString();
        }
        catch (IllegalArgumentException e) {
            throw new InvocationBeansException(e);
        }
        catch (IllegalAccessException e) {
            throw new InvocationBeansException(e);
        }
        catch (InvocationTargetException e) {
            throw new InvocationBeansException(e);
        }
    }

    public static Object getNestedProperty(Object bean, String pattern, Object[] args) throws InvocationBeansException {
        if (Eval.isOrNull(bean, pattern)) {
            throw new NullPointerException("argument is null.");
        }
        try {
            String[] nodes = BeanUtilities.splitNodes(pattern.trim());
            Object o = bean;
            int i = 0;
            while (i < nodes.length) {
                String node = nodes[i];
                switch (node.charAt(node.length() - 1)) {
                    case ')': {
                        o = BeanUtilities.getMethodProperty(o, node, args);
                        break;
                    }
                    case ']': {
                        o = BeanUtilities.getListProperty(o, node);
                        break;
                    }
                    default: {
                        o = BeanUtilities.getProperty(o, node);
                    }
                }
                ++i;
            }
            return o;
        }
        catch (RuntimeException e) {
            throw new InvocationBeansException("illegal pattern:" + pattern, e);
        }
    }

    private static String[] splitNodes(String pattern) {
        ArrayList<String> list = new ArrayList<String>(4);
        Matcher m = nodesPattern.matcher(pattern);
        int i = 0;
        while (i < pattern.length()) {
            if (!m.find(i)) break;
            int j = 0;
            while (j < m.groupCount()) {
                String e = m.group(j + 1);
                if (e != null) {
                    list.add(e);
                    break;
                }
                ++j;
            }
            i = m.end();
        }
        return list.toArray(new String[0]);
    }

    public static Object getListProperty(Object bean, String pattern) throws InvocationBeansException {
        int index = BeanUtilities.getListIndex(pattern);
        if (bean instanceof List) {
            bean = ((List)bean).get(index);
        } else if (Eval.isArray(bean)) {
            bean = Array.get(bean, index);
        } else {
            throw new InvocationBeansException("no Array, illegal pattern:" + pattern);
        }
        return bean;
    }

    private static int getListIndex(String pattern) throws InvocationBeansException {
        String sindex = pattern.substring(pattern.lastIndexOf(91) + 1, pattern.length() - 1);
        try {
            return Integer.parseInt(sindex);
        }
        catch (NumberFormatException e) {
            throw new InvocationBeansException("no Number, illegal pattern:" + pattern);
        }
    }

    public static Object getProperty(Object bean, String name) throws InvocationBeansException {
        if (Eval.isOrNull(bean, name)) {
            throw new NullPointerException("argument is null.");
        }
        try {
            Class<?> beanClass = bean.getClass();
            Method method = BeanUtilities.getMatchingAccessibleMethod(beanClass, "get" + BeanUtilities.capitalize(name));
            if (method == null) {
                method = BeanUtilities.getMatchingAccessibleMethod(beanClass, "is" + BeanUtilities.capitalize(name));
            }
            return method.invoke(bean, null);
        }
        catch (IllegalArgumentException e) {
            throw new InvocationBeansException("illegal property:" + name, e);
        }
        catch (IllegalAccessException e) {
            throw new InvocationBeansException("illegal property:" + name, e);
        }
        catch (InvocationTargetException e) {
            throw new InvocationBeansException("illegal property:" + name, e);
        }
    }

    private static String[] splitArguments(String node) {
        ArrayList<String> list = new ArrayList<String>(7);
        Matcher m = argumentsPattern.matcher(node);
        int i = 0;
        while (i < node.length()) {
            if (!m.find(i)) break;
            list.add(m.group(1));
            i = m.end(1);
        }
        return list.toArray(new String[0]);
    }

    private static Object[] getMethodArguments(String pattern, Object[] args) {
        String[] srcValues = BeanUtilities.splitArguments(pattern);
        Object[] arguments = new Object[srcValues.length];
        CELBinder exps = CELBinder.getBaseTypeCreationBinder();
        int i = 0;
        while (i < srcValues.length) {
            if (srcValues[i].charAt(0) == '%') {
                int index = Integer.parseInt(srcValues[i].substring(1));
                arguments[i] = args[index];
            } else {
                arguments[i] = exps.getValue(srcValues[i]);
            }
            ++i;
        }
        return arguments;
    }

    public static Object getMethodProperty(Object bean, String pattern, Object[] args) throws InvocationBeansException {
        if (Eval.isOrNull(bean, pattern)) {
            throw new NullPointerException("argument is null.");
        }
        try {
            Class<?> beanClass = bean.getClass();
            String methodName = pattern.substring(0, pattern.indexOf(40));
            String ptns = pattern.substring(pattern.indexOf(40) + 1, pattern.length() - 1);
            Object[] values = null;
            if (!Eval.isBlank(ptns)) {
                values = BeanUtilities.getMethodArguments(ptns, args);
            }
            if (values != null) {
                Class[] types = BeanUtilities.toTypes(values);
                Method method = BeanUtilities.getMatchingAccessibleMethod(beanClass, methodName, types);
                if (method == null) {
                    throw new InvocationBeansException();
                }
                return method.invoke(bean, values);
            }
            Method method = BeanUtilities.getMatchingAccessibleMethod(beanClass, methodName);
            if (method == null) {
                throw new InvocationBeansException();
            }
            return method.invoke(bean, null);
        }
        catch (IllegalArgumentException e) {
            throw new InvocationBeansException("illegal pattern:" + pattern, e);
        }
        catch (IllegalAccessException e) {
            throw new InvocationBeansException("illegal pattern:" + pattern, e);
        }
        catch (InvocationTargetException e) {
            throw new InvocationBeansException("illegal pattern:" + pattern, e);
        }
    }

    public static Class[] toTypes(Object[] args) {
        Class[] types = new Class[args.length];
        int i = 0;
        while (i < args.length) {
            types[i] = args[i].getClass();
            ++i;
        }
        return types;
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Object bean) {
        if (bean == null) {
            throw new NullPointerException("argument is null.");
        }
        return BeanUtilities.getPropertyDescriptors(bean.getClass());
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class beanClass) {
        if (beanClass == null) {
            throw new NullPointerException("argument is null.");
        }
        PropertyDescriptor[] descriptors = null;
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException e) {
            return new PropertyDescriptor[0];
        }
        descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            descriptors = new PropertyDescriptor[]{};
        }
        return descriptors;
    }

    public static Field getAccessibleField(Class c, String fieldName) {
        if (Eval.isOrNull(c, fieldName)) {
            throw new NullPointerException("argument is null.");
        }
        Field field = null;
        try {
            field = BeanUtilities.getAccessibleField(c.getField(fieldName));
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return field;
    }

    public static Constructor getMatchingAccessibleConstructor(Class c) {
        return BeanUtilities.getMatchingAccessibleConstructor(c, new Class[0]);
    }

    public static Constructor getMatchingAccessibleConstructor(Class c, Class[] parameterTypes) {
        if (Eval.isOrNull(c, parameterTypes)) {
            throw new NullPointerException("argument is null.");
        }
        try {
            Constructor constructor = BeanUtilities.getAccessibleConstructor(c.getConstructor(parameterTypes));
            if (constructor != null) {
                return constructor;
            }
        }
        catch (SecurityException constructor) {
        }
        catch (NoSuchMethodException constructor) {
            // empty catch block
        }
        int paramSize = parameterTypes.length;
        Constructor<?>[] constructors = c.getConstructors();
        int i = 0;
        int size = constructors.length;
        while (i < size) {
            Class<?>[] constructorParams = constructors[i].getParameterTypes();
            int constructorParamSize = constructorParams.length;
            if (constructorParamSize == paramSize) {
                Constructor constructor;
                boolean match = true;
                int n = 0;
                while (n < constructorParamSize) {
                    if (!BeanUtilities.isAssignmentCompatible(constructorParams[n], parameterTypes[n])) {
                        match = false;
                        break;
                    }
                    ++n;
                }
                if (match && (constructor = BeanUtilities.getAccessibleConstructor(constructors[i])) != null) {
                    return constructor;
                }
            }
            ++i;
        }
        return null;
    }

    public static Method getMatchingAccessibleSetProperty(Class c, String propertyName, Class parameterType) {
        return BeanUtilities.getMatchingAccessibleSetProperty(c, propertyName, new Class[]{parameterType});
    }

    public static Method getMatchingAccessibleSetProperty(Class c, String propertyName, Class[] parameterTypes) {
        return BeanUtilities.getMatchingAccessibleMethod(c, "set" + BeanUtilities.capitalize(propertyName), parameterTypes);
    }

    public static Method getMatchingAccessibleGetProperty(Class c, String propertyName, Class parameterType) {
        return BeanUtilities.getMatchingAccessibleGetProperty(c, propertyName, new Class[]{parameterType});
    }

    public static Method getMatchingAccessibleGetProperty(Class c, String propertyName, Class[] parameterTypes) {
        Method method = BeanUtilities.getMatchingAccessibleMethod(c, "get" + BeanUtilities.capitalize(propertyName), parameterTypes);
        if (method == null) {
            method = BeanUtilities.getMatchingAccessibleMethod(c, "is" + BeanUtilities.capitalize(propertyName), parameterTypes);
        }
        return method;
    }

    public static Method getMatchingAccessibleMethod(Class c, String methodName) {
        return BeanUtilities.getMatchingAccessibleMethod(c, methodName, new Class[0]);
    }

    public static Method getMatchingAccessibleMethod(Class c, String methodName, Class parameterType) {
        return BeanUtilities.getMatchingAccessibleMethod(c, methodName, new Class[]{parameterType});
    }

    public static Method getMatchingAccessibleMethod(Class c, String methodName, Class[] parameterTypes) {
        if (Eval.isOrNull(c, methodName, parameterTypes)) {
            throw new NullPointerException("argument is null.");
        }
        try {
            Method method = c.getMethod(methodName, parameterTypes);
            try {
                method.setAccessible(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return method;
        }
        catch (SecurityException method) {
        }
        catch (NoSuchMethodException method) {
            // empty catch block
        }
        int paramSize = parameterTypes.length;
        Method[] methods = c.getMethods();
        int i = 0;
        int size = methods.length;
        while (i < size) {
            Class<?>[] methodsParams;
            int methodParamSize;
            if (methods[i].getName().equals(methodName) && (methodParamSize = (methodsParams = methods[i].getParameterTypes()).length) == paramSize) {
                Method method;
                boolean match = true;
                int n = 0;
                while (n < methodParamSize) {
                    if (!BeanUtilities.isAssignmentCompatible(methodsParams[n], parameterTypes[n])) {
                        match = false;
                        break;
                    }
                    ++n;
                }
                if (match && (method = BeanUtilities.getAccessibleMethod(methods[i])) != null) {
                    try {
                        method.setAccessible(true);
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    return method;
                }
            }
            ++i;
        }
        return null;
    }

    private static boolean isAssignmentCompatible(Class fromType, Class toType) {
        Class parameterWrapperClass;
        if (fromType.isAssignableFrom(toType)) {
            return true;
        }
        if (fromType.isPrimitive() && (parameterWrapperClass = Boxing.boxClass(fromType)) != null) {
            return parameterWrapperClass.equals(toType);
        }
        return false;
    }

    private static Field getAccessibleField(Field field) {
        if (field == null) {
            return null;
        }
        if (!Modifier.isPublic(field.getModifiers())) {
            return null;
        }
        Class<?> c = field.getDeclaringClass();
        if (Modifier.isPublic(c.getModifiers())) {
            return field;
        }
        field = BeanUtilities.getAccessibleFieldFromInterfaceNest(c, field.getName());
        return field;
    }

    private static Field getAccessibleFieldFromInterfaceNest(Class c, String fieldName) {
        Field field = null;
        while (c != null) {
            Class<?>[] interfaces = c.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                if (Modifier.isPublic(interfaces[i].getModifiers())) {
                    try {
                        field = interfaces[i].getDeclaredField(fieldName);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    if (field != null || (field = BeanUtilities.getAccessibleFieldFromInterfaceNest(interfaces[i], fieldName)) != null) break;
                }
                ++i;
            }
            c = c.getSuperclass();
        }
        if (field != null) {
            return field;
        }
        return null;
    }

    private static Method getAccessibleMethod(Method method) {
        if (method == null) {
            return null;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        Class<?> c = method.getDeclaringClass();
        if (Modifier.isPublic(c.getModifiers())) {
            return method;
        }
        method = BeanUtilities.getAccessibleMethodFromInterfaceNest(c, method.getName(), method.getParameterTypes());
        return method;
    }

    private static Constructor getAccessibleConstructor(Constructor constructor) {
        if (constructor == null) {
            return null;
        }
        if (!Modifier.isPublic(constructor.getModifiers())) {
            return null;
        }
        Class c = constructor.getDeclaringClass();
        if (Modifier.isPublic(c.getModifiers())) {
            return constructor;
        }
        return null;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class c, String methodName, Class[] parameterTypes) {
        Method method = null;
        while (c != null) {
            Class<?>[] interfaces = c.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                if (Modifier.isPublic(interfaces[i].getModifiers())) {
                    try {
                        method = interfaces[i].getDeclaredMethod(methodName, parameterTypes);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    if (method != null || (method = BeanUtilities.getAccessibleMethodFromInterfaceNest(interfaces[i], methodName, parameterTypes)) != null) break;
                }
                ++i;
            }
            c = c.getSuperclass();
        }
        if (method != null) {
            return method;
        }
        return null;
    }

    public static Object newInstance(Class c) throws InvocationBeansException {
        return BeanUtilities.newInstance(c, new Class[0], new Object[0]);
    }

    public static Object newInstance(Class c, Object[] parameterValues) throws InvocationBeansException {
        return BeanUtilities.newInstance(c, BeanUtilities.toTypes(parameterValues), parameterValues);
    }

    public static Object newInstance(Class c, Class[] parameterTypes, Object[] parameterValues) throws InvocationBeansException {
        if (Eval.isOrNull(c, parameterTypes, parameterValues)) {
            throw new NullPointerException("argument is null.");
        }
        try {
            Constructor constructor = BeanUtilities.getConstructor(c, parameterTypes);
            return constructor.newInstance(BeanUtilities.newParameterValues(parameterValues));
        }
        catch (SecurityException e) {
            throw new InvocationBeansException("Class#getConstructor class:" + c, e);
        }
        catch (IllegalArgumentException e) {
            throw new InvocationBeansException("Constructor#newInstance class:" + c, e);
        }
        catch (NoSuchMethodException e) {
            throw new InvocationBeansException("Class#getConstructor class:" + c, e);
        }
        catch (InstantiationException e) {
            throw new InvocationBeansException("Constructor#newInstance class:" + c, e);
        }
        catch (IllegalAccessException e) {
            throw new InvocationBeansException("Constructor#newInstance class:" + c, e);
        }
        catch (InvocationTargetException e) {
            throw new InvocationBeansException("Constructor#newInstance class:" + c, e);
        }
    }

    public static Constructor getConstructor(Class c, Class[] parameterTypes) throws NoSuchMethodException {
        if (Eval.isOrNull(c, parameterTypes)) {
            throw new NullPointerException("argument is null.");
        }
        Constructor constructor = BeanUtilities.getMatchingAccessibleConstructor(c, parameterTypes);
        if (constructor == null) {
            throw new NoSuchMethodException(Format.format("class:{0}, args:{1,array}", c, parameterTypes));
        }
        return constructor;
    }

    public static Object invokeMethod(Class c, Object obj, String methodName) throws InvocationBeansException {
        return BeanUtilities.invokeMethod(c, obj, methodName, new Class[0], new Object[0]);
    }

    public static Object invokeMethod(Class c, Object obj, String methodName, Object[] parameterValues) throws InvocationBeansException {
        return BeanUtilities.invokeMethod(c, obj, methodName, BeanUtilities.toTypes(parameterValues), parameterValues);
    }

    public static Object invokeMethod(Class c, Object obj, String methodName, Class[] parameterTypes, Object[] parameterValues) throws InvocationBeansException {
        if (Eval.isOrNull(c, methodName, parameterTypes, parameterValues)) {
            throw new NullPointerException("argument is null.");
        }
        Method method = BeanUtilities.getMatchingAccessibleMethod(c, methodName, parameterTypes);
        try {
            if (Modifier.isStatic(method.getModifiers())) {
                return method.invoke(null, BeanUtilities.newParameterValues(parameterValues));
            }
            if (obj == null) {
                throw new NullPointerException("argument obj is null.");
            }
            return method.invoke(obj, BeanUtilities.newParameterValues(parameterValues));
        }
        catch (IllegalArgumentException e) {
            throw new InvocationBeansException("Method#invoke class:" + c, e);
        }
        catch (IllegalAccessException e) {
            throw new InvocationBeansException("Method#invoke class:" + c, e);
        }
        catch (InvocationTargetException e) {
            throw new InvocationBeansException("Method#invoke class:" + c, e);
        }
    }

    public static Object invokeMethod(Class c, Object obj, Method method, Object[] parameterValues) throws InvocationBeansException {
        if (Eval.isOrNull(c, method, parameterValues)) {
            throw new NullPointerException("argument is null.");
        }
        try {
            if (Modifier.isStatic(method.getModifiers())) {
                return method.invoke(null, BeanUtilities.newParameterValues(parameterValues));
            }
            if (obj == null) {
                throw new NullPointerException("argument obj is null.");
            }
            return method.invoke(obj, BeanUtilities.newParameterValues(parameterValues));
        }
        catch (IllegalArgumentException e) {
            throw new InvocationBeansException("Method#invoke class:" + c, e);
        }
        catch (IllegalAccessException e) {
            throw new InvocationBeansException("Method#invoke class:" + c, e);
        }
        catch (InvocationTargetException e) {
            throw new InvocationBeansException("Method#invoke class:" + c, e);
        }
    }

    public static Method getMethod(Class c, String methodName, Class[] parameterTypes) throws NoSuchMethodException {
        if (Eval.isOrNull(c, methodName, parameterTypes)) {
            throw new NullPointerException("argument is null.");
        }
        Method method = BeanUtilities.getMatchingAccessibleMethod(c, methodName, parameterTypes);
        if (method == null) {
            throw new NoSuchMethodException(Format.format("class:{0}, method:{1}, args:{2,array}", c, methodName, parameterTypes));
        }
        return method;
    }

    static Object getFieldValue(Class c, Object obj, Field field) throws InvocationBeansException {
        if (Eval.isOrNull(c, obj, field)) {
            throw new NullPointerException("argument is null.");
        }
        try {
            return field.get(obj);
        }
        catch (IllegalArgumentException e) {
            throw new InvocationBeansException("field#get class:" + c + ", field:" + field, e);
        }
        catch (IllegalAccessException e) {
            throw new InvocationBeansException("field#get class:" + c + ", field:" + field, e);
        }
    }

    static Object setFieldValue(Class c, Object obj, Field field, Object newValue) throws InvocationBeansException {
        if (Eval.isOrNull(c, obj, field)) {
            throw new NullPointerException("argument is null.");
        }
        try {
            Object oldValue = BeanUtilities.getFieldValue(c, obj, field);
            field.set(obj, newValue);
            return oldValue;
        }
        catch (IllegalArgumentException e) {
            throw new InvocationBeansException("field#set class:" + c + ", field:" + field + ", value:" + newValue, e);
        }
        catch (IllegalAccessException e) {
            throw new InvocationBeansException("field#set class:" + c + ", field:" + field + ", value:" + newValue, e);
        }
    }

    private static Object[] newParameterValues(Object[] srcValues) throws InvocationBeansException {
        if (srcValues == null) {
            throw new NullPointerException("argument srcValues is null.");
        }
        Object[] newValues = new Object[srcValues.length];
        int i = 0;
        while (i < srcValues.length) {
            Object o = srcValues[i];
            if (o instanceof ClassInfo) {
                o = ((ClassInfo)o).newInstance();
            }
            newValues[i] = o;
            ++i;
        }
        return newValues;
    }

    private static String capitalize(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        char[] chars = s.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }
}

