/*-----------------------------------------------------------------------------
[]	ShitarabianViewROI.cpp
[Tv]	ViewNXiROIIj̎
[l]	Ȃ
[]	2003-02-25	NC		Rgt(moralog)
-----------------------------------------------------------------------------*/


//-----------------------------------------------------------------------------
// CN[h
//-----------------------------------------------------------------------------
#include "stdafx.h"
#include "Common.h"
#include "Shitarabian.h"
#include "ShitarabianDoc.h"
#include "ShitarabianView.h"
#include "imm.h"
#include "EditDrawer.h"
#include "CommandManager.h"
#include "CommandInput.h"
#include "CommandCaret.h"
#include "CommandDelete.h"
#include "GeneralSetting.h"
#include <process.h>
#include "Selection.h"
#include "ROISelection.h"
#include "CommandMultiEdit.h"
#include "Padding.h"
#include "TokenReader.h"


//-----------------------------------------------------------------------------
// t@C֐
//-----------------------------------------------------------------------------

/*-----------------------------------------------------------------------------
[]	`IuWFNg擾
[@\]	`IuWFNg擾B
[ߒl]	CEditDrawer*	`IuWFNg [-] (-)
[l]	Ȃ
-----------------------------------------------------------------------------*/
static CEditDrawer*	GetDrawer()
{
	return( CEditDrawer::GetInstance() );
}


//-----------------------------------------------------------------------------
// NXo֐
//-----------------------------------------------------------------------------

/*-----------------------------------------------------------------------------
[]	Cxgnh
[@\]	Ƀ}EXCxgB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
BOOL CShitarabianView::PreTranslateROIMode(
	MSG*	pMsg,				// I  :bZ[W [-] (-)
	BOOL	bShift,				// I  :Vtg [-] (TRUE:AFALSE:Ȃ)
	BOOL	bCtrl,				// I  :Ctrl [-] (TRUE:AFALSE:Ȃ)
	BOOL	bAlt				// I  :Alt [-] (TRUE:AFALSE:Ȃ)
) 
{
	// warning C4100:x̖
	bAlt; bCtrl; bShift;

	CEditDrawer*	pDrawer = GetDrawer();
	CShitarabianDoc* pDoc = GetDocument();

	CFloatingSelection*	pSelection;
	pSelection = pDoc->GetFloatingSelection();

	BOOL	bBreak = FALSE;
	BOOL	bRedraw = FALSE;

	switch( pMsg->message )
	{
	case WM_LBUTTONUP:
		ReleaseCapture();
		m_bDrag = FALSE;
		bBreak = TRUE;
		break;

	case WM_MOUSEMOVE:
		DrawStatusBar();
		if ( m_bDrag )
		{
			POINTS	pt = MAKEPOINTS( pMsg->lParam );
			CPoint posCursor( pt.x, pt.y );
			posCursor = ScrollBoxToPixel( posCursor );

			CRect	rcOldROI = pDoc->GetROISelection()->GetROI();
			CRect	rcNewROI = pDoc->GetROISelection()->GetROI();

			rcNewROI.right = posCursor.x;
			rcNewROI.bottom = posCursor.y;
			pDoc->GetROISelection()->SetROI( rcNewROI );

			rcOldROI.NormalizeRect();
			rcNewROI.NormalizeRect();
			pDoc->SetUpdateStartRow( min( pDrawer->PixelToCaretRow( rcOldROI.top, pDoc ), pDrawer->PixelToCaretRow( rcNewROI.bottom, pDoc ) ) );
			pDoc->SetUpdateEndRow( max( pDrawer->PixelToCaretRow( rcOldROI.bottom, pDoc ), pDrawer->PixelToCaretRow( rcNewROI.bottom, pDoc ) ) );

			// I[gXN[
			{
				// ScrollToCaret() ŃJ^邽߂ɃLbgړ
				// YsvZ
				int idxRow = pDrawer->PixelToCaretRow( posCursor.y, pDoc );
				idxRow = min( idxRow, pDoc->GetLineCount()-1 );

				CString*	pstrCurrentLine = pDoc->GetLine( idxRow );
				if ( pstrCurrentLine != NULL )
				{
					int	idxColumn = 0;
					CEmphasisLine*	pEmphasisLine = pDoc->GetEmphasisLine( idxRow );
					if ( pEmphasisLine != NULL )
					{
						idxColumn = pEmphasisLine->PixelToCaretColumn( posCursor.x );
					}

					// Lbg̈ړ
					CCommandCaret	cmdCaret;
					cmdCaret.SetAttribute( 0x00, idxRow, idxColumn );
					cmdCaret.Execute( pDoc );

					ScrollToCaret();
				}
			}

			bRedraw = TRUE;
			bBreak = TRUE;
		}
		break;

	case WM_LBUTTONDOWN:
		{
			m_bDrag = TRUE;
			SetCapture( );

			// sNZW𓾂
			POINTS	pt = MAKEPOINTS( pMsg->lParam );
			CPoint posCursor( pt.x, pt.y );
			posCursor = ScrollBoxToPixel( posCursor );

			CRect	rcOldROI = pDoc->GetROISelection()->GetROI();
			rcOldROI.NormalizeRect();
			CRect	rcROI;
			rcROI.left = posCursor.x;
			rcROI.top = posCursor.y;
			rcROI.right = posCursor.x;
			rcROI.bottom = posCursor.y;
			pDoc->GetROISelection()->SetROI( rcROI );
			pDoc->SetUpdateStartRow( min( pDrawer->PixelToCaretRow( rcOldROI.top, pDoc ), pDrawer->PixelToCaretRow( rcROI.top, pDoc ) ) );
			pDoc->SetUpdateEndRow( max( pDrawer->PixelToCaretRow( rcOldROI.bottom, pDoc ), pDrawer->PixelToCaretRow( rcROI.bottom, pDoc ) ) );
		}
		bRedraw = TRUE;
		bBreak = TRUE;
		break;

	default:
		break;
	}

	if ( bRedraw )
	{
		// ĕ`
		pDoc->ReDraw();
	}

	return( bBreak );
}


/*-----------------------------------------------------------------------------
[]	L[nh
[@\]	ꂽL[ɉB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
BOOL CShitarabianView::PreTranslateKeyDownROIMode(
	UCHAR	unKey,				// I  :L[ [zL[R[h] (-)
	BOOL	bShift,				// I  :Vtg [-] (TRUE:AFALSE:Ȃ)
	BOOL	bCtrl,				// I  :Ctrl [-] (TRUE:AFALSE:Ȃ)
	BOOL	bAlt				// I  :Alt [-] (TRUE:AFALSE:Ȃ)
)
{
	// warning C4100:x̖
	bAlt; bCtrl; bShift;

	CShitarabianDoc*	pDoc = GetDocument();
	CFloatingSelection*	pSelection;
	pSelection = pDoc->GetFloatingSelection();

	BOOL	bBreak = FALSE;

	switch( unKey )
	{
	case VK_F4:
		// IԂ̉
		// [h̎
		ToNormal();
		bBreak = TRUE;
		break;

	default:
		return( FALSE );
		break;
	}

	return( TRUE );
}


/*-----------------------------------------------------------------------------
[]	̓nh
[@\]	͂ꂽɉB
[ߒl]	Ȃ
[l]	VK_ESCAPE:	ỈAʏҏWւ̈ڍs
-----------------------------------------------------------------------------*/
BOOL CShitarabianView::PreTranslateCharROIMode(
	CString	strChar,			// I  :͕@[-] (-)
	BOOL	bShift,				// I  :Vtg [-] (TRUE:AFALSE:Ȃ)
	BOOL	bCtrl,				// I  :Ctrl [-] (TRUE:AFALSE:Ȃ)
	BOOL	bAlt				// I  :Alt [-] (TRUE:AFALSE:Ȃ)
)
{
	// warning C4100:x̖
	bAlt; bCtrl; bShift;

	CShitarabianDoc*	pDoc = GetDocument();
	CFloatingSelection*	pSelection;
	pSelection = pDoc->GetFloatingSelection();

	BOOL	bBreak = FALSE;

	if ( strChar == VK_ESCAPE )
	{
		// IԂ̉
		// [h̎
		{
			ToNormal();
			bBreak = TRUE;
		}
	}
	else
	if ( strChar == VK_RETURN )
	{
		bBreak = TRUE;
	}
	else
	{
		return( FALSE );
	}

	{
		// ĕ`
		pDoc->ReDraw();

		// DrawCaret()ƕ`悪SȂB
		// Lbg̕`DrawPage()łB

		GetDocument()->SetMainView( this );
		return( TRUE );
	}
}

