/*-----------------------------------------------------------------------------
[]	ShitarabianViewPrint.cpp
[Tv]	ViewNXij̎
[l]	Ȃ
[]	2003-02-25	NC		Rgt(moralog)
		2003-11-20	b031130 (3198) BOX\ݒ蔽fǉ (dincom)
		2003-12-26  b031228 (3192) Ï̂ݏcWł݂C (dincom)
-----------------------------------------------------------------------------*/


//-----------------------------------------------------------------------------
// CN[h
//-----------------------------------------------------------------------------
#include "stdafx.h"
#include "Common.h"
#include "ExeCommon.h"
#include "Shitarabian.h"
#include "MainFrm.h"
#include "ShitarabianDoc.h"
#include "ShitarabianView.h"
#include "EditDrawer.h"
#include "GeneralSetting.h"
#include <process.h>
#include "Selection.h"
#include "BoxSelection.h"
#include "FloatingSelection.h"
#include "CommandMultiEdit.h"
#include "Padding.h"
#include "TokenReader.h"
#include "ToolBarManager.h"
#include "ShitarabianPlugInManager.h"



/*-----------------------------------------------------------------------------
[]	nh
[@\]	CView::OnPreparePrinting()̃wvQƁB
[ߒl]	CView::OnPreparePrinting()̃wvQƁB
[l]	Ȃ
-----------------------------------------------------------------------------*/
BOOL CShitarabianView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// ftHg̈
	{
		pInfo->m_nNumPreviewPages = 1;

		// I͈͎wL
		CShitarabianDoc*	pDoc = GetDocument();
		CSelection*			pSelection = pDoc->GetSelection();
		if ( pSelection->IsSelected() )
		{
			pInfo->m_pPD->m_pd.Flags |= PD_NOSELECTION;
			pInfo->m_pPD->m_pd.Flags -= PD_NOSELECTION;
			pInfo->m_pPD->m_pd.Flags |= PD_SELECTION;
		}
	}

	BOOL	bSuccess = DoPreparePrinting(pInfo);
	if ( !bSuccess )
	{
		PrintLastErr( "" );
		::ErrorLog(
				_T("si܂͒~j"),
				_T("CShitarabianView::OnPreparePrinting")
		);
	}

	return bSuccess;
}


/*-----------------------------------------------------------------------------
[]	nh
[@\]	CView::OnPrint()̃wvQƁB
[ߒl]	CView::OnPrint()̃wvQƁB
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CShitarabianView::OnPrint(CDC* pDC, CPrintInfo* pInfo) 
{
	CEditDrawer*		pDrawer = CEditDrawer::GetInstance();
	CShitarabianDoc*	pDoc = GetDocument();
	CSelection*			pSelection = pDoc->GetSelection();
	CPrintDefine*		pPrint = CGeneralSetting::GetInstance()->GetPrintDefine();

	int		nPageColumn = 1;
	if ( pPrint->m_bMarge )
	{
		 nPageColumn = pPrint->m_uiMargeCount;
	}

	BOOL	bOnlySelection = pInfo->m_pPD->PrintSelection();

	pDC->SetMapMode( MM_TEXT );

	// _Wł͈̈
	CSize		sizeTopLeftMarginDP;
	CSize		sizeRightBottomMarginDP;
	{
		sizeTopLeftMarginDP.cx = pPrint->m_lLeftMargin*100;
		sizeTopLeftMarginDP.cy = pPrint->m_lTopMargin*100;
		if ( pPrint->m_bHeader )
		{
			sizeTopLeftMarginDP.cy += pPrint->m_lHeaderHeight *100;
		}
		pDC->HIMETRICtoLP( &sizeTopLeftMarginDP );
		pDC->LPtoDP( &sizeTopLeftMarginDP );

		sizeRightBottomMarginDP.cx = pPrint->m_lRightMargin *100;
		sizeRightBottomMarginDP.cy = pPrint->m_lBottomMargin *100;
		if ( pPrint->m_bFooter )
		{
			sizeRightBottomMarginDP.cy += pPrint->m_lFooterHeight *100;
		}
		pDC->HIMETRICtoLP( &sizeRightBottomMarginDP );
		pDC->LPtoDP( &sizeRightBottomMarginDP );
	}

	// v^DC̑傫
	CSize		sizePrinterPageDP;
	{
		sizePrinterPageDP.cx = pInfo->m_rectDraw.Width() - sizeTopLeftMarginDP.cx - sizeRightBottomMarginDP.cx;
		sizePrinterPageDP.cy = pInfo->m_rectDraw.Height() - sizeTopLeftMarginDP.cy - sizeRightBottomMarginDP.cy;
	}

	// `pDC̑傫
	CSize	sizeMemDCPixel;
	{
		sizeMemDCPixel.cx = pPrint->m_lPrintPixelWidth;
		sizeMemDCPixel.cy = (int)( (double)sizeMemDCPixel.cx * sizePrinterPageDP.cy / sizePrinterPageDP.cx );
		sizeMemDCPixel.cy *= nPageColumn;
	}

	// y[Ws
	int		nLine = sizeMemDCPixel.cy / (pDrawer->CaretRowToPixel( 1 ) );

	// 鑍s
	int		idxRequestStartLine = 0;
	int		idxRequestEndLine = pDoc->GetLineCount()-1;
	int		nAllLine;
	UINT	nPage;
	{
		if ( bOnlySelection )
		{
			idxRequestStartLine = pSelection->GetSelectedStartRow();
			idxRequestEndLine = pSelection->GetSelectedEndRow();
		}

		nAllLine = idxRequestEndLine - idxRequestStartLine +1;
		nPage = (nAllLine+nLine-1) / nLine;
		if ( pPrint->m_bMarge )
		{
			nPage = (nPage+pPrint->m_uiMargeCount-1)/pPrint->m_uiMargeCount;
		}
		pInfo->SetMaxPage( nPage );
	}

	// y[WɈs
	int		iStartLine = idxRequestStartLine + (pInfo->m_nCurPage-1) * nLine * nPageColumn;
	int		iEndLine = min( iStartLine+nLine-1, idxRequestEndLine );

	// DC쐬
	CDC			MemDC;
	CBitmap		MemBitmap;
	{
		CDC*		pSrcDC = GetDC();
		MemDC.CreateCompatibleDC ( pSrcDC );
		BOOL	bSuccess = MemBitmap.CreateCompatibleBitmap(
			pSrcDC,
			sizeMemDCPixel.cx,
			sizeMemDCPixel.cy
		);
		ReleaseDC( pSrcDC );
		if( !bSuccess )
		{
			::ErrorLog( "DC쐬s", "CShitarabianView::OnPrint()" );
			return;
		}

		MemDC.SetMapMode( MM_TEXT );
		MemDC.SetBkMode( TRANSPARENT );
		MemDC.SetWindowOrg( 0,0 );
	}

	// \ݒ蔽fH
	BOOL	bEmphasisEnable;
	bEmphasisEnable = CGeneralSetting::GetInstance()->GetEmphasisDefine()->GetEnable();
	CGeneralSetting::GetInstance()->GetEmphasisDefine()->SetEnable(
		pPrint->m_bCareEmphasis
	);

	//  (3198) BGN 2003.11.20 (dincom) BOX\ݒ蔽fL
	// BOX\ݒ蔽f
	BOOL bBoxCharEnable;
	bBoxCharEnable = CGeneralSetting::GetInstance()->GetBoxCharDefine()->GetEnable();
	CGeneralSetting::GetInstance()->GetBoxCharDefine()->SetEnable(
		pPrint->m_bCareBoxChar
	);
	//  (3198) END 

	//  (3191) BGN 2003.11.25 (dincom) ̕s\F
	//  
	// // hLg\̍č\z
	// pDoc->ReflectEmphasis();
	// 
	BOOL bEmphasysChange( bEmphasisEnable != pPrint->m_bCareEmphasis );

	if ( bEmphasysChange )
	{
		// hLg\̍č\ziԂ̂ŕ\FύX̂ƂɌ肷j
		pDoc->ReflectEmphasis();
		pDoc->AnalizeEmphasisLinez( 0, pDoc->GetLineCount()-1 );
	}
	//  (3191) END

	// y[WJiWPj쐬
	int	idxPageColumn;
	for( idxPageColumn=0 ; idxPageColumn<nPageColumn ; idxPageColumn++ )
	{
		CBitmap*	pOldBitmap;
		pOldBitmap = MemDC.SelectObject( &MemBitmap );
		{
			COLORREF	colBack = ::GetBackColor( EMPHASIS_TEXT );
			CRect		rcClient(
				0,0,
				sizeMemDCPixel.cx,
				sizeMemDCPixel.cy
			);
			MemDC.FillSolidRect(
				rcClient,
				colBack
			);

			pDrawer->SetUpdateRect( rcClient );
			// eLXg̕\
			PrintColumn(
				&MemDC,
				pInfo,
				sizeMemDCPixel,
				iStartLine,
				iEndLine
			);
//  ([jO) BGN 2003.12.29 (moralog) warning C4239
			CRect	rcInit(0,0,0,0);
			pDrawer->SetUpdateRect( rcInit );
//  original BGN
//			pDrawer->SetUpdateRect( CRect(0,0,0,0) );
//  original END
//  ([jO) END
		}
		MemDC.SelectObject( pOldBitmap );

		// DCv^DC֓]
		pDC->LPtoDP( &sizeTopLeftMarginDP );
		pDC->SetWindowOrg( 0,0 );

		MemDC.SelectObject( pOldBitmap );

		int		iCaps = pDC->GetDeviceCaps( RASTERCAPS );
		if( iCaps & RC_STRETCHBLT )
		{
			// StretchBlt()ł
			int		iPageColumnWidth = sizePrinterPageDP.cx / nPageColumn;
			CRect rcDst;
			{
 				rcDst.left = pInfo->m_rectDraw.left + sizeTopLeftMarginDP.cx
						+ (iPageColumnWidth * idxPageColumn);
				rcDst.top = pInfo->m_rectDraw.top + sizeTopLeftMarginDP.cy;
				rcDst.right = rcDst.left + iPageColumnWidth;
				rcDst.bottom = rcDst.top + sizePrinterPageDP.cy;
			}

			CRect rcSrc(
				0,
				0,
				sizeMemDCPixel.cx,
				sizeMemDCPixel.cy
			);
			::DIBStretchBlt(
				pDC,
				rcDst,
				&MemDC,
				&MemBitmap,
				rcSrc
			);
		}
		else
		{
			// StretchBlt()łȂ
			if( iCaps & RC_BITBLT )
			{
				// łMemDCBlt邩dd
				::ErrorLog( "StretchDIBits()łȂ炵B", "CShitarabianView::OnPrint()" );
				break;
			}
			else
			{
				::ErrorLog( "Ẵv^A摜̓]oȂB", "CShitarabianView::OnPrint()" );
				break;
			}
		}
		MemDC.SelectObject( pOldBitmap );

		iStartLine += nLine;
		iEndLine += nLine;
	}

	// \ݒ蕜A
	CGeneralSetting::GetInstance()->GetEmphasisDefine()->SetEnable(
		bEmphasisEnable
	);

	//  (3198) BGN 2003.11.20 (dincom) BOX\ݒ蔽fL
	// BOX\ݒ蕜A
	CGeneralSetting::GetInstance()->GetBoxCharDefine()->SetEnable(
		bBoxCharEnable
	);
	//  (3198) END 

	//  (3191) BGN 2003.11.25 (dincom) ̕s\F
	// 
	// // hLg\̍č\z
	// pDoc->ReflectEmphasis();
	// 
	if ( bEmphasysChange )
	{
		// hLg\̍č\ziԂ̂ŕ\FύX̂ƂɌ肷j
		pDoc->ReflectEmphasis();
		pDoc->AnalizeEmphasisLinez( 0, pDoc->GetLineCount()-1 );
	}
	//  (3191) END

	// wb_
	if( pPrint->m_bHeader )
	{
		PrintHeader(
			pDC,
			pInfo,
			pPrint,
			sizePrinterPageDP
		);
	}

	// tb^
	if( pPrint->m_bFooter )
	{
		PrintFooter(
			pDC,
			pInfo,
			pPrint,
			sizePrinterPageDP
		);
	}

	// Sňς݁H
	if ( pInfo->m_nCurPage < nPage )
	{
		pInfo->m_bContinuePrinting = TRUE;
	}
	else
	{
		pInfo->m_bContinuePrinting = FALSE;
	}
}


/*-----------------------------------------------------------------------------
[]	Cxgnh
[@\]	Ƀ}EXCxgB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CShitarabianView::PrintColumn(
	CDC*			pDC,				//   O:o͐DC [}bsO:pixel] (-) :-
	CPrintInfo*		pInfo,				// I  : [-] (-) :-
	CSize			sizeMemDCPixel,		// I  :o͐DC傫 [pixel] (-) :-
	int				iStartLine,			// I  :`JnhLgs [-] (-) :-
	int				iEndLine			// I  :`IhLgs [-] (-) :-
)
{
	CEditDrawer*		pDrawer = CEditDrawer::GetInstance();
	CShitarabianDoc*	pDoc = GetDocument();
	CPrintDefine*		pPrint = CGeneralSetting::GetInstance()->GetPrintDefine();

	BOOL	bOnlySelection = pInfo->m_pPD->PrintSelection();

	// eLXg̕\
	int		idxLine;
	for( idxLine=iStartLine ; idxLine<=iEndLine ; idxLine++ )
	{
		//  (3192) BGN 2003.12.26 (dincom) 
		// I͈݈͂̂̂ƂAI͈͊OɒBI
		if ( bOnlySelection )
		if ( idxLine > pDoc->GetSelection()->GetSelectedEndRow() )
		{
			return;
		}
		//  (3192) END

		int		iRow = idxLine - iStartLine;
		// s`
		{
			CString*			pstr = pDoc->GetLine( idxLine );
			if ( pstr != NULL )
			{
				long boom = iRow * (pDrawer->CaretRowToPixel( 1 ) );
				CPoint	pt;
				pt.x = 0;
				pt.y = boom;

				// I͈݂͂̂̐ݒ̏ꍇAIeLXg͈͂𔽉f
				BOOL	bRgn1= FALSE, bRgn2 = FALSE;
				CRgn	rgn1, rgn2;
				if ( bOnlySelection )
				{
					// IJnsȂ
					if ( idxLine == pDoc->GetSelection()->GetSelectedStartRow() )
					{
						// [W𐧌䂷
						int		iStartPixelX = 0;
						CEmphasisLine*	pEmphasisLine = pDoc->GetEmphasisLine( idxLine );
						if ( pEmphasisLine != NULL )
						{
							iStartPixelX = pEmphasisLine->CaretColumnToPixel(
								pDoc->GetSelection()->GetSelectedStartColumn()
							);
						}

						rgn1.CreateRectRgn(
							iStartPixelX,
							pt.y,
							sizeMemDCPixel.cx,
							pt.y + pDrawer->CaretRowToPixel( 1 )
						);

						pDC->SelectClipRgn(
							&rgn1,
							RGN_AND
						);

						bRgn1 = TRUE;
					}

					// IsȂ
					if ( idxLine == pDoc->GetSelection()->GetSelectedEndRow() )
					{
						// [W𐧌䂷
						int		iEndPixelX = 0;
						CEmphasisLine*	pEmphasisLine = pDoc->GetEmphasisLine( idxLine );
						if ( pEmphasisLine != NULL )
						{
							iEndPixelX = pEmphasisLine->CaretColumnToPixel(
								pDoc->GetSelection()->GetSelectedEndColumn()
							);
						}

						rgn2.CreateRectRgn(
							0,
							pt.y,
							iEndPixelX,
							pt.y + pDrawer->CaretRowToPixel( 1 )
						);

						pDC->SelectClipRgn(
							&rgn2,
							RGN_AND
						);

						bRgn2 = TRUE;
					}
				}

				// `
				pDrawer->SetDstX( pt.x );
				pDrawer->SetDstY( pt.y );
				long	lXPixel;
				lXPixel = pDrawer->DrawPlaneLine(
						pDoc,
						pDC,
						idxLine,
						pPrint->m_bCareSelection
				);

				// [W̔j
				if ( bRgn1 )
				{
					pDC->SelectClipRgn( NULL );
					rgn1.DeleteObject();
				}
				if ( bRgn2 )
				{
					pDC->SelectClipRgn( NULL );
					rgn2.DeleteObject();
				}
			}
		}
	}
}


/*-----------------------------------------------------------------------------
[]	wb_`
[@\]	wb_̕`B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CShitarabianView::PrintHeader(
	CDC*			pDC,				//   O:o͐DC [}bsO:pixel] (-) :-
	CPrintInfo*		pInfo,				// I  : [-] (-) :-
	CPrintDefine*	pPrint,				// I  :` [-] (-) :-
	CSize			sizePrinterPageDP	// I  :DC傫 [DP] (-) :-
)
{
	CSize	ptHeader;

	// tHg̐ݒ
	CFont*	fontOld = (CFont*)(pDC->SelectObject( pPrint->m_fontHeader.GetFont( pDC ) ) );

	// WvZ [v^DC̃foCXW]
	ptHeader.cx = pPrint->m_lLeftMargin*100;
	ptHeader.cy = pPrint->m_lTopMargin*100;
	pDC->HIMETRICtoLP( &ptHeader );
	pDC->LPtoDP( &ptHeader );
	ptHeader.cx += pInfo->m_rectDraw.left;
	ptHeader.cy += pInfo->m_rectDraw.top;

	// [
	CString	strHeaderLeft = pPrint->Cooking( pPrint->m_strHeaderLeft, pInfo);
	if ( !strHeaderLeft.IsEmpty() )
	{
		CSize sizeHeaderLeft = pDC->GetTextExtent( strHeaderLeft );
		pDC->TextOut(
			ptHeader.cx,
			ptHeader.cy,
			strHeaderLeft
		);
	}

	// 
	CString	strHeaderMid = pPrint->Cooking( pPrint->m_strHeaderMid, pInfo);
	if ( !strHeaderMid.IsEmpty() )
	{
		CSize sizeHeaderMid = pDC->GetTextExtent( strHeaderMid );
		pDC->TextOut(
			ptHeader.cx + (sizePrinterPageDP.cx - sizeHeaderMid.cx )/2,
			ptHeader.cy,
			strHeaderMid
		);
	}

	// E[
	CString	strHeaderRight = pPrint->Cooking( pPrint->m_strHeaderRight, pInfo);
	if ( !strHeaderRight.IsEmpty() )
	{
		CSize sizeHeaderRight = pDC->GetTextExtent( strHeaderRight );
		pDC->TextOut(
			ptHeader.cx + sizePrinterPageDP.cx - sizeHeaderRight.cx,
			ptHeader.cy,
			strHeaderRight
		);
	}
	pDC->SelectObject( fontOld );
}


/*-----------------------------------------------------------------------------
[]	tb_`
[@\]	tb_̕`B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CShitarabianView::PrintFooter(
	CDC*			pDC,				//   O:o͐DC [}bsO:pixel] (-) :-
	CPrintInfo*		pInfo,				// I  : [-] (-) :-
	CPrintDefine*	pPrint,				// I  :` [-] (-) :-
	CSize			sizePrinterPageDP	// I  :DC傫 [DP] (-) :-
)
{
	CSize				ptFooter;

	// tHg̐ݒ
	CFont*	fontOld = (CFont*)(pDC->SelectObject( pPrint->m_fontFooter.GetFont( pDC ) ) );

	// WvZ [v^DC̃foCXW]
	ptFooter.cx = pPrint->m_lLeftMargin*100;
	ptFooter.cy = (pPrint->m_lBottomMargin)*100;
	pDC->HIMETRICtoLP( &ptFooter );
	pDC->LPtoDP( &ptFooter );
	ptFooter.cx += pInfo->m_rectDraw.left;
	ptFooter.cy = pInfo->m_rectDraw.bottom-ptFooter.cy;

	// [
	CString	strFooterLeft = pPrint->Cooking( pPrint->m_strFooterLeft, pInfo);
	if ( !strFooterLeft.IsEmpty() )
	{
		CSize sizeFooterLeft = pDC->GetTextExtent( strFooterLeft );
		pDC->TextOut(
			ptFooter.cx,
			ptFooter.cy - sizeFooterLeft.cy,
			strFooterLeft
		);
	}

	// 
	CString	strFooterMid = pPrint->Cooking( pPrint->m_strFooterMid, pInfo);
	if ( !strFooterMid.IsEmpty() )
	{
		CSize sizeFooterMid = pDC->GetTextExtent( strFooterMid );
		pDC->TextOut(
			ptFooter.cx + (sizePrinterPageDP.cx - sizeFooterMid.cx )/2,
			ptFooter.cy - sizeFooterMid.cy,
			strFooterMid
		);
	}

	// E[
	CString	strFooterRight = pPrint->Cooking( pPrint->m_strFooterRight, pInfo);
	if ( !strFooterRight.IsEmpty() )
	{
		CSize sizeFooterRight = pDC->GetTextExtent( strFooterRight );
		pDC->TextOut(
			ptFooter.cx + sizePrinterPageDP.cx - sizeFooterRight.cx,
			ptFooter.cy - sizeFooterRight.cy,
			strFooterRight
		);
	}
	pDC->SelectObject( fontOld );
}
