/*-----------------------------------------------------------------------------
[]	ShitarabianViewFloating.cpp
[Tv]	ViewNXit[eBO\tj̎
[l]	Ȃ
[]	2003-02-25	NC		Rgt(moralog)
-----------------------------------------------------------------------------*/


//-----------------------------------------------------------------------------
// CN[h
//-----------------------------------------------------------------------------
#include "stdafx.h"
#include "Common.h"
#include "Shitarabian.h"
#include "ShitarabianDoc.h"
#include "ShitarabianView.h"
#include "imm.h"
#include "EditDrawer.h"
#include "CommandManager.h"
#include "CommandInput.h"
#include "CommandCaret.h"
#include "CommandDelete.h"
#include "GeneralSetting.h"
#include <process.h>
#include "Selection.h"
#include "BoxSelection.h"
#include "FloatingSelection.h"
#include "CommandMultiEdit.h"
#include "Padding.h"
#include "TokenReader.h"


//-----------------------------------------------------------------------------
// t@C֐
//-----------------------------------------------------------------------------

/*-----------------------------------------------------------------------------
[]	`IuWFNg擾
[@\]	`IuWFNg擾B
[ߒl]	CEditDrawer*	`IuWFNg [-] (-)
[l]	Ȃ
-----------------------------------------------------------------------------*/
static CEditDrawer*	GetDrawer()
{
	return( CEditDrawer::GetInstance() );
}



//-----------------------------------------------------------------------------
// NXo֐
//-----------------------------------------------------------------------------

/*-----------------------------------------------------------------------------
[]	Cxgnh
[@\]	Ƀ}EXCxgB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
BOOL CShitarabianView::PreTranslateFloatingMode(
	MSG*	pMsg,				// I  :bZ[W [-] (-)
	BOOL	bShift,				// I  :Vtg [-] (TRUE:AFALSE:Ȃ)
	BOOL	bCtrl,				// I  :Ctrl [-] (TRUE:AFALSE:Ȃ)
	BOOL	bAlt				// I  :Alt [-] (TRUE:AFALSE:Ȃ)
)
{
	// warning C4100:x̖
	bAlt; bCtrl; bShift;

	CEditDrawer*	pDrawer = GetDrawer();
	CShitarabianDoc* pDoc = GetDocument();

	CFloatingSelection*	pSelection;
	pSelection = pDoc->GetFloatingSelection();


	int idxOldSelectedStartRow = pSelection->GetSelectedStartRow();
	int idxOldSelectedEndRow = pSelection->GetSelectedEndRow();
	BOOL	bSelectedModify = FALSE;

	BOOL	bBreak = FALSE;
	BOOL	bRedraw = FALSE;

	switch( pMsg->message )
	{
	case WM_LBUTTONUP:
		ReleaseCapture();
		m_bDrag = FALSE;
		bBreak = TRUE;
		break;

	case WM_MOUSEMOVE:
		DrawStatusBar();
		if ( m_bDrag )
		{
			long	iStartRow = pSelection->GetSelectedStartRow();
			long	iStartColumn = pSelection->GetSelectedStartColumn();

			POINTS	pt = MAKEPOINTS( pMsg->lParam );
			CPoint posCursor( pt.x, pt.y );
			posCursor = ScrollBoxToPixel( posCursor );

			// t[eBÖړWvZ
			CPoint		ptFloat( posCursor );
			ptFloat.x += m_iFloatOffsetX;
			ptFloat.y += m_iFloatOffsetY;

			// ړƕ\F
			MoveFloatPosition( ptFloat );

			// I[gXN[
			{
				// ScrollToCaret() ŃJ^邽߂ɃLbgړ
				// łΏ[܂͉[ɂ
				// ɈړƂ͏[HړȂ牺͂H
				BOOL	bUp = ( iStartRow > pSelection->GetSelectedStartRow() );
				BOOL	bDown = ( iStartRow < pSelection->GetSelectedStartRow() );
				BOOL	bLeft = ( iStartColumn > pSelection->GetSelectedStartColumn() );
				BOOL	bRight = ( iStartColumn < pSelection->GetSelectedStartColumn() );

				long	idxRow = pSelection->GetSelectedStartRow();
				long	idxColumn = pSelection->GetSelectedStartColumn();

				if ( bUp )
				{
					//
				}
				if ( bDown )
				{
					idxRow = pSelection->GetSelectedEndRow();
					idxColumn = pSelection->GetSelectedEndColumn();
				}
				if ( bLeft )
				{
					idxRow = pSelection->GetFloatBoundMinRow();
					idxColumn = pSelection->GetFloatBoundMinColumn();
				}
				if ( bRight )
				{
					idxRow = pSelection->GetFloatBoundMaxRow();
					idxColumn = pSelection->GetFloatBoundMaxColumn();
				}

				// Lbg̈ړ
				CCommandCaret	cmdCaret;
				cmdCaret.SetAttribute(
					0x00,
					idxRow,
					idxColumn
				);
				cmdCaret.Execute( pDoc );
				ScrollToCaret();
			}

			bRedraw = TRUE;
		}
		bBreak = TRUE;
		break;

	case WM_LBUTTONDOWN:
		{
			m_bDrag = TRUE;
			SetCapture( );

			// sNZW𓾂
			POINTS	pt = MAKEPOINTS( pMsg->lParam );
			CPoint posCursor( pt.x, pt.y );
			posCursor = ScrollBoxToPixel( posCursor );

			CDC*		pDC = NULL;
			pDC = GetDC();
			if ( pDC == NULL )
			{
				break;
			}

			int idxRow = pDoc->GetCaretRow();
			int idxColumn = pDoc->GetCaretColumn();
			idxRow = pDrawer->PixelToCaretRow( posCursor.y, pDoc );
			CString*	pstrCurrentLine = pDoc->GetLine( idxRow );
			if ( pstrCurrentLine != NULL )
			{
				idxColumn = 0;
				CEmphasisLine*	pEmphasisLine = pDoc->GetEmphasisLine( idxRow );
				if ( pEmphasisLine != NULL )
				{
					idxColumn = pEmphasisLine->PixelToCaretColumn( posCursor.x, TRUE );
				}

				if ( pSelection->IsSelected( idxRow, idxColumn ) )
				{
					CFloatingSelection*	pSelection;
					pSelection = pDoc->GetFloatingSelection();
					CPoint	ptFloat = pSelection->GetPosition();
					m_iFloatOffsetX = ptFloat.x - posCursor.x;
					m_iFloatOffsetY = ptFloat.y - posCursor.y;
				}
				else
				{
					// IBOXOȂ蒅
					OnEditFloatCopy();
					// BOXIJn
					PostMessage( pMsg->message, pMsg->wParam, pMsg->lParam );
					m_bDrag = FALSE;
				}
			}
			ReleaseDC( pDC );
		}
		bRedraw = TRUE;
		bBreak = TRUE;
		break;

	default:
		break;
	}

	if ( bSelectedModify )
	{
		pDoc->SetUpdateStartRow( min( idxOldSelectedStartRow, pSelection->GetSelectedStartRow() ) );
		pDoc->SetUpdateEndRow( max( idxOldSelectedEndRow, pSelection->GetSelectedEndRow() ) );
	}

	if ( bRedraw )
	{
		// ĕ`
		pDoc->ReDraw();

	}

	if( bBreak )
	{
		return( TRUE );
	}
	else
	{
		return( FALSE );
	}
}


/*-----------------------------------------------------------------------------
[]	BOXI[hւ̈ڍs
[@\]	BOXI[hֈڍsB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CShitarabianView::ToBoxSelection()
{
	CShitarabianDoc* pDoc = GetDocument();
	CFloatingSelection*	pSelection;
	pSelection = pDoc->GetFloatingSelection();

	pSelection->UnDoReflect();
	pDoc->SetOperationMode( OperationBoxSelect );
	pDoc->SetAllUpdate();
}


/*-----------------------------------------------------------------------------
[]	ʏҏW[hւ̈ڍs
[@\]	ʏҏW[hֈڍsB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CShitarabianView::ToNormal()
{
	CShitarabianDoc* pDoc = GetDocument();
	CFloatingSelection*	pSelection;
	pSelection = pDoc->GetFloatingSelection();

	// Lbg\郂[h
	m_bVisibleCaret = TRUE;

	pSelection->UnDoReflect();
	pDoc->SetOperationMode( OperationNormal );
	pDoc->SetAllUpdate();
}


/*-----------------------------------------------------------------------------
[]	t[eBO\t
[@\]	t[eBO\tB
[ߒl]	Ȃ
[l]	BOXI[hֈڍsB
-----------------------------------------------------------------------------*/
void CShitarabianView::OnEditFloatCancel()
{
	CShitarabianDoc* pDoc = GetDocument();

	ToBoxSelection();

	// VbgBOXI̐ݒłΒʏ탂[hɖ߂
	if( CGeneralSetting::GetInstance()->GetOneShotBOXSelect() )
	{
		ToNormal();
	}

	// ĕ`
	pDoc->ReDraw();
}


/*-----------------------------------------------------------------------------
[]	Rs[\tnh
[@\]	t[eBO\t蒅B
[ߒl]	Ȃ
[l]	uփRs[v
-----------------------------------------------------------------------------*/
void CShitarabianView::OnEditFloatCopy()
{
	CShitarabianDoc* pDoc = GetDocument();

	//蒅
	{
		CFloatingSelection*	pSelection;
		pSelection = pDoc->GetFloatingSelection();
		pSelection->Confirm();

		// [h̎
		ToBoxSelection();

		// I͈͎
		CBoxSelection*	pBox;
		pBox = pDoc->GetBoxSelection();
		pBox->SetSelectedNutral();

	}

	// VbgBOXI̐ݒłΒʏ탂[hɖ߂
	if( CGeneralSetting::GetInstance()->GetOneShotBOXSelect() )
	{
		ToNormal();
	}

	// ĕ`
	pDoc->ReDraw();
}


/*-----------------------------------------------------------------------------
[]	ړ\tnh
[@\]	t[eBO\t؂蒅B
[ߒl]	Ȃ
[l]	uֈړv
-----------------------------------------------------------------------------*/
void CShitarabianView::OnEditFloatMove()
{
	CShitarabianDoc*	pDoc = GetDocument();
	CFloatingSelection*	pSelection;
	pSelection = pDoc->GetFloatingSelection();

	// BoxI͈͂̃NA
	pSelection->UnDoReflect();
	pDoc->GetBoxSelection()->BoxClear();
	pSelection->DoReflect();

	// Rs[
	OnEditFloatCopy();
}


/*-----------------------------------------------------------------------------
[]	L[nh
[@\]	ꂽL[ɉB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
BOOL CShitarabianView::PreTranslateKeyDownFloatingMode(
	UCHAR	unKey,				// I  :L[ [zL[R[h] (-)
	BOOL	bShift,				// I  :Vtg [-] (TRUE:AFALSE:Ȃ)
	BOOL	bCtrl,				// I  :Ctrl [-] (TRUE:AFALSE:Ȃ)
	BOOL	bAlt				// I  :Alt [-] (TRUE:AFALSE:Ȃ)
)
{
	// warning C4100:x̖
	bAlt; bCtrl; bShift;

	CEditDrawer*		pDrawer = GetDrawer();
	CShitarabianDoc*	pDoc = GetDocument();
	CFloatingSelection*	pSelection;
	pSelection = pDoc->GetFloatingSelection();

	BOOL	bBreak = FALSE;

//	int idxOldSelectedStartRow = pSelection->GetSelectedStartRow();
//	int idxOldSelectedEndRow = pSelection->GetSelectedEndRow();

	int	nRow = pDoc->GetLineCount();


	switch( unKey )
	{
	case VK_F4:
		// IԂ̉
		// [h̎
		pSelection->UnDoReflect();
		ToNormal();
		bBreak = TRUE;
		break;

	case VK_LEFT:
	case VK_RIGHT:
	case VK_UP:
	case VK_DOWN:
		{
			int		iRowHeight = pDrawer->CaretRowToPixel( 1 );

			// t[eBÖړʒuvZ
			CPoint	ptTopLeft;				
			ptTopLeft = pSelection->GetPosition();
			switch( unKey )
			{
			case VK_LEFT:
				ptTopLeft.x--;
				if ( ptTopLeft.x < 0 )
				{
					ptTopLeft.x = 0;
				}
				break;
			case VK_RIGHT:
				ptTopLeft.x++;
				break;
			case VK_UP:
				ptTopLeft.y -= iRowHeight;
				if ( ptTopLeft.y < 0 )
//				if ( !CGeneralSetting::GetInstance()->GetFreeCursor() )
//				{
					ptTopLeft.y = 0;
//				}
				break;
			case VK_DOWN:
				ptTopLeft.y += iRowHeight;
				break;
			default:
				break;
			}

			// ړƕ\F
			MoveFloatPosition( ptTopLeft );

			// I[gXN[
			CCommandCaret	cmdCaret;
			switch( unKey )
			{
			case VK_UP:
				cmdCaret.SetAttribute(
					0x00,
					pSelection->GetSelectedStartRow(),
					pSelection->GetSelectedStartColumn()
				);
				break;
			case VK_LEFT:
				cmdCaret.SetAttribute(
					0x00,
					pSelection->GetFloatBoundMinRow(),
					pSelection->GetFloatBoundMinColumn()
				);
				break;
			case VK_RIGHT:
				cmdCaret.SetAttribute(
					0x00,
					pSelection->GetFloatBoundMaxRow(),
					pSelection->GetFloatBoundMaxColumn()
				);
				break;
			case VK_DOWN:
				cmdCaret.SetAttribute(
					0x00,
					pSelection->GetSelectedEndRow(),
					pSelection->GetSelectedEndColumn()
				);
				break;
			default:
				break;
			}
			cmdCaret.Execute( pDoc );
			ScrollToCaret();
		}
		bBreak = TRUE;
		break;

	case VK_BACK:
	case VK_DELETE:
		bBreak = TRUE;
		break;

	default:
		return( FALSE );
		break;
	}

	if ( nRow != pDoc->GetLineCount() )
	{
		ResetHScroll();
	}

	{
		// ĕ`
		pDoc->ReDraw();

		// DrawCaret()ƕ`悪SȂB
		// Lbg̕`DrawPage()łB

		GetDocument()->SetMainView( this );
		return( TRUE );
	}
}


/*-----------------------------------------------------------------------------
[]	̓nh
[@\]	͂ꂽɉB
[ߒl]	Ȃ
[l]	VK_ESCAPE:	
		VK_RETURN:	蒅
-----------------------------------------------------------------------------*/
BOOL CShitarabianView::PreTranslateCharFloatingMode(
	CString	strChar,			// I  :͕@[-] (-)
	BOOL	bShift,				// I  :Vtg [-] (TRUE:AFALSE:Ȃ)
	BOOL	bCtrl,				// I  :Ctrl [-] (TRUE:AFALSE:Ȃ)
	BOOL	bAlt				// I  :Alt [-] (TRUE:AFALSE:Ȃ)
)
{
	// warning C4100:x̖
	bAlt; bCtrl; bShift;

	CShitarabianDoc*	pDoc = GetDocument();
	CFloatingSelection*	pSelection;
	pSelection = pDoc->GetFloatingSelection();

	BOOL	bBreak = FALSE;
	BOOL	bSelectedModify = FALSE;

	int idxOldSelectedStartRow = pSelection->GetSelectedStartRow();
	int idxOldSelectedEndRow = pSelection->GetSelectedEndRow();

	int	nRow = pDoc->GetLineCount();

	if ( strChar == VK_ESCAPE )
	{
		// IԂ̉
		// [h̎
		{
			pSelection->UnDoReflect();
			ToNormal();
			bSelectedModify = TRUE;
			bBreak = TRUE;
		}
	}
	else
	if ( strChar == VK_RETURN )
	{
		CFloatingSelection*	pSelection;
		pSelection = pDoc->GetFloatingSelection();
		pSelection->Confirm();

		// [h̎
		ToBoxSelection();

		// I͈͎
		CBoxSelection*	pBox;
		pBox = pDoc->GetBoxSelection();
		pBox->SetSelectedNutral();
		bBreak = TRUE;
	}
	else
	{
		return( FALSE );
	}


	if ( bSelectedModify )
	{
		pDoc->SetUpdateStartRow( min( idxOldSelectedStartRow, pSelection->GetSelectedStartRow() ) );
		pDoc->SetUpdateEndRow( max( idxOldSelectedEndRow, pSelection->GetSelectedEndRow() ) );
	}

	if ( nRow != pDoc->GetLineCount() )
	{
		ResetHScroll();
	}

	{
		// XN[łł΃XN[o[𐧌
		ScrollToCaret();

		// ĕ`
		pDoc->ReDraw();

		// DrawCaret()ƕ`悪SȂB
		// Lbg̕`DrawPage()łB

		GetDocument()->SetMainView( this );
		return( TRUE );
	}
}


/*-----------------------------------------------------------------------------
[]	t[eBOړ
[@\]	ړƁAɔs\F́B
[ߒl]	BOOL	 [-] (TRUE:AFALSE:s)
[l]	Ȃ
-----------------------------------------------------------------------------*/
BOOL CShitarabianView::MoveFloatPosition(
	CPoint&	ptFloat			// I  :FloatingW@[v[pixel] (-)
)
{
	CShitarabianDoc*	pDoc = GetDocument();
	CFloatingSelection*	pSelection = pDoc->GetFloatingSelection();
	CEditDrawer*		pDrawer = CEditDrawer::GetInstance();

	// IXVAύX̐s͈̔͂𓾂
	long	iStartRow = pSelection->GetSelectedStartRow();
	long	iEndRow = pSelection->GetSelectedEndRow();
	{
		// ꎞIɕ\F͂OFFɂčs̕ҏWsB
		CEmphasisLine::SetAnalizeMultiLineEmphasisEnable( FALSE );
		pSelection->UnDoReflect();

		if ( CGeneralSetting::GetInstance()->GetFreeCursor() )
		{
		// t[J[\̏ꍇ͍s̊g
			pSelection->SetPosition( ptFloat );

			// 
			if( ptFloat.y < 0 )
			{
				// Lbg̈ړ
				CCommandCaret	cmdCaret;
				cmdCaret.SetAttribute( 0x00, 0, 0 );
				cmdCaret.Execute( pDoc );
				cmdCaret.SetAttribute( VK_UP, 0, 0 );
				cmdCaret.Execute( pDoc );

				// Is͂Psւ
				iStartRow++;
				iEndRow++;
			}

			// 
			{
				int		iRequiredRow = pDrawer->PixelToCaretRow( ptFloat.y, pDoc );
				iRequiredRow += iEndRow - iStartRow;
				// sʒu
				if( iRequiredRow >= pDoc->GetLineCount() )
				{
					// t[J[\[ĥƂsEJg
					pDoc->AppendRow( iRequiredRow );
				}
			}
		}
		else
		{
		// t[J[\Ŗꍇ͈ړ͈͂𐧌
			ptFloat.y = max( 0, ptFloat.y );
			TRACE("%d",(pDoc->GetLineCount()-(iEndRow-iStartRow+1))
					* pDrawer->CaretRowToPixel(1) );
			ptFloat.y = min(
				ptFloat.y,
				(pDoc->GetLineCount()-(iEndRow-iStartRow+1))
					* pDrawer->CaretRowToPixel(1)
			);

			pSelection->SetPosition( ptFloat );
		}

		pSelection->DoReflect();
		CEmphasisLine::SetAnalizeMultiLineEmphasisEnable( TRUE );

		// ύXs͈͂̎擾
		iStartRow = min( iStartRow, pSelection->GetSelectedStartRow() );
		iEndRow = max( iEndRow, pSelection->GetSelectedEndRow() );
	}

	// ύX̐sɑ΂As\F̂ݕ\F
	int		idxLine;
	for( idxLine=iStartRow ; idxLine<=iEndRow ; idxLine++ )
	{
		CEmphasisLine*	pLine = pDoc->GetEmphasisLine( idxLine );
		if ( pLine != NULL )
		{
			pLine->ResetDetailEmphasis();
		}
	}
	for( idxLine=iStartRow ; idxLine<=iEndRow ; idxLine++ )
	{
		pDoc->AnalizeMultiLineEmphasis(
			CGeneralSetting::GetInstance()->GetEmphasisDefine(),
			idxLine
		);
	}
	return( TRUE );
}