// RgL
/*-----------------------------------------------------------------------------
[]	ShitarabianPlugInKeyAssign.cpp
[Tv]	L[蓖Ă̎
[l]	PretranslateŏE͏āA͕ʂɏB
		nIȕ@ȁ`B
[]	2003-12-20	b031228 (3146)^OWvL[蓖(moralog)
-----------------------------------------------------------------------------*/



#include "stdafx.h"
#include "shitarabian.h"
#include "ShitarabianPlugInKeyAssign.h"
#include "PlugInKeyAssignDlg.h"
#include "Common.h"
#include "ExeCommon.h"
#include "SettingPath.h"

#include <afxcview.h>

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


TSystemKeyDefine	f_tSystemKeyDefine[] = 
{

	{ "Rs[",					'C',		FALSE,	TRUE,	FALSE },
	{ "؂",				'X',		FALSE,	TRUE,	FALSE },
	{ "\t",				'V',		FALSE,	TRUE,	FALSE },
	{ "ׂĂI",			'A',		FALSE,	TRUE,	FALSE },
	{ "I[hؑ",			VK_F4,		FALSE,	FALSE,	FALSE },
	{ "Nbv{[h",		'B',		FALSE,	TRUE,	FALSE },

	{ "UnDo",					'Z',		FALSE,	TRUE,	FALSE },
	{ "ReDo",					'Y',		FALSE,	TRUE,	FALSE },

	{ "g",					VK_ADD,		FALSE,	TRUE,	FALSE },
	{ "k",					VK_SUBTRACT,FALSE,	TRUE,	FALSE },
	{ "pbg",			' ',		FALSE,	TRUE,	FALSE },

	{ "}[LO",				VK_F2,		FALSE,	TRUE,	FALSE },
	{ "̃}[N",				VK_F2,		FALSE,	FALSE,	FALSE },
	{ "Õ}[N",				VK_F2,		TRUE,	FALSE,	FALSE },

	{ "_CAO",			'F',		FALSE,	TRUE,	FALSE },
	{ "",				VK_F3,		FALSE,	FALSE,	FALSE },
	{ "O",				VK_F3,		TRUE,	FALSE,	FALSE },
	{ "u_CAO",			'H',		FALSE,	TRUE,	FALSE },

	{ "y[WAbv",			VK_PRIOR,	FALSE,	FALSE,	FALSE },
	{ "y[W_E",			VK_NEXT,	FALSE,	FALSE,	FALSE },
	{ "PsAbv",				VK_PRIOR,	FALSE,	TRUE,	FALSE },
	{ "Ps_E",				VK_NEXT,	FALSE,	TRUE,	FALSE },

	{ "̃yC",				VK_F6,		FALSE,	FALSE,	FALSE },
	{ "Ô؃C",				VK_F6,		TRUE,	FALSE,	FALSE },

	{ "J",					'O',		FALSE,	TRUE,	FALSE },
	{ "VK",				'N',		FALSE,	TRUE,	FALSE },

	{ "Sp",				' ',		TRUE,	FALSE,	FALSE },

	{ "ւPhbg炷",		VK_LEFT,	TRUE,	TRUE,	TRUE },
	{ "EւPhbg炷",		VK_RIGHT,	TRUE,	TRUE,	TRUE },

	//  (3180) BGN 2003.11.18 (dincom)
	{ "Rs[",					VK_INSERT,		TRUE,	FALSE,	FALSE },
	{ "؂",				VK_DELETE,		TRUE,	FALSE,	FALSE },
	//  (3180) END

//  (3146) BGN 2003.12.20 (moralog) ^OWṽL[蓖Ēǉ
	{ "^OWv",			VK_F10,		FALSE,	FALSE,	FALSE },
//  (3146) END

};


//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CShitarabianPlugInKeyAssign::CShitarabianPlugInKeyAssign()
	: m_bEnable( FALSE )
{
	m_aKeyDefinez.RemoveAll();

	int	idxKeyDefine;
	for( idxKeyDefine=0 ; idxKeyDefine<sizeof(f_tSystemKeyDefine)/sizeof(TSystemKeyDefine) ; idxKeyDefine++ )
	{
		TKeyDefine	tKeyDefine;
		tKeyDefine.bSystemDefine		= TRUE;
		tKeyDefine.strKeyFunctionName	= f_tSystemKeyDefine[idxKeyDefine].szKeyFunctionName;
		tKeyDefine.iSrcKey				= f_tSystemKeyDefine[idxKeyDefine].iSrcKey;
		tKeyDefine.bSrcShift			= f_tSystemKeyDefine[idxKeyDefine].bSrcShift;
		tKeyDefine.bSrcCtrl				= f_tSystemKeyDefine[idxKeyDefine].bSrcCtrl;
		tKeyDefine.bSrcAlt				= f_tSystemKeyDefine[idxKeyDefine].bSrcAlt;
		tKeyDefine.iDstKey				= f_tSystemKeyDefine[idxKeyDefine].iSrcKey;
		tKeyDefine.bDstShift			= f_tSystemKeyDefine[idxKeyDefine].bSrcShift;
		tKeyDefine.bDstCtrl				= f_tSystemKeyDefine[idxKeyDefine].bSrcCtrl;
		tKeyDefine.bDstAlt				= f_tSystemKeyDefine[idxKeyDefine].bSrcAlt;

		m_aKeyDefinez.Add( tKeyDefine );
	}
}

CShitarabianPlugInKeyAssign::~CShitarabianPlugInKeyAssign()
{
	m_aKeyDefinez.RemoveAll();
}

const char* CShitarabianPlugInKeyAssign::GetPlugInName()
{
	return( "L[蓖 ver1.0" );
}

void CShitarabianPlugInKeyAssign::OnSetting(
	CDocumentIF*	pDocIF
)
{
	// warning C4100:x̖
	pDocIF;

	CPlugInKeyAssignDlg		dlg;
	dlg.m_aKeyDefinez.RemoveAll();
	dlg.m_aKeyDefinez.Append( m_aKeyDefinez );
	dlg.m_bEnable = m_bEnable;

	if ( dlg.DoModal() == IDOK )
	{
		m_aKeyDefinez.RemoveAll();
		m_aKeyDefinez.Append( dlg.m_aKeyDefinez );
		m_bEnable = dlg.m_bEnable;
	}
}
// L[ꂽƂ̃nh
void CShitarabianPlugInKeyAssign::OnKeyDown(
	CDocumentIF*	pDocIF,
	UCHAR*			punKey,
	BOOL*			pbShift,
	BOOL*			pbCtrl,
	BOOL*			pbAlt
)
{
	// warning C4100:x̖
	pDocIF;

	if ( m_bEnable )
	{
		int	idxKeyDefine;
		for( idxKeyDefine=0 ; idxKeyDefine<m_aKeyDefinez.GetSize() ; idxKeyDefine++ )
		{
			if ( *punKey == m_aKeyDefinez[idxKeyDefine].iDstKey )
			if ( (*pbShift?1:0) == (m_aKeyDefinez[idxKeyDefine].bDstShift?1:0) )
			if ( (*pbCtrl?1:0) == (m_aKeyDefinez[idxKeyDefine].bDstCtrl?1:0) )
			if ( (*pbAlt?1:0) == (m_aKeyDefinez[idxKeyDefine].bDstAlt?1:0) )
			{
				*punKey = (UCHAR)m_aKeyDefinez[idxKeyDefine].iSrcKey;
				*pbShift = m_aKeyDefinez[idxKeyDefine].bSrcShift;
				*pbCtrl =m_aKeyDefinez[idxKeyDefine].bSrcCtrl; 
				*pbAlt = m_aKeyDefinez[idxKeyDefine].bSrcAlt;
				return;
			}
		}

		// ̃L[͂E
		for( idxKeyDefine=0 ; idxKeyDefine<m_aKeyDefinez.GetSize() ; idxKeyDefine++ )
		{
			if ( *punKey == m_aKeyDefinez[idxKeyDefine].iSrcKey )
			if ( (*pbShift?1:0) == (m_aKeyDefinez[idxKeyDefine].bSrcShift?1:0) )
			if ( (*pbCtrl?1:0) == (m_aKeyDefinez[idxKeyDefine].bSrcCtrl?1:0) )
			if ( (*pbAlt?1:0) == (m_aKeyDefinez[idxKeyDefine].bSrcAlt?1:0) )
			{
				*punKey = VK_CANCEL;
				*pbShift = FALSE;
				*pbCtrl = FALSE; 
				*pbAlt = FALSE;
				return;
			}
		}
	}
}

// L[ꂽƂ̃nh
void CShitarabianPlugInKeyAssign::OnChar(
	CDocumentIF*	pDocIF,
	CString*		pstrChar,
	BOOL*			pbShift,
	BOOL*			pbCtrl,
	BOOL*			pbAlt
)
{
	if ( m_bEnable )
	if ( !pstrChar->IsEmpty() )
	{
		UCHAR		uChar =  *pstrChar[0];
		OnKeyDown(
			pDocIF,
			&uChar,
			pbShift,
			pbCtrl,
			pbAlt
		);
		if ( *pstrChar[0] != uChar )
		{
			*pstrChar = uChar;
		}
	}
}


void	CShitarabianPlugInKeyAssign::OnLoad(CDocumentIF*	pDocIF)
{
	// warning C4100:x̖
	pDocIF;

	static BOOL	bInitialize = FALSE;

	if ( !bInitialize )
	{
		Load( );
		bInitialize = TRUE;
	}

}

void	CShitarabianPlugInKeyAssign::OnSave(CDocumentIF*	pDocIF)
{
	// warning C4100:x̖
	pDocIF;

	Save( );
}



void CShitarabianPlugInKeyAssign::Save(
)
{
	try
	{
		CString	strIniFolderPath = CSettingPath::GetInstance()->GetFolderPath();
		CString	strIniFilePath = strIniFolderPath + "keyassign.ini";

		CStdioFile	File( strIniFilePath, CFile::modeCreate|CFile::modeWrite );
		File.WriteString( ::BoolToString( m_bEnable )+"\n" );

		int	idxKeyDefine;
		for( idxKeyDefine=0 ; idxKeyDefine<m_aKeyDefinez.GetSize() ; idxKeyDefine++ )
		{
			File.WriteString( ::BoolToString( m_aKeyDefinez[idxKeyDefine].bSystemDefine )+"\n" );
			File.WriteString( ::QuoteString( m_aKeyDefinez[idxKeyDefine].strKeyFunctionName )+"\n" );
			CString		strDstKey( ::VKToString(m_aKeyDefinez[idxKeyDefine].iDstKey) );
			File.WriteString( ::QuoteString( strDstKey )+"\n" );
			File.WriteString( ::BoolToString( m_aKeyDefinez[idxKeyDefine].bDstShift )+"\n" );
			File.WriteString( ::BoolToString( m_aKeyDefinez[idxKeyDefine].bDstCtrl )+"\n" );
			File.WriteString( ::BoolToString( m_aKeyDefinez[idxKeyDefine].bDstAlt )+"\n" );
			CString		strSrcKey( ::VKToString(m_aKeyDefinez[idxKeyDefine].iSrcKey) );
			File.WriteString( ::QuoteString( strSrcKey )+"\n" );
			File.WriteString( ::BoolToString( m_aKeyDefinez[idxKeyDefine].bSrcShift )+"\n" );
			File.WriteString( ::BoolToString( m_aKeyDefinez[idxKeyDefine].bSrcCtrl )+"\n" );
			File.WriteString( ::BoolToString( m_aKeyDefinez[idxKeyDefine].bSrcAlt )+"\n" );
		}
	}
	catch( CFileException* e )
	{
		e->Delete();
	}
}

void CShitarabianPlugInKeyAssign::Load(
)
{
	try
	{
		CString	strIniFolderPath = CSettingPath::GetInstance()->GetFolderPath();
		CString	strIniFilePath = strIniFolderPath + "keyassign.ini";

		CStdioFile	File( strIniFilePath, CFile::modeRead | CFile::shareDenyNone );
		CString		str;
		BOOL	bExist = TRUE;
		bExist &= File.ReadString( str );
		m_bEnable = bExist && ::StringToBool( str );

		m_aKeyDefinez.RemoveAll();
		while( bExist )
		{
			TKeyDefine	tKeyDefine;
			bExist &= File.ReadString( str );
			tKeyDefine.bSystemDefine = ::StringToBool( str );
			bExist &= File.ReadString( str );
			tKeyDefine.strKeyFunctionName = ::DeQuoteString( str );
			bExist &= File.ReadString( str );
			tKeyDefine.iDstKey = ::StringToVK(::DeQuoteString( str ));
			bExist &= File.ReadString( str );
			tKeyDefine.bDstShift = ::StringToBool( str );
			bExist &= File.ReadString( str );
			tKeyDefine.bDstCtrl = ::StringToBool( str );
			bExist &= File.ReadString( str );
			tKeyDefine.bDstAlt = ::StringToBool( str );
			bExist &= File.ReadString( str );
			tKeyDefine.iSrcKey = ::StringToVK(::DeQuoteString( str ));
			bExist &= File.ReadString( str );
			tKeyDefine.bSrcShift = ::StringToBool( str );
			bExist &= File.ReadString( str );
			tKeyDefine.bSrcCtrl = ::StringToBool( str );
			bExist &= File.ReadString( str );
			tKeyDefine.bSrcAlt = ::StringToBool( str );

			if ( bExist )
			{
				m_aKeyDefinez.Add( tKeyDefine );
			}
		}
	}
	catch( CFileException* e )
	{
		e->Delete();
	}
}
