/*-----------------------------------------------------------------------------
[]	Selection.cpp
[Tv]	INXij̎
[l]	Ȃ
[]	2003-02-26	NC		Rgt(moralog)
-----------------------------------------------------------------------------*/


//-----------------------------------------------------------------------------
// CN[hEsS`
//-----------------------------------------------------------------------------
#include "stdafx.h"
#include "Shitarabian.h"
#include "Selection.h"
#include "ShitarabianDoc.h"
#include "ExeCommon.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


/*-----------------------------------------------------------------------------
[]	RXgN^
[@\]	CX^X̐B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
CSelection::CSelection()
{

}


/*-----------------------------------------------------------------------------
[]	fXgN^
[@\]	CX^X̔jB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
CSelection::~CSelection()
{

}


/*-----------------------------------------------------------------------------
[]	I擾in[Jj
[@\]	I擾B
[ߒl]	long		In[J [-] (-)
[l]	m[}CYꂽl𓾂
-----------------------------------------------------------------------------*/
long	CSelection::GetSelectedStartColumn()
{
	if ( m_idxSelectedRowStart > m_idxSelectedRowEnd )
	{
		return( m_idxSelectedColumnEnd );
	}
	else if ( m_idxSelectedRowStart == m_idxSelectedRowEnd )
	{
		if ( m_idxSelectedColumnStart > m_idxSelectedColumnEnd )
		{
			return( m_idxSelectedColumnEnd );
		}
	}
	return( m_idxSelectedColumnStart );
}


/*-----------------------------------------------------------------------------
[]	I擾iI[Jj
[@\]	I擾B
[ߒl]	long		II[J [-] (-)
[l]	m[}CYꂽl𓾂
-----------------------------------------------------------------------------*/
long	CSelection::GetSelectedEndColumn()
{
	if ( m_pDoc != NULL )
	{
		int		iOver = 0;
		if ( m_pDoc->IsOverwriteMode() )
		{
			iOver = 1;
		}

		if ( m_idxSelectedRowStart < m_idxSelectedRowEnd )
		{
			return( m_idxSelectedColumnEnd+iOver );
		}
		else if ( m_idxSelectedRowStart == m_idxSelectedRowEnd )
		{
			if ( m_idxSelectedColumnStart < m_idxSelectedColumnEnd )
			{
				return( m_idxSelectedColumnEnd+iOver );
			}
		}
		return( m_idxSelectedColumnStart+iOver );
	}
	return( 0 );
}


/*-----------------------------------------------------------------------------
[]	I擾in[sj
[@\]	I擾B
[ߒl]	long		In[s [-] (-)
[l]	m[}CYꂽl𓾂
-----------------------------------------------------------------------------*/
long	CSelection::GetSelectedStartRow()
{
	if ( m_idxSelectedRowStart > m_idxSelectedRowEnd )
	{
		return( m_idxSelectedRowEnd );
	}
	else if ( m_idxSelectedRowStart == m_idxSelectedRowEnd )
	{
		if ( m_idxSelectedColumnStart > m_idxSelectedColumnEnd )
		{
			return( m_idxSelectedRowEnd );
		}
	}
	return( m_idxSelectedRowStart );
}


/*-----------------------------------------------------------------------------
[]	I擾iI[sj
[@\]	I擾B
[ߒl]	long		II[s [-] (-)
[l]	m[}CYꂽl𓾂
-----------------------------------------------------------------------------*/
long	CSelection::GetSelectedEndRow()
{
	if ( m_idxSelectedRowStart < m_idxSelectedRowEnd )
	{
		return( m_idxSelectedRowEnd );
	}
	else if ( m_idxSelectedRowStart == m_idxSelectedRowEnd )
	{
		if ( m_idxSelectedColumnStart < m_idxSelectedColumnEnd )
		{
			return( m_idxSelectedRowEnd );
		}
	}
	return( m_idxSelectedRowStart );
}


/*-----------------------------------------------------------------------------
[]	I𕶎
[@\]	Cӂ̕IĂ邩𔻒肷B
[ߒl]	BOOL	I𔻒 [-] (TRUE:IAFALSE:I)
[l]	Ȃ
-----------------------------------------------------------------------------*/
BOOL	CSelection::IsSelected(
	long	idxRow,			// I  :s [-] (-) :-
	long	idxColumn		// I  :J [-] (-) :-
)
{
	if ( idxRow > GetSelectedEndRow() )
	{
		return( FALSE );
	}else if ( idxRow == GetSelectedEndRow() )
	{
		if ( idxColumn >= GetSelectedEndColumn() )
		{
			return( FALSE );
		}
	}

	if ( idxRow < GetSelectedStartRow() )
	{
		return( FALSE );
	}else if ( idxRow == GetSelectedStartRow() )
	{
		if ( idxColumn < GetSelectedStartColumn() )
		{
			return( FALSE );
		}
	}

	return( TRUE );
}


/*-----------------------------------------------------------------------------
[]	I𕶎擾
[@\]	I𒆂̕擾B
[ߒl]	CString	I𕶎 [-] (-)
[l]	Ȃ
-----------------------------------------------------------------------------*/
CString	CSelection::GetSelectedText()
{
	if ( m_pDoc == NULL )
	{
		return( _T("") );
	}

	CString		strSelectedText;

	int			idxSelectedColumnStart = GetSelectedStartColumn();
	int			idxSelectedColumnEnd = GetSelectedEndColumn();
	int			idxSelectedRowStart = GetSelectedStartRow();
	int			idxSelectedRowEnd = GetSelectedEndRow();


	// X^[gs̃oCgʒuT
	long		idxStartByte;
	CString*	pstrStartLine;
	{
		// s̍폜H
		// Jnʒu擪ȑOĂAO̍s̐K
		if ( idxSelectedColumnStart < 0 )
		{
			pstrStartLine = m_pDoc->GetLine( idxSelectedRowStart-1 );
			if ( pstrStartLine == NULL )
			{
				return( strSelectedText );
			}
			idxSelectedRowStart--;
			idxSelectedColumnStart = ::ByteColumnToCaretColumn( *pstrStartLine, pstrStartLine->GetLength() );
		}

		pstrStartLine = m_pDoc->GetLine( idxSelectedRowStart );
		if ( pstrStartLine == NULL )
		{
			return( strSelectedText );
		}
		idxStartByte = ::CaretColumnToByteColumn( *pstrStartLine, idxSelectedColumnStart );
	}

	// Is̃oCgʒuT
	long		idxEndByte;
	CString*	pstrEndLine = m_pDoc->GetLine( idxSelectedRowEnd );
	{
		if ( pstrEndLine == NULL )
		{
			return( strSelectedText );
		}
		idxEndByte = ::CaretColumnToByteColumn( *pstrEndLine, idxSelectedColumnEnd );
		// s̍폜H
		// IoCgŌȌĂA̍s̓
		if ( idxEndByte > pstrEndLine->GetLength() )
		{
			idxSelectedRowEnd++;
			idxSelectedColumnEnd = 0;
			idxEndByte = 0;
			pstrEndLine = m_pDoc->GetLine( idxSelectedRowEnd );
			if ( pstrEndLine == NULL )
			{
				return( strSelectedText );
			}
		}
	}

	if ( idxSelectedRowStart == idxSelectedRowEnd )
	{
	// PsȂ
		// SubStringĕۑ
		strSelectedText = pstrStartLine->Mid( idxStartByte, idxEndByte - idxStartByte );
	}
	else
	{
	// sɂ킽Ȃ

		// i[̈m
		char*	pCopyBuffer= NULL;
		{
			// KvoCgvZ
			long	nByte = 0;

			long	idxLine;
			for( idxLine=idxSelectedRowStart ; idxLine<=idxSelectedRowEnd ; idxLine++ )
			{
				nByte += m_pDoc->GetLine( idxLine )->GetLength() + strlen( m_pDoc->ReturnChar() );
			}
			pCopyBuffer = new char[ nByte+1 ];
		}

		// Rs[
		{
			long	iOffset = 0;

			//ŏ̍s
			CString		strStartLine = pstrStartLine->Right( pstrStartLine->GetLength() - idxStartByte );
			memcpy( pCopyBuffer, strStartLine, strStartLine.GetLength() );
			iOffset += strStartLine.GetLength();

			// ssŘAĕۑ
			long	idxLine;
			for( idxLine=idxSelectedRowStart+1 ; idxLine<idxSelectedRowEnd ; idxLine++ )
			{
				memcpy( pCopyBuffer+iOffset, m_pDoc->ReturnChar(), strlen( m_pDoc->ReturnChar() ) );
				iOffset += strlen( m_pDoc->ReturnChar() );
				memcpy( pCopyBuffer+iOffset, *( m_pDoc->GetLine( idxLine ) ), m_pDoc->GetLine( idxLine )->GetLength() );
				iOffset += m_pDoc->GetLine( idxLine )->GetLength();
			}

			// Ō̍s
			memcpy( pCopyBuffer+iOffset, m_pDoc->ReturnChar(), strlen( m_pDoc->ReturnChar() ) );
			iOffset += strlen( m_pDoc->ReturnChar() );
			CString		strLastLine = pstrEndLine->Left( idxEndByte );
			memcpy( pCopyBuffer+iOffset, strLastLine, strLastLine.GetLength() );
			iOffset += strLastLine.GetLength();

			pCopyBuffer[ iOffset ] = 0x00;
		}
		strSelectedText = pCopyBuffer;

		delete [] pCopyBuffer;
	}

	return( strSelectedText );
}


/*-----------------------------------------------------------------------------
[]	I𒆔
[@\]	I𑀍쒆𔻒肷B
[ߒl]	BOOL	I𔻒 [-] (TRUE:IAFALSE:I)
[l]	Ȃ
-----------------------------------------------------------------------------*/
BOOL	CSelection::IsSelected()
{
	if ( GetSelectedStartRow() == GetSelectedEndRow() )
	if ( GetSelectedStartColumn() == GetSelectedEndColumn() )
	{
		return( FALSE );
	}
	return( TRUE );
}


/*-----------------------------------------------------------------------------
[]	I
[@\]	IB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void	CSelection::SetSelectedNutral()
{
	if ( m_pDoc != NULL )
	{
		SetSelectedStart(
			m_pDoc->GetCaretRow(),
			m_pDoc->GetCaretColumn()
		);
		SetSelectedEnd(
			m_pDoc->GetCaretRow(),
			m_pDoc->GetCaretColumn()
		);
	}
}


/*-----------------------------------------------------------------------------
[]	In[ݒ
[@\]	In[ݒ肷B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void	CSelection::SetSelectedStart(
	long	idxRow,			// I  :n[s [-] (-) :-
	long	idxColumn		// I  :n[J [-] (-) :-
)
{
	m_idxSelectedRowStart = min( idxRow, m_pDoc->GetLineCount()-1 );
	m_idxSelectedColumnStart = idxColumn;

}

/*-----------------------------------------------------------------------------
[]	II[ݒ
[@\]	II[ݒ肷B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void	CSelection::SetSelectedEnd(
	long	idxRow,			// I  :I[s [-] (-) :-
	long	idxColumn		// I  :I[J [-] (-) :-
)
{
	m_idxSelectedRowEnd = min( idxRow, m_pDoc->GetLineCount()-1 );
	m_idxSelectedColumnEnd = idxColumn;
}


/*-----------------------------------------------------------------------------
[]	Is擾
[@\]	sƂ̑IJ擾B
[ߒl]	CArray<TSelectColumn, TSelectColumn&>*	I [-] (-)
[l]	Ȃ
-----------------------------------------------------------------------------*/
CArray<TSelectColumn, TSelectColumn&>*	CSelection::GetSelectedLinez()
{
	m_atSelectColumnz.RemoveAll();

	int	idxStartRow = GetSelectedStartRow();
	int	idxEndRow = GetSelectedEndRow();

	if ( idxStartRow == idxEndRow )
	{
	// Ps̏ꍇ
		TSelectColumn	tColumn;
		tColumn.idxStart = GetSelectedStartColumn();
		tColumn.idxEnd = GetSelectedEndColumn();
		m_atSelectColumnz.Add( tColumn );
	}
	else
	{
	// Qsȏ̏ꍇ
		TSelectColumn	tColumn;

		// Ps
		tColumn.idxStart = GetSelectedStartColumn();
		tColumn.idxEnd = ::StringToColumn( *(m_pDoc->GetLine( idxStartRow )) );
		m_atSelectColumnz.Add( tColumn );

		int	idxRow;
		for( idxRow=idxStartRow+1 ; idxRow<idxEndRow ; idxRow++ )
		{
			tColumn.idxStart = 0;
			tColumn.idxEnd = ::StringToColumn( *(m_pDoc->GetLine( idxRow )) );
			m_atSelectColumnz.Add( tColumn );
		}

		// ŏIs
		tColumn.idxStart = 0;
		tColumn.idxEnd = GetSelectedEndColumn();
		m_atSelectColumnz.Add( tColumn );
	}

	return( &m_atSelectColumnz );
}


/*-----------------------------------------------------------------------------
[]	Isݒ
[@\]	sƂ̑IJݒ肷B
[ߒl]	BOOL	 [-] (-)
[l]	Ȃ
-----------------------------------------------------------------------------*/
BOOL CSelection::SetSelectedLinez(
	int idxLine,				// I  :s [-] (-) :-
	TSelectColumn& tSelect		// I  :sI [-] (-) :-
)
{
	if ( idxLine < m_atSelectColumnz.GetSize() )
	{
		m_atSelectColumnz.RemoveAt( idxLine );
		m_atSelectColumnz.InsertAt( idxLine, tSelect );

		// m[}Î߂ɁAI͈͖ʒuύX please! sƂ̑I͈͕ύXI/Fpӂׂ
		{
			if ( idxLine == 0 )
			{
				SetSelectedStart( m_idxSelectedRowStart, tSelect.idxStart );
			}
			if ( idxLine == m_atSelectColumnz.GetSize()-1 )
			{
				SetSelectedEnd( m_idxSelectedRowStart+idxLine, tSelect.idxEnd );
			}
		}
		return( TRUE );
	}
	return( FALSE );
}


/*-----------------------------------------------------------------------------
[]	K
[@\]	I𐳋KB
[ߒl]	Ȃ
[l]	Jnsɂ悤ɁddB
-----------------------------------------------------------------------------*/
void CSelection::Normalize()
{
	BOOL	bSwap = FALSE;
	
	if ( m_idxSelectedRowStart > m_idxSelectedRowEnd )
	{
		bSwap = TRUE;
	}

	if ( m_idxSelectedRowStart == m_idxSelectedRowEnd )
	if ( m_idxSelectedColumnStart > m_idxSelectedColumnEnd )
	{
		bSwap = TRUE;
	}

	if ( bSwap )
	{
		int	iTmp;

		iTmp = m_idxSelectedRowStart;
		m_idxSelectedRowStart = m_idxSelectedRowEnd;
		m_idxSelectedRowEnd = iTmp;

		iTmp = m_idxSelectedColumnStart;
		m_idxSelectedColumnStart = m_idxSelectedColumnEnd;
		m_idxSelectedColumnEnd = iTmp;
	}
}

