// RgL
// EmphasisColorDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "shitarabian.h"
#include "EmphasisColorDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CEmphasisColorDlg _CAO


CEmphasisColorDlg::CEmphasisColorDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CEmphasisColorDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CEmphasisColorDlg)
	m_strPattern1 = _T("");
	m_strPattern2 = _T("");
	m_bUnderLine = FALSE;
	m_bToken = FALSE;
	m_bRegExp = FALSE;
	m_bCareCase = FALSE;
	//}}AFX_DATA_INIT
}


void CEmphasisColorDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEmphasisColorDlg)
	DDX_Control(pDX, IDC_EMPHASISCOLOR_REGEXP, m_RegExp);
	DDX_Control(pDX, IDC_EMPHASISCOLOR_TOKEN, m_Token);
	DDX_Control(pDX, IDC_EMPHASISCOLOR_CARECASE, m_CareCase);
	DDX_Control(pDX, IDC_EMPHASISCOLOR_PATTERN1, m_Pattern1);
	DDX_Control(pDX, IDC_EMPHASISCOLOR_PATTERN2, m_Pattern2);
	DDX_Control(pDX, IDC_EMPHASISCOLOR_LABEL1, m_Label1);
	DDX_Control(pDX, IDC_EMPHASISCOLOR_LABEL2, m_Label2);
	DDX_Control(pDX, IDC_EMPHASISCOLOR_FORE, m_Fore);
	DDX_Control(pDX, IDC_EMPHASISCOLOR_BACK, m_Back);
	DDX_Text(pDX, IDC_EMPHASISCOLOR_PATTERN1, m_strPattern1);
	DDX_Text(pDX, IDC_EMPHASISCOLOR_PATTERN2, m_strPattern2);
	DDX_Check(pDX, IDC_EMPHASISCOLOR_UNDERLINE, m_bUnderLine);
	DDX_Check(pDX, IDC_EMPHASISCOLOR_TOKEN, m_bToken);
	DDX_Check(pDX, IDC_EMPHASISCOLOR_REGEXP, m_bRegExp);
	DDX_Check(pDX, IDC_EMPHASISCOLOR_CARECASE, m_bCareCase);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CEmphasisColorDlg, CDialog)
	//{{AFX_MSG_MAP(CEmphasisColorDlg)
	ON_WM_PAINT()
	ON_BN_CLICKED(IDC_EMPHASISCOLOR_FORE, OnEmphasiscolorFore)
	ON_BN_CLICKED(IDC_EMPHASISCOLOR_BACK, OnEmphasiscolorBack)
	ON_WM_LBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEmphasisColorDlg bZ[W nh

BOOL CEmphasisColorDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	m_strPattern1 = m_pEmphasis->GetPattern();
	m_strPattern2 = m_pEmphasis->GetTerminator();
	m_colFore = m_pEmphasis->GetForeColor();
	m_colBack = m_pEmphasis->GetBackColor();
	m_bUnderLine = m_pEmphasis->GetUnderLine();

	m_bCareCase = m_pEmphasis->GetFindCondition()->bCaseCare;
	m_bRegExp = m_pEmphasis->GetFindCondition()->bRegExp;
	m_bToken = m_pEmphasis->GetFindCondition()->bToken;

	if( m_bSystemDefineMode )
	{
		m_Label1.EnableWindow( FALSE );
		m_Label2.EnableWindow( FALSE );
		m_Pattern1.EnableWindow( FALSE );
		m_Pattern2.EnableWindow( FALSE );

		m_RegExp.EnableWindow( FALSE );
		m_CareCase.EnableWindow( FALSE );
		m_Token.EnableWindow( FALSE );
	}

	UpdateData( FALSE );
	return TRUE;
}

void CEmphasisColorDlg::OnOK() 
{
	UpdateData( TRUE );

	m_pEmphasis->SetPattern( m_strPattern1 );
	m_pEmphasis->SetTerminator( m_strPattern2 );
	m_pEmphasis->SetForeColor( m_colFore );
	m_pEmphasis->SetBackColor( m_colBack );
	m_pEmphasis->SetUnderLine( m_bUnderLine );

	m_pEmphasis->GetFindCondition()->bCaseCare = m_bCareCase;
	m_pEmphasis->GetFindCondition()->bRegExp = m_bRegExp;
	m_pEmphasis->GetFindCondition()->bToken = m_bToken;

	CDialog::OnOK();
}

void CEmphasisColorDlg::OnPaint() 
{
	CPaintDC dc(this); // `p̃foCX ReLXg

	{
		CRect	rc;
		m_Fore.GetWindowRect( &rc );
		CPoint	pt( rc.left, rc.top );
		ScreenToClient( &pt );
		rc.right = rc.Width();
		rc.bottom = rc.Height();
		rc.left = pt.x;
		rc.top = pt.y;
		rc.right += pt.x;
		rc.bottom += pt.y;
		dc.FillSolidRect(
			&rc,
			m_colFore
		);
	}

	{
		CRect	rc;
		m_Back.GetWindowRect( &rc );
		CPoint	pt( rc.left, rc.top );
		ScreenToClient( &pt );
		rc.right = rc.Width();
		rc.bottom = rc.Height();
		rc.left = pt.x;
		rc.top = pt.y;
		rc.right += pt.x;
		rc.bottom += pt.y;
		dc.FillSolidRect(
			&rc,
			m_colBack
		);
	}
}

void CEmphasisColorDlg::OnEmphasiscolorFore() 
{
	CColorDialog	dlg;
//	dlg.SetCurrentColor( m_colFore );
	if( dlg.DoModal() == IDOK )
	{
		m_colFore = dlg.GetColor();
		RedrawWindow();
	}
}

void CEmphasisColorDlg::OnEmphasiscolorBack() 
{
	CColorDialog	dlg;
//	dlg.SetCurrentColor( m_colBack );
	if( dlg.DoModal() == IDOK )
	{
		m_colBack = dlg.GetColor();
		RedrawWindow();
	}
}

void CEmphasisColorDlg::OnLButtonDown(UINT nFlags, CPoint point) 
{
	{
		CRect	rc;
		m_Fore.GetWindowRect( &rc );
		CPoint	pt( rc.left, rc.top );
		ScreenToClient( &pt );
		rc.right = rc.Width();
		rc.bottom = rc.Height();
		rc.left = pt.x;
		rc.top = pt.y;
		rc.right += pt.x;
		rc.bottom += pt.y;

		if( rc.left <= point.x )
		if( rc.right >= point.x )
		if( rc.top <= point.y )
		if( rc.bottom >= point.y )
		{
			OnEmphasiscolorFore();
		}
	}

	{
		CRect	rc;
		m_Back.GetWindowRect( &rc );
		CPoint	pt( rc.left, rc.top );
		ScreenToClient( &pt );
		rc.right = rc.Width();
		rc.bottom = rc.Height();
		rc.left = pt.x;
		rc.top = pt.y;
		rc.right += pt.x;
		rc.bottom += pt.y;

		if( rc.left <= point.x )
		if( rc.right >= point.x )
		if( rc.top <= point.y )
		if( rc.bottom >= point.y )
		{
			OnEmphasiscolorBack();
			return;
		}
	}

	CDialog::OnLButtonDown(nFlags, point);
}
