// RgL
// DocumentIF.cpp: CDocumentIF NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"

#include "DocumentIF.h"
#include "StructDefine.h"
#include "MacroCommandDefine.h"


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


// }NR}hs
// ǂ킯__stdcallł̓GNX|[głȂ悤Ȃ̂
// __cdecliCAC++Wjŉ䖝B
typedef BOOL (*EXECUTEMACROCOMMAND)( int, int, void* );
EXECUTEMACROCOMMAND f_funcExecuteMacroCommand = NULL;
BOOL CDocumentIF::ExecuteMacroCommand(
	int				eCommand,
	int				nArg,
	void*			paArg
)
{
	if ( f_funcExecuteMacroCommand == NULL )
	{
		f_funcExecuteMacroCommand = (EXECUTEMACROCOMMAND)GetProcAddress(
			m_hExe,
			"FuncExecuteMacroCommand"
		);
	}

	if ( f_funcExecuteMacroCommand != NULL )
	{
		BOOL bSuccess = f_funcExecuteMacroCommand(
			eCommand,
			nArg,
			paArg
		);

		return( bSuccess );
	}

	return( FALSE );
}


// ĕ`
BOOL CDocumentIF::ReDraw()
{
	return( ExecuteMacroCommand( MC_redraw ) );
}

// `̈wiS̈j
BOOL CDocumentIF::SetAllUpdate()
{
	return( ExecuteMacroCommand( MC_setallupdate ) );
}



int CDocumentIF::GetLineCount()
{
	int		nLine;
	int*	pnLine = &nLine;
	BOOL bSuccess = ExecuteMacroCommand(
		MC_getlinecount,
		1,
		&pnLine
	);
	if ( bSuccess )
	{
		return( nLine );
	}
	return( 0 );
}

// ̎ws擾
CString CDocumentIF::GetLine( int idxLine )
{
	int		iLength =0;
	void*	aArg[2];

	// ̒𓾂
	aArg[0] = &idxLine;
	aArg[1] = NULL;
	aArg[2] = &iLength;
	BOOL bSuccess = ExecuteMacroCommand(
		MC_getline,
		3,
		aArg
	);
	if ( bSuccess )
	{
		iLength++;		// 0x00p̈

		// 𓾂
		aArg[0] = &idxLine;
		aArg[1] = new char[iLength];
		aArg[2] = &iLength;
		BOOL bSuccess = ExecuteMacroCommand(
			MC_getline,
			3,
			aArg
		);
		CString		strLine;
		if ( bSuccess )
		{
			strLine = (char*)aArg[1];
		}
		delete [] aArg[1];
		return( strLine );
	}
	return( "" );
}


// }n
BOOL CDocumentIF::Insert( CString& strInsert )
{
	const char*	pstr = (LPCTSTR)strInsert;
	BOOL bSuccess = ExecuteMacroCommand(
		MC_insert,
		1,
		(void*)&pstr
	);
	return( bSuccess );
}

BOOL CDocumentIF::Insertfix( CString& strInsert )
{
	const char*	pstr = (LPCTSTR)strInsert;
	BOOL bSuccess = ExecuteMacroCommand(
		MC_insertfix,
		1,
		(void*)&pstr
	);
	return( bSuccess );
}

// 폜n
BOOL CDocumentIF::Backspace()
{
	return( ExecuteMacroCommand( MC_backspace ) );
}

BOOL CDocumentIF::Delete()
{
	return( ExecuteMacroCommand( MC_delete ) );
}

BOOL CDocumentIF::Up()
{
	BOOL bSuccess = ExecuteMacroCommand(
		MC_up,
		0,
		NULL
	);
	return( bSuccess );
}

BOOL CDocumentIF::Down()
{
	BOOL bSuccess = ExecuteMacroCommand(
		MC_down,
		0,
		NULL
	);
	return( bSuccess );
}

BOOL CDocumentIF::Left()
{
	BOOL bSuccess = ExecuteMacroCommand(
		MC_left,
		0,
		NULL
	);
	return( bSuccess );
}

BOOL CDocumentIF::Right()
{
	BOOL bSuccess = ExecuteMacroCommand(
		MC_right,
		0,
		NULL
	);
	return( bSuccess );
}

BOOL CDocumentIF::LineTop()
{
	BOOL bSuccess = ExecuteMacroCommand(
		MC_golinetop,
		0,
		NULL
	);
	return( bSuccess );
}

BOOL CDocumentIF::LineEnd()
{
	BOOL bSuccess = ExecuteMacroCommand(
		MC_golineend,
		0,
		NULL
	);
	return( bSuccess );
}

BOOL CDocumentIF::FileTop()
{
	BOOL bSuccess = ExecuteMacroCommand(
		MC_gofiletop,
		0,
		NULL
	);
	return( bSuccess );
}

BOOL CDocumentIF::FileEnd()
{
	BOOL bSuccess = ExecuteMacroCommand(
		MC_gofileend,
		0,
		NULL
	);
	return( bSuccess );
}

BOOL CDocumentIF::JumpToRow( int iRow )
{
	const int*	piRow = &iRow;
	BOOL bSuccess = ExecuteMacroCommand(
		MC_gocaretrow,
		1,
		(void*)&piRow
	);
	return( bSuccess );
}

BOOL CDocumentIF::JumpToColumn( int iColumn )
{
	const int*	piColumn = &iColumn;
	BOOL bSuccess = ExecuteMacroCommand(
		MC_gocaretcolumn,
		1,
		(void*)&piColumn
	);
	return( bSuccess );
}

// GUI
BOOL CDocumentIF::EntryToolBar(
	int		idResource
)
{
//	int		idResource = IDR_DLLTOOLBAR;
	int*	pidResource = &idResource;
	BOOL bSuccess = ExecuteMacroCommand(
		MC_entrytoolbar,
		1,
		&pidResource
	);
	return( bSuccess );
}

CComboBox*	CDocumentIF::SpawnComboBox(
	int			idxButton,
	int			iWidth,
	BOOL		bEdit
)
{
	HWND		hwnd;

	void*	aArg[4];
	aArg[0] = &idxButton;
	aArg[1] = &iWidth;
	aArg[2] = &bEdit;
	aArg[3] = &hwnd;

	BOOL bSuccess = ExecuteMacroCommand(
		MC_spawncombobox,
		4,
		aArg
	);
	if ( bSuccess )
	{
		CComboBox*	pCombo = (CComboBox*)( CWnd::FromHandle( hwnd ) );
		return( pCombo );
	}
	return( NULL );
}


BOOL CDocumentIF::ShowToolBar(
	BOOL	bShow
)
{
	BOOL*	pbShow = &bShow;
	BOOL bSuccess = ExecuteMacroCommand(
		MC_showtoolbar,
		1,
		&pbShow
	);
	return( bSuccess );
}

BOOL	CDocumentIF::KeyDown(
	CString		strChar,
	BOOL		bShift,
	BOOL		bCtrl,
	BOOL		bAlt
)
{
	void*	aArg[4];
	aArg[0] = (void*)(LPCTSTR)strChar;
	aArg[1] = &bShift;
	aArg[2] = &bCtrl;
	aArg[3] = &bAlt;

	BOOL bSuccess = ExecuteMacroCommand(
		MC_keydown,
		4,
		aArg
	);

	return( bSuccess );
}

BOOL	CDocumentIF::KeyInput(
	CString		strChar,
	BOOL		bShift,
	BOOL		bCtrl,
	BOOL		bAlt
)
{
	void*	aArg[4];
	aArg[0] = (void*)(LPCTSTR)strChar;
	aArg[1] = &bShift;
	aArg[2] = &bCtrl;
	aArg[3] = &bAlt;

	BOOL bSuccess = ExecuteMacroCommand(
		MC_keyinput,
		4,
		aArg
	);

	return( bSuccess );
}


BOOL CDocumentIF::SetSelectMode( int iMode )
{
	const int*	piMode = &iMode;
	BOOL bSuccess = ExecuteMacroCommand(
		MC_setselectmode,
		1,
		(void*)&piMode
	);
	return( bSuccess );
}

BOOL CDocumentIF::GetSelectMode( int* piMode )
{
	BOOL bSuccess = ExecuteMacroCommand(
		MC_getselectmode,
		1,
		(void*)&piMode
	);
	return( bSuccess );
}

BOOL CDocumentIF::GetROI( CRect* prcROI )
{
	BOOL bSuccess = ExecuteMacroCommand(
		MC_getroi,
		1,
		(void*)&prcROI
	);
	return( bSuccess );
}

BOOL CDocumentIF::Draw(
	CDC*	pDstDC,
	int		iDstLeft,
	int		iDstTop,
	CRect	rcSrcROI
)
{
	void*	aArg[4];
	HDC		hdc = 	pDstDC->m_hDC;
	aArg[0] = (void*)&hdc;
	aArg[1] = (void*)&iDstLeft;
	aArg[2] = (void*)&iDstTop;

	RECT		rcROI = rcSrcROI;
	aArg[3] = (void*)&rcROI;

	BOOL bSuccess = ExecuteMacroCommand(
		MC_draw,
		4,
		aArg		
	);
	return( bSuccess );
}

void CDocumentIF::SetEmphasisEnable( BOOL bEmphasis )
{
	BOOL*	pbEmphasis = &bEmphasis;
	ExecuteMacroCommand(
		MC_setemphasisenable,
		1,
		(void*)&pbEmphasis
	);
	return;
}

BOOL CDocumentIF::GetEmphasisEnable()
{
	BOOL bEmphasis = ExecuteMacroCommand(
		MC_getemphasisenable,
		0,
		NULL
	);
	return( bEmphasis );
}


CString	CDocumentIF::GetIniPath()
{
	int		iLength =0;
	void*	aArg[2];

	// ̒𓾂
	aArg[0] = NULL;
	aArg[1] = &iLength;
	BOOL bSuccess = ExecuteMacroCommand(
		MC_getinipath,
		2,
		aArg
	);
	if ( bSuccess )
	{
		iLength++;		// 0x00p̈

		// 𓾂
		aArg[0] = new char[iLength];
		aArg[1] = &iLength;
		BOOL bSuccess = ExecuteMacroCommand(
			MC_getinipath,
			2,
			aArg
		);
		CString		strIniPath;
		if ( bSuccess )
		{
			strIniPath = (char*)aArg[0];
		}
		delete [] aArg[0];
		return( strIniPath );
	}
	return( "" );
}


// EBhE`擾
CRect CDocumentIF::GetClientRect()
{
	RECT	rcClient;
	RECT*	prcClient = &rcClient;
	ExecuteMacroCommand(
		MC_getclientrect,
		1,
		(void*)&prcClient
	);
	return( rcClient );
}

// IeLXg擾
CString CDocumentIF::GetSelectedText()
{
	int		iLength =0;
	void*	aArg[2];

	// ̒𓾂
	aArg[0] = NULL;
	aArg[1] = &iLength;
	BOOL bSuccess = ExecuteMacroCommand(
		MC_getselectedtext,
		2,
		aArg
	);
	if ( bSuccess )
	{
		iLength++;		// 0x00p̈

		// 𓾂
		aArg[0] = new char[iLength];
		aArg[1] = &iLength;
		BOOL bSuccess = ExecuteMacroCommand(
			MC_getselectedtext,
			2,
			aArg
		);
		CString		str;
		if ( bSuccess )
		{
			str = (char*)aArg[0];
		}
		delete [] aArg[0];
		return( str );
	}
	return( "" );
}


// ʏI擾
void CDocumentIF::GetSelectInfoNormal(
	int*	piStartRow,
	int*	piStartColumn,
	int*	piEndRow,
	int*	piEndColumn
)
{
	void*	aArg[4];
	aArg[0] = (void*)piStartRow;
	aArg[1] = (void*)piStartColumn;
	aArg[2] = (void*)piEndRow;
	aArg[3] = (void*)piEndColumn;

	ExecuteMacroCommand(
		MC_getselectinfonormal,
		4,
		aArg
	);
	return;
}

// anwI擾
void CDocumentIF::GetSelectInfoBox(
	CDWordArray*	pdwaSelectInfoz
)
{
	ExecuteMacroCommand(
		MC_getselectinfobox,
		1,
		(void*)&pdwaSelectInfoz
	);
	return;
}

// IԔ
BOOL CDocumentIF::IsSelected()
{
	BOOL	bSelected;
	BOOL*	pbSelected = &bSelected;
	ExecuteMacroCommand(
		MC_isselected,
		1,
		(void*)&pbSelected
	);
	return( bSelected );
}


void CDocumentIF::ScrollToCaret()
{
	ExecuteMacroCommand(
		MC_scrolltocaret,
		0,
		NULL
	);
	return;
}
