/*-----------------------------------------------------------------------------
[]	ShitarabianView.cpp
[Tv]	r[NX̎
[l]	Ȃ
[]	2003-04-23	NC		Rgt(moralog)
-----------------------------------------------------------------------------*/

//-----------------------------------------------------------------------------
// CN[h
//-----------------------------------------------------------------------------
#include "stdafx.h"
#include "Common.h"
#include "Shitarabian.h"
#include "MainFrm.h"
#include "ShitarabianDoc.h"
#include "ShitarabianView.h"
#include "imm.h"
#include "EditDrawer.h"
#include "CommandManager.h"
#include "CommandInput.h"
#include "CommandCaret.h"
#include "CommandDelete.h"
#include "GeneralSetting.h"
#include <process.h>
#include "Selection.h"
#include "BoxSelection.h"
#include "FloatingSelection.h"
#include "CommandMultiEdit.h"
#include "Padding.h"
#include "TokenReader.h"
#include "ToolBarManager.h"
#include "ShitarabianPlugInManager.h"
#include "Unicoder.h"


/*-----------------------------------------------------------------------------
[]	`IuWFNg擾
[@\]	`IuWFNg̎擾B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
static CEditDrawer*	GetDrawer()
{
	return( CEditDrawer::GetInstance() );
}


/*-----------------------------------------------------------------------------
[]	샂[hؑփnh
[@\]	샂[hؑ֏B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CShitarabianView::OnEditModeselect() 
{
	CShitarabianDoc*	pDoc = GetDocument();

	switch( pDoc->GetOperationMode() )
	{
	case OperationNormal:
		// BOXIֈڍs
		pDoc->SetOperationMode( OperationBoxSelect );
		break;

	case OperationFloating:
		// 蒅
		{
			CFloatingSelection*	pSelection;
			pSelection = pDoc->GetFloatingSelection();
			pSelection->Confirm();
		}
		// ʏҏWֈڍs
		pDoc->SetOperationMode( OperationNormal );
		break;

	case OperationBoxSelect:
	default:
		// ʏҏWֈڍs
		pDoc->SetOperationMode( OperationNormal );
		break;
	}

	// I͈͏
	CSelection*	pSelection;
	pSelection = pDoc->GetSelection();
	pSelection->SetSelectedNutral();

	// ĕ`
	// LbgON/OFF̂őS`
	OnSetFocus( NULL );
	pDoc->SetAllUpdate();
	pDoc->ReDraw();
}


/*-----------------------------------------------------------------------------
[]	L[nh
[@\]	샂[hɉL[ւ̐U蕪B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
BOOL CShitarabianView::OnKeyDown(
	UCHAR	unKey,				// I  :L[ [zL[R[h] (-) :-
	BOOL	bShift,				// I  :Vtg [-] (TRUE:AFALSE:Ȃ) :-
	BOOL	bCtrl,				// I  :Ctrl [-] (TRUE:AFALSE:Ȃ) :-
	BOOL	bAlt				// I  :Alt [-] (TRUE:AFALSE:Ȃ) :-
)
{
	CShitarabianDoc* pDoc = GetDocument();

	if ( GetFocus() != this )
	{
		// tH[JXEBhEłȂĂɗB
		// itH[JXĂjEBhEɃbZ[W]B
		return( FALSE );
	}

	BOOL	bBreak = FALSE;

// Oꍇ͈ȍ~ŏȂ悤ɓ̂ȂR[hɖւ
	// DLLɂL[O
	CShitarabianPlugInManager::GetInstance()->OnKeyDown( pDoc, &unKey, &bShift, &bCtrl, &bAlt );

	// ANZ[^L[`FbN
	bBreak = ((CMainFrame*)AfxGetMainWnd())->AccelKeyDown( &unKey, &bShift, &bCtrl, &bAlt );

	// L[
	if ( !bBreak )
	switch( pDoc->GetOperationMode() )
	{
	case OperationROI:
		bBreak = PreTranslateKeyDownROIMode( unKey, bShift, bCtrl, bAlt );
		break;
	case OperationBoxSelect:
		bBreak = PreTranslateKeyDownBoxSelectMode( unKey, bShift, bCtrl, bAlt );
		break;
	case OperationFloating:
		bBreak = PreTranslateKeyDownFloatingMode( unKey, bShift, bCtrl, bAlt );
		break;
	case OperationNormal:
		bBreak = PreTranslateKeyDownNormalMode( unKey, bShift, bCtrl, bAlt );
		break;
	default:
		break;
	}

	return( bBreak );
}


/*-----------------------------------------------------------------------------
[]	̓nh
[@\]	샂[hɉ͏ւ̐U蕪B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
BOOL CShitarabianView::OnChar(
	CString	strChar,			// I  :͕@[-] (-) :-
	BOOL	bShift,				// I  :Vtg [-] (TRUE:AFALSE:Ȃ) :-
	BOOL	bCtrl,				// I  :Ctrl [-] (TRUE:AFALSE:Ȃ) :-
	BOOL	bAlt,				// I  :Alt [-] (TRUE:AFALSE:Ȃ) :-
	BOOL	bTranslate			// I  :ǂݑւL [-] (TRUE:AFALSE:Ȃ) :-
)
{
	CShitarabianDoc* pDoc = GetDocument();

	if ( GetFocus() != this )
	{
		// tH[JXEBhEłȂĂɗB
		// itH[JXĂjEBhEɃbZ[W]B
		return( FALSE );
	}

	BOOL	bBreak = FALSE;

	// DLLɂL[O
	if ( bTranslate )
	{
		CShitarabianPlugInManager::GetInstance()->OnChar( pDoc, &strChar, &bShift, &bCtrl, &bAlt );
	}

	// L[͏
	switch( pDoc->GetOperationMode() )
	{
	case OperationROI:
		bBreak = PreTranslateCharROIMode( strChar, bShift, bCtrl, bAlt );
		break;
	case OperationBoxSelect:
		bBreak = PreTranslateCharBoxSelectMode( strChar, bShift, bCtrl, bAlt );
		break;
	case OperationFloating:
		bBreak = PreTranslateCharFloatingMode( strChar, bShift, bCtrl, bAlt );
		break;
	case OperationNormal:
		bBreak = PreTranslateCharNormalMode( strChar, bShift, bCtrl, bAlt );
		break;
	default:
		break;
	}

	return( bBreak );
}


/*-----------------------------------------------------------------------------
[]	bZ[Wnh
[@\]	L[͏B
[ߒl]	Ȃ
[l]	CView::PreTranslateMessage()̃wvQƁB
-----------------------------------------------------------------------------*/
BOOL CShitarabianView::PreTranslateMessage( MSG* pMsg ) 
{
	CShitarabianDoc* pDoc = GetDocument();
	BOOL	bBreak = FALSE;

	// L[Ԃ̎擾
	BOOL	bShift = ::GetAsyncKeyState( VK_SHIFT ) &0x8000;
	BOOL	bCtrl = ::GetAsyncKeyState( VK_CONTROL ) &0x8000;
	BOOL	bAlt = ::GetAsyncKeyState( VK_MENU ) &0x8000;

	// L[
	switch( pMsg->message )
	{
	case WM_KEYDOWN:
		{
			UCHAR	unKey = (UCHAR)pMsg->wParam;
			bBreak = OnKeyDown( unKey, bShift, bCtrl, bAlt );
			if ( !bBreak )
			{
//				bBreak = OnChar( unKey, bShift, bCtrl, bAlt, FALSE );
			}
		}
		break;

	case WM_CHAR:
		{
			CString		strChar;
			strChar = (CString)((char)pMsg->wParam);
			bBreak = OnChar( strChar, bShift, bCtrl, bAlt, TRUE );
			if ( !strChar.IsEmpty() )
			if ( !bBreak )
			{
				bBreak = OnKeyDown( strChar[0], bShift, bCtrl, bAlt );
			}
		}
		break;

	case WM_IME_COMPOSITION:
		{
			CString		strChar;
			{
				if ( pMsg->lParam & GCS_RESULTSTR )
				{
					HIMC hIMC = ::ImmGetContext( m_hWnd );

					// Shift-Jisœǂݍ
					char*	pstr = NULL;
					{
						long nByte = ::ImmGetCompositionString( hIMC, GCS_RESULTSTR, NULL, 0 );
						long nChar = nByte / sizeof(char);
						pstr = new char [ nChar+1 ];
						ImmGetCompositionString( hIMC, GCS_RESULTSTR, (void*)pstr, nByte );
						ImmReleaseContext( m_hWnd, hIMC );
						pstr[nChar] = '\0';
					}

					// Unicodeœǂݍ
					wchar_t*	pwstr;
					{
						long nByte = ::ImmGetCompositionStringW( hIMC, GCS_RESULTSTR, NULL, 0 );
						long nChar = nByte / sizeof(wchar_t);
						pwstr = new wchar_t[ nChar+1 ];
						ImmGetCompositionStringW( hIMC, GCS_RESULTSTR, (void*)pwstr, nByte );
						ImmReleaseContext( m_hWnd, hIMC );
						pwstr[nChar] = (L'\0');
					}

					// UnicodeShift-Jisɕϊ
					strChar = CUnicoder::GetSJisString( pstr, pwstr );

					delete [] pwstr;
					delete [] pstr;

					// IMẼEBhEǂɕ\ꂽ킩Ȃ̂łׂčĕ`
					pDoc->SetAllUpdate();
				}
				else
				{
					break;
				}
			}
			bBreak = OnChar( strChar, bShift, bCtrl, bAlt, FALSE );
		}
		break;

	default:
		break;
	}

	if ( bBreak )
	{
		// XN[łł΃XN[o[𐧌
		ScrollToCaret();

		// ĕ`
		pDoc->ReDraw();

		// DrawCaret()ƕ`悪SȂB
		// Lbg̕`DrawPage()łB
		return( bBreak );
	}

	// L[͈ȊÕCxg
	switch( pDoc->GetOperationMode() )
	{
	case OperationBoxSelect:
		{
			bBreak = PreTranslateBoxSelectMode( pMsg, bShift, bCtrl, bAlt );
			if ( !bBreak )
			{
				bBreak = PreTranslateNormalMode( pMsg, bShift, bCtrl, bAlt );
			}
			if ( !bBreak )
			{
				bBreak = CView::PreTranslateMessage( pMsg );
			}
		}
		break;

	case OperationFloating:
		{
			bBreak = PreTranslateFloatingMode( pMsg, bShift, bCtrl, bAlt );
			if ( !bBreak )
			{
				bBreak = CView::PreTranslateMessage( pMsg );
			}
		}
		break;

	case OperationROI:
		{
			bBreak = PreTranslateROIMode( pMsg, bShift, bCtrl, bAlt );
			if ( !bBreak )
			{
				bBreak = CView::PreTranslateMessage( pMsg );
			}
		}
		break;

	case OperationNormal:
	default:
		{
			bBreak = PreTranslateNormalMode( pMsg, bShift, bCtrl, bAlt );
			if ( !bBreak )
			{
				bBreak = CView::PreTranslateMessage( pMsg );
			}
		}
		break;
	}
	return( bBreak );
}


/*-----------------------------------------------------------------------------
[]	XN[nh
[@\]	XN[B
[ߒl]	Ȃ
[l]	CView::OnHScroll()̃wvQƁB
-----------------------------------------------------------------------------*/
void CShitarabianView::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	CRect		rcClient;
	GetClientRect( &rcClient );
	CPoint		ptOldScroll = GetDeviceScrollPosition();

	HScrollCore(
		nSBCode,
		nPos,
		pScrollBar,
		ptOldScroll
	);
}


/*-----------------------------------------------------------------------------
[]	XN[nh
[@\]	XN[B
[ߒl]	Ȃ
[l]	CView::OnVScroll()̃wvQƁB
-----------------------------------------------------------------------------*/
void CShitarabianView::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	CRect		rcClient;
	GetClientRect( &rcClient );
	CPoint		ptOldScroll = GetDeviceScrollPosition();

	VScrollCore(
		nSBCode,
		nPos,
		pScrollBar,
		ptOldScroll
	);
}


/*-----------------------------------------------------------------------------
[]	TCYύXnh
[@\]	ĕ`揈B
[ߒl]	CView::OnSize() ̃wvQƁB
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CShitarabianView::OnSize(UINT nType, int cx, int cy) 
{
	CView::OnSize(nType, cx, cy);

	// XN[o[
	m_lMaxXPixel = 0;
	
	CShitarabianDoc* pDoc = GetDocument();
	pDoc->SetAllUpdate();
	pDoc->ReDraw();
}


/*-----------------------------------------------------------------------------
[]	DCpӃnh
[@\]	XN[邽߂DC̃}bsOύXB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CShitarabianView::OnPrepareDC(CDC* pDC, CPrintInfo* pInfo) 
{
	// warning C4100:x̖
	pInfo;

	CPoint	ptScrollBox = GetDeviceScrollPosition();
	pDC->SetViewportOrg( -ptScrollBox.x, -ptScrollBox.y );
	pDC->OffsetClipRgn( -ptScrollBox.x, -ptScrollBox.y );
}


/*-----------------------------------------------------------------------------
[]	}EXzC[nh
[@\]	XN[B
[ߒl]	CView::OnRegisteredMouseWheel()̃wvQƁB
[l]
	please! 2000 OnRegisteredMouseWheel H
	 OnRegisteredMouseWheel  Windows 95  Windows NT 3.51 ̃bZ[W܂B
	Windows NT 4.0 bZ[ẂAOnMouseWheel ŏ܂B
-----------------------------------------------------------------------------*/
LRESULT CShitarabianView::OnRegisteredMouseWheel( WPARAM wParam, LPARAM lParam ) 
{
	OnMouseWheel(
			(UINT)(((DWORD)wParam)&0x0FFFF),			// flag
			(short)(((DWORD)wParam)/0x10000),		// zDelta
			CPoint(
				(short)(((DWORD)lParam)&0xFFFF),		// x
				(short)(((DWORD)lParam)/0x10000)		// y
			)
	);
	return( 0 );
}


/*-----------------------------------------------------------------------------
[]	}EXzC[nh
[@\]	XN[B
[ߒl]	CView::OnMouseWheel()̃wvQƁB
[l]
	XPp?
	XPƃ}EXzC[̉]Cxgłʂ
	 OnRegisteredMouseWheel  Windows 95  Windows NT 3.51 ̃bZ[W܂B
		Windows NT 4.0 bZ[ẂAOnMouseWheel ŏ܂B
-----------------------------------------------------------------------------*/
BOOL CShitarabianView::OnMouseWheel(UINT nFlags, short zDelta, CPoint pt) 
{
	// warning C4100:x̖
	pt; nFlags;

// please! 2000 OnRegisteredMouseWheel H
	CPoint		ptOldScroll = GetDeviceScrollPosition();
	CPoint		ptScroll = ptOldScroll;

	CEditDrawer*		pDrawer = GetDrawer();
	UINT		uiPixelY = pDrawer->CaretRowToPixelZoomed( CGeneralSetting::GetInstance()->GetWheelMove() );
	if ( zDelta < 0 )
	{
		ptScroll.y += uiPixelY;
	}
	else
	{
		ptScroll.y -= uiPixelY;
	}

	// XN[{bNX̉摜炷Kvȗ̈ĕ`
	ManualVScroll( ptScroll.y );

	return( TRUE );
}


/*-----------------------------------------------------------------------------
[]	t@Chbvnh
[@\]	hbvꂽt@CʑŊJB
[ߒl]	Ȃ
[l]	CView::OnDropFiles() ̃wvQƁB
-----------------------------------------------------------------------------*/
void CShitarabianView::OnDropFiles(HDROP hDropInfo) 
{
	const	iMaxLength( 1028 );	// pXi[obt@

	// st@C𓾂
	char	strExeShortPath[ iMaxLength ];
	{
		char	strExeLongPath[ iMaxLength ];
		::GetModuleFileName(
			NULL,
			strExeLongPath,
			iMaxLength
		);

		// V[gt@C̃pX𓾂
		::GetShortPathName( strExeLongPath, strExeShortPath, iMaxLength );
	}

	// hbOꂽt@C̏
	int nFile = DragQueryFile(
		hDropInfo,
		0xFFFFFFFF,
		NULL,
		0
	);
	for (int idxFile=0; idxFile<nFile; idxFile++)
	{
		char	strFilename[ iMaxLength ];

		// hLg̃t@C𓾂
		DragQueryFile( hDropInfo, idxFile, strFilename, iMaxLength );
		char	strDocumentShortPath[ iMaxLength ];
		::GetShortPathName( strFilename, strDocumentShortPath, iMaxLength );

		// ʑŊJ
		_spawnl( _P_NOWAIT, strExeShortPath, strExeShortPath, strDocumentShortPath, NULL );
	}
	DragFinish( hDropInfo );
}


/*-----------------------------------------------------------------------------
[]	J[\ݒnh
[@\]	J[\ACR̐ݒB
[ߒl]	Ȃ
[l]	CView::OnSetCursor() ̃wvQƁB
-----------------------------------------------------------------------------*/
BOOL CShitarabianView::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message) 
{
	switch ( nHitTest )
	{
	case HTCLIENT:
		{
			if ( m_bInputMode )
			{
//				ShowCursor( FALSE );
			}
			else
			{
				CShitarabianDoc* pDoc = GetDocument();
				switch( pDoc->GetOperationMode() )
				{
				case OperationNormal:
					// ɂƂIr[
					SetCursor( AfxGetApp()->LoadStandardCursor(IDC_IBEAM) );
					break;
				case OperationBoxSelect:
					// hbO͕K{J[\
					if ( m_bDrag )
					{
						SetCursor( AfxGetApp()->LoadStandardCursor(IDC_CROSS) );
					}
					// 
				case OperationFloating:
					// I͈͂̏ɂƂ͈ړAłȂ΁{
					{
						// J[\ʒu𓾂
						CPoint	ptScreen;
						GetCursorPos( &ptScreen );
						CPoint ptClient = ptScreen;
						ScreenToClient( &ptClient );

						CPoint		ptPixel = ScrollBoxToPixel( ptClient );


						CEditDrawer*	pDrawer = CEditDrawer::GetInstance();
						CShitarabianDoc*	pDoc = GetDocument();

						int	iRow = pDrawer->PixelToCaretRow( ptPixel.y, pDoc );
						if ( iRow < pDoc->GetLineCount() )
						{
							int	iColumn = 0;
							CEmphasisLine*	pEmphasisLine = pDoc->GetEmphasisLine( iRow );
							if ( pEmphasisLine != NULL )
							{
								iColumn = pEmphasisLine->PixelToCaretColumn( ptPixel.x, TRUE );
							}

							CSelection*			pSelection = pDoc->GetSelection();
							BOOL	bSelected = pSelection->IsSelected(
								iRow, iColumn
							);

							// ̍W͑IĂ邩H
							if ( bSelected )
							{
								SetCursor( AfxGetApp()->LoadStandardCursor(IDC_SIZEALL) );
							}
							else
							{
								SetCursor( AfxGetApp()->LoadStandardCursor(IDC_CROSS) );
							}
						}
					}
					break;
				case OperationROI:
					SetCursor( AfxGetApp()->LoadStandardCursor(IDC_ARROW) );
					break;
				default:
					break;
				}
			}
			return TRUE;
		}
		break;

	default:
		return CView::OnSetCursor(pWnd, nHitTest, message);
		break;
	}
}


/*-----------------------------------------------------------------------------
[]	wi`nh
[@\]	wi`揈̔p~B
[ߒl]	Ȃ
[l]	CView::OnEraseBkgnd() ̃wvQƁB
-----------------------------------------------------------------------------*/
BOOL CShitarabianView::OnEraseBkgnd(CDC* pDC) 
{
	// warning C4100:x̖
	pDC;

	return( TRUE );
}


/*-----------------------------------------------------------------------------
[]	tH[JX擾nh
[@\]	ĕ`揈B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CShitarabianView::OnSetFocus(CWnd* pOldWnd) 
{
	CView::OnSetFocus(pOldWnd);

	CShitarabianDoc* pDoc = GetDocument();
	pDoc->SetAllUpdate();

	m_bVisibleCaret = TRUE;

	m_bDrag = FALSE;
}


/*-----------------------------------------------------------------------------
[]	tH[JXrnh
[@\]	Lbg̔jB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CShitarabianView::OnKillFocus(CWnd* pNewWnd) 
{
	CView::OnKillFocus(pNewWnd);
	DestroyCaret();
	m_bVisibleCaret = FALSE;
}


/*-----------------------------------------------------------------------------
[]	Is󔒕ij[nhj
[@\]	Iꂽsɑ΂āAs̋󔒕菜B
		ꕔłIĂsɑ΂ďB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CShitarabianView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	// warning C4100:x̖
	nFlags;

	CShitarabianDoc*	pDoc = GetDocument();

	CMenu menu;
	switch( pDoc->GetOperationMode() )
	{
	case OperationNormal:
		NormalPopUp( point );
		return;
		break;
	case OperationBoxSelect:
	default:
		VERIFY(menu.LoadMenu(IDR_POPUP));
		break;
	case OperationFloating:
		VERIFY(menu.LoadMenu(IDR_FLOATPOPUP));
		break;
	case OperationROI:
		ToNormal();
		pDoc->ReDraw();
		return;
		break;
	}

	CMenu* pPopup = menu.GetSubMenu(0);
	ASSERT(pPopup != NULL);


	ClientToScreen( &point );
	pPopup->TrackPopupMenu(
		TPM_LEFTALIGN | TPM_RIGHTBUTTON,
		point.x, point.y,
		AfxGetMainWnd()
	);
}

