/*-----------------------------------------------------------------------------
[]	ShitarabianViewBoxSelection.cpp
[Tv]	ViewNXiBOXIj̎
[l]	Ȃ
[]	2003-02-25	NC		Rgt(moralog)
-----------------------------------------------------------------------------*/


//-----------------------------------------------------------------------------
// CN[h
//-----------------------------------------------------------------------------
#include "stdafx.h"
#include "Common.h"
#include "Shitarabian.h"
#include "ShitarabianDoc.h"
#include "ShitarabianView.h"
#include "imm.h"
#include "EditDrawer.h"
#include "CommandManager.h"
#include "CommandInput.h"
#include "CommandCaret.h"
#include "CommandDelete.h"
#include "GeneralSetting.h"
#include <process.h>
#include "Selection.h"
#include "BoxSelection.h"
#include "FloatingSelection.h"
#include "CommandMultiEdit.h"
#include "Padding.h"
#include "TokenReader.h"
#include "ExeCommon.h"


//-----------------------------------------------------------------------------
// t@C֐
//-----------------------------------------------------------------------------

/*-----------------------------------------------------------------------------
[]	`IuWFNg擾
[@\]	`IuWFNg擾B
[ߒl]	CEditDrawer*	`IuWFNg [-] (-)
[l]	Ȃ
-----------------------------------------------------------------------------*/
static CEditDrawer*	GetDrawer()
{
	return( CEditDrawer::GetInstance() );
}


//-----------------------------------------------------------------------------
// NXo֐
//-----------------------------------------------------------------------------

/*-----------------------------------------------------------------------------
[]	Cxgnh
[@\]	Ƀ}EXCxgB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
BOOL CShitarabianView::PreTranslateBoxSelectMode(
	MSG*	pMsg,				// I  :bZ[W [-] (-)
	BOOL	bShift,				// I  :Vtg [-] (TRUE:AFALSE:Ȃ)
	BOOL	bCtrl,				// I  :Ctrl [-] (TRUE:AFALSE:Ȃ)
	BOOL	bAlt				// I  :Alt [-] (TRUE:AFALSE:Ȃ)
) 
{
	// warning C4100:x̖
	bAlt; bShift; 

	CEditDrawer*	pDrawer = GetDrawer();
	CShitarabianDoc* pDoc = GetDocument();
	CSelection*			pSelection = pDoc->GetSelection();

	BOOL	bBreak = FALSE;
	BOOL	bRedraw = FALSE;
	BOOL	bSelectedModify = FALSE;

	int idxOldSelectedStartRow = pSelection->GetSelectedStartRow();
	int idxOldSelectedEndRow = pSelection->GetSelectedEndRow();

	switch( pMsg->message )
	{
	case WM_LBUTTONUP:
		m_bDrag = FALSE;
		m_bVisibleCaret = TRUE;
		ReleaseCapture();
		break;

	case WM_MOUSEMOVE:
		// ͑쎞ɏĂ}EXJ[\̓}EXړŌ
		m_bInputMode = FALSE;
		DrawStatusBar();

		if ( !(GetAsyncKeyState( VK_LBUTTON ) &0x8000) )
		{
			m_bDrag = FALSE;
		}
		if ( m_bDrag )
		{
			// sNZW𓾂
			POINTS	pt = MAKEPOINTS( pMsg->lParam );
			CPoint posCursor( pt.x, pt.y );
			posCursor = ScrollBoxToPixel( posCursor );
			
			pDoc->GetBoxSelection()->SetSelectedEndPixel( posCursor );
			posCursor.y = max( posCursor.y, 0 );

			bSelectedModify = TRUE;
			bRedraw = TRUE;

			// I[gXN[
			{
				// ScrollToCaret() ŃJ^邽߂ɃLbgړ
				// YsvZ
				int idxRow = pDrawer->PixelToCaretRow( posCursor.y, pDoc );
				idxRow = min( idxRow, pDoc->GetLineCount()-1 );

				CString*	pstrCurrentLine = pDoc->GetLine( idxRow );
				if ( pstrCurrentLine != NULL )
				{
					int	idxColumn = 0;
					CEmphasisLine*	pEmphasisLine = pDoc->GetEmphasisLine( idxRow );
					if ( pEmphasisLine != NULL )
					{
						idxColumn = pEmphasisLine->PixelToCaretColumn( posCursor.x );
					}

					// Lbg̈ړ
					CCommandCaret	cmdCaret;
					cmdCaret.SetAttribute( 0x00, idxRow, idxColumn );
					cmdCaret.Execute( pDoc );

					ScrollToCaret();
				}
			}
		}
		bBreak = TRUE;
		break;

	case WM_LBUTTONDOWN:
		{
			// sNZW𓾂
			POINTS	pt = MAKEPOINTS( pMsg->lParam );
			CPoint posCursor( pt.x, pt.y );
			posCursor = ScrollBoxToPixel( posCursor );

			CDC*		pDC = NULL;
			pDC = GetDC();
			if ( pDC == NULL )
			{
				break;
			}

			// NbNꂽsAJʒuvZ
			int idxRow = pDoc->GetCaretRow();
			int idxColumn = pDoc->GetCaretColumn();
			idxRow = pDrawer->PixelToCaretRow( posCursor.y, pDoc );
			CEmphasisLine*	pEmphasisLine = pDoc->GetEmphasisLine( idxRow );
			if ( pEmphasisLine != NULL )
			{
				idxColumn = pEmphasisLine->PixelToCaretColumn( posCursor.x, TRUE );
			}
			else
			{
				// YsȂ
				break;
			}

			// Rg[L[Ȃł΂I
			if ( bCtrl )
			{
				pDoc->GetBoxSelection()->SetLineInfo(
					idxRow,
					idxColumn
				);

				bSelectedModify = TRUE;
				bRedraw = TRUE;
				bBreak = TRUE;
				break;
			}

			// hbO̊Jn
			m_bDrag = TRUE;
			SetCapture( );

			// hbO̓J[\\
			DestroyCaret();
			m_bVisibleCaret = FALSE;

			if ( pSelection->IsSelected( idxRow, idxColumn ) )
			{
				// t[eBO[hɈڍs
				BoxSelectToFloating();

				CFloatingSelection*	pSelection;
				pSelection = pDoc->GetFloatingSelection();
				CPoint	ptFloat = pSelection->GetPosition();

				m_iFloatOffsetX = ptFloat.x - posCursor.x;
				m_iFloatOffsetY = ptFloat.y - posCursor.y;
			}
			else
			{
				SetCapture( );
				// Lbg̈ړ
				{
					int idxRow = pDoc->GetCaretRow();
					idxRow = pDrawer->PixelToCaretRow( posCursor.y, pDoc );

					CEmphasisLine*	pEmphasisLine = pDoc->GetEmphasisLine( idxRow );
					if ( pEmphasisLine != NULL )
					{
						int		idxColumn = 0;
						idxColumn = pEmphasisLine->PixelToCaretColumn(
							posCursor.x
						);

						CCommandCaret	cmdCaret;
						cmdCaret.SetAttribute( 0x00, idxRow, idxColumn );
						cmdCaret.Execute( pDoc );
					}

					ReleaseDC( pDC );
				}

				if ( GetAsyncKeyState( VK_SHIFT ) &0x8000 )
				{
					// ShiftȂȂI͈͂ύX
					pDoc->GetBoxSelection()->SetSelectedEndPixel(
							posCursor
					);
				}
				else
				{
					pDoc->GetBoxSelection()->SetSelectedStartPixel(
							posCursor
					);

					// IԂ̉
					pDoc->GetBoxSelection()->SetSelectedNutral();
				}
			}
		}
		bSelectedModify = TRUE;
		bRedraw = TRUE;
		bBreak = TRUE;
		break;

	default:
		break;
	}

	if ( bSelectedModify )
	{
		pDoc->SetUpdateStartRow( min( idxOldSelectedStartRow, pSelection->GetSelectedStartRow() ) );
		pDoc->SetUpdateEndRow( max( idxOldSelectedEndRow, pSelection->GetSelectedEndRow() ) );
	}

	if ( bRedraw )
	{
		pDoc->ReDraw();

	}

	if( bBreak )
	{
		return( TRUE );
	}
	else
	{
		return( FALSE );
	}
}


/*-----------------------------------------------------------------------------
[]	t[eBO\t[hڍs
[@\]	I𒆕ăt[eBO\t[hֈڍsB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CShitarabianView::BoxSelectToFloating()
{
	CShitarabianDoc*	pDoc = GetDocument();
	CBoxSelection*		pSelection = pDoc->GetBoxSelection();
	CEditDrawer*		pDrawer = CEditDrawer::GetInstance();

	// BOXI͈͂̏㉺󔒍s̏
	{
		CArray<TSelectColumn, TSelectColumn&>* patColumnz = pSelection->GetSelectedLinez();

		long	lStartRow = pDrawer->PixelToCaretRow( pSelection->GetSelectedStartY(), pDoc); 
		long	lEndRow =  pDrawer->PixelToCaretRow( pSelection->GetSelectedEndY(), pDoc); 

		// i󔒕݂̂̍sj
		CWhitespaceDefine*	pWhitespace = CGeneralSetting::GetInstance()->GetWhitespace();
		CArray<TWhiteSpace, TWhiteSpace&>*	paCharz = pWhitespace->GetCharz();
		long	lRowHeight = pDrawer->CaretRowToPixel( 1 );
		long	idxRow;
		for( idxRow=lEndRow ; idxRow>=lStartRow ; idxRow-- )
		{
			// ̂ق̋󔒍s
			if ( idxRow < pDoc->GetLineCount() )
			{
				long		idxBlackSpace;
				CPadding	Padding;
				idxBlackSpace = Padding.NextBlackSpaceColumn(
					*(pDoc->GetLine( idxRow )),
					patColumnz->GetAt(idxRow-lStartRow).idxStart,
					*(paCharz)
				);
				if ( idxBlackSpace >= 0 )
				if ( idxBlackSpace <= patColumnz->GetAt(idxRow-lStartRow).idxEnd )
				{
					break;
				}
			}
			patColumnz->RemoveAt( idxRow-lStartRow );
			lEndRow--;
			pSelection->SetSelectedEndY(
				pSelection->GetSelectedEndY() - lRowHeight
			);
		}
		for( idxRow=lStartRow ; idxRow<=lEndRow ; idxRow++ )
		{
			// ̂ق̋󔒍s
			if ( idxRow < pDoc->GetLineCount() )
			{
				long		idxBlackSpace;
				CPadding	Padding;
				idxBlackSpace = Padding.NextBlackSpaceColumn(
					*(pDoc->GetLine( idxRow )),
					patColumnz->GetAt(idxRow-lStartRow).idxStart,
					*(paCharz)
				);
				if ( idxBlackSpace >= 0 )
				if ( idxBlackSpace <= patColumnz->GetAt(idxRow-lStartRow).idxEnd )
				{
					break;
				}
			}
			patColumnz->RemoveAt( idxRow-lStartRow );
			lStartRow ++;
			pSelection->SetSelectedStartY(
				pSelection->GetSelectedStartY() + lRowHeight
			);
		}

		if ( patColumnz->GetSize() < 1 )
		{
			// BOXI͈͂ɕȂ΃t[eBOɈڍsȂ
			pSelection->SetSelectedNutral();
			return;
		}

		// BOXȊI͈͂XV
		pSelection->SetSelectedStart( lStartRow, patColumnz->GetAt(0).idxStart );
		pSelection->SetSelectedEnd( lEndRow, patColumnz->GetAt(lEndRow-lStartRow).idxEnd );
	}

	// 󔒃J
	pSelection->TrimSelection();

	// ͂ވʒũY擾
	CStringArray	astrLinez;
	long			lLeftGap;
	pSelection->GetSelectedLinezWithPadding(
		&astrLinez,
		&lLeftGap
	);

	// t[eBOI𕶎ݒ
	CString		strLinez;
	strLinez = pSelection->GetSelectedText();
	ToFloating(
		strLinez,
		pSelection->GetSelectedStartX() +lLeftGap,
		pSelection->GetSelectedStartY()
	);
	TRACE("%s\n",strLinez);

	pDoc->SetAllUpdate();
}



/*-----------------------------------------------------------------------------
[]	t[eBO\t[hڍs
[@\]	t[eBO\t[hֈڍsB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CShitarabianView::ToFloating(
	CString		strLinez,		// I  :t[g [-] (-) :-
	int			iPixelX,		// I  :t[g [v[pixel] (-) :-
	int			iPixelY			// I  :t[g [v[pixel] (-) :-
)
{
	CShitarabianDoc*	pDoc = GetDocument();

	// ͑쎞ɏĂ}EXJ[\\
	m_bInputMode = FALSE;

	CFloatingSelection*	pFloating;
	pFloating = pDoc->GetFloatingSelection();

	// t[eBOI𕶎ݒ
	CString strDelimiter( pDoc->ReturnChar() );
	CStringArray	astrLinez;
	::StringToArray(
		strLinez,
		&astrLinez,
		strDelimiter
	);
	pFloating->SetLinez( astrLinez );

	pFloating->SetPosition(
		CPoint(
			iPixelX,
			iPixelY
		)
	);
	// t[eBO[hɈڍs
	pDoc->SetOperationMode( OperationFloating );
	pFloating->DoReflect();
}


/*-----------------------------------------------------------------------------
[]	L[nh
[@\]	ꂽL[ɉB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
BOOL CShitarabianView::PreTranslateKeyDownBoxSelectMode(
	UCHAR	unKey,				// I  :L[ [zL[R[h] (-)
	BOOL	bShift,				// I  :Vtg [-] (TRUE:AFALSE:Ȃ)
	BOOL	bCtrl,				// I  :Ctrl [-] (TRUE:AFALSE:Ȃ)
	BOOL	bAlt				// I  :Alt [-] (TRUE:AFALSE:Ȃ)
)
{
	CShitarabianDoc*	pDoc = GetDocument();
	CSelection*			pSelection = pDoc->GetSelection();

	BOOL	bBreak = FALSE;
	BOOL	bSelectedModify = FALSE;

	int idxOldSelectedStartRow = pSelection->GetSelectedStartRow();
	int idxOldSelectedEndRow = pSelection->GetSelectedEndRow();

	int	nRow = pDoc->GetLineCount();

	switch( unKey )
	{
	case VK_ESCAPE:
		// IԂ̉
		pSelection->SetSelectedNutral();
		bSelectedModify = TRUE;
		OnEditModeselect();
		bBreak = TRUE;
		break;

	case VK_F4:
		pSelection->SetSelectedNutral();
		bSelectedModify = TRUE;
		OnEditModeselect();
		bBreak = TRUE;
		break;

	case VK_TAB:
		if ( pDoc->GetSelection()->IsSelected() )
		{
			// ^u
			CString		strTabString;
			int			nTabChar;
			if ( CGeneralSetting::GetInstance()->GetTabConvert() )
			{
				strTabString = CGeneralSetting::GetInstance()->GetTabString();
			}
			else
			{
				strTabString = (char)(unKey);
			}
			nTabChar = ::StringToColumn( strTabString );

			// }`Cfg̎s
			int		idxStartRow = pSelection->GetSelectedStartRow();
			CArray<TSelectColumn, TSelectColumn&>*	pLinez;
			pLinez = pSelection->GetSelectedLinez();
			{
				CCommandMultiEdit	cmdEdit;
				for( int idxLine=0 ; idxLine<pLinez->GetSize() ; idxLine++ )
				{
					int	idxColumn = pLinez->GetAt(idxLine).idxStart;
					int idxRow = idxStartRow+idxLine;

					int idxStartColumn = pLinez->GetAt(idxLine).idxStart;
					int idxEndColumn = pLinez->GetAt(idxLine).idxEnd;

					CString* pstrLine = pDoc->GetLine( idxRow );
					if( pstrLine != NULL )
					{
						if ( bShift )
						{
						// }`tCfg

							// 󔒕H
							BOOL	bWhiteSpace = FALSE;
							{
								CArray< TToken, TToken& >	aTokenz;
								CTokenReader::StringToCharTypez(
									*pstrLine,
									&aTokenz
								);

								// P
								int		idxToken = CTokenReader::TokenIndex(
									aTokenz,
									idxColumn-1
								);
								if ( idxToken != InvalidTokenIndex )
								{
									bWhiteSpace = ( aTokenz[idxToken].eCharType == CharTypeWhitespace );
								}
							}

							// 󔒕̍폜
							if( bWhiteSpace )
							{
								// ̓R}h̓o^
								CCommandDelete	cmdDelete;
								cmdDelete.SetAttribute(
									idxRow, idxColumn-1,
									idxRow, idxColumn
								);
								cmdEdit.Add( cmdDelete );

								pDoc->GetBoxSelection()->SetLineInfo(
									idxRow,
									idxColumn-1,
									idxEndColumn-1
								);
							}
						}
						else
						{
						// }`Cfg
							if ( !pstrLine->IsEmpty() )
							{
								// ̓R}h̓o^
								CCommandInput	cmdInput;
								cmdInput.SetAttribute( strTabString, idxRow, idxColumn );
								cmdEdit.Add( cmdInput );
							}

							pDoc->GetBoxSelection()->SetLineInfo(
								idxRow,
								idxStartColumn+nTabChar,
								idxEndColumn+nTabChar
							);
						}
					}
				// please! AddĂݒ肵ق悳
				}
				cmdEdit.Execute( pDoc );

				// R}h}l[Wɓo^
				CCommandManager*	pCmd = CCommandManager::GetInstance();
				pCmd->Add( cmdEdit );
				// please! AddĂݒ肵ق悳
			}
		}
		bBreak = TRUE;
		break;

	case VK_UP:
	case VK_DOWN:
	case VK_LEFT:
	case VK_RIGHT:
		// t[eBO[hɈڍs
		if ( pDoc->GetSelection()->IsSelected() )
		{
			BoxSelectToFloating();
			PreTranslateKeyDownFloatingMode(
					unKey,				// I  :L[ [zL[R[h] (-)
					bShift,				// I  :Vtg [-] (TRUE:AFALSE:Ȃ)
					bCtrl,				// I  :Ctrl [-] (TRUE:AFALSE:Ȃ)
					bAlt
			);
			bBreak = TRUE;
		}
		break;

	case VK_BACK:
		// IԂ̉
		// [h̎
		// BoxI͈͂̐؂폜
		{
			CCommandMultiEdit	cmdEdit;

			// sPʂDelete
			CBoxSelection* pSelection = dynamic_cast<CBoxSelection*>(pDoc->GetSelection());
			if ( pSelection == NULL )
			{
				break;
			}
			int		idxStartRow = pSelection->GetSelectedStartRow();
			CArray<TSelectColumn, TSelectColumn&>*	pLinez;
			pLinez = pSelection->GetSelectedLinez();

			for( int idxLine=0 ; idxLine<pLinez->GetSize() ; idxLine++ )
			{
				CCommandDelete	cmdDelete;
				cmdDelete.SetAttribute(
					idxStartRow+idxLine,
					pLinez->GetAt(idxLine).idxStart,
					idxStartRow+idxLine,
					pLinez->GetAt(idxLine).idxEnd
				);
				cmdEdit.Add( cmdDelete );
			}

			// please! AddĂݒ肵ق悳
			cmdEdit.Execute( pDoc );

			// R}h}l[Wɓo^
			CCommandManager*	pCmd = CCommandManager::GetInstance();
			pCmd->Add( cmdEdit );
			// please! AddĂݒ肵ق悳


			// IԂ̉
			pSelection->SetSelectedNutral();
		}
		bBreak = TRUE;
		break;

	case VK_DELETE:
		// IԂ̉
		// BoxI͈͂̃NA
		pDoc->GetBoxSelection()->BoxClear();
		bBreak = TRUE;
		break;

	default:
		bBreak = PreTranslateKeyDownNormalMode( unKey, bShift, bCtrl, bAlt );
		return( bBreak );
		break;
	}

	if ( bSelectedModify )
	{
		pDoc->SetUpdateStartRow( min( idxOldSelectedStartRow, pSelection->GetSelectedStartRow() ) );
		pDoc->SetUpdateEndRow( max( idxOldSelectedEndRow, pSelection->GetSelectedEndRow() ) );
	}

	if ( nRow != pDoc->GetLineCount() )
	{
		ResetHScroll();
	}

	if( bBreak )
	{
		// XN[łł΃XN[o[𐧌
		ScrollToCaret();

		// ĕ`
		pDoc->ReDraw();

		// DrawCaret()ƕ`悪SȂB
		// Lbg̕`DrawPage()łB

		GetDocument()->SetMainView( this );
		return( TRUE );
	}
	return( FALSE );
}


/*-----------------------------------------------------------------------------
[]	̓nh
[@\]	͂ꂽɉB
[ߒl]	Ȃ
[l]	VK_ESCAPE:	ỈAʏҏWւ̈ڍs
		VK_F4:		ỈAʏҏWւ̈ڍs
		VK_TAB:		}`Cfg
-----------------------------------------------------------------------------*/
BOOL CShitarabianView::PreTranslateCharBoxSelectMode(
	CString	strChar,			// I  :͕@[-] (-)
	BOOL	bShift,				// I  :Vtg [-] (TRUE:AFALSE:Ȃ)
	BOOL	bCtrl,				// I  :Ctrl [-] (TRUE:AFALSE:Ȃ)
	BOOL	bAlt				// I  :Alt [-] (TRUE:AFALSE:Ȃ)
)
{
	CShitarabianDoc*	pDoc = GetDocument();
	CSelection*			pSelection = pDoc->GetSelection();

	BOOL	bBreak = FALSE;
	BOOL	bSelectedModify = FALSE;

	int idxOldSelectedStartRow = pSelection->GetSelectedStartRow();
	int idxOldSelectedEndRow = pSelection->GetSelectedEndRow();

	int	nRow = pDoc->GetLineCount();

	if( strChar == (CString)VK_ESCAPE )
	{
		// IԂ̉
		pSelection->SetSelectedNutral();
		bSelectedModify = TRUE;
		OnEditModeselect();
		bBreak = TRUE;
	}
	else if( strChar == (CString)VK_F4 )
	{
		pSelection->SetSelectedNutral();
		bSelectedModify = TRUE;
		OnEditModeselect();
		bBreak = TRUE;
	}
	else if( strChar == (CString)VK_TAB )
	{
		if ( pDoc->GetSelection()->IsSelected() )
		{
			// ^u
			CString		strTabString;
			int			nTabChar;
			if ( CGeneralSetting::GetInstance()->GetTabConvert() )
			{
				strTabString = CGeneralSetting::GetInstance()->GetTabString();
			}
			else
			{
				strTabString = strChar;
			}
			nTabChar = ::StringToColumn( strTabString );

			// }`Cfg̎s
			int		idxStartRow = pSelection->GetSelectedStartRow();
			CArray<TSelectColumn, TSelectColumn&>*	pLinez;
			pLinez = pSelection->GetSelectedLinez();
			{
				CCommandMultiEdit	cmdEdit;
				for( int idxLine=0 ; idxLine<pLinez->GetSize() ; idxLine++ )
				{
					int	idxColumn = pLinez->GetAt(idxLine).idxStart;
					int idxRow = idxStartRow+idxLine;

					int idxStartColumn = pLinez->GetAt(idxLine).idxStart;
					int idxEndColumn = pLinez->GetAt(idxLine).idxEnd;

					CString* pstrLine = pDoc->GetLine( idxRow );
					if( pstrLine != NULL )
					{
						if ( bShift )
						{
						// }`tCfg

							// 󔒕H
							BOOL	bWhiteSpace = FALSE;
							{
								CArray< TToken, TToken& >	aTokenz;
								CTokenReader::StringToCharTypez(
									*pstrLine,
									&aTokenz
								);

								// P
								int		idxToken = CTokenReader::TokenIndex(
									aTokenz,
									idxColumn-1
								);
								if ( idxToken != InvalidTokenIndex )
								{
									bWhiteSpace = ( aTokenz[idxToken].eCharType == CharTypeWhitespace );
								}
							}

							// 󔒕̍폜
							if( bWhiteSpace )
							{
								// ̓R}h̓o^
								CCommandDelete	cmdDelete;
								cmdDelete.SetAttribute(
									idxRow, idxColumn-1,
									idxRow, idxColumn
								);
								cmdEdit.Add( cmdDelete );

								pDoc->GetBoxSelection()->SetLineInfo(
									idxRow,
									idxColumn-1,
									idxEndColumn-1
								);
							}
						}
						else
						{
						// }`Cfg
							if ( !pstrLine->IsEmpty() )
							{
								// ̓R}h̓o^
								CCommandInput	cmdInput;
								cmdInput.SetAttribute( strTabString, idxRow, idxColumn );
								cmdEdit.Add( cmdInput );
							}

							pDoc->GetBoxSelection()->SetLineInfo(
								idxRow,
								idxStartColumn+nTabChar,
								idxEndColumn+nTabChar
							);
						}
					}
				// please! AddĂݒ肵ق悳
				}
				cmdEdit.Execute( pDoc );

				// R}h}l[Wɓo^
				CCommandManager*	pCmd = CCommandManager::GetInstance();
				pCmd->Add( cmdEdit );
				// please! AddĂݒ肵ق悳
			}
		}
		bBreak = TRUE;
	}
	else
	{
		bBreak = PreTranslateCharNormalMode( strChar, bShift, bCtrl, bAlt );
		return( bBreak );
	}

	if ( bSelectedModify )
	{
		pDoc->SetUpdateStartRow( min( idxOldSelectedStartRow, pSelection->GetSelectedStartRow() ) );
		pDoc->SetUpdateEndRow( max( idxOldSelectedEndRow, pSelection->GetSelectedEndRow() ) );
	}

	if ( nRow != pDoc->GetLineCount() )
	{
		ResetHScroll();
	}

	if( bBreak )
	{
		// XN[łł΃XN[o[𐧌
		ScrollToCaret();

		// ĕ`
		pDoc->ReDraw();

		// DrawCaret()ƕ`悪SȂB
		// Lbg̕`DrawPage()łB

		GetDocument()->SetMainView( this );
		return( TRUE );
	}
	return( FALSE );
}
