/************************************************
 *	[imgctl.h] Version 1.04
 *		For <imgctl.dll> version 1.04.
 *		<imgctl.dll> is free software.
 ************************************************/
/*
 *	[쌠ɂ]
 *		imgctl.dll  [`F ɒ쌠܂B
 *	[About copyright]
 *		<imgctl.dll> copyright (C) 2001-2002 ruche.
 */
/*
 *	[JPEGɂ]
 *		imgctl.dll  JPEGǂݏɂ The Independent JPEG Group (IJG) 
 *		쐬Ajpeg.lib pĂ܂B
 *	[About JPEG]
 *		JPEG control functions of <imgctl.dll> was coded by using <jpeg.lib>
 *		edited by The Independent JPEG Group (IJG).
 */
/*
 *	[PNGɂ]
 *		imgctl.dll PNGǂݏɂ libpng.lib  zlib.lib pĂ܂B
 *		܂APNG̓ǂݍ݂́A{⌫ ifpng.spi ̃\[XQlɂĂ܂B
 *	[About PNG]
 *		PNG control functions of <imgctl.dll> was coded by using <libpng.lib> and
 *		<zlib.lib>. And PNG loading function of <imgctl.dll> was coded by referring
 *		of a source of <ifpng.spi> coded by Ken Miyasaka.
 */
/*
 *	[LZWASYɂ]
 *		imgctl.dll ł́Af[^kASY "LZW" ͈؎gpĂ܂B
 *	[About LZW algorithm]
 *		"LZW" data compression algorithm is not used at all in <imgctl.dll>.
 */
/*
 *	[XV]
 *		* Version 1.00B
 *			: eXgfŉJ
 *		* Version 1.00
 *			: ɌJ
 *			: HeadDIB֐ǉ
 *			: ColorDIB֐ǉ
 *			: DIBto16Bit֐ǉ
 *			: DIBto24Bit֐dlύX
 *			: DIBtoRLE֐dlύX
 *			: RLEtoDIB֐dlύX
 *			: SizeDIB֐폜
 *		* Version 1.01B
 *			: ToDIB֐ǉ
 *			: PaletteDIB֐ǉ
 *			: PixelDIB֐ǉ
 *			: CutDIB֐ǉ
 *			: DIBtoPNGex֐ǉ
 *			: HeadDIB֐oOC
 *		* Version 1.01B2
 *			: ImgctlBeta֐ǉ
 *			: DCtoDIB֐ǉ
 *		* Version 1.01
 *			: DIBtoPNGex֐dlύX
 *		* Version 1.02B
 *			: DIBto8Bit֐ǉ
 *			: DIBto24Bit֐oOC
 *			: DIBto16Bit֐oOC
 *		* Version 1.02B2
 *			: GrayDIB֐ǉ
 *			: ToneDIB֐ǉ
 *			: ReplaceDIB֐ǉ
 *		* Version 1.02
 *			: PNGtoDIB֐sC
 *		* Version 1.03B
 *			: GetImageType֐g
 *			: DIBto8Bit֐g
 *			: BMPtoDIB֐g
 *		* Version 1.03B2
 *			: JPGtoDIB֐g
 *		* Version 1.03B3
 *			: GetImageType֐C
 *		* Version 1.03
 *			: GetImageType֐g
 *		* Version 1.04B
 *			: GetImageType֐C
 *		* Version 1.04
 *			: DIBStretchDIBits2֐ǉ
 */

#ifndef _INC_IMGCTL
#define _INC_IMGCTL

/* imgctl.h support version */
#define IMGCTL_VERSION	104
#define IMGCTL_BETA		0

#ifndef _WINDOWS_
#include <windows.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* DIB data handle */
typedef void *HDIB;
typedef const void *HDIBC;

/* PNGOPT structure */
typedef struct
{
	DWORD dwFlag;		/* etO̘_a */
	WORD wCompLevel;	/* k: [] 0 ` 9 [] */
	DWORD dwFilter;		/* tB^ */
	DWORD dwGamma;		/* K}␳l (0 ` 100000) */
	LPARAM clrTrans;	/* F */
	LPARAM clrBack;		/* wiF */
	LPSTR lpText;		/* eLXg */

	DWORD dwReserved1;	/* \(0ɂ) */
	DWORD dwReserved2;	/* \(0ɂ) */
}
PNGOPT, *PPNGOPT, FAR *LPPNGOPT;
typedef const PNGOPT FAR *LPCPNGOPT;

/* ߏ\ for PNGOPT */
typedef struct
{
	BYTE trans[256];	/* epbg̓ߓx(lقǓ) */
	DWORD dwNum;		/* trans̐ݒLɂ鐔 */
}
PALTRANS, *PPALTRANS, FAR *LPPALTRANS;

/* PNGOPT flags () */
#define POF_COMPLEVEL	0x00000001	/* kg */
#define POF_FILTER		0x00000002	/* tB^g */
#define POF_GAMMA		0x00000004	/* K}␳g */
#define POF_TRNSCOLOR	0x00000008	/* Fg */
#define POF_BACKCOLOR	0x00000010	/* wiFg */
#define POF_TEXT		0x00000020	/* eLXgg */
#define POF_TEXTCOMP	0x00000040	/* eLXgks */
#define POF_INTERLACING	0x00000080	/* C^[[Xɂ */
#define POF_TIME		0x00000100	/* ŏIXVԂۑ */
#define POF_BACKPALETTE	0x00010000	/* wiF̎wɃpbgԍg(1,4,8Bit) */
#define POF_TRNSPALETTE	0x00020000	/* F̎wɃpbgԍg(1,4,8Bit) */
#define POF_TRNSALPHA	0x00040000	/* F̎wɓߏ\̂g(1,4,8Bit) */

/* PNGOPT filters () */
#define PO_FILTER_NONE	0x00000008	/* tB^KpȂ */
#define PO_FILTER_SUB	0x00000010	/* ̃sNZ̍ */
#define PO_FILTER_UP	0x00000020	/* ̃sNZ̍ */
#define PO_FILTER_AVG	0x00000040	/* Ə̃sNZ̗\Ƃ̍ */
#define PO_FILTER_PAETH	0x00000080	/* Əƍ̃sNZ̗\Ƃ̍ */
#define PO_FILTER_ALL \
	(PO_FILTER_NONE | PO_FILTER_SUB | PO_FILTER_UP | PO_FILTER_AVG | PO_FILTER_PAETH)

/* Populer gammas for PNGOPT */
#define PO_GAMMA_NORMAL	45455		/* 1.0/2.2*100000 */
#define PO_GAMMA_WIN	PO_GAMMA_NORMAL
#define PO_GAMMA_MAC	55556		/* 1.0/1.8*100000 */

/* Image types */
#define IMG_UNKNOWN	0x00000000
#define IMG_BMP		0x00000001
#define IMG_BITMAP	IMG_BMP
#define IMG_DIB		IMG_BMP
#define IMG_RLE		IMG_BMP
#define IMG_JPEG	0x00000002
#define IMG_JPE		IMG_JPEG
#define IMG_JPG		IMG_JPEG
#define IMG_PNG		0x00000003
#define IMG_GIF		0x00000004
#define IMG_TIFF	0x00000005
#define IMG_TIF		IMG_TIFF
#define IMG_PICT	0x00000006
#define IMG_PIC		IMG_PICT
#define IMG_PCT		IMG_PICT
#define IMG_MAG		0x00000007
#define IMG_MAKI	IMG_MAG
#define IMG_PCX		0x00000008	/* v1.03 */

/* Bitfield types */
#define BF16_RGB555	0x00007C00, 0x000003E0, 0x0000001F
#define BF16_RGB565	0x0000F800, 0x000007E0, 0x0000001F
#define BF32_RGB888	0x00FF0000, 0x0000FF00, 0x000000FF

/* Flags for DIBto8Bit */
#define TO8_DIV_RGB		0x00000000
#define TO8_DIV_LIGHT	0x00000001
#define TO8_SEL_CENTER	0x00000000
#define TO8_SEL_AVGRGB	0x00000100
#define TO8_SEL_AVGPIX	0x00000200
#define TO8_PUT_RGB		0x00000000
#define TO8_PUT_LIGHT	0x00010000
#define TO8_PUT_YUV		0x00020000

/* Replace colors */
#define REP_R		0
#define REP_RED		REP_R
#define REP_G		1
#define REP_GREEN	REP_G
#define REP_B		2
#define REP_BLUE	REP_B

#if !defined(IMGCTL_RUNTIME)

#ifndef __BORLANDC__
#define	_export
#endif

/* Standard functions */
WORD WINAPI _export ImgctlVersion(
	void
	);
WORD WINAPI _export ImgctlBeta(
	void
	);
DWORD WINAPI _export GetImageType(
	LPCSTR lpImageFile,
	DWORD *pdwFlag
	);
HDIB WINAPI _export ToDIB(
	LPCSTR lpImageFile
	);

/* DIB functions */
BOOL WINAPI _export DeleteDIB(
	HDIB hDIB
	);
BOOL WINAPI _export HeadDIB(
	HDIBC hDIB,
	LPBITMAPINFOHEADER pbmih
	);
DWORD WINAPI _export PaletteDIB(
	HDIBC hDIB,
	RGBQUAD *rgbColors,
	DWORD dwClrNum
	);
COLORREF WINAPI _export PixelDIB(
	HDIBC hDIB,
	long lXPos,
	long lYPos
	);
DWORD WINAPI _export ColorDIB(
	HDIBC hDIB
	);
BOOL WINAPI _export GetDIB(
	HDIBC hDIB,
	LPBITMAPINFO pbmi,
	DWORD *pdwbmiSize,
	LPVOID pvData,
	DWORD *pdwDataSize
	);
BOOL WINAPI _export MapDIB(
	HDIBC hDIB,
	LPBITMAPINFO *ppbmi,
	DWORD *pdwbmiSize,
	LPVOID *ppvData,
	DWORD *pdwDataSize
	);
HDIB WINAPI _export CreateDIB(
	const BITMAPINFO *pbmi,
	LPCVOID pvData
	);
HDIB WINAPI _export CopyDIB(
	HDIBC hDIB
	);
HDIB WINAPI _export CutDIB(
	HDIBC hDIB,
	long lX,
	long lY,
	long lWidth,
	long lHeight
	);
BOOL WINAPI _export DIBto24Bit(
	HDIB hDIB
	);
BOOL WINAPI _export DIBto16Bit(
	HDIB hDIB,
	const DWORD *dwBitFields
	);
BOOL WINAPI _export DIBto8Bit(
	HDIB hDIB,
	DWORD dwFlags,
	DWORD dwReserved
	);

/* RLE-DIB functions */
BOOL WINAPI _export IsRLE(
	HDIBC hDIB
	);
BOOL WINAPI _export DIBtoRLE(
	HDIB hDIB
	);
BOOL WINAPI _export RLEtoDIB(
	HDIB hRLE
	);

/* Bitmap functions */
BOOL WINAPI _export DIBtoBMP(
	LPCSTR lpBmpFile,
	HDIBC hDIB
	);
HDIB WINAPI _export BMPtoDIB(
	LPCSTR lpBmpFile
	);

/* JPEG functions */
BOOL WINAPI _export DIBtoJPG(
	LPCSTR lpJpegFile,
	HDIBC hDIB,
	int iQuality,
	BOOL bProgression
	);
HDIB WINAPI _export JPGtoDIB(
	LPCSTR lpJpegFile
	);

/* PNG functions */
BOOL WINAPI _export DIBtoPNG(
	LPCSTR lpPngFile,
	HDIBC hDIB,
	BOOL bInterlacing
	);
BOOL WINAPI _export DIBtoPNGex(
	LPCSTR lpPngFile,
	HDIBC hDIB,
	LPCPNGOPT pPngOpt
	);
HDIB WINAPI _export PNGtoDIB(
	LPCSTR lpPngFile
	);

/* Filter functions */
BOOL WINAPI _export GrayDIB(
	HDIB hDIB,
	WORD wStrength
	);
BOOL WINAPI _export ToneDIB(
	HDIB hDIB,
	short rMove,
	short gMove,
	short bMove
	);
BOOL WINAPI _export ReplaceDIB(
	HDIB hDIB,
	WORD rTo,
	WORD gTo,
	WORD bTo
	);

/* Device context functions */
BOOL WINAPI _export DIBDIBits(
	HDC hdc,
	int nXDest,
	int nYDest,
	int nWidth,
	int nHeight,
	HDIBC hDIB,
	int nXSrc,
	int nYSrc,
	DWORD dwRop
	);
BOOL WINAPI _export DIBStretchDIBits(
	HDC hdc,
	int XDest,
	int YDest,
	int nDestWidth,
	int nDestHeight,
	HDIBC hDIB,
	int XSrc,
	int YSrc,
	int nSrcWidth,
	int nSrcHeight,
	DWORD dwRop
	);
BOOL WINAPI _export DIBStretchDIBits2(
	HDC hdc,
	int XDest,
	int YDest,
	int nDestWidth,
	int nDestHeight,
	HDIBC hDIB,
	int XSrc,
	int YSrc,
	int nSrcWidth,
	int nSrcHeight,
	DWORD dwRop,
	int iStretchMode
	);
HDIB WINAPI _export DCtoDIB(
	HDC hdc,
	long lXSrc,
	long lYSrc,
	long lWidth,
	long lHeight
	);

#elif defined(IMGCTL_RUNTIME) && !defined(IMGCTL_TYPEDEF_NOTUSE)

/* Standard functions */
typedef WORD (CALLBACK *IMGCTLVERSION)(void);
typedef WORD (CALLBACK *IMGCTLBETA)(void);
typedef DWORD (CALLBACK *GETIMAGETYPE)(LPCSTR, DWORD *);
typedef HDIB (CALLBACK *TODIB)(LPCSTR);

/* DIB functions */
typedef BOOL (CALLBACK *DELETEDIB)(HDIB);
typedef BOOL (CALLBACK *HEADDIB)(HDIBC, LPBITMAPINFOHEADER);
typedef DWORD (CALLBACK *PALETTEDIB)(HDIBC, RGBQUAD *, DWORD);
typedef COLORREF (CALLBACK *PIXELDIB)(HDIBC, long, long);
typedef DWORD (CALLBACK *COLORDIB)(HDIBC);
typedef BOOL (CALLBACK *GETDIB)(HDIBC, LPBITMAPINFO, DWORD *, LPVOID, DWORD *);
typedef BOOL (CALLBACK *MAPDIB)(HDIBC, LPBITMAPINFO *, DWORD *, LPVOID *, DWORD *);
typedef HDIB (CALLBACK *CREATEDIB)(const BITMAPINFO *, LPCVOID);
typedef HDIB (CALLBACK *COPYDIB)(HDIBC);
typedef HDIB (CALLBACK *CUTDIB)(HDIBC, long, long, long, long);
typedef BOOL (CALLBACK *DIBTO24BIT)(HDIB);
typedef BOOL (CALLBACK *DIBTO16BIT)(HDIB, const DWORD *);
typedef BOOL (CALLBACK *DIBTO8BIT)(HDIB, DWORD, DWORD);

/* RLE-DIB functions */
typedef BOOL (CALLBACK *ISRLE)(HDIBC);
typedef BOOL (CALLBACK *DIBTORLE)(HDIB);
typedef BOOL (CALLBACK *RLETODIB)(HDIB);

/* Bitmap functions */
typedef BOOL (CALLBACK *DIBTOBMP)(LPCSTR, HDIBC);
typedef HDIB (CALLBACK *BMPTODIB)(LPCSTR);

/* JPEG functions */
typedef BOOL (CALLBACK *DIBTOJPG)(LPCSTR, HDIBC, int, BOOL);
typedef HDIB (CALLBACK *JPGTODIB)(LPCSTR);

/* PNG functions */
typedef BOOL (CALLBACK *DIBTOPNG)(LPCSTR, HDIBC, BOOL);
typedef BOOL (CALLBACK *DIBTOPNGEX)(LPCSTR, HDIBC, LPCPNGOPT);
typedef HDIB (CALLBACK *PNGTODIB)(LPCSTR);

/* Filter functions */
typedef BOOL (CALLBACK *GRAYDIB)(HDIB, WORD);
typedef BOOL (CALLBACK *TONEDIB)(HDIB, short, short, short);
typedef BOOL (CALLBACK *REPLACEDIB)(HDIB, WORD, WORD, WORD);

/* Device context functions */
typedef BOOL (CALLBACK *DIBDIBITS)(HDC, int, int, int, int, HDIBC, int, int, DWORD);
typedef BOOL (CALLBACK *DIBSTRETCHDIBITS)(
	HDC, int, int, int, int, HDIBC, int, int, int, int, DWORD);
typedef BOOL (CALLBACK *DIBSTRETCHDIBITS2)(
	HDC, int, int, int, int, HDIBC, int, int, int, int, DWORD, int);
typedef HDIB (CALLBACK *DCTODIB)(HDC, long, long, long, long);

#endif /* IMGCTL_RUNTIME */

#ifdef __cplusplus
}
#endif

#endif /* _INC_IMGCTL */
