// RgL
// EmphasisDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "shitarabian.h"
#include "EmphasisDlg.h"
#include "EmphasisColorDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CEmphasisDlg _CAO


CEmphasisDlg::CEmphasisDlg(CWnd* pParent /*=NULL*/)
	: COwnerTabPage(CEmphasisDlg::IDD, pParent)
	, m_pDefine( NULL )
{
	//{{AFX_DATA_INIT(CEmphasisDlg)
	m_bEnable = FALSE;
	//}}AFX_DATA_INIT
}


void CEmphasisDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEmphasisDlg)
	DDX_Control(pDX, IDC_EMPHASIS_UP, m_btnUp);
	DDX_Control(pDX, IDC_EMPHASIS_EDIT, m_btnEdit);
	DDX_Control(pDX, IDC_EMPHASIS_DOWN, m_btnDown);
	DDX_Control(pDX, IDC_EMPHASIS_DELETE, m_btnDelete);
	DDX_Control(pDX, IDC_EMPHASIS_ADD, m_btnAdd);
	DDX_Control(pDX, IDC_EMPHASIS_LIST, m_listEmphasis);
	DDX_Check(pDX, IDC_EMPHASIS_ENABLE, m_bEnable);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CEmphasisDlg, CDialog)
	//{{AFX_MSG_MAP(CEmphasisDlg)
	ON_BN_CLICKED(IDC_EMPHASIS_EDIT, OnEmphasisEdit)
	ON_BN_CLICKED(IDC_EMPHASIS_ADD, OnEmphasisAdd)
	ON_BN_CLICKED(IDC_EMPHASIS_DELETE, OnEmphasisDelete)
	ON_BN_CLICKED(IDC_EMPHASIS_UP, OnEmphasisUp)
	ON_BN_CLICKED(IDC_EMPHASIS_DOWN, OnEmphasisDown)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_EMPHASIS_LIST, OnItemchangedEmphasisList)
	ON_NOTIFY(NM_DBLCLK, IDC_EMPHASIS_LIST, OnDblclkEmphasisList)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEmphasisDlg bZ[W nh

BOOL CEmphasisDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	m_listEmphasis.InsertColumn(	0,	"L"	);
	m_listEmphasis.InsertColumn(	1,	"p^["	);

	m_listEmphasis.SetColumnWidth(	0,	40		);
	m_listEmphasis.SetColumnWidth(	1,	360		);

	if ( m_pDefine != NULL )
	{
		CArray<CEmphasisItem, CEmphasisItem&>& Itemz = m_pDefine->GetItemz();
		for( int idxItem=0 ; idxItem<Itemz.GetSize() ; idxItem++ )
		{
			CEmphasisItem&	Emphasis = Itemz[idxItem];
			m_listEmphasis.InsertItem(
				idxItem,
				Emphasis.GetPattern()
			);
		}
		m_bEnable = m_pDefine->GetEnable();
	}

	VisibleControl();
	UpdateData( FALSE );

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}


void CEmphasisDlg::OnEmphasisEdit() 
{
	CEmphasisColorDlg	dlg;
	
	int		idxItem = m_listEmphasis.GetSelectionMark();
	if ( idxItem >= 0 )
	{
		CArray<CEmphasisItem, CEmphasisItem&>& Itemz = m_listEmphasis.GetList()->GetItemz();
		CEmphasisItem&	Emphasis = Itemz[idxItem];

		dlg.Attach( &Emphasis );
		dlg.SetMode( idxItem < EMPHASIS_USERDEFINE );
		dlg.DoModal();
		m_listEmphasis.Update( idxItem );
	}
	VisibleControl();
}

void CEmphasisDlg::OnEmphasisAdd() 
{
	CEmphasisItem	Emphasis;

	CArray<CEmphasisItem, CEmphasisItem&>& Itemz = m_listEmphasis.GetList()->GetItemz();
	Itemz.Add( Emphasis );

	m_listEmphasis.InsertItem(
		m_listEmphasis.GetItemCount(),
		Emphasis.GetPattern()
	);

	m_listEmphasis.SetSelectionMark( m_listEmphasis.GetItemCount()-1 );
	m_listEmphasis.SetItemState( m_listEmphasis.GetItemCount()-1, LVIS_SELECTED, LVIS_SELECTED );

	RedrawWindow();
	VisibleControl();
}

void CEmphasisDlg::OnEmphasisDelete() 
{
	CEmphasisColorDlg	dlg;
	
	int		idxItem = m_listEmphasis.GetSelectionMark();
	if ( idxItem >= 0 )
	{
		CArray<CEmphasisItem, CEmphasisItem&>& Itemz = m_listEmphasis.GetList()->GetItemz();
		Itemz.RemoveAt( idxItem );
		m_listEmphasis.DeleteItem( idxItem );

		m_listEmphasis.SetSelectionMark( idxItem-1 );
		m_listEmphasis.SetItemState( idxItem-1, LVIS_SELECTED, LVIS_SELECTED );
	}
	VisibleControl();
}

void CEmphasisDlg::OnEmphasisUp() 
{
	int		idxItem = m_listEmphasis.GetSelectionMark();
	if ( idxItem > EMPHASIS_USERDEFINE )
	{
		CArray<CEmphasisItem, CEmphasisItem&>& Itemz = m_listEmphasis.GetList()->GetItemz();
		CEmphasisItem	Emphasis = Itemz[idxItem];

		Itemz.RemoveAt( idxItem );
		Itemz.InsertAt( idxItem-1, Emphasis );

		m_listEmphasis.DeleteItem( idxItem );
		m_listEmphasis.InsertItem(
			idxItem-1,
			Emphasis.GetPattern()
		);

		m_listEmphasis.SetSelectionMark( idxItem-1 );
		m_listEmphasis.SetItemState( idxItem-1, LVIS_SELECTED, LVIS_SELECTED );
	}
	VisibleControl();
}

void CEmphasisDlg::OnEmphasisDown() 
{
	int		idxItem = m_listEmphasis.GetSelectionMark();
	if ( idxItem < m_listEmphasis.GetItemCount()-1 )
	if ( idxItem >= EMPHASIS_USERDEFINE )
	{
		CArray<CEmphasisItem, CEmphasisItem&>& Itemz = m_listEmphasis.GetList()->GetItemz();
		CEmphasisItem	Emphasis = Itemz[idxItem];

		Itemz.RemoveAt( idxItem );
		Itemz.InsertAt( idxItem+1, Emphasis );

		m_listEmphasis.DeleteItem( idxItem );
		m_listEmphasis.InsertItem(
			idxItem+1,
			Emphasis.GetPattern()
		);

		m_listEmphasis.SetSelectionMark( idxItem+1 );
		m_listEmphasis.SetItemState( idxItem+1, LVIS_SELECTED, LVIS_SELECTED );
	}
	VisibleControl();
}

void CEmphasisDlg::VisibleControl()
{
	int		idxItem = m_listEmphasis.GetSelectionMark();

	m_btnUp.EnableWindow( idxItem > EMPHASIS_USERDEFINE );
	m_btnDown.EnableWindow( idxItem >= EMPHASIS_USERDEFINE && ( idxItem < m_listEmphasis.GetItemCount()-1 ));

	m_btnAdd.EnableWindow( TRUE );
	m_btnEdit.EnableWindow( idxItem > -1 );
	m_btnDelete.EnableWindow( idxItem >= EMPHASIS_USERDEFINE );
}


void CEmphasisDlg::OnItemchangedEmphasisList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	VisibleControl();
	*pResult = 0;
}

void CEmphasisDlg::OnDblclkEmphasisList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	OnEmphasisEdit();
	*pResult = 0;
}

void CEmphasisDlg::OnOK() 
{
	UpdateData( TRUE );
	m_pDefine->SetEnable( m_bEnable );
	
	CDialog::OnOK();
}
