/*-----------------------------------------------------------------------------
[]	PrintDefine.cpp
[Tv]	`NX̎
[l]	Ȃ
[]	2003-04-23	NC		Rgt(moralog)
-----------------------------------------------------------------------------*/


//-----------------------------------------------------------------------------
// CN[h
//-----------------------------------------------------------------------------
#include "stdafx.h"
#include "shitarabian.h"
#include "PrintDefine.h"
#include "Common.h"
#include "ExeCommon.h"
#include "ShitarabianDoc.h"
#include "MainFrm.h"
#include "SettingPath.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


//-----------------------------------------------------------------------------
// X^eBbNȍ
//-----------------------------------------------------------------------------
CString		CPrintDefine::m_strKeywordPath		= _T("&[pX]");
CString		CPrintDefine::m_strKeywordFile		= _T("&[̧ٖ]");
CString		CPrintDefine::m_strKeywordExt		= _T("&[gq]");
CString		CPrintDefine::m_strKeywordPage		= _T("&[Ŕԍ]");
CString		CPrintDefine::m_strKeywordPageCount	= _T("&[Ő]");
CString		CPrintDefine::m_strKeywordYear		= _T("&[N]");
CString		CPrintDefine::m_strKeywordMonth		= _T("&[]");
CString		CPrintDefine::m_strKeywordDay		= _T("&[]");
CString		CPrintDefine::m_strKeywordDayOfWeek	= _T("&[j]");
CString		CPrintDefine::m_strKeywordHour		= _T("&[]");
CString		CPrintDefine::m_strKeywordMinute	= _T("&[]");


/*-----------------------------------------------------------------------------
[]	RXgN^
[@\]	CX^X̐B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
CPrintDefine::CPrintDefine()
	:	m_lTopMargin( 15 )
	,	m_lHeaderHeight( 10 )
	,	m_lLeftMargin( 15 )
	,	m_lRightMargin( 15 )
	,	m_lFooterHeight( 10 )
	,	m_lBottomMargin( 15 )

	,	m_lPrintPixelWidth( 600 )
	,	m_bPrintWidthLine( FALSE )

	,	m_bCareSelection( FALSE )
	,	m_bCareEmphasis( FALSE )

	,	m_bHeader( TRUE )
	,	m_strHeaderLeft( _T("") )
	,	m_strHeaderMid( _T("") )
	,	m_strHeaderRight( _T("&[̧ٖ]") )

	,	m_bFooter( TRUE )
	,	m_strFooterLeft( _T("") )
	,	m_strFooterMid( _T("&[Ŕԍ]") )
	,	m_strFooterRight( _T("&[N]/&[]/&[]") )

	,	m_bMarge( FALSE )
	,	m_uiMargeCount( 2 )

	,	m_fontHeader()
	,	m_fontFooter()
{
	m_fontHeader.m_iPointSize = 8;
	m_fontFooter.m_iPointSize = 8;
}


/*-----------------------------------------------------------------------------
[]	fXgN^
[@\]	CX^X̔jB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
CPrintDefine::~CPrintDefine()
{

}


/*-----------------------------------------------------------------------------
[]	ݒۑ
[@\]	ݒ̃t@CoB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
BOOL	CPrintDefine::Write(
	CString&		strGeneralFilename		// I  : t@C [-] (-) :-
)
{
	BOOL	bSuccess = TRUE;

	bSuccess &= WritePrintProfile( strGeneralFilename, "lTopMargin",		LongToString( m_lTopMargin ) );
	bSuccess &= WritePrintProfile( strGeneralFilename, "lHeaderHeight",		LongToString( m_lHeaderHeight ) );
	bSuccess &= WritePrintProfile( strGeneralFilename, "lLeftMargin",		LongToString( m_lLeftMargin ) );
	bSuccess &= WritePrintProfile( strGeneralFilename, "lRightMargin",		LongToString( m_lRightMargin ) );
	bSuccess &= WritePrintProfile( strGeneralFilename, "lBottomMargin",		LongToString( m_lBottomMargin ) );
	bSuccess &= WritePrintProfile( strGeneralFilename, "lFooterHeight",		LongToString( m_lFooterHeight ) );

	bSuccess &= WritePrintProfile( strGeneralFilename, "lPrintPixelWidth",	LongToString( m_lPrintPixelWidth ) );
	bSuccess &= WritePrintProfile( strGeneralFilename, "bPrintWidthLine",	BoolToString( m_bPrintWidthLine ) );

	bSuccess &= WritePrintProfile( strGeneralFilename, "bCareSelection",	BoolToString( m_bCareSelection ) );
	bSuccess &= WritePrintProfile( strGeneralFilename, "bCareEmphasis",		BoolToString( m_bCareEmphasis ) );

	bSuccess &= WritePrintProfile( strGeneralFilename, "bHeader",			BoolToString( m_bHeader ) );
	bSuccess &= WritePrintProfile( strGeneralFilename, "strHeaderLeft",		QuoteString( m_strHeaderLeft ) );
	bSuccess &= WritePrintProfile( strGeneralFilename, "strHeaderMid",		QuoteString( m_strHeaderMid ) );
	bSuccess &= WritePrintProfile( strGeneralFilename, "strHeaderRight",	QuoteString( m_strHeaderRight ) );

	bSuccess &= WritePrintProfile( strGeneralFilename, "bFooter",			BoolToString( m_bFooter ) );
	bSuccess &= WritePrintProfile( strGeneralFilename, "strFooterLeft",		QuoteString( m_strFooterLeft ) );
	bSuccess &= WritePrintProfile( strGeneralFilename, "strFooterMid",		QuoteString( m_strFooterMid ) );
	bSuccess &= WritePrintProfile( strGeneralFilename, "strFooterRight",	QuoteString( m_strFooterRight ) );

	bSuccess &= WritePrintProfile( strGeneralFilename, "bMarge",			BoolToString( m_bMarge ) );
	bSuccess &= WritePrintProfile( strGeneralFilename, "uiMargeCount",		LongToString( m_uiMargeCount ) );

	m_fontHeader.Write(
		strGeneralFilename,
		"HeaderFont"
	);

	m_fontFooter.Write(
		strGeneralFilename,
		"FooterFont"
	);

	return( bSuccess );
}


/*-----------------------------------------------------------------------------
[]	ݒǂݍ
[@\]	ݒ̃t@Cǂݍ݁B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
BOOL	CPrintDefine::Read(
	CString&		strGeneralFilename		// I  : t@C [-] (-) :-
)
{
	BOOL		bSuccess;

	// o[W̓ǂݍ
	CString		strVersion;
	bSuccess = ReadGeneralProfile( strGeneralFilename, "Version", &strVersion );
	if ( bSuccess )
	{
		CString		strValue;

		bSuccess = ReadPrintProfile( strGeneralFilename, "lTopMargin", &strValue );
		if ( bSuccess ){ m_lTopMargin	= StringToLong( strValue ); }
		bSuccess = ReadPrintProfile( strGeneralFilename, "lHeaderHeight", &strValue );
		if ( bSuccess ){ m_lHeaderHeight	= StringToLong( strValue ); }
		bSuccess = ReadPrintProfile( strGeneralFilename, "lLeftMargin", &strValue );
		if ( bSuccess ){ m_lLeftMargin	= StringToLong( strValue ); }
		bSuccess = ReadPrintProfile( strGeneralFilename, "lRightMargin", &strValue );
		if ( bSuccess ){ m_lRightMargin	= StringToLong( strValue ); }
		bSuccess = ReadPrintProfile( strGeneralFilename, "lFooterHeight", &strValue );
		if ( bSuccess ){ m_lFooterHeight = StringToLong( strValue ); }
		bSuccess = ReadPrintProfile( strGeneralFilename, "lBottomMargin", &strValue );
		if ( bSuccess ){ m_lBottomMargin = StringToLong( strValue ); }

		bSuccess = ReadPrintProfile( strGeneralFilename, "lPrintPixelWidth", &strValue );
		if ( bSuccess ){ m_lPrintPixelWidth = StringToLong( strValue ); }
		bSuccess = ReadPrintProfile( strGeneralFilename, "bPrintWidthLine", &strValue );
		if ( bSuccess ){ m_bPrintWidthLine = StringToBool( strValue ); }

		bSuccess = ReadPrintProfile( strGeneralFilename, "bCareSelection", &strValue );
		if ( bSuccess ){ m_bCareSelection = StringToBool( strValue ); }
		bSuccess = ReadPrintProfile( strGeneralFilename, "m_bCareEmphasis", &strValue );
		if ( bSuccess ){ m_bCareEmphasis = StringToBool( strValue ); }

		bSuccess = ReadPrintProfile( strGeneralFilename, "bHeader", &strValue );
		if ( bSuccess ){ m_bHeader = StringToBool( strValue ); }
		bSuccess = ReadPrintProfile( strGeneralFilename, "strHeaderLeft", &strValue );
		if ( bSuccess ){ m_strHeaderLeft = DeQuoteString( strValue ); }
		bSuccess = ReadPrintProfile( strGeneralFilename, "strHeaderMid", &strValue );
		if ( bSuccess ){ m_strHeaderMid = DeQuoteString( strValue ); }
		bSuccess = ReadPrintProfile( strGeneralFilename, "strHeaderRight", &strValue );
		if ( bSuccess ){ m_strHeaderRight = DeQuoteString( strValue ); }

		bSuccess = ReadPrintProfile( strGeneralFilename, "bFooter", &strValue );
		if ( bSuccess ){ m_bFooter = StringToBool( strValue ); }
		bSuccess = ReadPrintProfile( strGeneralFilename, "strFooterLeft", &strValue );
		if ( bSuccess ){ m_strFooterLeft = DeQuoteString( strValue ); }
		bSuccess = ReadPrintProfile( strGeneralFilename, "strFooterMid", &strValue );
		if ( bSuccess ){ m_strFooterMid = DeQuoteString( strValue ); }
		bSuccess = ReadPrintProfile( strGeneralFilename, "strFooterRight", &strValue );
		if ( bSuccess ){ m_strFooterRight = DeQuoteString( strValue ); }

		bSuccess = ReadPrintProfile( strGeneralFilename, "bMarge", &strValue );
		if ( bSuccess ){ m_bMarge = StringToBool( strValue ); }
		bSuccess = ReadPrintProfile( strGeneralFilename, "uiMargeCount", &strValue );
		if ( bSuccess ){ m_uiMargeCount = StringToLong( strValue ); }

		m_fontHeader.Read(
			strGeneralFilename,
			"HeaderFont"
		);

		m_fontFooter.Read(
			strGeneralFilename,
			"FooterFont"
		);
	}
	return( bSuccess );
}


/*-----------------------------------------------------------------------------
[]	wb_tb^񐶐
[@\]	L[[h̓̕IȕɕϊB
[ߒl]	CString		wb_tb^ [-] (-)
[l]	Ȃ
-----------------------------------------------------------------------------*/
CString		CPrintDefine::Cooking(
	CString&		strSrc,		// I  : L[[h蕶 [-] (-) :-
	CPrintInfo*		pInfo		// I  :  [-] (-) :-
)
{
	CString		strDst = strSrc;

	{
		CShitarabianDoc*	pDoc;
		pDoc = ::GetDocument();

		CString		strPathName = pDoc->GetPathName();
		int	idxLastSlash = strPathName.ReverseFind( '\\' );
		int	idxLastDot = strPathName.ReverseFind( '.' );

		strDst.Replace(
			m_strKeywordPath,
			strPathName.Left( idxLastSlash+1 )
		);

		strDst.Replace(
			m_strKeywordFile,
			strPathName.Mid( idxLastSlash+1, idxLastDot-idxLastSlash-1 )
		);

		strDst.Replace(
			m_strKeywordExt,
			strPathName.Mid( idxLastDot+1 )
		);
	}

	// 
	{
		CString		strPage;
		strPage.Format("%d",pInfo->m_nCurPage);
		strDst.Replace(
			m_strKeywordPage,
			strPage
		);

		CString		strPageCount;
		strPageCount.Format("%d",pInfo->GetMaxPage());
		strDst.Replace(
			m_strKeywordPageCount,
			strPageCount
		);
	}

	// t
	{
		COleDateTime dateNow;
		dateNow = COleDateTime::GetCurrentTime();

		CString		strYear;
		strYear.Format("%d", dateNow.GetYear());
		strDst.Replace(
			m_strKeywordYear,
			strYear
		);
		
		CString		strMonth;
		strMonth.Format("%d", dateNow.GetMonth());
		strDst.Replace(
			m_strKeywordMonth,
			strMonth
		);
		CString		strDay;
		strDay.Format("%d", dateNow.GetDay());
		strDst.Replace(
			m_strKeywordDay,
			strDay
		);

		CString		strDayOfWeek;
		strDayOfWeek = ::DayOfWeek( dateNow.GetDayOfWeek() );
		strDst.Replace(
			m_strKeywordDayOfWeek,
			strDayOfWeek
		);

		CString		strHour;
		strHour.Format("%d", dateNow.GetHour());
		strDst.Replace(
			m_strKeywordHour,
			strHour
		);
		CString		strMinite;
		strMinite.Format("%d", dateNow.GetMinute());
		strDst.Replace(
			m_strKeywordMinute,
			strMinite
		);
	}
	return( strDst );
}