// RgL

/*-----------------------------------------------------------------------------
[]	MainFrmAccel.cpp
[Tv]	R}hnh̎
[l]	CMainFrame ̃R}hnh֐݂̂𔲂oĂB
[]	2003-02-27	NC		Rgt(moralog)
-----------------------------------------------------------------------------*/


//-----------------------------------------------------------------------------
// CN[h
//-----------------------------------------------------------------------------
#include "stdafx.h"
#define	APSTUDIO_INVOKED	// \[XID̐ݒƔ`
#include "resource.h"
#include "Shitarabian.h"
#include "MainFrm.h"
#include "Selection.h"
#include "EditDrawer.h"
#include "GeneralSetting.h"
#include "ShitarabianView.h"
#include "CommandManager.h"
#include "CommandInput.h"
#include "CommandCaret.h"
#include "CommandDelete.h"
#include "Common.h"
#include "ShitarabianDoc.h"
#include "TokenReader.h"
#include "Padding.h"
#include "CommandMultiEdit.h"
#include "Unicoder.h"
#include "ExeCommon.h"
#include "ClipHistoryDlg.h"
#include "ClipHistory.h"
#include "LinkDefine.h"
#include <process.h>

extern CShitarabianApp theApp;


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


typedef struct
{
	int		idMenu;
	UCHAR	unKey;
	BOOL	bShift;
	BOOL	bCtrl;
	BOOL	bAlt;
	BOOL	bWithNormal;
	BOOL	bWithBoxSelect;
	BOOL	bWithFloating;
	BOOL	bWithROI;
} TAccelDefine;


static const TAccelDefine	f_aAccel[] =
{
//	idMenu					unKey			bShift	bCtrl	bAlt		Normal	Box		Float	ROI
	{ IDM_EDIT_ALLSELECT,	'A',			FALSE,	TRUE,	FALSE,		TRUE,	FALSE,	FALSE,	FALSE	},

	{ IDM_EDIT_FIND,		'F',			FALSE,	TRUE,	FALSE,		TRUE,	FALSE,	FALSE,	FALSE	},
	{ IDM_EDIT_FINDPREV,	VK_F3,			TRUE,	FALSE,	FALSE,		TRUE,	FALSE,	FALSE,	FALSE	},
	{ IDM_EDIT_FINDNEXT,	VK_F3,			FALSE,	FALSE,	FALSE,		TRUE,	FALSE,	FALSE,	FALSE	},
	{ IDM_EDIT_FINDMAGICROD,VK_F3,			FALSE,	TRUE,	FALSE,		TRUE,	FALSE,	FALSE,	FALSE	},
	{ IDM_EDIT_REPLACE,		'H',			FALSE,	TRUE,	FALSE,		TRUE,	FALSE,	FALSE,	FALSE	},

	{ IDM_EDIT_MARK,		VK_F2,			FALSE,	TRUE,	FALSE,		TRUE,	FALSE,	FALSE,	FALSE	},
	{ IDM_EDIT_PREVMARK,	VK_F2,			TRUE,	FALSE,	FALSE,		TRUE,	FALSE,	FALSE,	FALSE	},
	{ IDM_EDIT_NEXTMARK,	VK_F2,			FALSE,	FALSE,	FALSE,		TRUE,	FALSE,	FALSE,	FALSE	},

	{ ID_EDIT_COPY,			'C',			FALSE,	TRUE,	FALSE,		TRUE,	TRUE,	TRUE,	FALSE	},
	{ ID_EDIT_CUT,			'X',			FALSE,	TRUE,	FALSE,		TRUE,	TRUE,	TRUE,	FALSE	},
	{ ID_EDIT_PASTE,		'V',			FALSE,	TRUE,	FALSE,		TRUE,	TRUE,	TRUE,	FALSE	},
	{ ID_EDIT_CLIPHISTORY,	'B',			FALSE,	TRUE,	FALSE,		TRUE,	TRUE,	TRUE,	FALSE	},

	{ ID_EDIT_UNDO,			'Z',			FALSE,	TRUE,	FALSE,		TRUE,	TRUE,	FALSE,	FALSE	},
	{ ID_EDIT_REDO,			'Y',			FALSE,	TRUE,	FALSE,		TRUE,	TRUE,	FALSE,	FALSE	},

	{ IDM_VIEW_ZOOMIN,		VK_ADD,			FALSE,	TRUE,	FALSE,		TRUE,	TRUE,	TRUE,	TRUE	},
	{ IDM_VIEW_ZOOMOUT,		VK_SUBTRACT,	FALSE,	TRUE,	FALSE,		TRUE,	TRUE,	TRUE,	TRUE	},

	{ IDM_EDIT_CHARPALETTE,	' ',			FALSE,	TRUE,	FALSE,		TRUE,	FALSE,	FALSE,	FALSE	},

	{ ID_FILE_OPEN,			'O',			FALSE,	TRUE,	FALSE,		TRUE,	TRUE,	TRUE,	TRUE	},
	{ ID_FILE_NEW,			'N',			FALSE,	TRUE,	FALSE,		TRUE,	TRUE,	TRUE,	TRUE	},
//	{ ID_FILE_PRINT,		'P',			FALSE,	TRUE,	FALSE,		TRUE,	TRUE,	TRUE,	TRUE	},
//	{ ID_FILE_SAVE,			'S',			FALSE,	TRUE,	FALSE,		TRUE,	TRUE,	TRUE,	TRUE	},

	{ ID_NEXT_PANE,			VK_F6,			FALSE,	FALSE,	FALSE,		TRUE,	TRUE,	TRUE,	TRUE	},
	{ ID_PREV_PANE,			VK_F6,			TRUE,	FALSE,	FALSE,		TRUE,	TRUE,	TRUE,	TRUE	},

	{ IDM_EDIT_SHIFTLEFT,	VK_LEFT,		TRUE,	TRUE,	TRUE,		TRUE,	FALSE,	FALSE,	FALSE	},
	{ IDM_EDIT_SHIFTRIGHT,	VK_RIGHT,		TRUE,	TRUE,	TRUE,		TRUE,	FALSE,	FALSE,	FALSE	},

	{ IDM_FIND_NEXTMODIFY,	'T',			FALSE,	TRUE,	FALSE,		TRUE,	FALSE,	FALSE,	FALSE	},
	{ IDM_FIND_PREVMODIFY,	'T',			TRUE,	TRUE,	FALSE,		TRUE,	FALSE,	FALSE,	FALSE	},

//	idMenu					unKey			bShift	bCtrl	bAlt		Normal	Box		Float	ROI
};


BOOL CMainFrame::AccelKeyDown(
	UCHAR*	punKey,
	BOOL*	pbShift,
	BOOL*	pbCtrl,
	BOOL*	pbAlt
)
{
	CShitarabianDoc* pDoc = GetDocument();

	int	idxCommand;
	for ( idxCommand=0 ; idxCommand<sizeof(f_aAccel)/sizeof(TAccelDefine) ; idxCommand++ )
	{
		if ( f_aAccel[idxCommand].unKey == *punKey )
		if ( (f_aAccel[idxCommand].bShift?1:0) == (*pbShift?1:0) )
		if ( (f_aAccel[idxCommand].bCtrl?1:0) == (*pbCtrl?1:0) )
		if ( (f_aAccel[idxCommand].bAlt?1:0) == (*pbAlt?1:0) )
		{
			TRACE("%d\n",*pbCtrl?1:0);
			TRACE("%d\n",f_aAccel[idxCommand].bCtrl?1:0);

			switch( pDoc->GetOperationMode() )
			{
			case OperationROI:
				if ( !f_aAccel[idxCommand].bWithROI )
				{
					continue;
				}
				break;
			case OperationBoxSelect:
				if ( !f_aAccel[idxCommand].bWithBoxSelect )
				{
					continue;
				}
				break;
			case OperationFloating:
				if ( !f_aAccel[idxCommand].bWithFloating )
				{
					continue;
				}
				break;
			case OperationNormal:
				if ( !f_aAccel[idxCommand].bWithNormal )
				{
					continue;
				}
				break;
			default:
				break;
			}

			switch( f_aAccel[idxCommand].idMenu )
			{
			case IDM_EDIT_ALLSELECT:
				OnEditAllselect();
				break;

			case IDM_EDIT_FIND:
				OnEditFind();
				break;
			case IDM_EDIT_FINDNEXT:
				OnEditFindnext();
				break;
			case IDM_EDIT_FINDPREV:
				OnEditFindprev();
				break;
			case IDM_EDIT_FINDMAGICROD:
				OnEditFindmagicrod();
				break;
			case IDM_EDIT_REPLACE:
				OnEditReplace();
				break;

			case IDM_EDIT_MARK:
				OnEditMark();
				break;
			case IDM_EDIT_PREVMARK:
				OnEditPrevmark();
				break;
			case IDM_EDIT_NEXTMARK:
				OnEditNextmark();
				break;


			case ID_EDIT_COPY:
				OnEditCopy();
				break;
			case ID_EDIT_CUT:
				OnEditCut();
				break;
			case ID_EDIT_PASTE:
				OnEditPaste();
				break;
			case ID_EDIT_CLIPHISTORY:
				OnEditClipHistory();
				break;

			case ID_EDIT_UNDO:
				OnEditUndo();
				break;
			case ID_EDIT_REDO:
				OnEditRedo();
				break;

			case IDM_VIEW_ZOOMIN:
				OnViewZoomin();
				break;
			case IDM_VIEW_ZOOMOUT:
				OnViewZoomout();
				break;

			case IDM_EDIT_CHARPALETTE:
				OnEditCharpalette();
				break;


			case ID_NEXT_PANE:
				OnNextPane();
				break;
			case ID_PREV_PANE:
				OnPrevPane();
				break;


			case ID_FILE_OPEN:
				theApp.FileOpen();
				break;

			case ID_FILE_NEW:
				{
					theApp.FileNew();
					CShitarabianDoc* pDoc = (CShitarabianDoc*)GetActiveDocument();
					pDoc->SetAllUpdate();
					pDoc->ReDraw();
				}
				break;

			case ID_FILE_PRINT:
				{
					theApp.PostThreadMessage( ID_FILE_PRINT,0,0 );
//					pDoc->GetMainView()->PostMessage( ID_FILE_PRINT );
				}
				break;
			case ID_FILE_SAVE:
{
	MSG	msg;
	msg.message = ID_FILE_SAVE;
	msg.wParam = 0;
	msg.lParam = 0;
//				theApp.PostThreadMessage( ID_FILE_SAVE,0,0 );
//				pDoc->GetMainView()->PostMessage( ID_FILE_SAVE );
	theApp.PreTranslateMessage( &msg );
}
				break;

			case IDM_EDIT_SHIFTLEFT:
				OnEditShiftleft();
				break;
			case IDM_EDIT_SHIFTRIGHT:
				OnEditShiftright();
				break;

			case IDM_FIND_NEXTMODIFY:
				OnFindNextmodify();
				break;

			case IDM_FIND_PREVMODIFY:
				OnFindPrevmodify();
				break;

			default:
				continue;
				break;
			}
			return( TRUE );
			break;
		}
	}
	return( FALSE );
}


// 
void CMainFrame::OnEditCopy() 
{
	CShitarabianDoc* pDoc = GetDocument();
	CString		strCopy = pDoc->GetSelection()->GetSelectedText();
	::EditCopyString( strCopy );
}


void CMainFrame::OnEditCut() 
{
	// Nbv{[hփRs[
	OnEditCopy();

	// I𕶎̃f[g
	CShitarabianDoc* pDoc = GetDocument();
	pDoc->SelectedDelete();

	// IԂ̉
	pDoc->GetSelection()->SetSelectedNutral();

	// \XV
	pDoc->ReDraw();
}


// 
void CMainFrame::OnEditPaste() 
{
	// Nbv{[h當擾
	CString	strInsert = EditPasteString();

	// I͈͂̍폜
	CShitarabianDoc* pDoc = GetDocument();
	pDoc->SelectedDelete();

	// \tĩCT[gj
	switch ( pDoc->GetOperationMode() )
	{
	case OperationNormal:
		{
			// R}h̓o^
			CCommandInput	cmdInput;
			cmdInput.SetAttribute(
				strInsert,
				pDoc->GetCaretRow(),
				pDoc->GetCaretColumn()
			);
			cmdInput.Execute( pDoc );

			CCommandManager*	pCmd = CCommandManager::GetInstance();
			pCmd->Add( cmdInput );

			// IԂ̉
			pDoc->GetSelection()->SetSelectedNutral();
		}
		break;
	case OperationFloating:
	case OperationBoxSelect:
		// t[eBO[hֈڍs
		{
			CShitarabianView*	pView = pDoc->GetMainView();
			CPoint	ptScrollBox = pView->GetDeviceScrollPosition();

			CPoint	ptFloat( ptScrollBox );
			ptFloat.x /= CEditDrawer::GetInstance()->GetZoom();
			ptFloat.y /= CEditDrawer::GetInstance()->GetZoom();
			pView->ToFloating(
				strInsert,
				ptFloat.x,
				ptFloat.y
			);
		}
		break;
	default:
		break;
	}

	// ĕ`
	pDoc->GetMainView()->ScrollToCaret();
	pDoc->ReDraw();	
}



void CMainFrame::OnEditQuotepaste() 
{
	// Nbv{[h當擾
	CString	strInsert = EditPasteString();

	// I͈͂̍폜
	CShitarabianDoc* pDoc = GetDocument();
	pDoc->SelectedDelete();

	// p̑}
	CString		strQuote( CGeneralSetting::GetInstance()->GetQuote() );
	CString		strCRLFQuote( pDoc->ReturnChar()+strQuote );
	strInsert.Replace(
		pDoc->ReturnChar(),
		strCRLFQuote
	);
	strInsert.Insert( 0, strQuote );

	// \tĩCT[gj
	{
		// R}h̓o^
		CCommandInput	cmdInput;
		cmdInput.SetAttribute(
			strInsert,
			pDoc->GetCaretRow(),
			pDoc->GetCaretColumn()
		);
		cmdInput.Execute( pDoc );

		CCommandManager*	pCmd = CCommandManager::GetInstance();
		pCmd->Add( cmdInput );

		// IԂ̉
		pDoc->GetSelection()->SetSelectedNutral();
	}

	// ĕ`
	pDoc->GetMainView()->ScrollToCaret();
	pDoc->ReDraw();
}


void CMainFrame::OnEditClipHistory()
{
	CClipHistoryDlg		dlg;
	dlg.Attach( CClipHistory::GetInstance() );

	if ( dlg.DoModal() == IDOK )
	{
		OnEditPaste();
	}
}



void CMainFrame::OnEditAllselect() 
{
	CShitarabianDoc*	pDoc = GetDocument();
	switch( pDoc->GetOperationMode() )
	{
	case OperationNormal:
		{
			// 擪sZbg
			pDoc->GetSelection()->SetSelectedStart(0,0);

			// ŌsZbg
			int		idxLastLine = pDoc->GetLineCount()-1;
			CString*	pstrLastLine = pDoc->GetLine( idxLastLine );
			pDoc->GetSelection()->SetSelectedEnd( idxLastLine, ::StringToColumn( (LPCTSTR)*pstrLastLine ) );

			// ĕ`
			pDoc->SetAllUpdate();
			pDoc->ReDraw();	
		}
		break;

	default:
		break;
	}	
}




void CMainFrame::OnViewZoomin() 
{
	CEditDrawer*	pDraw = CEditDrawer::GetInstance();
	int		iZoom = pDraw->GetZoom();
	pDraw->SetZoom( iZoom+1 );

	CShitarabianDoc* pDoc = (CShitarabianDoc*)GetActiveDocument();

	RecalcScrollBar();

// Bݒ肵Ă܂hLg炾B
	// XN[{bNXړ
	CPoint		ptScroll = pDoc->GetMainView()->GetDeviceScrollPosition();
	ptScroll.x = ptScroll.x*(iZoom+1)/iZoom;
	ptScroll.y = ptScroll.y*(iZoom+1)/iZoom;

// please! ׂĂVIewɓKpȂƂȂƎv
	pDoc->GetMainView()->SetDeviceScrollPosition( ptScroll );
//	pDoc->GetMainView()->ResetHScroll();

	// \XV
	pDoc->SetAllUpdate();
	pDoc->ReDraw();
}

void CMainFrame::OnViewZoomout() 
{
	CEditDrawer*	pDraw = CEditDrawer::GetInstance();
	int		iZoom = pDraw->GetZoom();
	pDraw->SetZoom( iZoom-1 );

	CShitarabianDoc* pDoc = (CShitarabianDoc*)GetActiveDocument();

	// XN[{bNXړ
	CPoint		ptScroll = pDoc->GetMainView()->GetDeviceScrollPosition();
	ptScroll.x = ptScroll.x*(iZoom-1)/(iZoom);
	ptScroll.y = ptScroll.y*(iZoom-1)/(iZoom);

	// please! ׂĂViewɓKpȂƂȂƎv
	RecalcScrollBar();
	pDoc->GetMainView()->SetDeviceScrollPosition( ptScroll );
	pDoc->GetMainView()->ResetHScroll();

	// \XV
	pDoc->SetAllUpdate();
	pDoc->ReDraw();
}


void CMainFrame::OnEditUndo() 
{
	// IԂ̉
	// \XV͈͐ݒ
	CShitarabianDoc* pDoc = (CShitarabianDoc*)GetActiveDocument( );
	CSelection*			pSelection = pDoc->GetSelection();
	pDoc->SetUpdateStartRow( pSelection->GetSelectedStartRow() );
	pDoc->SetUpdateEndRow( pSelection->GetSelectedEndRow() );
	pSelection->SetSelectedNutral();

	// Undo
	CCommandManager*	pCmd = CCommandManager::GetInstance();
	pCmd->UnDo();

	// \XV
	pDoc->GetMainView()->ScrollToCaret();
	pDoc->ReDraw();
}


void CMainFrame::OnEditRedo() 
{
	// IԂ̉
	// \XV͈͐ݒ
	CShitarabianDoc* pDoc = (CShitarabianDoc*)GetActiveDocument( );
	CSelection*			pSelection = pDoc->GetSelection();
	pDoc->SetUpdateStartRow( pSelection->GetSelectedStartRow() );
	pDoc->SetUpdateEndRow( pSelection->GetSelectedEndRow() );
	pSelection->SetSelectedNutral();

	// Redo
	CCommandManager*	pCmd = CCommandManager::GetInstance();
	pCmd->ReDo();

	// \XV
	pDoc->GetMainView()->ScrollToCaret();
	pDoc->ReDraw();
}


void CMainFrame::OnEditMark() 
{
	CShitarabianDoc* pDoc = (CShitarabianDoc*)GetActiveDocument();
	int		iCurrentRow = pDoc->GetCaretRow();

	pDoc->Mark( iCurrentRow );

	pDoc->SetUpdateStartRow( iCurrentRow );
	pDoc->SetUpdateEndRow( iCurrentRow );
	pDoc->ReDraw();
}

void CMainFrame::OnEditNextmark() 
{
	CShitarabianDoc* pDoc = (CShitarabianDoc*)GetActiveDocument();
//	int		iCurrentRow = pDoc->GetCaretRow();

	pDoc->NextMark();

	pDoc->SetAllUpdate();
	pDoc->GetMainView()->ScrollToCaret();
	pDoc->ReDraw();
}

void CMainFrame::OnEditPrevmark() 
{
	CShitarabianDoc* pDoc = (CShitarabianDoc*)GetActiveDocument();
//	int		iCurrentRow = pDoc->GetCaretRow();

	pDoc->PrevMark();

	pDoc->SetAllUpdate();
	pDoc->GetMainView()->ScrollToCaret();
	pDoc->ReDraw();
}




void CMainFrame::OnEditFind() 
{
	m_dlgReplacer.ShowWindow( SW_HIDE );
	m_dlgFinder.ShowWindow( SW_SHOW );
	return;
}

void CMainFrame::OnEditFindnext() 
{
	CString		strSubString;
	m_wndSubStringCombo.GetWindowText( strSubString );
	AddSubString( strSubString, &m_wndSubStringCombo );

	m_dlgFinder.FindNext(  );
}

void CMainFrame::OnEditFindprev() 
{
	CString		strSubString;
	m_wndSubStringCombo.GetWindowText( strSubString );
	AddSubString( strSubString, &m_wndSubStringCombo );

	m_dlgFinder.FindPrev(  );
}

void CMainFrame::OnEditFindmagicrod() 
{
	CShitarabianDoc* pDoc = (CShitarabianDoc*)GetActiveDocument();
	pDoc->GetMainView()->FindMagicRod();
}


void CMainFrame::OnEditReplace() 
{
	m_dlgFinder.ShowWindow( SW_HIDE );
	m_dlgReplacer.ShowWindow( SW_SHOW );
	return;
}

void CMainFrame::OnEditCharpalette() 
{
	CShitarabianDoc* pDoc = (CShitarabianDoc*)GetActiveDocument();

	CCharPaletteDlg*	pDlg = CGeneralSetting::GetInstance()->GetCharPaletteManager()->GetCharPaletteDlg();
	pDlg->ShowWindow( SW_SHOW );
	pDlg->SetFocus();
}



void CMainFrame::OnNextPane()
{
	CSplitterWnd*	pSplitter = ((CMainFrame*)::AfxGetMainWnd())->GetSplitter();

	int	iRow;
	int	iColumn;
	pSplitter->GetActivePane(
		&iRow,
		&iColumn
	);

	iColumn++;
	if ( iColumn >= pSplitter->GetColumnCount() )
	{
		iColumn = 0;
		iRow++;
		if ( iRow >= pSplitter->GetRowCount() )
		{
			iRow = 0;
		}

	}
	pSplitter->SetActivePane( iRow, iColumn, NULL );

	CShitarabianDoc* pDoc = (CShitarabianDoc*)GetActiveDocument();
	pDoc->SetAllUpdate();
	pDoc->ReDraw();
}


void CMainFrame::OnPrevPane()
{
	CSplitterWnd*	pSplitter = ((CMainFrame*)::AfxGetMainWnd())->GetSplitter();

	int	iRow;
	int	iColumn;
	pSplitter->GetActivePane(
		&iRow,
		&iColumn
	);

	iColumn--;
	if ( iColumn < 0 )
	{
		iColumn = pSplitter->GetColumnCount() - 1;
		iRow--;
		if ( iRow < 0 )
		{
			iRow = pSplitter->GetRowCount() -1;
		}

	}
	pSplitter->SetActivePane( iRow, iColumn, NULL );

	CShitarabianDoc* pDoc = (CShitarabianDoc*)GetActiveDocument();
	pDoc->SetAllUpdate();
	pDoc->ReDraw();
}


void CMainFrame::OnEditShiftleft() 
{
	EditShift( FALSE );
	CShitarabianDoc* pDoc = (CShitarabianDoc*)GetActiveDocument();
	pDoc->ReDraw();
}

void CMainFrame::OnEditShiftright() 
{
	EditShift( TRUE );
	CShitarabianDoc* pDoc = (CShitarabianDoc*)GetActiveDocument();
	pDoc->ReDraw();
}


void CMainFrame::EditShift(
	BOOL	bRight
)
{
	CShitarabianDoc* pDoc = (CShitarabianDoc*)GetActiveDocument();

	// LbgʒũJƍs擾
	int		iCaretRow = pDoc->GetCaretRow();
	int		iCaretColumn = pDoc->GetCaretColumn();

	// Lbgs̎擾
	CString*		pstr = pDoc->GetLine( iCaretRow );

	// g[Nɕ
	CArray< TToken, TToken& >	aTokenz;
	CTokenReader::StringToCharTypez(
		*pstr,
		&aTokenz
	);

	// Ώۂ̃g[NT
	int		idxToken;
	{
		// Lbĝg[N
		idxToken = CTokenReader::TokenIndex(
			aTokenz,
			iCaretColumn
		);
		if ( idxToken != InvalidTokenIndex )
		{
			// Lbg󔒈ʒuƂ̋Eɂ΋󔒈ʒuƂ݂Ȃ
			if ( aTokenz[idxToken].eCharType != CharTypeWhitespace )
			if ( aTokenz[idxToken].idxStartColumn == iCaretColumn )
			if ( idxToken > 0 )
			if ( aTokenz[idxToken-1].eCharType == CharTypeWhitespace )
			{
				idxToken--;
			}
		}
	}

	if ( idxToken != InvalidTokenIndex )
	// Lbg󔒈ʒuɂꍇ
	if ( aTokenz[idxToken].eCharType == CharTypeWhitespace )
	{
		CDC*	pDC = GetDC();
		// ̃g[N̊Ԃ̋󔒂̑傫擾
		int		iOldWidth;
		{
			int iStartByte = ::CaretColumnToByteColumn( *pstr, aTokenz[idxToken].idxStartColumn );
			int iEndByte = ::CaretColumnToByteColumn( *pstr, aTokenz[idxToken].idxStartColumn + aTokenz[idxToken].nColumn );
			CString		strSubString = pstr->Mid( 
				iStartByte,
				iEndByte - iStartByte
			);
			CEditDrawer*	pDraw = CEditDrawer::GetInstance();
			iOldWidth = pDraw->StringToPixelX(
				strSubString,
				pDC
			);
		}

		// 󔒂̑傫ɃvXPĂ݂ăpfBOB
		CString		strPad;
		int		iOffset;
		for ( iOffset=1 ; iOffset<100 ; iOffset++ )	// [v΍BK
		{
			CPadding	Padding;
			long	iGap;
			if ( bRight )
			{
				iGap = Padding.Padding(
					pDC,
					iOldWidth+iOffset,
					strPad,
					*( CGeneralSetting::GetInstance()->GetWhitespace()->GetCharz() ),
					TRUE
				);
			}
			else
			{
				if ( iOldWidth-iOffset <= 0 )
				{
					strPad.Empty();
					break;
				}
				iGap = Padding.Padding(
					pDC,
					iOldWidth-iOffset,
					strPad,
					*( CGeneralSetting::GetInstance()->GetWhitespace()->GetCharz() ),
					TRUE
				);
			}

			if ( iGap == 0 )
			{
				// HIT!
				break;
			}
			strPad.Empty();
		}
		ReleaseDC( pDC );

		// R}h̓o^
		CCommandManager*	pCmd = CCommandManager::GetInstance();
		CCommandMultiEdit	cmdEdit;
		{
			CCommandDelete	cmdDelete;
			cmdDelete.SetAttribute(
				iCaretRow,
				aTokenz[idxToken].idxStartColumn,
				iCaretRow,
				aTokenz[idxToken].idxStartColumn + aTokenz[idxToken].nColumn
			);
			cmdEdit.Add( cmdDelete );

			// R}h̓o^
			CCommandInput	cmdInput;
			cmdInput.SetAttribute( strPad, iCaretRow, aTokenz[idxToken].idxStartColumn );
			cmdEdit.Add( cmdInput );
		}
		cmdEdit.Execute( pDoc );
		pCmd->Add( cmdEdit );
	}
	else
	if ( bRight )
	{
		// pfBOł傫𓾂
		CDC*	pDC = GetDC();

		// 󔒂̑傫ɃvXPĂ݂ăpfBOB
		CString		strPad;
		int		iOffset;
		for ( iOffset=1 ; iOffset<100 ; iOffset++ )	// [v΍BK
		{
			CPadding	Padding;
			long	iGap = Padding.Padding(
				pDC,
				iOffset,
				strPad,
				*( CGeneralSetting::GetInstance()->GetWhitespace()->GetCharz() ),
				TRUE
			);
			if ( iGap == 0 )
			{
				// HIT!
				break;
			}
			strPad.Empty();
		}
		ReleaseDC( pDC );

		// Ԃɓ˂ŏI
		CCommandInput	cmdInput;
		cmdInput.SetAttribute( strPad, iCaretRow, iCaretColumn );
		cmdInput.Execute( pDoc );
		CCommandManager*	pCmd = CCommandManager::GetInstance();
		pCmd->Add( cmdInput );
	}	
}


void CMainFrame::OnFindNextmodify() 
{
	CShitarabianDoc* pDoc = (CShitarabianDoc*)GetActiveDocument();
	pDoc->NextModify();
	pDoc->SetAllUpdate();
	pDoc->GetMainView()->ScrollToCaret();
	pDoc->ReDraw();
}

void CMainFrame::OnFindPrevmodify() 
{
	CShitarabianDoc* pDoc = (CShitarabianDoc*)GetActiveDocument();
	pDoc->PrevModify();
	pDoc->SetAllUpdate();
	pDoc->GetMainView()->ScrollToCaret();
	pDoc->ReDraw();
}

void CMainFrame::Alignment(
	long	idxRow,
	EAlign	eAlign
)
{
	CShitarabianDoc* pDoc = (CShitarabianDoc*)GetActiveDocument();
	CString*	pstrLine = pDoc->GetLine( idxRow );

	// ݍs̒𓾂
	long		lLineWidth = 0;
	CString		strSolidLine;
	if ( pstrLine != NULL )
	{
		// g[NɕA󔒂łȂ擾
		CArray< TToken, TToken& >	aTokenz;
		CTokenReader::StringToCharTypez(
			*pstrLine,
			&aTokenz
		);

		// 󔒂łȂ𓾂
		int		idxSolidStartByteColumn = 0;
		for( int idxToken=0 ; idxToken<aTokenz.GetSize() ; idxToken++ )
		{
			if ( aTokenz[idxToken].eCharType != CharTypeWhitespace )
			{
				idxSolidStartByteColumn =
					::CaretColumnToByteColumn(
						*pstrLine,
						aTokenz[idxToken].idxStartColumn
					);
				break;
			}
		}
		int		idxSolidEndByteColumn = 0;
		for( idxToken=aTokenz.GetSize()-1 ; idxToken>=0 ; idxToken-- )
		{
			if ( aTokenz[idxToken].eCharType != CharTypeWhitespace )
			{
				idxSolidEndByteColumn =
					::CaretColumnToByteColumn(
						*pstrLine,
						aTokenz[idxToken].idxStartColumn+aTokenz[idxToken].nColumn
					);
				break;
			}
		}
		strSolidLine = pstrLine->Mid(
			idxSolidStartByteColumn,
			idxSolidEndByteColumn - idxSolidStartByteColumn
		);

		// 擾
		CDC*	pDC = GetDC();
		lLineWidth = CEditDrawer::GetInstance()->StringToPixelX(
			strSolidLine,
			pDC
		);
		ReleaseDC( pDC );
	}

	// pfBOׂ𓾂
	long	lClientWidth = CGeneralSetting::GetInstance()->GetPrintDefine()->m_lPrintPixelWidth;
	long	lPaddingWidth;
	switch( eAlign )
	{
	case AlignLeft:
	default:
		lPaddingWidth = 0;
		break;

	case AlignCenter:
		lPaddingWidth = (lClientWidth - lLineWidth)/2;
		break;

	case AlignRight:
		lPaddingWidth = lClientWidth - lLineWidth;
		break;
	}

	// pfBO𓾂
	CString	strPadding;
	{
		CPadding	Padding;
		CDC*	pDC = GetDC();
		Padding.Padding(
			pDC,
			lPaddingWidth,
			strPadding,
			*( CGeneralSetting::GetInstance()->GetWhitespace()->GetCharz() )
		);
		ReleaseDC( pDC );
	}

	// s̍ւ
	CCommandMultiEdit	cmdEdit;
	{
		CCommandDelete	cmdDelete;
		cmdDelete.SetAttribute(
			idxRow, 0,
			idxRow, ::StringToColumn( *pstrLine )
		);
		cmdEdit.Add( cmdDelete );

		if( !strSolidLine.IsEmpty() )
		{
			CCommandInput	cmdInput;
			cmdInput.SetAttribute(
				strPadding + strSolidLine,
				idxRow,
				0
			);
			cmdEdit.Add( cmdInput );
		}
	}
	cmdEdit.Execute( pDoc );
	CCommandManager*	pCmd = CCommandManager::GetInstance();
	pCmd->Add( cmdEdit );
}

void CMainFrame::Alignment(
	EAlign	eAlign
)
{
	CShitarabianDoc* pDoc = (CShitarabianDoc*)GetActiveDocument( );
	CSelection*			pSelection = pDoc->GetSelection();
	if( pSelection->IsSelected() )
	{
		for( int idxRow=pSelection->GetSelectedStartRow();
					idxRow<=pSelection->GetSelectedEndRow();
					idxRow++ )
		{
			Alignment( idxRow, eAlign );
		}

		// IԕύX
		int		idxStart = pSelection->GetSelectedStartRow();
		int		idxEnd = pSelection->GetSelectedEndRow();
		pSelection->SetSelectedStart(
			idxStart,
			0
		);
		pSelection->SetSelectedEnd(
			idxEnd,
			::StringToColumn(
				*( pDoc->GetLine( idxEnd ) )
			)
		);
	}
	else
	{
		Alignment(
			pDoc->GetCaretRow(),
			eAlign
		);
	}
}

void CMainFrame::OnEditLeft() 
{
	CShitarabianDoc* pDoc = (CShitarabianDoc*)GetActiveDocument();
	CSelection*			pSelection = pDoc->GetSelection();
	if( pSelection->IsSelected() && CGeneralSetting::GetInstance()->GetBlockAlignment() )
	{
		BlockAlignment(
			AlignLeft
		);
	}
	else
	{
		Alignment(
			AlignLeft
		);
	}
	pDoc->ReDraw();
}

void CMainFrame::OnEditMid() 
{
	CShitarabianDoc* pDoc = (CShitarabianDoc*)GetActiveDocument();
	CSelection*			pSelection = pDoc->GetSelection();
	if( pSelection->IsSelected() && CGeneralSetting::GetInstance()->GetBlockAlignment() )
	{
		BlockAlignment(
			AlignCenter
		);
	}
	else
	{
		Alignment(
			AlignCenter
		);
	}
	pDoc->ReDraw();	
}

void CMainFrame::OnEditRight() 
{
	CShitarabianDoc* pDoc = (CShitarabianDoc*)GetActiveDocument();
	CSelection*			pSelection = pDoc->GetSelection();
	if( pSelection->IsSelected() && CGeneralSetting::GetInstance()->GetBlockAlignment() )
	{
		BlockAlignment(
			AlignRight
		);
	}
	else
	{
		Alignment(
			AlignRight
		);
	}
	pDoc->ReDraw();
}






void CMainFrame::BlockAlignment(
	long	idxRow,
	EAlign	eAlign,
	long	lSrcBlockLeft,
	long	lSrcBlockRight
)
{
	CDC*	pDC = GetDC();

	CShitarabianDoc*	pDoc = ::GetDocument();
//	CEditDrawer*		pDrawer = CEditDrawer::GetInstance();
	CString*			pstrLine = pDoc->GetLine( idxRow );

	// ݍs̒𓾂
	int		idxSolidStartPixel = 0;
	int		idxSolidEndPixel = 0;
	long		lLineWidth = 0;
	CString		strSolidLine;
	if ( pstrLine != NULL )
	{
		// g[NɕA󔒂łȂ擾
		CArray< TToken, TToken& >	aTokenz;
		CTokenReader::StringToCharTypez(
			*pstrLine,
			&aTokenz
		);

		// 󔒂łȂ𓾂
		int		idxSolidStartByteColumn = 0;
		int		idxSolidEndByteColumn = 0;
		int		idxSolidStartCaretColumn = 0;
		int		idxSolidEndCaretColumn = 0;
		{
			for( int idxToken=0 ; idxToken<aTokenz.GetSize() ; idxToken++ )
			{
				if ( aTokenz[idxToken].eCharType != CharTypeWhitespace )
				{
					idxSolidStartCaretColumn  = aTokenz[idxToken].idxStartColumn;
					idxSolidStartByteColumn = ::CaretColumnToByteColumn(
						*pstrLine,
						idxSolidStartCaretColumn
					);

					CEmphasisLine*	pEmphasisLine = pDoc->GetEmphasisLine( idxRow );
					if ( pEmphasisLine != NULL )
					{
						idxSolidStartPixel = pEmphasisLine->CaretColumnToPixel( idxSolidStartCaretColumn );
					}
					break;
				}
			}
			for( idxToken=aTokenz.GetSize()-1 ; idxToken>=0 ; idxToken-- )
			{
				if ( aTokenz[idxToken].eCharType != CharTypeWhitespace )
				{
					idxSolidEndCaretColumn = aTokenz[idxToken].idxStartColumn+aTokenz[idxToken].nColumn;
					idxSolidEndByteColumn = ::CaretColumnToByteColumn(
						*pstrLine,
						idxSolidEndCaretColumn
					);


					idxSolidEndPixel = 0;
					CEmphasisLine*	pEmphasisLine = pDoc->GetEmphasisLine( idxRow );
					if ( pEmphasisLine != NULL )
					{
						idxSolidEndPixel = pEmphasisLine->CaretColumnToPixel( idxSolidEndCaretColumn );
					}
					break;
				}
			}
		}
		strSolidLine = pstrLine->Mid(
			idxSolidStartByteColumn,
			idxSolidEndByteColumn - idxSolidStartByteColumn
		);

		// 擾
		lLineWidth = CEditDrawer::GetInstance()->StringToPixelX(
			strSolidLine,
			pDC
		);
	}

	// pfBOׂ𓾂
	long	lClientWidth = CGeneralSetting::GetInstance()->GetPrintDefine()->m_lPrintPixelWidth;
	long	lPaddingWidth;
	switch( eAlign )
	{
	case AlignLeft:
	default:
		lPaddingWidth = idxSolidStartPixel - lSrcBlockLeft;;
		break;

	case AlignCenter:
		lPaddingWidth = (lClientWidth - (lSrcBlockRight - lSrcBlockLeft))/2
						 + idxSolidStartPixel - lSrcBlockLeft;
		break;

	case AlignRight:
		lPaddingWidth = (lClientWidth - (lSrcBlockRight - lSrcBlockLeft))
						 + idxSolidStartPixel - lSrcBlockLeft;
		break;
	}

	// pfBO𓾂
	CString	strPadding;
	{
		CPadding	Padding;
		Padding.Padding(
			pDC,
			lPaddingWidth,
			strPadding,
			*( CGeneralSetting::GetInstance()->GetWhitespace()->GetCharz() )
		);
	}

	// s̍ւ
	CCommandMultiEdit	cmdEdit;
	{
		CCommandDelete	cmdDelete;
		cmdDelete.SetAttribute(
			idxRow, 0,
			idxRow, ::StringToColumn( *pstrLine )
		);
		cmdEdit.Add( cmdDelete );

		if( !strSolidLine.IsEmpty() )
		{
			CCommandInput	cmdInput;
			cmdInput.SetAttribute(
				strPadding + strSolidLine,
				idxRow,
				0
			);
			cmdEdit.Add( cmdInput );
		}
	}
	cmdEdit.Execute( pDoc );
	CCommandManager*	pCmd = CCommandManager::GetInstance();
	pCmd->Add( cmdEdit );


	ReleaseDC( pDC );
}

void CMainFrame::BlockAlignment(
	EAlign		eAlign
)
{
	CShitarabianDoc* pDoc = (CShitarabianDoc*)GetActiveDocument( );
	CSelection*			pSelection = pDoc->GetSelection();
//	CEditDrawer*		pDrawer = CEditDrawer::GetInstance();

	if( pSelection->IsSelected() )
	{
		int idxRow;
		// ubN̒𓾂
		long	lBlockLeft = INT_MAX;
		long	lBlockRight = 0;
		for( idxRow=pSelection->GetSelectedStartRow();
			idxRow<=pSelection->GetSelectedEndRow();
			idxRow++ )
		{
			CString*			pstrLine = pDoc->GetLine( idxRow );

			// ݍs̒𓾂
			if ( pstrLine != NULL )
			if ( !pstrLine->IsEmpty() )
			{
				// g[NɕA󔒂łȂ擾
				CArray< TToken, TToken& >	aTokenz;
				CTokenReader::StringToCharTypez(
					*pstrLine,
					&aTokenz
				);

				// 󔒂łȂ𓾂
				int		idxSolidStartCaretColumn = 0;
				int		idxSolidEndCaretColumn = 0;
				int		idxSolidStartPixel = 0;
				int		idxSolidEndPixel = 0;
				{
					CEmphasisLine*	pEmphasisLine = pDoc->GetEmphasisLine( idxRow );
					for( int idxToken=0 ; idxToken<aTokenz.GetSize() ; idxToken++ )
					{
						if ( aTokenz[idxToken].eCharType != CharTypeWhitespace )
						{
							idxSolidStartCaretColumn  = aTokenz[idxToken].idxStartColumn;
							if ( pEmphasisLine != NULL )
							{
								idxSolidStartPixel = pEmphasisLine->CaretColumnToPixel(
									idxSolidStartCaretColumn
								);
							}
							break;
						}
					}
					for( idxToken=aTokenz.GetSize()-1 ; idxToken>=0 ; idxToken-- )
					{
						if ( aTokenz[idxToken].eCharType != CharTypeWhitespace )
						{
							idxSolidEndCaretColumn = aTokenz[idxToken].idxStartColumn+aTokenz[idxToken].nColumn;
							if ( pEmphasisLine != NULL )
							{
								idxSolidEndPixel = pEmphasisLine->CaretColumnToPixel(
									idxSolidEndCaretColumn
								);
							}
							break;
						}
					}
				}
				lBlockLeft = min ( lBlockLeft, idxSolidStartPixel );
				lBlockRight = max ( lBlockRight, idxSolidEndPixel );
			}
		}

		// pfBOs̍ւ
		for( idxRow=pSelection->GetSelectedStartRow();
					idxRow<=pSelection->GetSelectedEndRow();
					idxRow++ )
		{
			BlockAlignment(
				idxRow,
				eAlign,
				lBlockLeft,
				lBlockRight
			);
		}

		// IԕύX
		{
			int		idxStart = pSelection->GetSelectedStartRow();
			int		idxEnd = pSelection->GetSelectedEndRow();
			pSelection->SetSelectedStart(
				idxStart,
				0
			);
			pSelection->SetSelectedEnd(
				idxEnd,
				::StringToColumn(
					*( pDoc->GetLine( idxEnd ) )
				)
			);
		}
	}
}





/*-----------------------------------------------------------------------------
[]	Nnh
[@\]	ҏW̃NJB
[ߒl]	Ȃ
[l]	ENbÑ|bvAbvj[R[B
-----------------------------------------------------------------------------*/
void CMainFrame::OnLink() 
{
	// JgtH_ړ
	{
		// JĂhLg̃tH_JgtH_Ƃ
		CShitarabianDoc* pDoc = (CShitarabianDoc*)GetActiveDocument( );
		CString	strPathName = pDoc->GetPathName();
		if ( !strPathName.IsEmpty() )
		{
			int	idxLastSlash = strPathName.ReverseFind( '\\' );
			strPathName = strPathName.Left( idxLastSlash+1 );

			if ( !strPathName.IsEmpty() )
			{
				::SetCurrentDirectory( strPathName );
			}
		}
	}

	// N
	CLinkDefine*	pLinkDefine = CLinkDefine::GetInstance();
	TLinkTarget*	pLink = pLinkDefine->TargetLink();
	switch( pLink->eLinkType )
	{
	case LinkOpenAction:
		// shell open
		{
			::ShellExecute( HWND_DESKTOP, NULL, pLink->strTarget, NULL, NULL, SW_SHOWNORMAL);
			// please! JȂꍇ̃bZ[Wo
		}
		break;

	case LinkTxt:
		// тŊJ
		{
			const	iMaxLength( 1028 );	// pXi[obt@

			// st@C𓾂
			char	strExeShortPath[ iMaxLength ];
			{
				char	strExeLongPath[ iMaxLength ];
				::GetModuleFileName(
					NULL,
					strExeLongPath,
					iMaxLength
				);

				// V[gt@C̃pX𓾂
				::GetShortPathName( strExeLongPath, strExeShortPath, iMaxLength );
			}

			BOOL	bExist;
			CFileStatus	dummy;
			bExist = CFile::GetStatus( pLink->strTarget, dummy );
			if ( bExist )
			{
				// hLgt@C𓾂
				char	strDocumentShortPath[ iMaxLength ];
				::GetShortPathName( pLink->strTarget, strDocumentShortPath, iMaxLength );

				// ʑŊJ
				_spawnl( _P_NOWAIT, strExeShortPath, strExeShortPath, strDocumentShortPath, NULL );
			}
			else
			{
				CString		strMes;
				strMes.Format( "t@C\"%s\"݂܂", pLink->strTarget );
				::AfxMessageBox( strMes );
			}
		}
		break;

	case LinkJump:
		// sփWv
		{
			// N悩琔o

			// sɊY鐔̂săWv
			CString		strSubString(  pLink->strTarget );
			AddSubString( strSubString, NULL );

			BOOL	bLoopOld = m_dlgFinder.m_bLoop;
			m_dlgFinder.m_bLoop = TRUE;
			m_dlgFinder.FindNext(  );
			m_dlgFinder.m_bLoop = bLoopOld;
		}
		break;

	default:
		
		break;
	}
}


/*-----------------------------------------------------------------------------
[]	Inh
[@\]	ҏW̕IB
[ߒl]	Ȃ
[l]	ENbÑ|bvAbvj[R[B
-----------------------------------------------------------------------------*/
void CMainFrame::OnMagicSelect() 
{
	// IB
	TLinkTarget*	pLink = CLinkDefine::GetInstance()->TargetLink();
	CShitarabianDoc* pDoc = GetDocument();
	CSelection*	pSelection = pDoc->GetNormalSelection();

	pSelection->SetSelectedStart(
		pLink->idxRow,
		pLink->idxColumn
	);

	pSelection->SetSelectedEnd(
		pLink->idxRow,
		pLink->idxColumn + pLink->nColumn
	);

	// ĕ`
	pDoc->SetUpdateStartRow( pLink->idxRow );
	pDoc->SetUpdateEndRow( pLink->idxRow );
	pDoc->ReDraw();
}


/*-----------------------------------------------------------------------------
[]	Rs[nh
[@\]	ҏW̕Rs[B
[ߒl]	Ȃ
[l]	ENbÑ|bvAbvj[R[B
-----------------------------------------------------------------------------*/
void CMainFrame::OnMagicCopy() 
{
	TLinkTarget*	pLink = CLinkDefine::GetInstance()->TargetLink();
	::EditCopyString( pLink->strTarget );
}
