// RgL
// MacroExecute.cpp: CMacroExecute NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "shitarabian.h"
#include "MacroExecute.h"
#include "ShitarabianDoc.h"
#include "MainFrm.h"

#include "CommandCaret.h"
#include "CommandInput.h"
#include "CommandManager.h"
#include "CommandDelete.h"
#include "Selection.h"
#include "ToolBarManager.h"
#include "ShitarabianView.h"
#include "RoiSelection.h"
#include "GeneralSetting.h"
#include "SettingPath.h"
#include "EditDrawer.h"
#include "Common.h"
#include "ExeCommon.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif



// ǂ킯__stdcallł̓GNX|[głȂ悤Ȃ̂
// __cdecliCAC++Wjŉ䖝B
extern "C" BOOL __declspec(dllexport) FuncExecuteMacroCommand( int, int, void* );
BOOL FuncExecuteMacroCommand(
	int				eCommand,
	int				nArg,
	void*			paArg
)
{
	return(
		CMacroExecute::Execute(
			(EMacroCommand)eCommand,
			nArg,
			paArg
		)
	);
}




//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CMacroExecute::CMacroExecute()
{

}

CMacroExecute::~CMacroExecute()
{

}


BOOL	CMacroExecute::Execute(
	int				eCommand,
	int				nArg,
	void*			paArg
)
{
	BOOL	bSuccess = FALSE;

	CShitarabianDoc* pDoc;
	{
		pDoc = ::GetDocument();
		if ( pDoc == NULL )
		{
			return( FALSE );
		}
	}
	CSelection*			pSelection = pDoc->GetSelection();

	BOOL	bSelectedModify = FALSE;
	int idxOldSelectedStartRow = pSelection->GetSelectedStartRow();
	int idxOldSelectedEndRow = pSelection->GetSelectedEndRow();

	int idxRow = pDoc->GetCaretRow();
	int idxColumn = pDoc->GetCaretColumn();

	int	nRow = pDoc->GetLineCount();

	switch( (EMacroCommand)eCommand )
	{
//}n
	case MC_insert:			//̑}iLbgړj
		if ( nArg == 1 )
		{
			CString		strInsert( (const char*)(*(void**)paArg) );
			CCommandInput	cmdInput;
			int idxRow = pDoc->GetCaretRow();
			int idxColumn = pDoc->GetCaretColumn();
			cmdInput.SetAttribute( strInsert, idxRow, idxColumn );
			cmdInput.Execute( pDoc );

			CCommandManager*	pCmd = CCommandManager::GetInstance();
			pCmd->Add( cmdInput );
			bSuccess = TRUE;
		}
		break;

	case MC_insertfix:		//̑}iLbgړȂj
		if ( nArg == 1 )
		{
			CString		strInsert( (const char*)(*(void**)paArg) );
			CCommandInput	cmdInput;
			int idxRow = pDoc->GetCaretRow();
			int idxColumn = pDoc->GetCaretColumn();
			cmdInput.SetAttribute( strInsert, idxRow, idxColumn );
			cmdInput.Execute( pDoc );

			CCommandManager*	pCmd = CCommandManager::GetInstance();
			pCmd->Add( cmdInput );

			// J[\̈ʒuɖ߂
			CCommandCaret	cmdCaret;
			cmdCaret.SetAttribute( 0x00, idxRow, idxColumn );
			cmdCaret.Execute( pDoc );
			bSuccess = TRUE;
		}
		break;

//폜n
	case MC_backspace:		//BSL[
		if ( nArg == 0 )
		{
			// ̐擪łBSłȂ
			if ( idxRow == 0 )
			if ( idxColumn == 0 )
			{
				break;
			}
			CCommandCaret	cmdCaret;
			cmdCaret.SetAttribute( VK_LEFT, idxRow, idxColumn );
			cmdCaret.Execute( pDoc );
		} // MC_delete

	case MC_delete:			//DELL[
		if ( nArg == 0 )
		{
			{
				// R}h̓o^
				CCommandDelete	cmdDelete;

				if (( pSelection->GetSelectedStartColumn() == pSelection->GetSelectedEndColumn() ) &&
					( pSelection->GetSelectedStartRow() == pSelection->GetSelectedEndRow() ) )
				{
				// P폜̂Ƃ
					int idxRow = pDoc->GetCaretRow();
					int idxColumn = pDoc->GetCaretColumn();
					cmdDelete.SetAttribute( idxRow, idxColumn, idxRow, idxColumn+1 );
				}
				else
				{
				// I͈͍폜
					cmdDelete.SetAttribute(
						pSelection->GetSelectedStartRow(),
						pSelection->GetSelectedStartColumn(),
						pSelection->GetSelectedEndRow(),
						pSelection->GetSelectedEndColumn()
					);
					
				}
				cmdDelete.Execute( pDoc );

				CCommandManager*	pCmd = CCommandManager::GetInstance();
				pCmd->Add( cmdDelete );
			}
			// IԂ̉
			if ( pSelection->IsSelected() )
			{
				bSelectedModify = TRUE;
			}
			pSelection->SetSelectedNutral();
			bSuccess = TRUE;
		}
		break;

//J[\ړn
	case MC_up:				//J[\ړ
		if ( nArg == 0 )
		{
			if ( idxRow > 0 )
			{
				CCommandCaret	cmdCaret;
				cmdCaret.SetAttribute( VK_UP, idxRow, idxColumn );
				cmdCaret.Execute( pDoc );
				bSuccess = TRUE;
			}
		}
		break;

	case MC_down:			//J[\ړ
		if ( nArg == 0 )
		{
			if ( idxRow < nRow-1 )
			{
				CCommandCaret	cmdCaret;
				cmdCaret.SetAttribute( VK_DOWN, idxRow, idxColumn );
				cmdCaret.Execute( pDoc );
				bSuccess = TRUE;
			}
		}
		break;

	case MC_left:			//J[\ړ
		if ( nArg == 0 )
		{
			CCommandCaret	cmdCaret;
			cmdCaret.SetAttribute( VK_LEFT, idxRow, idxColumn );
			bSuccess = cmdCaret.Execute( pDoc );
		}
		break;

	case MC_right:			//J[\Eړ
		if ( nArg == 0 )
		{
			CString*	pstr = pDoc->GetLine( idxRow );
			if ( pstr != NULL )
			{
				CCommandCaret	cmdCaret;
				cmdCaret.SetAttribute( VK_RIGHT, idxRow, idxColumn );
				bSuccess = cmdCaret.Execute( pDoc );
			}
		}
		break;

	case MC_gofileend:		//t@C̍ŌɈړ
		if ( nArg == 0 )
		{
			CCommandCaret	cmdCaret;
			cmdCaret.SetAttribute( 0x00, nRow-1, 0 );
			cmdCaret.Execute( pDoc );
			cmdCaret.SetAttribute( VK_END, 0, 0 );
			bSuccess = cmdCaret.Execute( pDoc );
		}
		break;

	case MC_gofiletop:		//t@C̐擪Ɉړ
		if ( nArg == 0 )
		{
			CCommandCaret	cmdCaret;
			cmdCaret.SetAttribute( 0x00, 0, 0 );
			bSuccess = cmdCaret.Execute( pDoc );
		}
		break;

	case MC_golastupdated:	//ŌɕҏWɈړ
		AfxMessageBox( "(MC_golastupdated)" );
		break;

	case MC_golineend:		//s̍ŌɈړ
		if ( nArg == 0 )
		{
			CCommandCaret	cmdCaret;
			cmdCaret.SetAttribute( VK_END, 0, 0 );
			bSuccess = cmdCaret.Execute( pDoc );
		}
		break;

	case MC_golinetop:		//s̐擪Ɉړ
		if ( nArg == 0 )
		{
			CCommandCaret	cmdCaret;
			cmdCaret.SetAttribute( VK_HOME, 0, 0 );
			bSuccess = cmdCaret.Execute( pDoc );
		}
		break;

	case MC_goscreenend:	//ʂ̍ŌɈړ
	case MC_goscreentop:	//ʂ̐擪Ɉړ
		AfxMessageBox( "(MC_goscreenend/top)" );
		break;

	case MC_gocaretrow:		//Cӂ̍sւ̃J[\ړ
		if ( nArg == 1 )
		{
			int	iNewRow = *( (int*)(*(void**)paArg) );
			if ( iNewRow >= 0 )
			if ( iNewRow < nRow )
			{
				CCommandCaret	cmdCaret;
				cmdCaret.SetAttribute( 0x00, iNewRow, idxColumn );
				bSuccess = cmdCaret.Execute( pDoc );
			}
		}
		break;

	case MC_gocaretcolumn:	//Cӂ̗ւ̃J[\ړ
		if ( nArg == 1 )
		{
			int	iNewColumn = *( (int*)(*(void**)paArg) );

			CString*	pstr = pDoc->GetLine( idxRow );
			if ( pstr != NULL )
			if ( iNewColumn < ::StringToColumn( *pstr ) )
			{
				CCommandCaret	cmdCaret;
				cmdCaret.SetAttribute( 0x00, idxRow, iNewColumn );
				bSuccess = cmdCaret.Execute( pDoc );
			}
		}
		break;

	case MC_wordleft:		//Pꍶ
	case MC_wordright:		//PE
		AfxMessageBox( "(MC_wordleft/right)" );
		break;

	case MC_setmark:		//ݍs̃}[N/}[N
		if ( nArg == 0 )
		{
			pDoc->Mark( idxRow );
			bSuccess = TRUE;
		}
		break;

	case MC_clearallmark:	//}[NSĉ
		if ( nArg == 0 )
		{
			pDoc->DeMark();
			bSuccess = TRUE;
		}
		break;

	case MC_nextmark:		//}[Ns̉
		if ( nArg == 0 )
		{
			pDoc->NextMark();
			bSuccess = TRUE;
		}
		break;

	case MC_prevmark:		//}[Ns̏㌟
		if ( nArg == 0 )
		{
			pDoc->PrevMark();
			bSuccess = TRUE;
		}
		break;

//Nbv{[h
	case MC_beginsel:		//͈͑IJn
	case MC_endsel:			//͈͑I[h
	case MC_escapesel:		//͈͑I
	case MC_copy:			//Rs[
	case MC_cut:			//؂蔲
	case MC_paste:			//\t

//̑ҏW
	case MC_indent:			//Is̃Cfg
	case MC_unindent:		//Is̋tCfg
	case MC_undo:			//蒼
	case MC_redo:			//蒼̂蒼
	case MC_overwriteswitch://}E㏑[hؑ

//
	case MC_find:			//Cӂ̒P̌ip^j
	case MC_finddown:		//
	case MC_findup:			//
	case MC_replace:		//Cӂ̒P̒uip^j
	case MC_replacedown:	//u
	case MC_replaceup:		//u
	case MC_replaceall:		//Su
		break;

// \
	case MC_setallupdate:	// S\v
		if ( nArg == 0 )
		{
			pDoc->SetAllUpdate();
			bSuccess = TRUE;
		}
		break;

	case MC_redraw:			// ĕ`
		if ( nArg == 0 )
		{
		    const HINSTANCE hInstance = ::AfxGetResourceHandle();
			CWinApp*		pApp = AfxGetApp();
			::AfxSetResourceHandle( pApp->m_hInstance );
			pDoc->ReDraw();
			::AfxSetResourceHandle(hInstance);
			bSuccess = TRUE;
		}
		break;

// Doc̎擾
	case MC_getlinecount:	// s̎擾
		if ( nArg == 1 )
		{
			int*	pnLine = ( (int*)(*(void**)paArg) );
			*pnLine = pDoc->GetLineCount();
			bSuccess = TRUE;
		}
		break;

	case MC_getline:		// CӍse̎擾
		if ( nArg == 3 )
		{
			// 	sԍ
			int			iLine = *( (int*)(*(void**)paArg) );
			//  i[obt@AhX
			char*		pstrLine = ((char*)*((void**)paArg+1) );
			// O i[oCg
			int*		pLength = ((int*)*((void**)paArg+2) );

			// pstrLine NULL̂Ƃ͒Ԃ
			CString*	pstrSrc = pDoc->GetLine( iLine );
			if ( pstrLine == NULL )
			{
				*pLength = pstrSrc->GetLength();
			}
			else
			{
				*pLength = min( (*pLength)-1, pstrSrc->GetLength() );
				memcpy( pstrLine, (LPCTSTR)*pstrSrc, *pLength );
				pstrLine[ *pLength ] = 0x00;
			}
			bSuccess = TRUE;
		}
		break;

	case MC_getcaretcolumn:	// Lbg̎擾
	case MC_getcaretrow:	// Lbgs̎擾
		break;

// c[o[
	case MC_entrytoolbar:		// c[o[̒ǉ
		if ( nArg == 1 )
		{
			// [0] \[XID
				int		idResource = *((int*)(*(((void**)paArg)+0)));

			// EXẼc[o[ǗɃANZXI
			bSuccess = CToolBarManager::GetInstance()->EntryToolBar(
				idResource
			);
		}
		break;

	case MC_showtoolbar:		// c[o[̕\^\
		if ( nArg == 1 )
		{
			// [0] BOOL
				BOOL		bShow = *((BOOL*)(*(((void**)paArg)+0)));

			// EXẼc[o[ǗɃANZXI
			bSuccess = CToolBarManager::GetInstance()->ShowToolBar(
				bShow
			);
		}
		break;


	case MC_spawncombobox:		// R{{bNX̍쐬
		if ( nArg == 4 )
		{
			int			idxButton = *((int*)(*(((void**)paArg)+0)));
			int			iWidth = *((int*)(*(((void**)paArg)+1)));
			BOOL		bEdit = *((BOOL*)(*(((void**)paArg)+2)));
			HWND*		phwnd = (HWND*)(*(((void**)paArg)+3));
//			CComboBox**	ppCombo = ((CComboBox**)(*(((CComboBox***)paArg)+3)));

			// EXẼc[o[ǗɃANZXI
			*phwnd = CToolBarManager::GetInstance()->SpawnComboBox(
				idxButton,
				iWidth,
				bEdit
			)->m_hWnd;
			bSuccess = ( *phwnd != NULL );
		}
		break;

	case MC_keydown:
		if ( nArg == 4 )
		{
			// [0] L[
				const char*	pstrKey = ((const char*)(*(((void**)paArg)+0)));
			// [1] Vtg
				BOOL		bShift = *((BOOL*)(*(((void**)paArg)+1)));
			// [2] Rg[
				BOOL		bCtrl = *((BOOL*)(*(((void**)paArg)+2)));
			// [3] Alt
				BOOL		bAlt = *((BOOL*)(*(((void**)paArg)+3)));

			if( strlen(pstrKey) != 0 )
			{
				pDoc->GetMainView()->OnKeyDown(
					pstrKey[0],
					bShift,
					bCtrl,
					bAlt
				);
			}
			bSuccess = TRUE;
		}
		break;

	case MC_keyinput:
		if ( nArg == 4 )
		{
			// [0] L[
				const char*	strChar = ((const char*)(*(((void**)paArg)+0)));
			// [1] Vtg
				BOOL		bShift = *((BOOL*)(*(((void**)paArg)+1)));
			// [2] Rg[
				BOOL		bCtrl = *((BOOL*)(*(((void**)paArg)+2)));
			// [3] Alt
				BOOL		bAlt = *((BOOL*)(*(((void**)paArg)+3)));

			// 
			pDoc->GetMainView()->OnChar(
				strChar,
				bShift,
				bCtrl,
				bAlt,
				FALSE
			);
			bSuccess = TRUE;
		}
		break;

	case MC_setselectmode:
		if ( nArg == 1 )
		{
			// [0] [h
				int		iMode = *((int*)(*(((void**)paArg)+0)));

			// 
			pDoc->SetOperationMode( (EOperationMode)iMode );

			CSelection*	pSelection;
			pSelection = pDoc->GetSelection();
			pSelection->SetSelectedNutral();
			bSuccess = TRUE;
		}
		break;

	case MC_getselectmode:
		if ( nArg == 1 )
		{
			// [0] [h
				int*	piMode = ((int*)(*(((void**)paArg)+0)));

			// 
			*piMode = pDoc->GetOperationMode();
			bSuccess = TRUE;
		}
		break;

	case MC_getroi:
		if ( nArg == 1 )
		{
			// [0] ROI`
				CRect*	prcROI = ((CRect*)(*(((void**)paArg)+0)));

			// 
			CROISelection*	pSelection = pDoc->GetROISelection();
			CRect rcROI = pSelection->GetROI();
			rcROI.NormalizeRect();
			*prcROI = rcROI;

			return( *prcROI != CRect(0,0,0,0) );
		}
		break;

	case MC_draw:
		if ( nArg == 4 )
		{
			// [0] ROI`
//				CDC*	pDstDC =	 ((CDC*)(*(((CDC**)paArg)+0)));
				HDC		hdc =		*((HDC*)(*(((void**)paArg)+0)));
			// [1] ROI`
//				int		iSrcLeft = *((int*)(*(((int**)paArg)+1)));
			// [2] ROI`
//				int		iSrcTop = *((int*)(*(((int**)paArg)+2)));
			// [3] ROI`
				RECT	rcSrcROI = *((RECT*)(*(((void**)paArg)+3)));

			// 
			pDoc->GetMainView()->DrawToROI(
				CDC::FromHandle( hdc ),
				0,
				0,
				rcSrcROI
			);

			return( TRUE );
		}
		break;

	case MC_setemphasisenable:
		if ( nArg == 1 )
		{
			// [0] 
				BOOL	bEnable = *((BOOL*)(*(((void**)paArg)+0)));

			// 
			CGeneralSetting::GetInstance()->GetEmphasisDefine()->SetEnable( bEnable );

			// hLg\̍č\z
			pDoc->ReflectEmphasis();

			bSuccess = TRUE;
		}
		break;

	case MC_getemphasisenable:
		if ( nArg == 0 )
		{
			BOOL	bEnable;
			bEnable = CGeneralSetting::GetInstance()->GetEmphasisDefine()->GetEnable();
			return( bEnable );
		}
		break;

	case MC_getinipath:
		if ( nArg == 2 )
		{
			// [0] IniPath
				char*	pstr = ((char*)(*(((void**)paArg)+0)));
			// [1] 
				int*	pLength = ((int*)(*(((void**)paArg)+1)));

			CString		strIniPath = CSettingPath::GetInstance()->GetFolderPath();
			if ( pstr == NULL )
			{
				*pLength = strIniPath.GetLength();
			}
			else
			{
				*pLength = min( (*pLength)-1, strIniPath.GetLength() );
				memcpy( pstr, (LPCTSTR)strIniPath, *pLength );
				pstr[ *pLength ] = 0x00;
			}
			bSuccess = TRUE;
		}
		break;

	case MC_getclientrect:
	// EBhE`擾
		if ( nArg == 1 )
		{
			CWinApp*		pApp = ::AfxGetApp();
			CMainFrame*		pWnd = (CMainFrame*)(pApp->GetMainWnd());

			RECT*	prcClient = ((CRect*)(*(((void**)paArg)+0)));
			CRect	rcClient;
			pWnd->GetClientRect( &rcClient );
			*prcClient = rcClient;
			bSuccess = TRUE;
		}
		break;

	case MC_getselectedtext:
	// IeLXg擾
		if ( nArg == 2 )
		{
			// [0] text
				char*	pstr = ((char*)(*(((void**)paArg)+0)));
			// [1] 
				int*	pLength = ((int*)(*(((void**)paArg)+1)));

			CString		str = pDoc->GetSelection()->GetSelectedText();

			if ( pstr == NULL )
			{
				*pLength = str.GetLength();
			}
			else
			{
				*pLength = min( (*pLength)-1, str.GetLength() );
				memcpy( pstr, (LPCTSTR)str, *pLength );
				pstr[ *pLength ] = 0x00;
			}
			bSuccess = TRUE;
		}
		break;

	case MC_getselectinfonormal:
	// ʏI擾
		if ( nArg == 4 )
		{
			int*	piStartRow		= ((int*)(*(((void**)paArg)+0)));
			int*	piStartColumn	= ((int*)(*(((void**)paArg)+1)));
			int*	piEndRow		= ((int*)(*(((void**)paArg)+2)));
			int*	piEndColumn		= ((int*)(*(((void**)paArg)+3)));

			*piStartRow		= pDoc->GetNormalSelection()->GetSelectedStartRow();
			*piStartColumn	= pDoc->GetNormalSelection()->GetSelectedStartColumn();
			*piEndRow		= pDoc->GetNormalSelection()->GetSelectedEndRow();
			*piEndColumn	= pDoc->GetNormalSelection()->GetSelectedEndColumn();
			bSuccess = TRUE;
		}
		break;

	case MC_getselectinfobox:
	// anwI擾
		if ( nArg == 1 )
		{
//			CDWordArray*	pdwaSelectInfoz	= ((CDWordArray*)(*(((CDWordArray**)paArg)+0)));

			// please! 
			::ErrorLog(
				"",
				"CMacroExecute::Execute()"
			);

			bSuccess = TRUE;
		}
		break;

	case MC_isselected:
	// IԔ
		if ( nArg == 1 )
		{
			BOOL*	pbSelected = ((BOOL*)(*(((void**)paArg)+0)));
			*pbSelected = pDoc->GetSelection()->IsSelected();
			bSuccess = TRUE;
		}
		break;

	case MC_scrolltocaret:
	// IԔ
		if ( nArg == 0 )
		{
			CShitarabianView*	pView = pDoc->GetMainView();
			if ( pView != NULL )
			{
				pView->ScrollToCaret();
			}
		}
		break;
// G[
	default:
		ASSERT( FALSE );
		{
			CString		str;
			str.Format( "sȃ}NR}hi%dj", eCommand );
			::ErrorLog(
				str,
				"CMacroExecute::Execute()"
			);
		}
		break;
	}

	if ( bSelectedModify )
	{
		pDoc->SetUpdateStartRow( min( idxOldSelectedStartRow, pSelection->GetSelectedStartRow() ) );
		pDoc->SetUpdateEndRow( max( idxOldSelectedEndRow, pSelection->GetSelectedEndRow() ) );
	}

	return( bSuccess );
}
