// RgL
// Line.cpp: CLine NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "shitarabian.h"
#include "EmphasisLine.h"
#include "EmphasisDefine.h"
#include "FinderVBScript.h"
#include "EditDrawer.h"
#include "Unicoder.h"
#include "GeneralSetting.h"
#include "Selection.h"
#include "ExeCommon.h"
#include "MainFrm.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


BOOL	CEmphasisLine::m_bEmphasisAnalizeEnable = TRUE;


//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CEmphasisLine::CEmphasisLine()
:	m_strLine()					// s
,	m_bMark( FALSE )			// }[NL
,	m_bModify( FALSE )			// XVL
,	m_bInitialized( FALSE )		// 擾ς݃tO
,	m_lAllWidth( 0 )
,	m_nColumn( 0 )
,	m_listCharz()				// \񃊃Xg
,	m_idxPrevRelationEmphasis( EMPHASIS_TEXT )		// a̍sA鋭\
,	m_idxNextContinueEmphasis( EMPHASIS_TEXT )		// ̍s֘A鋭\
,	m_bMultiLineEmphasisAnalized( FALSE )
{

}

CEmphasisLine::~CEmphasisLine()
{

}

void CEmphasisLine::SetString( const char* pstrSrc )
{
	m_strLine = pstrSrc;
	m_bModify = TRUE;
	ResetDetailEmphasis();
}


// \ݒ肷ׂĂ̏
void CEmphasisLine::ResetWholeEmphasis()
{
	m_bMultiLineEmphasisAnalized = FALSE;
	m_idxPrevRelationEmphasis = EMPHASIS_TEXT;
	m_idxNextContinueEmphasis = EMPHASIS_TEXT;

	ResetDetailEmphasis();
}

// \ݒڍׁis\FJzݒȊOj̏
void CEmphasisLine::ResetDetailEmphasis()
{
	m_bInitialized = FALSE;
	m_lAllWidth = 0;
	m_nColumn = 0;
	m_listCharz.RemoveAll();
}



// ߂l B
BOOL CEmphasisLine::Analize()
{
	if ( m_bInitialized )
	{
		return( FALSE );
	}

	HDC	hdc = ::GetDC( NULL );
	CDC*	pDC = CDC::FromHandle( hdc );

	// s\̉
	AnalizeStringMultiLineEmphasis(
		pDC,
		CGeneralSetting::GetInstance()->GetEmphasisDefine()
	);

	BOOL	bProcess = Analize(
		pDC,
		CGeneralSetting::GetInstance()->GetEmphasisDefine()
	);

	::ReleaseDC( NULL, hdc );

	return( bProcess );
}



// ߂l B

/*-----------------------------------------------------------------------------
[]	\F
[@\]	\F͂sĕ\łԂɂB
[ߒl]	BOOL	 [-] (TRUE:AFALSE:s)
[l]	Ȃ
-----------------------------------------------------------------------------*/
BOOL CEmphasisLine::Analize(
	CDC*				pDstDC,				// I: o͐DC [-] (-) :-
	CEmphasisDefine*	pEmphasisDefine		// I: \Fݒ [-] (-) :-
)
{
	// \F͂łȂΉ͂
	if ( !m_bInitialized )
	{
		AnalizeString(
			pDstDC,
			pEmphasisDefine
		);
	}
	return( TRUE );
}


BOOL CEmphasisLine::Copy( CEmphasisLine& Src )
{
	m_strLine	= Src.m_strLine;		// s
	m_bMark		= Src.m_bMark;		// }[NL
	m_bModify	= Src.m_bModify;		// XVL


	m_idxPrevRelationEmphasis = Src.m_idxPrevRelationEmphasis;	// \
	m_idxNextContinueEmphasis = Src.m_idxNextContinueEmphasis;	// \

	m_bInitialized	= Src.m_bInitialized;				// 擾ς݃tO

	m_listCharz.RemoveAll();
	m_listCharz.AddTail( &Src.m_listCharz );			// \񃊃Xg

	return( TRUE );
}


void	CEmphasisLine::SetEmphasisPrevRelation(
	short idxPrevRelationEmphasis
)
{
	m_idxPrevRelationEmphasis = idxPrevRelationEmphasis;
	m_idxNextContinueEmphasis = idxPrevRelationEmphasis;
	ResetDetailEmphasis();
}






// ̕ʒusNZ
long CEmphasisLine::CaretColumnToPixel(
	long			idxTargetChar
)
{
	// \񂪍\zĂȂ΂
	Analize();

	long		idxChar = 0;
	long		lSizeX = 0;
	POSITION	pos = m_listCharz.GetHeadPosition();
	while( pos != NULL )
	{
		if( idxChar >= idxTargetChar )
		{
			break;
		}
		TEmphasisChar&	tChar = m_listCharz.GetNext( pos );
		lSizeX += tChar.iWidth;
		idxChar += tChar.nColumn;
	}

	return( lSizeX );
}

long CEmphasisLine::CaretColumnToPixelZoomed(
	long			idxTargetChar
)
{
	int	lSizeX = CaretColumnToPixel( idxTargetChar );
	CEditDrawer*	pDrawer = CEditDrawer::GetInstance();
	return( pDrawer->PixelToZoomedPixel( lSizeX ) );
}

// sNZ̕ʒu
long CEmphasisLine::PixelToCaretColumnZoomed(
	long			iX,
	BOOL			bAbsolute	// ̂wO㔼𔻒ɉȂ@[-] (TRUE:ȂAFALSE:) :FALSE
)
{
	CEditDrawer*	pDrawer = CEditDrawer::GetInstance();
	long	iColumn = PixelToCaretColumn(
		pDrawer->ZoomedPixelToPixel( iX ) ,
		bAbsolute
	);
	return( iColumn );
}

long CEmphasisLine::CaretColumnToWindowPixelZoomed(
	long	idxChar
)
{
	int	lSizeX = CaretColumnToPixelZoomed( idxChar );

	long	lLeftMargin;
	lLeftMargin = CGeneralSetting::GetInstance()->GetLeftMargin();

	return( lSizeX + lLeftMargin );
}

// sNZ̕ʒu
long CEmphasisLine::PixelToCaretColumn(
	long	iX,
	BOOL	bAbsolute	// ̂wO㔼𔻒ɉȂ@[-] (TRUE:ȂAFALSE:) :FALSE
)
{
	// \񂪍\zĂȂ΂
	Analize();

	long	idxCaretColumn = 0;
	POSITION	pos = m_listCharz.GetHeadPosition();
	while( pos != NULL )
	{
		TEmphasisChar&	tChar = m_listCharz.GetNext( pos );

		// I
		if ( iX <= tChar.iWidth )
		{
			// ̑OȂ當̑OǍ㔼Ȃ當̗̌pB
			if ( !bAbsolute )
			if ( iX > ((double)tChar.iWidth/2) )
			{
				idxCaretColumn += tChar.nColumn;
			}
			break;
		}
		iX -= tChar.iWidth;
		idxCaretColumn += tChar.nColumn;
	}
	return( idxCaretColumn );
}



long CEmphasisLine::GetColumnCount()
{
	// \񂪍\zĂȂ΂
	Analize();
	return( m_nColumn );
}






// 
/*-----------------------------------------------------------------------------
[]	Jz\I[
[@\]	Jz\ݒ̏I[B
[ߒl]	int		I[Iʒu [J] (-)
[l]	Ȃ
-----------------------------------------------------------------------------*/
int	CEmphasisLine::SerchEmphasisTerminator(
//	const char*			pstrSrc,			// s [-] (-)
	CEmphasisDefine*	pEmphasisDefine,	// \Fݒ [-] (-)
	short				iContinueEmphasis	// Jz\F [CfNX] (-)
){
	// \ݒ擾
	CArray<CEmphasisItem, CEmphasisItem&>&	aEmphasisz = pEmphasisDefine->GetItemz();

	CString		strTerminator( aEmphasisz[ iContinueEmphasis ].GetTerminator() );
	if ( !strTerminator.IsEmpty() )
	{
		TMatch	Match;
		CFinder*	pFinder = ::GetFinder( aEmphasisz[ iContinueEmphasis ].GetFindCondition()->bRegExp );
		BOOL bFound = pFinder->QuickMatch(
			(LPCTSTR)m_strLine,
			strTerminator,
			&Match,
			aEmphasisz[ iContinueEmphasis ].GetFindCondition()->bCaseCare,
			aEmphasisz[ iContinueEmphasis ].GetFindCondition()->bToken
		);

		int		iRelatedColumn;
		if ( bFound )
		{
			iRelatedColumn = Match.idxStartColumn + Match.nColumn;
		}
		else
		{
			iRelatedColumn = -1;
		}
		return( iRelatedColumn );
	}

	
/*
	// \ݒ擾
	CArray<CEmphasisItem, CEmphasisItem&>&	aEmphasisz = pEmphasisDefine->GetItemz();

	CString		strTerminator( aEmphasisz[ iContinueEmphasis ].GetTerminator() );
	if ( !strTerminator.IsEmpty() )
	{
		CArray< TMatch, TMatch& > aMatchz;
		CFinderVBScript		Finder;
//		CString	strSrc( pstrSrc );
		Finder.GetMatchz(
			m_strLine,
			strTerminator,
			&aMatchz,
			TRUE,
			FALSE
		);

		int		iRelatedColumn;
		if ( aMatchz.GetSize() > 0 )
		{
			iRelatedColumn = aMatchz[0].idxStartColumn + aMatchz[0].nColumn;
		}
		else
		{
			iRelatedColumn = -1;
		}
		return( iRelatedColumn );
	}
*/
	return( 0 );
}


// 
/*-----------------------------------------------------------------------------
[]	s\̂ݕ\F́ij
[@\]	ȈՕ\F́B
		̂ߕs\F̂݉͂sBs̕\FJzݒ肷B
[ߒl]	BOOL	 [-] (TRUE:AFALSE:s)
[l]	ǉ
		AnalizeStringMultiLineEmphasis() oRČĂ΂B
-----------------------------------------------------------------------------*/
BOOL CEmphasisLine::AnalizeStringMultiLineEmphasis(
	CDC*				pDstDC,				// I: o͐DC [-] (-) :-
	CEmphasisDefine*	pEmphasisDefine		// I: \Fݒ [-] (-) :-
)
{
	if ( !m_bEmphasisAnalizeEnable )
	{
		return( TRUE );
	}

	// s\̎n[
	BOOL	bFound = FALSE;
	{

		// K\̂ɂČ
		{
			// \ݒ肩畡s\̌Ώۂ𓾂
			CString&	strPattern = pEmphasisDefine->GetMultiLineEmphasisStarterRegExp();
			if( !strPattern.IsEmpty() )
			{
				// n[
				CArray< TMatch, TMatch& > aMatchz;
				CFinder*	pFinder = ::GetFinder( TRUE );
				if( pFinder != NULL )
				{
					int		nMatch = pFinder->GetMatchz(
						m_strLine,
						strPattern,
						&aMatchz,
						TRUE, //aEmphasisz[ idxEmphasis ].GetFindCondition()->bCaseCare,	// bCaseCare
						FALSE //aEmphasisz[ idxEmphasis ].GetFindCondition()->bToken		// bToken
					);
					// Pł}b`ΔƂďI
					if ( nMatch > 0 )
					{
						// n[݂邱Ƃ͂킩
						// ̎n[͑̋\ɑłĂꍇ̂
						// ܂߂ɉ͂Kv
						//    // /*   Ƃ΂ꍇ/*͖B
						bFound = TRUE;
					}
				}
			}
		}

		// K\łȂ̂ɂČ
		if( !bFound )
		if ( pEmphasisDefine->IsMultiLineEmphasisStarterNormalExist() )
		{
			// \ݒ擾
			CArray<CEmphasisItem, CEmphasisItem&>&	aEmphasisz = pEmphasisDefine->GetItemz();

			// \ݒ肩畡s\̂̂̂݌
			int		idxEmphasis;
			for( idxEmphasis=EMPHASIS_NEEDCOLORINGITEM ; idxEmphasis<aEmphasisz.GetSize() ; idxEmphasis++ )
			if ( !aEmphasisz[ idxEmphasis ].GetFindCondition()->bRegExp )
			if( aEmphasisz[ idxEmphasis ].GetEnable() )					// `L
			if( !aEmphasisz[ idxEmphasis ].GetTerminator().IsEmpty() )	// I[ == s\
			{
				CString	strPattern( aEmphasisz[ idxEmphasis ].GetPattern() );
				if( !strPattern.IsEmpty() )
				{
					// n[
					CArray< TMatch, TMatch& > aMatchz;
					CFinder*	pFinder = ::GetFinder( FALSE );
					int		nMatch = pFinder->GetMatchz(
						m_strLine,
						strPattern,
						&aMatchz,
						aEmphasisz[ idxEmphasis ].GetFindCondition()->bCaseCare,	// bCaseCare
						aEmphasisz[ idxEmphasis ].GetFindCondition()->bToken		// bToken
					);
					// Pł}b`ΔƂďI
					if ( nMatch > 0 )
					{
						// n[݂邱Ƃ͂킩
						// ̎n[͑̋\ɑłĂꍇ̂
						// ܂߂ɉ͂Kv
						//    // /*   Ƃ΂ꍇ/*͖B
						bFound = TRUE;
					}
				}
			}
		}
	}

	// sɕs\̎n[݂Ȃ܂߂ɉ͂
	if( bFound )
	{
		HDC	hdc = ::GetDC( NULL );
		CDC*	pDC = CDC::FromHandle( hdc );

		Analize(
			pDC,
			CGeneralSetting::GetInstance()->GetEmphasisDefine()
		);

		::ReleaseDC( NULL, hdc );
	}
	else
	{
		// s\̎n[݂Ȃ̂
		// JnFƓFŏI邩
		SetEmphasisNextContinue( GetEmphasisPrevRelation() );
	}

	return( TRUE );
}















// ==========================================================
// 03.02.24







/*-----------------------------------------------------------------------------
[]	`
[@\]	̋\`揈B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CEmphasisLine::Draw(
	CDC*				pDstDC,
	long				lStartX,			// I  :DC̊Jnʒu [-] (-) :-
	long				lStartY,			// I  :DC̊Jnʒu [-] (-) :-
	int					iLeftX,				// I  :DC̕`KvJnW [-] (-) :-
	int					iWidthX,			// I  :DC̕`Kv [-] (-) :-
	BOOL				bCareEmphasis,		// I  :\L [-] (TRUE:LAFALSE:) :-
	CEmphasisDefine*	pEmphasisDefine,	// I  :\` [-] (-) :-
	BOOL				bCareSelection,		// I  :I\L [-] (TRUE:LAFALSE:) :-
	CShitarabianDoc*	pDoc,				// I  :޷ [-] (-) :-
	int					iRow				// I  :s [-] (-) :-
)
{
	// R[fBOG[`FbN
	{
		// XV̈斢ݒŌĂ΂Ă܂ꍇoĂ݂
		// XV̈ SetUpdateRect() Őݒ肷KvB
		ASSERT( iWidthX != 0 );
	}

	// warning C4100:x̖
	bCareEmphasis;

	// \F͂łȂΉ͂
	Analize(
		pDstDC,
		pEmphasisDefine
	);

	COLORREF	colBackNatural = ::GetBackColor( EMPHASIS_TEXT );
	COLORREF	colForeSelect = ::GetForeColor( EMPHASIS_SELECTED );
	COLORREF	colBackSelect = ::GetBackColor( EMPHASIS_SELECTED );

	long		lX;
	int			idxColumn;
	BOOL		bContinue;
	POSITION	pos;

	CEditDrawer*	pDrawer = CEditDrawer::GetInstance();
	TEmphasisChar	tEOFChar = { TypeEOF, 0x00, 0x00, EMPHASIS_EOF, (USHORT)pDrawer->GetEOFWidth(), 0,0,FALSE };
	TEmphasisChar	tEOLChar = { TypeEOL, 0x00, 0x00, EMPHASIS_CRLF, (USHORT)pDrawer->GetBlankWidth(), 0,0,FALSE };

	// wihԂ
	lX = lStartX;
	idxColumn = 0;
	pos = m_listCharz.GetHeadPosition();
	bContinue = TRUE;
	while( bContinue )
	{
		bContinue = ( pos != NULL );

		TEmphasisChar*	pChar;
		if ( pos != NULL )
		{
			pChar = &(m_listCharz.GetNext( pos ));
		}
		else
		{
			if ( iRow == pDoc->GetLineCount()-1 )
			{
				if ( !CGeneralSetting::GetInstance()->GetEmphasisDefine()->GetItemz()[EMPHASIS_EOF].GetEnable() )
				{
					break;
				}
				pChar = &tEOFChar;
			}
			else
			{
				if ( !CGeneralSetting::GetInstance()->GetEmphasisDefine()->GetItemz()[EMPHASIS_CRLF].GetEnable() )
				{
					break;
				}
				pChar = &tEOLChar;
			}
		}
		TEmphasisChar&	tChar = *pChar;

		// `v͈͂łΕ`悷
		if ( lX+tChar.iWidth >= 0 )
		{
			BOOL	bSelection = FALSE;
			if ( bCareSelection )
			if ( pDoc != NULL )
			{
				bSelection = pDoc->GetSelection()->IsSelected( iRow, idxColumn );
			}

			if ( bSelection )
			{
				pDstDC->FillSolidRect(
					lX,
					lStartY,
					tChar.iWidth,
					pDrawer->GetBlankHeight(),
					colBackSelect
				);
			}
			else
			{
				// W̔wiF͕ǎ\̂߃kLFƂB
				// W̔wiFłȂƂhԂB
				COLORREF	colBack = pEmphasisDefine->GetItemz()[ tChar.idxEmphasis ].GetBackColor();
				if ( colBackNatural != colBack )
				{
					pDstDC->FillSolidRect(
						lX,
						lStartY,
						tChar.iWidth,
						pDrawer->GetBlankHeight(),
						colBack
					);
				}
			}
		}
		lX += tChar.iWidth;
		idxColumn += tChar.nColumn;

		// `v͈͂`悵I甲
		if ( lX > iWidthX )
		{
			break;
		}
	}

	// `
	long	idxByte = 0;
	lX = lStartX;
	idxColumn = 0;
	pos = m_listCharz.GetHeadPosition();

	pDstDC->SetBkMode( TRANSPARENT );
	pDrawer->ReflectFont( pDstDC );
	BOOL	bUnderLineEmphasis = FALSE;

	bContinue = TRUE;
	while( bContinue )
	{
		bContinue = ( pos != NULL );

		TEmphasisChar*	pChar;
		if ( pos != NULL )
		{
			pChar = &(m_listCharz.GetNext( pos ));
		}
		else
		{
			if ( iRow == pDoc->GetLineCount()-1 )
			{
				if ( !CGeneralSetting::GetInstance()->GetEmphasisDefine()->GetItemz()[EMPHASIS_EOF].GetEnable() )
				{
					break;
				}
				pChar = &tEOFChar;
			}
			else
			{
				if ( !CGeneralSetting::GetInstance()->GetEmphasisDefine()->GetItemz()[EMPHASIS_CRLF].GetEnable() )
				{
					break;
				}
				pChar = &tEOLChar;
			}
		}
		TEmphasisChar&	tChar = *pChar;

		// tHgݒ肪قȂ̂ł΃tHgݒ肵Ȃ
		BOOL bUnderLine = pEmphasisDefine->GetItemz()[tChar.idxEmphasis].GetUnderLine();
		if ( bUnderLine != bUnderLineEmphasis )
		{
			// tHgݒ
			pDrawer->RestoreFont( pDstDC );

			// UnderLineݒ肵ătHgݒ
			CGeneralSetting::GetInstance()->GetLogFont()->m_bUnderLine = bUnderLine;
			pDrawer->ReflectFont( pDstDC );

			// UnderLineԂL^
			bUnderLineEmphasis = bUnderLine;
		}

		// `v͈͂łΕ`悷
		if ( lX+tChar.iWidth >= 0 )
		{
			// IԁH
			BOOL	bSelection = FALSE;
			if ( bCareSelection )
			if ( pDoc != NULL )
			{
				bSelection = pDoc->GetSelection()->IsSelected( iRow, idxColumn );
			}
			// FI
			if ( bSelection )
			{
				pDstDC->SetTextColor( colForeSelect );
			}
			else
			{
				COLORREF	colFore = pEmphasisDefine->GetItemz()[ tChar.idxEmphasis ].GetForeColor();
				pDstDC->SetTextColor( colFore );
			}

			pDrawer->SetDstX( lX );
			pDrawer->SetDstY( lStartY );

			switch( tChar.eType )
			{
			case TypeShiftJis:
				{
					int		iPrintedChar;
					pDrawer->DrawSJisCharactor(
						((LPCTSTR)m_strLine) + idxByte,
						pDstDC,
						&iPrintedChar,
						tChar.iWidth,
						tChar.bBox
					);
				}
				break;
			case TypeUnicode:
				{
					if ( tChar.bBox )
					{
						int		iPrintedChar;
						pDrawer->DrawSJisCharactor(
							((LPCTSTR)m_strLine) + idxByte,
							pDstDC,
							&iPrintedChar,
							tChar.iWidth,
							TRUE
						);
					}
					else
					{
						CUnicoder*	pUnicoder = CUnicoder::GetInstance();
						CRect	rcDst( pDrawer->GetDstX(), pDrawer->GetDstY(), pDrawer->GetDstX(), pDrawer->GetDstY() );
						pUnicoder->DrawCharCode(
							pDstDC,
							rcDst,
							(wchar_t)(tChar.aiCode[1]*256 + tChar.aiCode[0])
						);
					}
				}
				break;
			case TypeEOL:
				pDrawer->DrawEOL( pDstDC, FALSE, bSelection );
				break;
			case TypeEOF:
				pDrawer->DrawEOL( pDstDC, TRUE, bSelection );
				break;
			default:
				break;
			}
		}

		idxByte += tChar.nByte;
		lX += tChar.iWidth;
		idxColumn += tChar.nColumn;

		// `v͈͂`悵I甲
		if ( lX > iWidthX )
		{
			break;
		}
	}

	// UnderLineݒAFONTݒ
	CGeneralSetting::GetInstance()->GetLogFont()->m_bUnderLine = FALSE;
	pDrawer->RestoreFont( pDstDC );
}





/*-----------------------------------------------------------------------------
[]	\F́ij
[@\]	\F͂sĕ\łԂɂB
[ߒl]	int		 [Pixel] (-)
[l]	Ȃ
-----------------------------------------------------------------------------*/
long CEmphasisLine::AnalizeString(
	CDC*				pDstDC,				// I: o͐DC [-] (-) :-
	CEmphasisDefine*	pEmphasisDefine		// I: \Fݒ [-] (-) :-
)
{
	const char*			pstrSrc = m_strLine;

	m_bInitialized = FALSE;
	m_lAllWidth = 0;
	m_nColumn = 0;
	m_listCharz.RemoveAll();

	// \ݒ擾
	CArray<CEmphasisItem, CEmphasisItem&>&	aEmphasisz = pEmphasisDefine->GetItemz();

	int	idxByte = 0;
	int	idxColumn = 0;
	int	X = 0;

	int		iRelatedColumn = 0;		// O̍sAĂ鋭\̃J

	// Os̕\Fݒ𔽉f
	{
		// ̍sւ̋\ݒp
		SetEmphasisNextContinue( EMPHASIS_TEXT );

		// s̊JnFI[̕\FłΏI[T
		CString		strTerminator( aEmphasisz[ m_idxPrevRelationEmphasis ].GetTerminator() );
		if ( !strTerminator.IsEmpty() )
		{
			// I[̌
			int	idxTerminator = SerchEmphasisTerminator(
				pEmphasisDefine,			// \Fݒ [-] (-)
				m_idxPrevRelationEmphasis	// Jz\F [CfNX] (-)
			);
			if ( idxTerminator >= 0 )
			{
				// I[܂ł͊JnFŖ܂
				iRelatedColumn = idxTerminator;
			}
			else
			{
				// sŜJnFŖ܂
				iRelatedColumn = INT_MAX;

				// ̍s֘A
				SetEmphasisNextContinue( GetEmphasisPrevRelation() );
			}
		}
	}

	// \HIT쐬
	CList< TEmphasisHit, TEmphasisHit& >	listHitz;
	AnalizeString(
		pEmphasisDefine,
		&listHitz,
		iRelatedColumn
	);

	// DCNULLnꂽꍇA\F͂sA
	// ͕ŝ܂܏IƂB
	// ܂łŕs\̎̍sւ̌Jz͐ݒ肳ĂB
	// please! DC̓XN[ŒƂĂႤ̂
	if( pDstDC == NULL )
	{
		return( 0 );
	}

	CEditDrawer*	pDrawer = CEditDrawer::GetInstance();
	pDrawer->ReflectFont( pDstDC );
	while( *(pstrSrc+idxByte) != 0x00 )
	{
		int		iPrintedByte = 0;
		int		iPrintedColumn = 0;
		CSize	sizeExtent;
		sizeExtent = pDrawer->ExtentCharactor(
			pstrSrc + idxByte,
			pDstDC,
			&iPrintedByte,
			&iPrintedColumn,
			X
		);
		// ۑ
		{
			// ̍쐬
			TEmphasisChar EmphasisChar;
			EmphasisChar.iWidth = (WORD)sizeExtent.cx;	// \
			EmphasisChar.nByte = (char)iPrintedByte;			// oCg
			EmphasisChar.nColumn = (char)iPrintedColumn;		// J
			if ( iPrintedColumn == 1 )
			{
				// VOJJISR[h
				EmphasisChar.eType = TypeShiftJis;
				EmphasisChar.aiCode[0] = pstrSrc[idxByte +0];
				EmphasisChar.aiCode[1] = pstrSrc[idxByte +1];
			}
			else
			{
				// }`JijR[hj
				CUnicoder*	pUnicoder = CUnicoder::GetInstance();
				wchar_t		wcharUnicode;
				pUnicoder->IsUnicode(
					pstrSrc +idxByte,
					&wcharUnicode
				);
				EmphasisChar.eType = TypeUnicode;
				EmphasisChar.aiCode[0] = (char)(((WORD)wcharUnicode)%0x100);
				EmphasisChar.aiCode[1] = (char)(((WORD)wcharUnicode)/0x100);
			}

			// {Fݒ
			EmphasisChar.idxEmphasis = EMPHASIS_TEXT;			// \
			if ( idxColumn < iRelatedColumn )
			{
				// O̍spĂ鋭\
				EmphasisChar.idxEmphasis = GetEmphasisPrevRelation();
			}

			// \
			{
				// listHitz ɊYJ邩
				// ΋\
				POSITION pos = listHitz.GetHeadPosition();
				while( pos != NULL )
				{
					TEmphasisHit& Hit = listHitz.GetNext( pos );
					if( Hit.iStartColumn <= idxColumn )
					{
						if( Hit.nColumn == INT_MAX ) // nColumnINT_MAXł邱Ƃ
						{
							EmphasisChar.idxEmphasis = Hit.idxEmphasisType;
							break;
						}

						if( Hit.iStartColumn+Hit.nColumn >= idxColumn+iPrintedColumn )
						{
							EmphasisChar.idxEmphasis = Hit.idxEmphasisType;
							break;
						}
					}
				}
			}

			EmphasisChar.bBox = FALSE;
			{
				EmphasisChar.bBox = CGeneralSetting::GetInstance()->GetBoxCharDefine()->IsBox(
					( pstrSrc+idxByte )
				);
			}

			m_listCharz.AddTail( EmphasisChar );
		}

		idxByte += iPrintedByte;
		idxColumn += iPrintedColumn;
		X += sizeExtent.cx;
	}

	pDrawer->RestoreFont( pDstDC );

	m_strLine = pstrSrc;
	m_lAllWidth = X;
	m_nColumn = idxColumn;

	m_bInitialized = TRUE;

	return( X );
}



/*-----------------------------------------------------------------------------
[]	\HIT쐬
[@\]	JPʂ̋\HIT\zB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
long CEmphasisLine::AnalizeString(
	CEmphasisDefine*						pEmphasisDefine,	// I  :\` [-] (-) :-
	CList< TEmphasisHit, TEmphasisHit& >*	plstEmphasisHitz,	//   O:\HIT [-] (-) :-
	long									iRelatedColumn		// I  :s\JzeJ [-] (-) :-
																//     i܂łO̍s̕\FЂĂj :-
)
{
	plstEmphasisHitz->RemoveAll();

	// \ݒ擾
	CArray<CEmphasisItem, CEmphasisItem&>&	aEmphasisz = pEmphasisDefine->GetItemz();

	// \HIT쐬
	{
		// \HIT邷ׂĂ̏W
		CList< TEmphasisHit, TEmphasisHit& >	listHitAllz;

		// Sp^[̌
		{
			CArray<CEmphasisItem, CEmphasisItem&>&	EmphasisItem = pEmphasisDefine->GetItemz();

			int		idxEmphasis;
			for( idxEmphasis=EMPHASIS_NEEDCOLORINGITEM ; idxEmphasis<EmphasisItem.GetSize() ; idxEmphasis++ )
			if( EmphasisItem[ idxEmphasis ].GetEnable() )
			{
				CString	strPattern( EmphasisItem[ idxEmphasis ].GetPattern() );
				if( !strPattern.IsEmpty() )
				{
					CArray< TMatch, TMatch& > aMatchz;

					CFinder*	pFinder = ::GetFinder( EmphasisItem[ idxEmphasis ].GetFindCondition()->bRegExp );
					pFinder->GetMatchz(
						m_strLine,
						strPattern,
						&aMatchz,
						EmphasisItem[ idxEmphasis ].GetFindCondition()->bCaseCare,	// bCaseCare
						EmphasisItem[ idxEmphasis ].GetFindCondition()->bToken		// bToken
					);

					int		idxMatch;
					for( idxMatch=0 ; idxMatch<aMatchz.GetSize() ; idxMatch++ )
					{
						// ʂ̋\͕s\F̌JzA
						// EMPHASIS_FOUND ͌Jzɂ炸ׂĎW
						BOOL	bHit =  ( iRelatedColumn <= aMatchz[idxMatch].idxStartColumn );
						bHit |= ( idxEmphasis == EMPHASIS_FOUND );
						if ( bHit )
						{
							TEmphasisHit	tHit;
							tHit.iStartColumn = aMatchz[idxMatch].idxStartColumn;
							tHit.nColumn = aMatchz[idxMatch].nColumn;
							tHit.idxEmphasisType = (USHORT)idxEmphasis;
							tHit.bTerminated = TRUE;

							listHitAllz.AddTail( tHit );
						}
					}
				}
			}
		}

		// HIT̂\[g
		// dJ͗Dx̒ႢɎ̂Ă
		// ̋\̌㔼Ɋ܂܂͎̂̂Ă
		long		iExecedColumn = -1;
		while( TRUE )
		{
			long				iMinColumn = INT_MAX;
			TEmphasisHit*	pHit = NULL;
			POSITION		pos = listHitAllz.GetHeadPosition();
			while( pos != NULL )
			{
				TEmphasisHit& Item = listHitAllz.GetNext( pos );

				// Found ͓ʏi\͌Aɍڂ邩񂶁j
				if ( Item.idxEmphasisType != EMPHASIS_FOUND )
				{
					// ς݃J𖳎
					if ( Item.iStartColumn <= iExecedColumn )
					{
						continue;
					}

					// JH
					if ( Item.iStartColumn < iMinColumn )
					{
						pHit = &Item;
						iMinColumn = pHit->iStartColumn;
					}
					// JŗDxH
					if ( Item.iStartColumn == iMinColumn )
					{
						if ( pHit != NULL )
						if ( Item.idxEmphasisType >= pHit->idxEmphasisType )
						{
							continue;
						}
						pHit = &Item;
					}
				}
			}

			if ( pHit != NULL )
			{
				// I[w肪ΒT
				CString strTerminator( aEmphasisz[ pHit->idxEmphasisType ].GetTerminator() );
				if( !strTerminator.IsEmpty() )
				{
					int	idxSerchByte = ::CaretColumnToByteColumn(
							(LPCTSTR)m_strLine,
							pHit->iStartColumn+pHit->nColumn
					);

					TMatch	Match;
					CFinder*	pFinder = ::GetFinder( aEmphasisz[ pHit->idxEmphasisType ].GetFindCondition()->bRegExp );
					BOOL bFound = pFinder->QuickMatch(
						(LPCTSTR)m_strLine + idxSerchByte,
						strTerminator,
						&Match,
						aEmphasisz[ pHit->idxEmphasisType ].GetFindCondition()->bCaseCare,
						aEmphasisz[ pHit->idxEmphasisType ].GetFindCondition()->bToken
					);

					int		iRelatedColumn;
					if ( bFound )
					{
						iRelatedColumn = pHit->iStartColumn+pHit->nColumn + Match.idxStartColumn + Match.nColumn;

						// I[
						// pHit̓eς
						pHit->nColumn +=
							Match.idxStartColumn + Match.nColumn;
						pHit->bTerminated = TRUE;
					}
					else
					{
						iRelatedColumn = -1;

						// Ȃꍇ͍s܂HITƂ݂Ȃ
						pHit->bTerminated = FALSE;
						pHit->nColumn = INT_MAX;

						// ̍s֘A
						SetEmphasisNextContinue( pHit->idxEmphasisType );

					}
/*
					CArray< TMatch, TMatch& > aMatchz;
					CFinderVBScript		Finder;
					Finder.GetMatchz(
						m_strLine,
						strTerminator,
						&aMatchz,
						TRUE,
						FALSE
					);

					int		idxMatch;
					for( idxMatch=0 ; idxMatch<aMatchz.GetSize() ; idxMatch++ )
					{
						if ( pHit->iStartColumn+pHit->nColumn <= aMatchz[idxMatch].idxStartColumn )
						{
							// I[
							// pHit̓eς
							pHit->nColumn =
								aMatchz[idxMatch].idxStartColumn - pHit->iStartColumn +
								aMatchz[idxMatch].nColumn
							;
							pHit->bTerminated = TRUE;
							break;
						}
					}
					if( idxMatch == aMatchz.GetSize() )
					{
						// Ȃꍇ͍s܂HITƂ݂Ȃ
						pHit->bTerminated = FALSE;
						pHit->nColumn = INT_MAX;

						// ̍s֘A
						SetEmphasisNextContinue( pHit->idxEmphasisType );
					}
*/
				}
				plstEmphasisHitz->AddTail( *pHit );
				if ( pHit->nColumn == INT_MAX )
				{
					iExecedColumn = INT_MAX;
				}
				else
				{
					iExecedColumn = pHit->iStartColumn + pHit->nColumn -1;
				}
			}
			else
			{
				break;
			}
		}

		// Found ͓ʏi\͌Aɍڂ邩񂶁j
		POSITION		pos = listHitAllz.GetHeadPosition();
		while( pos != NULL )
		{
			TEmphasisHit& FoundItem = listHitAllz.GetNext( pos );
			if ( FoundItem.idxEmphasisType == EMPHASIS_FOUND )
			{
				// YJTA
				POSITION		posHitz = plstEmphasisHitz->GetHeadPosition();
//				if( posHitz == NULL )
//				{
//					// o^
//					plstEmphasisHitz->AddTail( FoundItem );
//					continue;
//				}

				BOOL	bInserted = FALSE;
				while( posHitz != NULL )
				{
					POSITION	posPrev = posHitz;
					TEmphasisHit& HitzItem = plstEmphasisHitz->GetNext( posHitz );
					if ( HitzItem.idxEmphasisType != EMPHASIS_FOUND )
					{
						// 񂪖\Fɂꍇ
						if ( HitzItem.nColumn == INT_MAX )
						{
							if ( HitzItem.iStartColumn <= FoundItem.iStartColumn )
							{
								// o^
								plstEmphasisHitz->InsertAfter( posHitz, FoundItem );
								bInserted = TRUE;

								// \F㔼o^
								TEmphasisHit tmp = HitzItem;
								tmp.nColumn = INT_MAX;
								tmp.iStartColumn = FoundItem.iStartColumn + FoundItem.nColumn;
								plstEmphasisHitz->InsertAfter( posHitz, tmp );

								// \FO̒؂l߂
								//HitzItem.nColumn = FoundItem.iStartColumn;
								HitzItem.nColumn = FoundItem.iStartColumn;
							}
							break;
						}

						// \FŜƂԂĂꍇ
						if ( HitzItem.iStartColumn >= FoundItem.iStartColumn )
						if ( HitzItem.iStartColumn + HitzItem.nColumn <= FoundItem.iStartColumn + FoundItem.nColumn )
						{
							// \F폜
							plstEmphasisHitz->RemoveAt( posPrev );
							continue;
						}

						// 񂪕\Fɂꍇ
						if ( HitzItem.iStartColumn <= FoundItem.iStartColumn )
						if ( HitzItem.iStartColumn + HitzItem.nColumn >= FoundItem.iStartColumn + FoundItem.nColumn )
						{
							// \F㔼o^
							TEmphasisHit tmp = HitzItem;
							tmp.nColumn = (tmp.iStartColumn+tmp.nColumn)-(FoundItem.iStartColumn+FoundItem.nColumn);
							tmp.iStartColumn = FoundItem.iStartColumn + FoundItem.nColumn;
							if ( tmp.nColumn > 0 )
							{
								plstEmphasisHitz->InsertBefore( posHitz, tmp );
							}

							// o^
							plstEmphasisHitz->InsertBefore( posHitz, FoundItem );
							bInserted = TRUE;

							// \FO̒؂l߂
							HitzItem.nColumn = FoundItem.iStartColumn - HitzItem.iStartColumn;
							break;
						}

						// \F㔼ƂԂĂꍇ
						if ( HitzItem.iStartColumn <= FoundItem.iStartColumn )
						if ( HitzItem.iStartColumn + HitzItem.nColumn > FoundItem.iStartColumn )
						{
							// \F̒؂l߂
							HitzItem.nColumn = FoundItem.iStartColumn - HitzItem.iStartColumn;
							continue;
						}

						// \FOƂԂĂꍇ
						if ( HitzItem.iStartColumn >= FoundItem.iStartColumn )
						if ( HitzItem.iStartColumn + HitzItem.nColumn <= FoundItem.iStartColumn + FoundItem.nColumn )
						{
							// \FJnʒu炷
							HitzItem.nColumn = (HitzItem.iStartColumn+HitzItem.nColumn)-(FoundItem.iStartColumn+FoundItem.nColumn);
							HitzItem.iStartColumn = FoundItem.iStartColumn + FoundItem.nColumn;
							break;
						}

						// \F̏ꍇ
						if ( HitzItem.iStartColumn < FoundItem.iStartColumn + FoundItem.nColumn )
						{
							// \̑}
							plstEmphasisHitz->InsertBefore( posHitz, FoundItem );
							bInserted = TRUE;
							break;
						}
					}
				}

				if ( !bInserted )
				{
					// o^
					plstEmphasisHitz->AddTail( FoundItem );
				}
			}
		}
	}

//	// YJTA
//	POSITION		pos = plstEmphasisHitz->GetHeadPosition();
//	while( pos != NULL )
//	{
//		TEmphasisHit	Item;
//		Item = plstEmphasisHitz->GetNext( pos );
//		TRACE( "%d(%d) = %d\n", Item.iStartColumn, Item.nColumn, Item.idxEmphasisType );
//	}
//	TRACE( "\n" );

	return( plstEmphasisHitz->GetCount() );
}




// `敝擾
long	CEmphasisLine::GetWidth()
{
	Analize();
	return( m_lAllWidth );
};
