/*-----------------------------------------------------------------------------
[]	CharPaletteSettingDlg.cpp
[Tv]	pbgݒ_CAONX̎
[l]	Ȃ
[]	2003-04-22	NC		Rgt(moralog)
-----------------------------------------------------------------------------*/


//-----------------------------------------------------------------------------
// CN[h
//-----------------------------------------------------------------------------
#include "stdafx.h"
#include "shitarabian.h"
#include "CharPaletteSettingDlg.h"
#include "CharPalette.h"
#include <afxtempl.h>
#include "GeneralSetting.h"
#include "ExeCommon.h"
#include "MainFrm.h"
#include "CharPaletteTabEditDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/*-----------------------------------------------------------------------------
[]	RXgN^
[@\]	CX^X̐B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
CCharPaletteSettingDlg::CCharPaletteSettingDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCharPaletteSettingDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCharPaletteSettingDlg)
	m_iScrollBarAlign = -1;
	m_uiHeight = 0;
	m_uiWidth = 0;
	m_bTopMost = FALSE;
	m_iTabAlign = -1;
	m_uiHistoryCount = 0;
	m_bHistorySort = FALSE;
	//}}AFX_DATA_INIT
}


/*-----------------------------------------------------------------------------
[]	f[^ϊ
[@\]	CDialog::DoDataExchange() ̃wvQƁB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CCharPaletteSettingDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCharPaletteSettingDlg)
	DDX_Control(pDX, IDC_CHARPALETTE_SETTING_UP, m_btnUp);
	DDX_Control(pDX, IDC_CHARPALETTE_SETTING_EDIT, m_btnEdit);
	DDX_Control(pDX, IDC_CHARPALETTE_SETTING_DOWN, m_btnDown);
	DDX_Control(pDX, IDC_CHARPALETTE_SETTING_DELETE, m_btnDelete);
	DDX_Control(pDX, IDC_CHARPALETTE_SETTING_ADD, m_btnAdd);
	DDX_Control(pDX, IDC_CHARPALETTE_SETTING_TABLIST, m_listTab);
	DDX_Radio(pDX, IDC_CHARPALETTESETTING_SCROLLBARALIGNTOP, m_iScrollBarAlign);
	DDX_Text(pDX, IDC_CHARPALETTE_SETTING_BUTTONHEIGHT, m_uiHeight);
	DDX_Text(pDX, IDC_CHARPALETTE_SETTING_BUTTONWIDTH, m_uiWidth);
	DDX_Check(pDX, IDC_CHARPALETTE_SETTING_TOPMOST, m_bTopMost);
	DDX_Radio(pDX, IDC_CHARPALETTESETTING_TABALIGNTOP, m_iTabAlign);
	DDX_Text(pDX, IDC_CHARPALETTE_SETTING_HISTORYCOUNT, m_uiHistoryCount);
	DDX_Check(pDX, IDC_CHARPALETTE_SETTING_HISTORYSORT, m_bHistorySort);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CCharPaletteSettingDlg, CDialog)
	//{{AFX_MSG_MAP(CCharPaletteSettingDlg)
	ON_BN_CLICKED(IDC_CHARPALETTE_SETTING_ADD, OnCharpaletteSettingAdd)
	ON_BN_CLICKED(IDC_CHARPALETTE_SETTING_EDIT, OnCharpaletteSettingEdit)
	ON_BN_CLICKED(IDC_CHARPALETTE_SETTING_DELETE, OnCharpaletteSettingDelete)
	ON_LBN_SELCHANGE(IDC_CHARPALETTE_SETTING_TABLIST, OnSelchangeCharpaletteSettingTablist)
	ON_BN_CLICKED(IDC_CHARPALETTE_SETTING_UP, OnCharpaletteSettingUp)
	ON_BN_CLICKED(IDC_CHARPALETTE_SETTING_DOWN, OnCharpaletteSettingDown)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/*-----------------------------------------------------------------------------
[]	nh
[@\]	B
[ߒl]	CDialog::OnInitDialog()̃wvQƁB
[l]	Ȃ
-----------------------------------------------------------------------------*/
BOOL CCharPaletteSettingDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	// Rg[ɏlݒ
	CCharPaletteManager*	pManager = CGeneralSetting::GetInstance()->GetCharPaletteManager();
	m_bTopMost = pManager->m_bCharPaletteFore;
	m_iScrollBarAlign = (int)pManager->m_eScrollBarAlign;
	m_iTabAlign = (int)pManager->m_eTabAlign;
	m_uiHeight = pManager->m_sizeButton.cy;
	m_uiWidth = pManager->m_sizeButton.cx;
	m_CharPaletteDefine.Copy( *CGeneralSetting::GetInstance()->GetCharPaletteManager()->GetDefine() );
	m_bHistorySort = pManager->m_bHistorySort;
	m_uiHistoryCount = pManager->m_uiHistoryCount;

	// Xgփ^u
	CArray<CCharPalette, CCharPalette&>* paPalettez = m_CharPaletteDefine.GetItemz();
	for ( int idxTab=0 ; idxTab<paPalettez->GetSize() ; idxTab++ )
	{
		m_listTab.AddString( paPalettez->GetAt( idxTab ).GetName() );
	}

	UpdateData( FALSE );
	VisibleControl();
	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}


/*-----------------------------------------------------------------------------
[]	OK{^nh
[@\]	m菈B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CCharPaletteSettingDlg::OnOK() 
{
	UpdateData( TRUE );

	CCharPaletteManager*	pManager = CGeneralSetting::GetInstance()->GetCharPaletteManager();

	// Rg[̓eO֔f
	pManager->GetDefine()->Copy( m_CharPaletteDefine );
	pManager->m_bCharPaletteFore = m_bTopMost;
	pManager->m_sizeButton = CSize( m_uiWidth, m_uiHeight );
	pManager->m_eScrollBarAlign = (EScrollBarAlign)m_iScrollBarAlign;
	pManager->m_eTabAlign = (EScrollBarAlign)m_iTabAlign;
	pManager->m_bHistorySort = m_bHistorySort;
	pManager->m_uiHistoryCount = m_uiHistoryCount;

	pManager->RebuildCharPaletteDlg();

	CDialog::OnOK();
}


/*-----------------------------------------------------------------------------
[]	Add{^nh
[@\]	^u̒ǉB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CCharPaletteSettingDlg::OnCharpaletteSettingAdd() 
{
	long	idxTab = m_listTab.GetCurSel();

	CString		strNewName( _T("(VK)") );

	CCharPalette	Palette;
	Palette.SetName( strNewName );
	if ( idxTab < 0 )
	{
		m_listTab.InsertString( 0, strNewName );
		m_CharPaletteDefine.InsertTab( 0, Palette );
	}
	else
	{
		m_listTab.InsertString( idxTab, strNewName );
		m_CharPaletteDefine.InsertTab( idxTab, Palette );
	}
	VisibleControl();
}


/*-----------------------------------------------------------------------------
[]	Edit{^nh
[@\]	^u̕ҏWB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CCharPaletteSettingDlg::OnCharpaletteSettingEdit() 
{
	long	idxTab = m_listTab.GetCurSel();
	if ( idxTab < 0 )
	{
		return;
	}

	CCharPaletteTabEditDlg	dlg;

	CCharPalette& Palette = (*m_CharPaletteDefine.GetItemz())[ idxTab ];
	dlg.m_strName = Palette.GetName();
	if( dlg.DoModal() == IDOK )
	{
		Palette.SetName( dlg.m_strName );
		m_listTab.DeleteString ( idxTab );
		m_listTab.InsertString( idxTab, dlg.m_strName );
	}
}


/*-----------------------------------------------------------------------------
[]	Delete{^nh
[@\]	^u̍폜B
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CCharPaletteSettingDlg::OnCharpaletteSettingDelete() 
{
	long	idxTab = m_listTab.GetCurSel();
	if ( idxTab < 0 )
	{
		return;
	}
	m_CharPaletteDefine.GetItemz()->RemoveAt( idxTab );
	m_listTab.DeleteString ( idxTab );

	VisibleControl();
}


/*-----------------------------------------------------------------------------
[]	^uXgIύXnh
[@\]	^uIύXɔ{^EnableB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CCharPaletteSettingDlg::OnSelchangeCharpaletteSettingTablist() 
{
	VisibleControl();
}


/*-----------------------------------------------------------------------------
[]	{^Enable
[@\]	{^EnableԐB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CCharPaletteSettingDlg::VisibleControl() 
{
	// ړҏW폜͑IԂ̂Ƃ̂ݗpł
	long	idxTab = m_listTab.GetCurSel();
	BOOL	bSelected = ( idxTab >= 0 );

	// ^û͕ҏWłȂ
	BOOL	bEditable = FALSE;
	if ( bSelected )
	{
		CCharPalette& Palette = (*m_CharPaletteDefine.GetItemz())[ idxTab ];
		bEditable = ( Palette.GetName() != CGeneralSetting::GetInstance()->GetCharPaletteManager()->HistoryTabName() );
	}

	m_btnEdit.EnableWindow( bEditable );
	m_btnDelete.EnableWindow( bSelected );
	m_btnAdd.EnableWindow( TRUE );

	m_btnUp.EnableWindow( idxTab > 0 );
	m_btnDown.EnableWindow( bSelected && idxTab < m_listTab.GetCount()-1 );
}


/*-----------------------------------------------------------------------------
[]	Up{^nh
[@\]	^üʒuړijB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CCharPaletteSettingDlg::OnCharpaletteSettingUp() 
{
	long	idxTab = m_listTab.GetCurSel();
	if ( idxTab <= 0 )
	{
		return;
	}

	// ЂƂO֒ǉ
	CCharPalette Palette = (*m_CharPaletteDefine.GetItemz())[ idxTab ];
	m_CharPaletteDefine.GetItemz()->InsertAt(
		idxTab-1,
		Palette
	);
	m_listTab.InsertString( idxTab-1, Palette.GetName() );

	// ̈ʒu폜
	m_CharPaletteDefine.GetItemz()->RemoveAt( idxTab+1 );
	m_listTab.DeleteString ( idxTab+1 );

	// ڐ
	m_listTab.SetCurSel( idxTab-1 );
	VisibleControl();
}

/*-----------------------------------------------------------------------------
[]	Down{^nh
[@\]	^üʒuړijB
[ߒl]	Ȃ
[l]	Ȃ
-----------------------------------------------------------------------------*/
void CCharPaletteSettingDlg::OnCharpaletteSettingDown() 
{
	long	idxTab = m_listTab.GetCurSel();
	if ( idxTab >= m_listTab.GetCount()-1 )
	{
		return;
	}
	if ( idxTab < 0 )
	{
		return;
	}

	// ЂƂ֒ǉ
	CCharPalette Palette = (*m_CharPaletteDefine.GetItemz())[ idxTab ];
	m_CharPaletteDefine.GetItemz()->InsertAt(
		idxTab+2,
		Palette
	);
	m_listTab.InsertString( idxTab+2, Palette.GetName() );

	// ̈ʒu폜
	m_CharPaletteDefine.GetItemz()->RemoveAt( idxTab );
	m_listTab.DeleteString ( idxTab );

	// ڐ
	m_listTab.SetCurSel( idxTab+1 );
	VisibleControl();
}
