open ScmEval
open Lexing 

let scheme_stream_from_channel = Lexing.from_channel
let scheme_stream_from_string = Lexing.from_string
let scheme_stream_from_function = Lexing.from_function


let parse_stream_with_environment = ScmEval.load 


let parse_stream env ?(prompt = fun x -> x) scheme_stream = 
    parse_stream_with_environment env ~prompt scheme_stream

let parse_string env string  =
  parse_stream_with_environment env (scheme_stream_from_string string)
