(**************************************************************************)
(*  Mana : A kana(romaji)-kanji conversion engine using ChaSen algorithm.    *)
(*  Copyright (C) 2003, 2004, 2005  Yamagata Yoriyuki                     *)
(*                                                                        *)
(*  This program is free software; you can redistribute it and/or modify  *)
(*  it under the terms of the GNU General Public License as published by  *)
(*  the Free Software Foundation; either version 2 of the License, or (at  *)
(*  your option) any later version.                                       *)
(*                                                                        *)
(*  This program is distributed in the hope that it will be useful, but   *)
(*  WITHOUT ANY WARRANTY; without even the implied warranty of            *)
(*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *)
(*  General Public License for more details.                              *)
(**************************************************************************)

(* $Id: parse.mli 171 2006-04-24 15:23:30Z yori $ *)

(** ʸĹʸΰ֤EUCʸοɽ롣*)

(** ѡ̤Ǽ뷿 *)
type parse_obj

(** [parse string state pos len ] [state]ȯ[string]
[pos]Ĺ[len]ʬʸϤѡ롣*)
val parse : string -> state:int -> pos:int -> len:int -> parse_obj

(** [best_path_from parse_obj state pos]ϰ[pos][state]
 Ŭѥ֤ѥ[(<>,<ϰ>,<Ĺ>,<>,<ѥ>)...]
 ɽ롣 ѥ¸ߤʤNot_found夲롣 *) 
val best_path_from_parse_obj : parse_obj -> state:int -> pos:int  -> (Mrph.mrph * int * int * int * int) list

(** [list_candidates string state pos mrph_len len][state]ȯ
[string][pos]Ĺ[mrph_len]ʬʸбǤ
롣ͤϷ,Ǥб븶ʸĹ,ηǤ
Ȥ[(mrph, state, cost)]ΥꥹȤǤ롣*) 
val list_candidates : string -> state:int -> pos:int -> mrph_len:int -> len:int -> (Mrph.mrph * int * int) list

(** [list_candidates_from parse_obj state pos mrph_len]
[list_candidates]Ʊͤ[parse_obj]Ѵ롣 *)
val list_candidates_from_parse_obj : parse_obj -> state:int -> pos:int -> mrph_len:int ->
  (Mrph.mrph * int * int) list


(** [learn parse_obj state pos path] [pos][state]
 path[path]=[<<ɽع¤>,<ϰ>,<Ĺ>>...]ǤäȲꤷƳ
 Ԥ *) 
val learn : parse_obj -> state:int -> pos:int ->  (string * int * int) list -> unit 
