open ScmTypes
open ScmEval
open Lexing

let interactive = Array.length Sys.argv = 1

(*
let prompt () = 
  if interactive then
    (print_string "? ";
     flush stdout)
*)

let () = 
  if interactive then 
    (Readline.readline_init "schoca";
     (* Sys.set_signal 2 (Sys.Signal_handle (fun _ -> print_endline "^C")); *)

     List.iter (fun (n,_) -> Readline.add_completion_string n) ScmEval.command_list)
      
let open_script name = 
  let ch = open_in name in
  let exec_line = input_line ch in
    if String.length exec_line <= 2 ||
      String.sub exec_line 0 2 <> "#!"  then
	seek_in ch 0;
    ch 

let eof_stream s =
  try Stream.empty s; true
  with Stream.Failure -> false


let main () =
  if interactive then 
    (print_string "Schoca Shell (Version 0.2.4) by Christoph Bauer\n\n";
     flush stdout);
  let p = ref "schoca> " in
  let lexbuf = 
    if interactive then (* stdin *)
      let reader = Readline.stream_reader (fun () -> let r = !p in p := "... "; r) in
	Lexing.from_function reader
    else 
      let input_channel = open_script Sys.argv.(1) in
	Lexing.from_channel input_channel in
  let prompt =
    if interactive then 
      fun v -> 
	p := "schoca> " ;
	print_string ("==> " ^ string_of_datum v ^ "\n"); 
	flush stdout;
	v
    else fun v -> v in
  let env = init_environment () in
  let my_scm_define env cont args =
    let my_cont v = Readline.add_completion_string (string_of_symbol v); cont v in
      scm_define env my_cont args
  in
    ignore( ScmEval.Environment.global_add env "define" (ML_LazyProcedure my_scm_define) );
    let rec exc_loop () =
      try 
	p := "schoca> ";
	ignore( ScmSchoca.parse_stream env ~prompt lexbuf );
      with 
	| ScmEval.Quit | Exit | Failure "Eof" -> ()
	| e ->
	    if not interactive then raise e
	    else 
	      (print_string ("Exception: " ^ Printexc.to_string e ^ "\n");
	       flush stdout;
	       exc_loop ()) 
    in exc_loop ()

in 
 main ()
     
