(**************************************************************************)
(*  Mana : A kana(romaji)-kanji conversion engine using ChaSen algorithm.    *)
(*  Copyright (C) 2003, 2004, 2005  Yamagata Yoriyuki                     *)
(*                                                                        *)
(*  This program is free software; you can redistribute it and/or modify  *)
(*  it under the terms of the GNU General Public License as published by  *)
(*  the Free Software Foundation; either version 2 of the License, or (at  *)
(*  your option) any later version.                                       *)
(*                                                                        *)
(*  This program is distributed in the hope that it will be useful, but   *)
(*  WITHOUT ANY WARRANTY; without even the implied warranty of            *)
(*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *)
(*  General Public License for more details.                              *)
(**************************************************************************)

(* $Id: parse.mli 150 2005-09-26 08:52:41Z yori $ *)

(** ʸĹʸΰ֤EUCʸοɽ롣*)

(** ѡ̤Ǽ뷿 *)
type parse_obj

(** [parse string state pos len ] [state]ȯ[string]
[pos]Ĺ[len]ʬʸϤѡ롣*)
val parse : string -> state:int -> pos:int -> len:int -> parse_obj

(** [best_path_from parse_obj state pos]ϰ[pos][state]
 Ŭѥ֤*)
val best_path_from : parse_obj -> state:int -> pos:int ->
  (Chasen.mrph * int * int * int * int) list

(** [list_candidates string state pos mrph_len len][state]ȯ
[string][pos]Ĺ[mrph_len]ʬʸбǤ
롣ͤϷ,Ǥб븶ʸĹ,ηǤ
Ȥ[(mrph, state, cost)]ΥꥹȤǤ롣*) 
val list_candidates : string -> state:int -> pos:int -> mrph_len:int -> len:int -> (Chasen.mrph * int * int) list

(** [list_candidates_from parse_obj state pos mrph_len]
[list_candidates]Ʊͤ[parse_obj]Ѵ롣 *)
val list_candidates_from : parse_obj -> state:int -> pos:int -> mrph_len:int ->
  (Chasen.mrph * int * int) list

