/**************************************************************************/
/*  Mana : A kana(romaji)-kanji conversion engine using ChaSen algorithm.    */
/*  Copyright (C) 2003, 2004, 2005  Yamagata Yoriyuki                     */
/*                                                                        */
/*  This program is free software; you can redistribute it and/or modify  */
/*  it under the terms of the GNU General Public License as published by  */
/*  the Free Software Foundation; either version 2 of the License, or (at  */
/*  your option) any later version.                                       */
/*                                                                        */
/*  This program is distributed in the hope that it will be useful, but   */
/*  WITHOUT ANY WARRANTY; without even the implied warranty of            */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     */
/*  General Public License for more details.                              */
/**************************************************************************/

/* $Id: hinsi.c 132 2005-08-07 18:05:59Z yori $ */

#include <string.h>
#include <caml/mlvalues.h>
#include <caml/memory.h>
#include <caml/alloc.h>
#include "chalib.h"
#include "dartsdic.h"

value hinsi_composit (value v){
  CAMLparam1(v);
  hinsi_t *hinsi;
  hinsi = (hinsi_t*)v;
  CAMLreturn (Val_long(hinsi->composit));
}

value hinsi_depth (value v){
  CAMLparam1(v);
  hinsi_t *hinsi;
  hinsi = (hinsi_t*)v;
  CAMLreturn (Val_long(hinsi->depth));
}

value hinsi_kt (value v){
  CAMLparam1(v);
  hinsi_t *hinsi;
  hinsi = (hinsi_t*)v;
  CAMLreturn (Val_long(hinsi->kt));
}

value hinsi_cost (value v){
  CAMLparam1(v);
  hinsi_t *hinsi;
  hinsi = (hinsi_t*)v;
  CAMLreturn (Val_long(hinsi->cost));
}

value get_hinsi (value v){
  CAMLparam1(v);
  CAMLreturn ((value)&Cha_hinsi[Long_val(v)]);
}
