{
  open ScmParser
  open ScmTypes

  let line = ref 1

  (* let parse_number s = 
    try Number (Dynnum.of_int (int_of_string s))
    with _ -> 
      try Number (Dynnum.of_float (float_of_string s))
      with _ -> Number (Dynnum.of_complex (complex_of_string s)) *)

			  
			
  let extract_string s = 
    assert( String.length s >= 2 );
    let shift = ref false
    and idx = ref ~-1 in
    let sub =
	String.sub s 1 (String.length s - 2) in
    let convert =
      function
	| '\\' when not !shift ->
	    shift := true
	| c ->
	    incr idx;
	    let nc =
	      if !shift then
		match c with
		  | 'n' -> '\n'
		  | 'b' -> '\b'
		  | 'r' -> '\r'
		  | _ -> c
	      else c in
	      shift := false;
	      String.unsafe_set sub !idx nc 
    in 
      String.iter convert sub; 
      String.sub sub 0 (succ !idx)

  let extract_character = 
    function
	"#\\space" -> ' '
      | "#\\newline" -> '\n'
      | s -> String.get s 2

  let extract_boolean =
    function
      | "#t" | "#T" -> scm_true
      | "#f" | "#F" -> scm_false
      | _ -> invalid_arg "extract_boolean"

  let extract_symbol = String.lowercase



(*
  let car_marker = ref ~-1
  let mark_lpar lexbuf = car_marker := Lexing.lexeme_end lexbuf
  let is_car_position lexbuf = !car_marker = Lexing.lexeme_start lexbuf
  let ignore_space lexbuf = if is_car_position lexbuf then mark_lpar lexbuf
*)

}


(* R5RS 7.1.1 *)

let letter = [ 'a'-'z'  'A'-'Z' ]
let special_initial = [ '!' '$' '%' '&' '*' '/' ':' '<' '=' '>' '?' '^' '_' '~' '.' ]
let digit = ['0'-'9']
let special_subsequent = ['+' '-' '.' '@']
let peculiar_identifier = ['+' '-']
let initial = letter | special_initial 
let subseqent = initial | digit | special_subsequent
let identifier = 
    initial subseqent * 
  | peculiar_identifier
let newline = (  '\n' | '\r' | "\n\r" )
let comment = ';' [^ '\n' '\r'] *  newline
let whitespace = [' ' '\t'] | newline
let atmosphere = whitespace | comment
let intertoken_space = atmosphere +
let radix_2 = ( "#b" | "#B" )
let radix_8 = ("#o" | "#O" )
let radix_10 = ("" | "#d" | "#D" )
let radix_16 = ("#x" | "#X")
let digit_2 = ['0' '1']
let digit_8 = ['0'-'7']
let digit_10 = digit
let digit_16 = (digit_10 | ['a'-'f' 'A'-'F'])
let exactness = "" | "#i" | "#I" | "#e" | "#E"
let sign = "" | '+' | '-'
let exponent_marker = "" | ['e' 's' 'f' 'd' 'l']
let suffix = "" | (exponent_marker sign digit_10+)
let prefix_2 = radix_2 exactness | exactness radix_2
let prefix_8 = radix_8 exactness | exactness radix_8
let prefix_10 = radix_10 exactness | exactness radix_10
let prefix_16 = radix_16 exactness | exactness radix_16
let uinteger_2 = digit_2 + '#' *
let uinteger_8 = digit_8 + '#' *
let uinteger_10 = digit_10 + '#' *
let uinteger_16 = digit_16 + '#' *
let decimal_10 = 
    (uinteger_10 suffix) 
  | ('.' digit_10 + '#' * suffix)
  | (digit_10 + '.' digit_10 *  '#' * suffix)
  | (digit_10 + '#' + '.' '#' * suffix)
let ureal_2 = 
    uinteger_2 
  | uinteger_2 '/' uinteger_2
let ureal_8 = 
    uinteger_8 
  | uinteger_8 '/' uinteger_8
let ureal_10 = 
    uinteger_10 
  | uinteger_10 '/' uinteger_10
  | decimal_10
let ureal_16 = 
    uinteger_16 
  | uinteger_16 '/' uinteger_16
let real_2 = sign ureal_2
let real_8 = sign ureal_8
let real_10 = sign ureal_10
let real_16 = sign ureal_16
let complex_2 =
    real_2
  | real_2 '@' real_2
  | real_2 ['+' '-'] ureal_2 'i'
  | real_2 ['+' '-'] 'i'
let complex_8 =
    real_8
  | real_8 '@' real_8
  | real_8 ['+' '-'] ureal_8 'i'
  | real_8 ['+' '-'] 'i'
let complex_10 =
    real_10
  | real_10 '@' real_10
  | real_10 ['+' '-'] ureal_10 'i'
  | real_10 ['+' '-'] 'i'
let complex_16 =
    real_16
  | real_16 '@' real_16
  | real_16 ['+' '-'] ureal_16 'i'
  | real_16 ['+' '-'] 'i'
let num_2 = prefix_2 complex_2
let num_8 = prefix_8 complex_8
let num_10 = prefix_10 complex_10
let num_16 = prefix_16 complex_16
let number = num_2 | num_8 | num_10 | num_16
let string_element = [^ '"' '\\'] | ("\\" _)
let string = '"' string_element * '"'
let character = "#\\space"  | "#\\newline" | ("#\\" _)
let boolean = "#t" | "#f"

		
rule token = parse		  
  | newline { incr line; token lexbuf }
  | intertoken_space { token lexbuf }
  | "#(" { SHARPLPARENT } 
  | "'" { QUOTE }
  | "`" { BACKQUOTE }
  | ",@" { COMAAT }
  | ',' { COMA}
  | '.' intertoken_space { DOT }
  | '('  { LPARENT }
  | ')'  { RPARENT }
  | "=>" intertoken_space { ARROW }
  | number { DATA( datum_of_number (ScmDynnum.of_string (Lexing.lexeme lexbuf))) }
  | string { DATA( datum_of_string(extract_string (Lexing.lexeme lexbuf))) }
  | character { DATA( datum_of_char (extract_character (Lexing.lexeme lexbuf))) }
  | boolean { DATA( extract_boolean (Lexing.lexeme lexbuf)) }
  | identifier { DATA( gen_symbol (extract_symbol (Lexing.lexeme lexbuf))) } 
  | eof { EOF }

    
   

