(**************************************************************************)
(*  Mana : A kana(romaji)-kanji conversion engine using ChaSen algorithm.    *)
(*  Copyright (C) 2003, 2004  Yamagata Yoriyuki                           *)
(*                                                                        *)
(*  This program is free software; you can redistribute it and/or modify  *)
(*  it under the terms of the GNU General Public License as published by  *)
(*  the Free Software Foundation; either version 2 of the License, or (at  *)
(*  your option) any later version.                                       *)
(*                                                                        *)
(*  This program is distributed in the hope that it will be useful, but   *)
(*  WITHOUT ANY WARRANTY; without even the implied warranty of            *)
(*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *)
(*  General Public License for more details.                              *)
(**************************************************************************)

(* $Id: chasen.mli 99 2005-07-03 18:47:47Z yori $ *)

external romaji : string -> string = "caml_romaji"
external katakana : string -> string = "caml_katakana"
external hiragana : string -> string = "caml_hiragana"

type darts
type mrph
type mrph_data
type undef_info
type hinsi

external undef_info_cost : undef_info -> int = "undef_info_cost"
external undef_info_cost_step : undef_info -> int = "undef_info_cost_step"
external undef_info_con_tbl : undef_info -> int = "undef_info_con_tbl"
external undef_info_hinsi : undef_info -> int = "undef_info_hinsi"

external hinsi_composit : hinsi -> int = "hinsi_composit"
external hinsi_depth : hinsi -> int = "hinsi_depth"
external hinsi_kt : hinsi -> int = "hinsi_kt"
external hinsi_cost : hinsi -> int = "hinsi_cost"

external darts_open : string -> string -> string -> darts = "darts_open"

val mrph_cost_weight : int

val posid : mrph -> int
val inf_type : mrph -> int
val inf_form : mrph -> int
val weight : mrph -> int
val con_tbl : mrph -> int
val keyword : mrph -> string
val keyword_len : mrph -> int
val is_undef : mrph -> int
val undef_info : mrph -> undef_info
val hinsi : mrph -> hinsi
val darts : mrph -> darts
val undefwords : string -> mrph list
val darts_lookup : string -> int -> int -> mrph list
val darts_lookup_prefix : string -> int -> int -> (mrph * int) list
val connect_cost : int -> mrph -> (int * int)

val mrph_data_of_mrph : mrph -> mrph_data
val mrph_of_mrph_data : mrph_data -> mrph

val headword : mrph_data -> string
val headword_len : mrph_data -> int
val reading : mrph_data -> string
val reading_len : mrph_data -> int
val pron : mrph_data -> string
val pron_len : mrph_data -> int
val stem_len : mrph_data -> int
val base : mrph_data -> string
val info : mrph_data -> string
val compound : mrph_data -> int
val surface_form : mrph_data -> string

val serialize_mrph : mrph -> string
val deserialize_mrph : string -> mrph

val new_word : kaki:string -> yomi:string -> mrph list
