module C :
  sig
    type t = Complex.t = { re : float; im : float; }
    val zero : t
    val one : t
    val i : t
    val neg : t -> t
    val conj : t -> t
    val add : t -> t -> t
    val sub : t -> t -> t
    val mul : t -> t -> t
    val inv : t -> t
    val div : t -> t -> t
    val sqrt : t -> t
    val norm2 : t -> float
    val norm : t -> float
    val arg : t -> float
    val polar : float -> float -> t
    val exp : t -> t
    val log : t -> t
    val pow : t -> t -> t
  end
type number_exactness = Exact | Inexact
and number_value = Int of int | Float of float | Complex of C.t
and t = { value : number_value; exactness : number_exactness; }
val zero : t
val one : t
val i : t
val of_int : int -> t
val of_float : float -> t
val combine_exactness :
  number_exactness -> number_exactness -> number_exactness
val convert_to_complex : number_value -> number_value
val convert_to_float : number_value -> number_value
val convert_to_int : number_value -> number_value
val same_type : number_value -> number_value -> bool
val convert_to_same_type :
  number_value -> number_value -> number_value * number_value
val do_op : (number_value * number_value -> number_value) -> t -> t -> t
val do_unary_op : (number_value -> number_value) -> t -> t
val st_add : number_value * number_value -> number_value
val st_sub : number_value * number_value -> number_value
val st_mul : number_value * number_value -> number_value
val st_div : number_value * number_value -> number_value
val st_quotient : number_value * number_value -> number_value
val st_remainder : number_value * number_value -> number_value
val st_modulo : number_value * number_value -> number_value
val st_abs : number_value -> number_value
val check_pred : (number_value * number_value -> 'a) -> t -> t -> 'a
val predicate : (number_value -> 'a) -> t -> 'a
val st_is_integer : number_value -> bool
val st_is_real : number_value -> bool
val st_is_complex : 'a -> bool
val st_is_rational : number_value -> bool
val st_greater : number_value * number_value -> bool
val st_greater_or_equal : number_value * number_value -> bool
val st_equal : 'a * 'a -> bool
val st_unequal : 'a -> 'a -> bool
val st_less : number_value * number_value -> bool
val st_less_or_equal : number_value * number_value -> bool
val is_zero : t -> bool
val is_positive : t -> bool
val is_negative : t -> bool
val int_of : t -> int
val is_odd : t -> bool
val is_even : t -> bool
val st_max : number_value * number_value -> number_value
val st_min : number_value * number_value -> number_value
val st_neg : number_value -> number_value
val int_pow : int -> int -> int
val st_pow : number_value * number_value -> number_value
val st_float_to_int : (float -> float) -> number_value -> number_value
val st_floor : number_value -> number_value
val st_ceil : number_value -> number_value
val st_truncate : number_value -> number_value
val invalid : string -> 'a -> 'b
val float_op :
  (float -> float) -> (C.t -> C.t) -> number_value -> number_value
val st_sqrt : number_value -> number_value
val st_exp : number_value -> number_value
val st_log : number_value -> number_value
val st_sin : number_value -> number_value
val st_cos : number_value -> number_value
val st_asin : number_value -> number_value
val st_acos : number_value -> number_value
val st_tan : number_value -> number_value
val st_im_part : number_value -> number_value
val st_re_part : number_value -> number_value
val st_numerator : number_value -> number_value
val st_denominator : number_value -> number_value
val add : t -> t -> t
val sub : t -> t -> t
val mul : t -> t -> t
val div : t -> t -> t
val max : t -> t -> t
val min : t -> t -> t
val greater : t -> t -> bool
val less : t -> t -> bool
val greater_or_equal : t -> t -> bool
val less_or_equal : t -> t -> bool
val equal : t -> t -> bool
val is_complex : t -> bool
val is_rational : t -> bool
val is_integer : t -> bool
val is_real : t -> bool
val quotient : t -> t -> t
val remainder : t -> t -> t
val modulo : t -> t -> t
val neg : t -> t
val abs : t -> t
val sin : t -> t
val cos : t -> t
val tan : t -> t
val asin : t -> t
val acos : t -> t
val atan : t -> t
val exp : t -> t
val log : t -> t
val im_part : t -> t
val re_part : t -> t
val inexact : t -> t
val exact : t -> t
val is_exact : t -> bool
val is_inexact : t -> bool
val pow : t -> t -> t
val do_int_op : (int -> int -> int) -> t -> t -> t
val gcd : t -> t -> t
val lcm : t -> t -> t
val numerator : t -> t
val denominator : t -> t
val zero_code : int
val a_code : int
val default_radix : t
val of_string : ?radix:t -> string -> t
val string_of : ?radix:t -> t -> string
val sqrt : t -> t
val truncate : t -> t
