(**************************************************************************)
(*  Mana : A kana(romaji)-kanji conversion engine using ChaSen algorithm.    *)
(*  Copyright (C) 2003, 2004  Yamagata Yoriyuki                           *)
(*                                                                        *)
(*  This program is free software; you can redistribute it and/or modify  *)
(*  it under the terms of the GNU General Public License as published by  *)
(*  the Free Software Foundation; either version 2 of the License, or (at  *)
(*  your option) any later version.                                       *)
(*                                                                        *)
(*  This program is distributed in the hope that it will be useful, but   *)
(*  WITHOUT ANY WARRANTY; without even the implied warranty of            *)
(*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *)
(*  General Public License for more details.                              *)
(**************************************************************************)

(* $Id: parse.mli 39 2004-11-14 19:58:01Z yori $ *)

type parse_tree

val f : string -> parse_tree
val hiragana : string -> parse_tree

val split_best : parse_tree -> Chasen.mrph list * parse_tree
val best_path : parse_tree -> Chasen.mrph list
val p_cost : parse_tree -> int

val match_head : (Chasen.mrph -> bool) -> parse_tree -> parse_tree

val fix_firstmrph : string -> parse_tree -> parse_tree
val fix_firstmrph_len : int -> parse_tree -> parse_tree
val fix_firstmrph_len_hira : int -> parse_tree -> parse_tree
val list_candidates : int -> parse_tree -> string list
val list_candidates_hira : int -> parse_tree -> string list


