// Shimakuma-Green Image Viewer
// Version:3.1811
// Copyright (c) 2018-2019 Mitsuhiro Tsuda.

(function(window, $){

	window.s14vToggleUnit = function(b){};
	window.s14vToggleEditor = function(){};
	window.s14vToggleAnnote = function(){};
	window.s14vUpdateSize = function(w,h){};
	window.s14vUpdateRect = function(x,y,w,h,rx,ry,rw,rh,rot){};
	window.s14vAdjustSize = function(){
		var wid = $(window).width();
		var hei = $(window).height();
		return [wid, hei];
	};

	// Tools
	window.s14vHideMyTools = function(){};

	// Context Menu
	$("body").on("contextmenu", function(event){ event.preventDefault(); });

	window.addEventListener("keyup", function(event) {
		var evt = event || window.event;
		var keycode = evt.charCode || evt.keyCode;
		if (keycode == 33){ event.preventDefault(); window.movePage(-1); }
		else if (keycode == 34){ event.preventDefault(); window.movePage(+1); }
	}, false);



}(window, window.jQuery));


(function(window, $){

	function load_manifest(link){
		$.ajax({
			type: "GET",
			url: link,
			dataType: "json",
			success: function(json){

				var s_resource = json.sequences[0].canvases[0].images[0].resource;
				var s_service = s_resource["@id"];
				var s_type = "jpg";
				if (typeof s_resource.service !== "undefined"){
					s_service = s_resource.service["@id"];
					s_type = "iiif";
				}
				var s_num1 = s_service.lastIndexOf("/");
				var s_num2 = s_service.lastIndexOf(".");
				if (s_num1 > s_num2) s_num2 = -1;
				var s_name = s_service.substring(s_num1+1);
				if (s_num2 > 0){
					s_name = s_service.substring(s_num1+1,s_num2);
					s_type = s_type + "|" + s_service.substring(s_num2+1);
				}

				window.Shimakuma.Viewer.forcedIn("viewer", {
					path: s_service.substring(0,s_num1+1),
					name: s_name,
					type: s_type
				});

			},
			error: function(){}
		});
	}

	jQuery(window).ready(function(){

		var dropper = $("#viewer");

		dropper.on("drop",function(event){

			event.stopPropagation();

			if (contains( event.originalEvent.dataTransfer.types, "text/uri-list")){
				event.preventDefault();

				var link = event.originalEvent.dataTransfer.getData("text/uri-list");

				load_manifest(link);
			}
			else if(contains( event.originalEvent.dataTransfer.types, "Files")){
				event.preventDefault();

				var file = event.originalEvent.dataTransfer.files[0];

				var fileReader = new FileReader();
				fileReader.onload = function(event) {

					var json = JSON.parse(event.target.result);
					var s_resource = json.sequences[0].canvases[0].images[0].resource;
					var s_service = s_resource["@id"];
					var s_type = "jpg";
					if (typeof s_resource.service !== "undefined"){
						s_service = s_resource.service["@id"];
						s_type = "iiif";
					}
					var s_num1 = s_service.lastIndexOf("/");
					var s_num2 = s_service.lastIndexOf(".");
					if (s_num1 > s_num2) s_num2 = -1;
					var s_name = s_service.substring(s_num1+1);
					if (s_num2 > 0){
						s_name = s_service.substring(s_num1+1,s_num2);
						s_type = s_type + "|" + s_service.substring(s_num2+1);
					}

					window.Shimakuma.Viewer.forcedIn("viewer", {
						path: s_service.substring(0,s_num1+1),
						name: s_name,
						type: s_type
					});

				}
				fileReader.readAsText(file);
			}
			else {
				cancelEvent(event);
				return false;
			}

		});

		var cancelEvent = function(event) {
				//event.preventDefault();
				//event.stopPropagation();
				return false;
		};

		function contains(list, value) {
			for( var i = 0; i < list.length; ++i ) {
				if (list[i] === value) return true;
			}
			return false;
		}

		dropper.on("dragenter dragover", function(event){
			if (contains( event.originalEvent.dataTransfer.types, "text/uri-list")){
				event.preventDefault();
			}
			else if(contains( event.originalEvent.dataTransfer.types, "Files")){
				event.preventDefault();
			}
			else {
				return false;
			}
		});

	});

}(window, window.jQuery));
