/*  
 *  Copyright (C) 2006  ӹ (WAKATSUKI toshihiro)
 *  
 *  gtk  libgauche Ȥä Scheme ѥ֥ƥȥǥ
 */

#include<gauche.h>
#include<gtk/gtk.h>
#include<gdk/gdkkeysyms.h>

#define INDENT_WIDTH 2

static GtkWidget *editor_window;
/* ֳס¸ס̾¸סΰ¹ԡץ */
static GtkToolItem *oicon, *sicon, *saicon, *eicon;
static gchar *current_filename;
static GtkTextTag *parentEmphasisColorTag;

/* ƥȥХåեƤʸФ */
static gchar* get_all_buffer_contents(GtkTextBuffer *buffer) {
  GtkTextIter start, end;
  gtk_text_buffer_get_start_iter(buffer, &start);
  gtk_text_buffer_get_end_iter(buffer, &end);
  return gtk_text_buffer_get_text(buffer, &start, &end, FALSE);
}

/* buffer Ƥե filename ¸ */
static gboolean save_text_buffer(gchar *filename, GtkWidget *buffer) {
  gchar *contents;
  if(!filename) return FALSE;
  contents = get_all_buffer_contents(GTK_TEXT_BUFFER(buffer));
  /* ʸե¸ */
  g_file_set_contents(filename, contents, -1, NULL);
  g_free(contents);
  return TRUE;
}

/* 򳫤ե̾msg ϥΥå */
static gchar *get_filename_from_dialog(const gchar *msg) {

  GtkWidget *dialog = gtk_file_selection_new(msg);
  int resp = gtk_dialog_run(GTK_DIALOG(dialog));
  gchar *filename = NULL;

  /* gtk_file_selection_get_filename ֤ʸŪ˳ݤ줿ХåեؤƤΤǡԡʤФʤʤ */
  if(resp == GTK_RESPONSE_OK)
    filename = g_strdup(gtk_file_selection_get_filename(GTK_FILE_SELECTION(dialog)));

  gtk_widget_destroy(dialog);
  return filename;
}

/* ե¸륤٥ȥϥɥ */
static void save_file_handler(GtkWidget *widget, GtkWidget *buffer) {

  /* ѹ̵в⤷ʤ */
  if(!gtk_text_buffer_get_modified(GTK_TEXT_BUFFER(buffer))) return;

  /* ޤե̾ꤵƤʤä顤򳫤Ϥ */
  if(!current_filename)
    save_text_buffer(current_filename = g_strdup(get_filename_from_dialog("Save File As ...")), buffer);
  else
    save_text_buffer(current_filename, buffer);

  if(!current_filename) return;
  gtk_window_set_title (GTK_WINDOW (editor_window), current_filename);
}

/* ե̾¸륤٥ȥϥɥ */
static void save_file_as_handler(GtkWidget *widget, GtkWidget *buffer) {
  save_text_buffer(get_filename_from_dialog("Save File As ..."), buffer);
}

/* ե򳫤٥ȥϥɥ */
static void open_file_handler(GtkWidget *widget,  GtkWidget *buffer) {

  gchar *text;
  gsize len;

  gchar *filename = get_filename_from_dialog("File Selection");

  if(!filename) return;

  if(g_file_get_contents(filename, &text, &len, NULL)) {
    gtk_text_buffer_set_text(GTK_TEXT_BUFFER(buffer), text, len);
    g_free(text);
    if(current_filename)
      g_free(current_filename);
    current_filename = filename;
    gtk_window_set_title (GTK_WINDOW (editor_window), current_filename);
  } else
    g_printerr("Get file contents error !\n");
}

/* gauche ưʸɾ */
static gchar *eval_cstring_by_gauche(gchar *s) {
  gchar *msg;

  ScmObj result, error; 
  /* ʸݡȳ */
  ScmObj os = Scm_MakeOutputStringPort(TRUE);

  /* Scheme ٥ǥ顼ϥɥ */
  /* http://alohakun.blog7.fc2.com/blog-entry-517.html */
  Scm_Define(Scm_UserModule(), SCM_SYMBOL(SCM_INTERN("*input*")), SCM_MAKE_STR(s));
  Scm_Define(Scm_UserModule(), SCM_SYMBOL(SCM_INTERN("*error*")), SCM_FALSE);

  result = Scm_EvalCString("(guard (e (else (set! *error* e) #f)) (eval (read-from-string *input*) (current-module)))", SCM_OBJ(Scm_UserModule()));

  error = Scm_GlobalVariableRef(Scm_UserModule(), SCM_SYMBOL(SCM_INTERN("*error*")), 0);

  /* ʸɾ̤ݡȤ˽񤭹 */
  if (!SCM_FALSEP(error))
    Scm_Write(error, os, SCM_WRITE_DISPLAY);
  else
    Scm_Write(result, os, SCM_WRITE_DISPLAY);

  msg = Scm_GetString(SCM_STRING(Scm_GetOutputString(SCM_PORT(os))));
  /* ݡĤ */
  Scm_ClosePort(SCM_PORT(os));

  return msg;
}

/* ХܥΥϥɥ󥰡Хåե򤵤Ƥ S ɾ */
static void buffer_exec_handler(GtkWidget *widget,  GtkWidget *buffer) {
  GtkTextIter start, end, p;
  gchar *code;
  gtk_text_buffer_get_end_iter(GTK_TEXT_BUFFER(buffer), &p);
  gtk_text_buffer_insert(GTK_TEXT_BUFFER(buffer), &p, "\n\n", -1);

  /* ޥ򤵤ƤϰϤʸ */
  if(gtk_text_buffer_get_selection_bounds(GTK_TEXT_BUFFER(buffer), &start, &end)) {
    code = gtk_text_buffer_get_text(GTK_TEXT_BUFFER(buffer), &start, &end, FALSE);
    gtk_text_buffer_insert(GTK_TEXT_BUFFER(buffer), &p, eval_cstring_by_gauche(code), -1);
    g_free(code);
  }

}

// GtkTextCharPredicate
static gboolean is_kakko_or_kokka(gunichar ch, gpointer p) {
  return ch == '(' || ch == ')';
}
static gboolean is_kokka(gunichar ch, gpointer p) {return ch == ')';}


/* ')' б '(' ޤǤʸ (S ) ڤФ */
static gboolean search_sexp_string(GtkTextIter *start) {
  gint nest_level = 0;
  /* ֤ˤ S ڤФ */
  while(1) {
    if(!gtk_text_iter_backward_find_char(start, is_kakko_or_kokka, NULL, NULL))
      return FALSE;

    if(gtk_text_iter_get_char(start) == ')')
      nest_level++;
    else {
      if(!nest_level)
        break;
      else
        nest_level--;
    }
  }
  return TRUE;
}

/* ֤Υͥȥ٥֤ */
static gint get_parent_nest_level_at_cursor(GtkTextBuffer *buffer) {
  gint nest_level = 0;
  GtkTextIter start, end;
  gtk_text_buffer_get_start_iter(buffer, &start);
  if(gtk_text_iter_get_char(&start) == '(') nest_level++;

  /* ΰ (= end)  */
  gtk_text_buffer_get_iter_at_mark(buffer,&end, gtk_text_buffer_get_insert(buffer));

  while(1) {
    /* end ޤ '('  ')' õƸĤʤä齪λ */
    if(!gtk_text_iter_forward_find_char(&start, is_kakko_or_kokka, NULL, &end))
      return nest_level;

    if(gtk_text_iter_get_char(&start) == '(')
      nest_level++;
    else 
      nest_level--;
  }
}

/* ΥΥϥɥ */

/* 줿 */
static gboolean signal_key_press (GtkWidget *widget, GdkEventKey *event, GtkWidget *buffer) {
  GtkTextIter start, end;

  /* θ̵̤ */
  gtk_text_buffer_get_start_iter(GTK_TEXT_BUFFER(buffer), &start);
  gtk_text_buffer_get_end_iter(GTK_TEXT_BUFFER(buffer), &end);
  gtk_text_buffer_remove_tag(GTK_TEXT_BUFFER(buffer), parentEmphasisColorTag, &start, &end);

  /* Ctrl + j :  S ɾ */
  if(event->keyval == GDK_j && event->state & GDK_CONTROL_MASK) {
    gchar *code;
    GtkTextIter start, end;

    /* ΰ֤ */
    gtk_text_buffer_get_iter_at_mark(GTK_TEXT_BUFFER(buffer), &end, gtk_text_buffer_get_insert(GTK_TEXT_BUFFER(buffer)));

    gtk_text_iter_backward_find_char(&end, is_kokka, NULL, NULL);
    start = end;
    gtk_text_iter_forward_char(&end);

    /* ֤ˤ S ڤФ */
    if(!search_sexp_string(&start)) return FALSE;

    code = gtk_text_buffer_get_text(GTK_TEXT_BUFFER(buffer), &start, &end, FALSE);
    gtk_text_buffer_insert(GTK_TEXT_BUFFER(buffer), &end, "\n\n", -1);
    gtk_text_buffer_insert(GTK_TEXT_BUFFER(buffer), &end, eval_cstring_by_gauche(code), -1);

    g_free(code);

  }

  return FALSE;
}

/* Υ줿 */
static gboolean signal_key_release (GtkWidget *widget, GdkEventKey *event, GtkWidget *buffer) {

  if(event->keyval == GDK_parenright && event->state & GDK_SHIFT_MASK) {
    GtkTextIter start, end;

    /* ΰ֤ */
    gtk_text_buffer_get_iter_at_mark(GTK_TEXT_BUFFER(buffer), &end, gtk_text_buffer_get_insert(GTK_TEXT_BUFFER(buffer)));

    start = end;
    gtk_text_iter_backward_char(&start);

    /* ֤ˤ S ڤФ */
    if(!search_sexp_string(&start)) return FALSE;

    gtk_text_buffer_apply_tag (GTK_TEXT_BUFFER(buffer), parentEmphasisColorTag, &start, &end);
  }

  /* Ԥ뤿ӤˡưŪ˳̤ΥͥȤο˱Υڡ (ǥ) Ƭ */
  if(event->keyval == GDK_Return) {
    gint indentWidth = get_parent_nest_level_at_cursor(GTK_TEXT_BUFFER(buffer)) * INDENT_WIDTH;
    gchar *indent = g_strnfill(indentWidth, ' ');
    gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(buffer), indent, -1);
    g_free(indent);
  }

  return FALSE;
}

/* YES ܥNO ܥ󤽤줾ǸƤФ callback */
void really_quit_dialog_yes(GtkWidget *widget, gboolean *flag){*flag = FALSE;}
void really_quit_dialog_no(GtkWidget *widget, gint *flag){*flag = TRUE;}

/* ˽λƤǤ ? */
gboolean delete_event(GtkWidget *widget, GdkEvent *event, GtkWidget *buffer){
  GtkWidget *yes_button, *no_button;
  static GtkWidget *dialog_window = NULL;

  /* ѹ̵ФΤޤ޽λ */
  if(!gtk_text_buffer_get_modified(GTK_TEXT_BUFFER(buffer))) return FALSE;

  if(dialog_window == NULL) {
    gboolean flag = TRUE;
    dialog_window = gtk_dialog_new ();

    /* ˽λƤǤ ? ν */
    g_signal_connect(G_OBJECT(dialog_window), "delete_event", G_CALLBACK(gtk_false), NULL);
    g_signal_connect(G_OBJECT(dialog_window), "destroy", G_CALLBACK(gtk_main_quit), NULL);

    gtk_window_set_title(GTK_WINDOW (dialog_window), "Really Quit ?");
    /* YES Υܥ */
    yes_button = gtk_button_new_with_label("YES");
    g_signal_connect(GTK_OBJECT(yes_button), "clicked", G_CALLBACK(really_quit_dialog_yes), &flag);
    g_signal_connect_swapped(GTK_OBJECT(yes_button), "clicked", G_CALLBACK(gtk_widget_destroy), G_OBJECT(dialog_window));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog_window)->action_area),  yes_button, TRUE, TRUE, 0);

    /* NO Υܥ */
    no_button = gtk_button_new_with_label("NO");
    g_signal_connect(GTK_OBJECT(no_button), "clicked", G_CALLBACK(really_quit_dialog_no), &flag);
    g_signal_connect_swapped(GTK_OBJECT(no_button), "clicked", G_CALLBACK(gtk_widget_destroy), G_OBJECT(dialog_window));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog_window)->action_area),  no_button, TRUE, TRUE, 0);

    gtk_window_set_modal(GTK_WINDOW(dialog_window), TRUE);
    gtk_window_set_transient_for(GTK_WINDOW(dialog_window), GTK_WINDOW (editor_window));

    gtk_widget_show_all(dialog_window);
    gtk_main ();
    dialog_window = NULL;

    /* "delete_event" ֤ͤ FALSE ʤ"destory" ȯԤ졤window ˲ */
    return flag;
  }
  return TRUE;
}

/* ڡΥ֤ȶ on/off */
static void tabsborder_book(GtkButton *button, GtkNotebook *notebook) {
  gint tval = FALSE;
  gint bval = FALSE;
  if(notebook->show_tabs == FALSE)
    tval = TRUE; 
  if(notebook->show_border == FALSE)
    bval = TRUE;

  gtk_notebook_set_show_tabs(notebook, tval);
  gtk_notebook_set_show_border(notebook, bval);
}

/* Ρȥ֥åڡ */
static void remove_book(GtkButton *button, GtkNotebook *notebook) {
  gint page = gtk_notebook_get_current_page(notebook);
  gtk_notebook_remove_page(notebook, page);
  /* åȤŪ˺ */
  gtk_widget_queue_draw(GTK_WIDGET(notebook));
}

/* Хåե */
static GtkWidget *new_scrolled_text_buffer() {

  GtkWidget *scrolledwindow, *view;
  GtkTextBuffer *buffer;

  /* 륦ɤ */
  scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW(scrolledwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  /* ƥȥӥ塼ȥХåե */
  view = gtk_text_view_new();
  buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(view));
  gtk_container_add(GTK_CONTAINER(scrolledwindow), view);
  g_signal_connect(G_OBJECT(editor_window), "delete_event", G_CALLBACK(delete_event), buffer);
  gtk_widget_set_size_request(GTK_WIDGET(view), 500, 500);

  /* ֳץܥ˥եɤ߹ॢϢդ */
  g_signal_connect(G_OBJECT(oicon), "clicked", G_CALLBACK(open_file_handler), G_OBJECT(buffer));
  /* ¸ץܥ˥ե񤭽ФϢդ */
  g_signal_connect(G_OBJECT(sicon), "clicked", G_CALLBACK(save_file_handler), G_OBJECT(buffer));
  /* ̾¸ץܥ̾Υե볫Ƥ񤭽ФϢդ */
  g_signal_connect(G_OBJECT(saicon), "clicked", G_CALLBACK(save_file_as_handler), G_OBJECT(buffer));
  /* Хåե¹ԥܥ libgauche Ϣդ */
  g_signal_connect(G_OBJECT(eicon), "clicked", G_CALLBACK(buffer_exec_handler), G_OBJECT(buffer));

  /* ХɤΥϥɥ󥰤Ͽ */
  g_signal_connect(G_OBJECT(view), "key-press-event", G_CALLBACK (signal_key_press), G_OBJECT(buffer));
  g_signal_connect(G_OBJECT(view), "key-release-event", G_CALLBACK (signal_key_release), G_OBJECT(buffer));

  /* ͡ʽ */
  parentEmphasisColorTag = gtk_text_buffer_create_tag (buffer, "parent_emphasis_background", "background", "green", NULL);

  return scrolledwindow;
}


/* Ρȥ֥å˥ڡɲ */
static void append_book(GtkButton *button, GtkNotebook *notebook) {

  gtk_notebook_append_page(notebook,
      new_scrolled_text_buffer(),
      gtk_label_new("New Buffer"));

  gtk_widget_show_all(GTK_WIDGET(notebook));
}

/* ֤ΰ֤Ĵ */
static void rotate_book(GtkButton   *button, GtkNotebook *notebook ) {
  gtk_notebook_set_tab_pos(notebook, (notebook->tab_pos + 1) % 4);
}

/* ǥԽ̤ν */
static void editor_window_init() {
  GtkWidget *vbox, *toolbar, *notebook;
  GtkToolItem *icon;
  GtkIconSize iconsize;

  /*  */
  editor_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  g_signal_connect(G_OBJECT(editor_window), "destroy", G_CALLBACK(gtk_main_quit), NULL);

  /* ѥå󥰥ܥå */
  vbox = gtk_vbox_new(FALSE, 0);
  /* ġС */
  toolbar = gtk_toolbar_new();
  gtk_box_pack_start(GTK_BOX(vbox), toolbar, FALSE, FALSE, 0);


  /* ġСդ륢 */
  gtk_toolbar_set_style(GTK_TOOLBAR (toolbar), GTK_TOOLBAR_ICONS);
  iconsize = gtk_toolbar_get_icon_size (GTK_TOOLBAR (toolbar));

  /*  */
  /* ե볫 */
  oicon = gtk_tool_button_new(gtk_image_new_from_stock ("gtk-open", iconsize), "");
  gtk_container_add(GTK_CONTAINER (toolbar), GTK_WIDGET(oicon));
  /* Хåե¸ */
  sicon = gtk_tool_button_new(gtk_image_new_from_stock ("gtk-save", iconsize), "");
  gtk_container_add (GTK_CONTAINER (toolbar), GTK_WIDGET(sicon));      
  /* Хåե̾¸ */
  saicon = gtk_tool_button_new(gtk_image_new_from_stock ("gtk-save-as", iconsize), "");
  gtk_container_add (GTK_CONTAINER (toolbar), GTK_WIDGET(saicon));
  /* Хåե¹ */
  eicon = gtk_tool_button_new(gtk_image_new_from_stock ("gtk-execute", iconsize), "");
  gtk_container_add (GTK_CONTAINER (toolbar), GTK_WIDGET(eicon));

  gtk_container_add(GTK_CONTAINER(editor_window), vbox);

  notebook = gtk_notebook_new();
  gtk_container_add(GTK_CONTAINER(vbox), notebook);

  /* ǥեȤΥڡɲ */
  gtk_notebook_prepend_page(GTK_NOTEBOOK(notebook),
      new_scrolled_text_buffer(),
      gtk_label_new("New Buffer"));

  /* Υ */
  icon = gtk_tool_button_new(gtk_image_new_from_stock ("gtk-media-previous", iconsize), "prev");
  g_signal_connect_swapped(G_OBJECT(icon), "clicked", G_CALLBACK(gtk_notebook_prev_page), G_OBJECT(notebook));
  gtk_container_add (GTK_CONTAINER (toolbar), GTK_WIDGET(icon));

  /* Υ */
  icon = gtk_tool_button_new(gtk_image_new_from_stock ("gtk-media-next", iconsize), "next");
  g_signal_connect_swapped(G_OBJECT(icon), "clicked", G_CALLBACK(gtk_notebook_next_page), G_OBJECT(notebook));
  gtk_container_add (GTK_CONTAINER (toolbar), GTK_WIDGET(icon));

  /* ֤ on/off */
  icon = gtk_tool_button_new(gtk_image_new_from_stock ("gtk-apply", iconsize), "append");
  g_signal_connect(G_OBJECT(icon), "clicked", G_CALLBACK(tabsborder_book), (gpointer) notebook);
  gtk_container_add (GTK_CONTAINER (toolbar), GTK_WIDGET(icon));

  /* ֤ΰ */
  icon = gtk_tool_button_new(gtk_image_new_from_stock ("gtk-preferences", iconsize), "append");
  g_signal_connect(G_OBJECT(icon), "clicked", G_CALLBACK(rotate_book), (gpointer) notebook);
  gtk_container_add (GTK_CONTAINER (toolbar), GTK_WIDGET(icon));

  /* ֤ɲ */
  icon = gtk_tool_button_new(gtk_image_new_from_stock ("gtk-add", iconsize), "append");
  g_signal_connect(G_OBJECT(icon), "clicked", G_CALLBACK(append_book), (gpointer) notebook);
  gtk_container_add (GTK_CONTAINER (toolbar), GTK_WIDGET(icon));

  /* 򤵤Ƥڡ */
  icon = gtk_tool_button_new(gtk_image_new_from_stock ("gtk-close", iconsize), "remove");
  g_signal_connect(G_OBJECT(icon), "clicked", G_CALLBACK(remove_book), (gpointer) notebook);
  gtk_container_add (GTK_CONTAINER (toolbar), GTK_WIDGET(icon));

  gtk_widget_show_all(editor_window);
}

int main(int argc, char *argv[]) {
  /* ƥᥤ롼פ */
  gtk_set_locale(); 
  gtk_init(&argc, &argv);
  GC_INIT(); Scm_Init(GAUCHE_SIGNATURE);
  editor_window_init();
  gtk_main();
  Scm_Exit(0);
  return 0;
}
