/*
SRConstant.h

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>

// Bookmark type
extern NSString*    SRBookmarkTypeHTML;
extern NSString*    SRBookmarkTypeFolder;
extern NSString*    SRBookmarkTypeJavaScript;
extern NSString*    SRBookmarkTypeSmart;
extern NSString*    SRBookmarkTypeBookmarkBar;
extern NSString*    SRBookmarkTypeBookmarkMenu;
extern NSString*    SRBookmarkTypeRoot;

// Browser
extern NSString*    SRBrowserShiira;
extern NSString*    SRBrowserSafari;
extern NSString*    SRBrowserFirefox;
extern NSString*    SRBrowserCamino;
extern NSString*    SRBrowserIE;
extern NSString*    SRBrowserOmniWeb;
extern NSString*    SRBrowserOpera;
extern NSString*    SRBrowserICab;

// Search engine type
extern NSString*    SRSearchEngineTypeEngine;
extern NSString*    SRSearchEngineTypeFolder;
extern NSString*    SRSearchEngineTypeSeparator;

// Support file names
extern NSString*    SRBookmarksFileName;
extern NSString*    SRHistoryFileName;
extern NSString*    SRSearchEnginesFileName;
extern NSString*    SRSearchEngineIconFileName;
extern NSString*    SRKeyBindingsFileName;

// Pasteboard data type
extern NSString*    SRBookmarkPboardType;
extern NSString*    SRPageInfoPboardType;

extern NSString*    CorePasteboardFlavorType_rtf;
extern NSString*    CorePasteboardFlavorType_utxt;
extern NSString*    CorePasteboardFlavorType_ustl;
extern NSString*    CorePasteboardFlavorType_TEXT;
extern NSString*    CorePasteboardFlavorType_styl;
extern NSString*    CorePasteboardFlavorType_url;
extern NSString*    CorePasteboardFlavorType_urln;
extern NSString*    WebURLsWithTitlesPboardType;

// Bookmark element name for Safari
extern NSString*    SafariBookmarkChildrenName;
extern NSString*    SafariBookmarkTitleName;
extern NSString*    SafariBookmarkTypeName;
extern NSString*    SafariBookmarksTypeListName;
extern NSString*    SafariBookmarksTypeLeafName;
extern NSString*    SafariBookmarkURLName;
extern NSString*    SafariBookmarkURIDictionaryName;
extern NSString*    SafariBookmarkURITitleName;
extern NSString*    SafariBookmarkAutoTabName;
extern NSString*    SafariBookmarkUUIDName;

extern NSString*    SafariBookmarkVersion;

extern NSString*    SafariBookmarksBarName;
extern NSString*    SafariBookmarksMenuName;
extern NSString*    SafariAddressBookMenuName;
extern NSString*    SafariRendezbousMenuName;
extern NSString*    SafariHistoryMenuName;

// Notifications
extern NSString*    SRBookmarkUpdated;
extern NSString*    SRWebHistoryUpdated;

