/*
HMWebKitEx.h

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>
#import <WebKit/WebKit.h>

struct WebCoreTextStyle
{
    NSColor*    textColor;
    NSColor*    backgroundColor;
    float       letterSpacing;
    float       wordSpacing;
    float       padding;
    float       tabWidth;
    float       xpos;
    NSString**  families;
    unsigned    smallCaps : 1;
    unsigned    rtl : 1;
    unsigned    visuallyOrdered : 1;
    unsigned    applyRunRounding : 1;
    unsigned    applyWordRounding : 1;
    unsigned    attemptFontSubstitution : 1;
};

struct WebCoreTextRun
{
    const UniChar*  characters;
    unsigned int    length;
    int             from;
    int             to;
};

struct WebCoreTextGeometry
{
    NSPoint point;
    float   selectionY;
    float   selectionHeight;
    bool    useFontMetricsForSelectionYAndHeight : 1;
};

@interface DOMNode (DOMNodeExtensions)
- (NSRect)boundingBox;
@end

@interface NSPasteboard (WebExtras)
+ (void)initialize;
+ (id)_web_writableTypesForURL;
+ (id)_web_writableTypesForImageIncludingArchive:(BOOL)fp8;
+ (id)_web_dragTypesForURL;
+ (int)_web_setFindPasteboardString:(id)fp8 withOwner:(id)fp12;
- (id)_web_bestURL;
- (void)_web_writeURL:(id)fp8 andTitle:(id)fp12 types:(id)fp16;
- (void)_web_writeFileWrapperAsRTFDAttachment:(id)fp8;
- (void)_web_writeImage:(id)fp8 URL:(id)fp12 title:(id)fp16 archive:(id)fp20 types:(id)fp24;
- (id)_web_declareAndWriteDragImage:(id)fp8 URL:(id)fp12 title:(id)fp16 archive:(id)fp20 source:(id)fp24;
@end

@interface NSURL (WebNSURLExtras)
+ (id)_web_URLWithUserTypedString:(id)fp8;
- (id)_web_userVisibleString;
- (id)_web_hostString;
@end

@protocol WebCoreImageRenderer <NSObject, NSCopying>
- (BOOL)incrementalLoadWithBytes:(const void *)fp8 length:(unsigned int)fp12 complete:(BOOL)fp16 callback:(id)fp20;
- (struct _NSSize)size;
- (void)resize:(struct _NSSize)fp8;
- (void)drawImageInRect:(struct _NSRect)fp8 fromRect:(struct _NSRect)fp24;
- (void)drawImageInRect:(struct _NSRect)fp8 fromRect:(struct _NSRect)fp24 compositeOperator:(int)fp40 context:(struct CGContext *)fp44;
- (void)stopAnimation;
- (void)tileInRect:(struct _NSRect)fp8 fromPoint:(struct _NSPoint)fp24 context:(struct CGContext *)fp32;
- (BOOL)isNull;
- (id)retainOrCopyIfNeeded;
- (void)increaseUseCount;
- (void)decreaseUseCount;
- (void)flushRasterCache;
- (struct CGImage *)imageRef;
- (void)resetAnimation;
@end

@interface WebFrame (Resources)
- (NSArray*)subresources;
@end

@interface WebPreferences (Preferences)
- (BOOL)isPlugInsEnabled;
@end

@protocol WebDocumentDragging <NSObject>
@end
@protocol WebDocumentElement <NSObject>
@end
@protocol WebDocumentSelection <NSObject>
@end

@interface WebHTMLView : NSView <WebDocumentView, WebDocumentSearching, WebDocumentText, WebDocumentDragging, WebDocumentElement, WebDocumentSelection>
{
    id  _private;
}
- (void)_layoutIfNeeded;
- (void)_resetCachedWebPreferences:(NSNotification*)ignored;
- (void)jumpToSelection:(id)sender;

- (unsigned)markAllMatchesForText:(NSString *)string caseSensitive:(BOOL)caseFlag limit:(unsigned)limit;
- (void)unmarkAllTextMatches;
- (void)setMarkedTextMatchesAreHighlighted:(BOOL)newValue;
- (BOOL)markedTextMatchesAreHighlighted;
- (NSArray *)rectsForTextMatches;
@end

extern NSString*    WebIconDatabaseDidAddIconNotification;

@interface WebIconDatabase : NSObject
{
    id _private;
}
+ (WebIconDatabase*)sharedIconDatabase;
- (NSImage*)iconForURL:(NSString*)URL withSize:(NSSize)size;
- (NSImage*)iconForURL:(NSString*)urlString withSize:(NSSize)size cache:(BOOL)flag;
- (NSString*)iconURLForURL:(NSString*)URL;
- (NSImage*)defaultIconWithSize:(NSSize)size;
- (void)retainIconForURL:(NSString*)URL;
- (void)releaseIconForURL:(NSString*)URL;
- (void)delayDatabaseCleanup;
- (void)allowDatabaseCleanup;
@end

@interface WebIconDatabase (WebPrivate)
- (BOOL)_isEnabled;
- (void)_setIcon:(NSImage*)icon forIconURL:(NSString*)iconURL;
- (void)_setHaveNoIconForIconURL:(NSString*)iconURL;
- (void)_setIconURL:(NSString*)iconURL forURL:(NSString*)URL;
- (BOOL)_hasIconForIconURL:(NSString*)iconURL;
@end

@interface WebURLsWithTitles : NSObject
{
}

+ (id)arrayWithIFURLsWithTitlesPboardType;
+ (void)writeURLs:(id)fp8 andTitles:(id)fp12 toPasteboard:(id)fp16;
+ (id)titlesFromPasteboard:(id)fp8;
+ (id)URLsFromPasteboard:(id)fp8;
@end

@interface WebURLsWithTitles (NSURLExtras)
+ (id)_web_userVisibleURLStringsFromPasteboard:(NSPasteboard*)pboard;
@end

@interface WebView (Frame)
- (NSArray*)webFrames;
@end

@interface WebView (DocumentText)
- (NSString*)selectedString;
@end

@interface WebView (DOMDocument)
- (NSArray*)DOMDocuments;
- (BOOL)containsDOMDocument:(DOMDocument*)document;
- (WebFrame*)webFrameForDOMDocument:(DOMDocument*)document;
@end

@interface WebView (WebPrivate)
+ (BOOL)_canHandleRequest:(id)request;

- (void)_close;

- (BOOL)canMakeTextStandardSize;
- (IBAction)makeTextStandardSize:(id)sender;
@end

@interface WebView (WebPendingPublic)
- (void)setMainFrameURL:(id)fp8;
- (id)mainFrameURL;
- (BOOL)isLoading;
- (id)mainFrameTitle;
- (id)mainFrameIcon;
- (void)setDrawsBackground:(BOOL)fp8;
- (BOOL)drawsBackground;
- (void)toggleSmartInsertDelete:(id)fp8;
- (void)toggleContinuousSpellChecking:(id)fp8;
- (BOOL)isContinuousGrammarCheckingEnabled;
- (void)setContinuousGrammarCheckingEnabled:(BOOL)fp8;
- (void)toggleContinuousGrammarChecking:(id)fp8;
- (void)setScriptDebugDelegate:(id)fp8;
- (id)scriptDebugDelegate;
- (BOOL)shouldClose;
@end




@interface WebFrame (WebKitDebug)
- (id)renderTreeAsExternalRepresentation;
@end

@protocol WebCoreTextRenderer <NSObject>
- (int)ascent;
- (int)descent;
- (int)lineSpacing;
- (float)xHeight;
- (float)floatWidthForRun:(const struct WebCoreTextRun *)fp8 style:(const struct WebCoreTextStyle *)fp12 widths:(float *)fp16;
- (void)drawRun:(const struct WebCoreTextRun *)fp8 style:(const struct WebCoreTextStyle *)fp12 geometry:(const struct WebCoreTextGeometry *)fp16;
- (void)drawHighlightForRun:(const struct WebCoreTextRun *)fp8 style:(const struct WebCoreTextStyle *)fp12 geometry:(const struct WebCoreTextGeometry *)fp16;
- (void)drawLineForCharacters:(struct _NSPoint)fp8 yOffset:(float)fp16 width:(int)fp20 color:(id)fp24 thickness:(float)fp28;
- (void)drawLineForMisspelling:(struct _NSPoint)fp8 withWidth:(int)fp16;
- (int)misspellingLineThickness;
- (int)pointToOffset:(const struct WebCoreTextRun *)fp8 style:(const struct WebCoreTextStyle *)fp12 position:(int)fp16 reversed:(BOOL)fp20 includePartialGlyphs:(BOOL)fp24;
@end

@interface WebTextRenderer : NSObject <WebCoreTextRenderer>
{
    int ascent;
    int descent;
    int lineSpacing;
    int lineGap;
    struct LLCStyleInfo *styleGroup;
    NSFont *font;
    struct GlyphMap *characterToGlyphMap;
    struct UnicodeGlyphMap *unicodeCharacterToGlyphMap;
    struct WidthMap *glyphToWidthMap;
    BOOL treatAsFixedPitch;
    unsigned short spaceGlyph;
    float spaceWidth;
    float adjustedSpaceWidth;
    int numSubstituteFontWidthMaps;
    int maxSubstituteFontWidthMaps;
    struct SubstituteFontWidthMap *substituteFontWidthMaps;
    BOOL usingPrinterFont;
    BOOL isSmallCapsRenderer;
    WebTextRenderer *smallCapsRenderer;
    NSFont *smallCapsFont;
    struct OpaqueATSUStyle *_ATSUSstyle;
    BOOL ATSUStyleInitialized;
    BOOL ATSUMirrors;
}

+ (id)webFallbackFontFamily;
+ (BOOL)shouldBufferTextDrawing;
+ (void)initialize;
- (id)initWithFont:(id)fp8 usingPrinterFont:(BOOL)fp12;
- (void)dealloc;
- (void)finalize;
- (int)ascent;
- (int)descent;
- (int)lineSpacing;
- (float)xHeight;
- (void)drawRun:(const struct WebCoreTextRun *)fp8 style:(const struct WebCoreTextStyle *)fp12 geometry:(const struct WebCoreTextGeometry *)fp16;
- (float)floatWidthForRun:(const struct WebCoreTextRun *)fp8 style:(const struct WebCoreTextStyle *)fp12 widths:(float *)fp16;
- (void)drawLineForCharacters:(struct _NSPoint)fp8 yOffset:(float)fp16 width:(int)fp20 color:(id)fp24 thickness:(float)fp28;
- (void)drawHighlightForRun:(const struct WebCoreTextRun *)fp8 style:(const struct WebCoreTextStyle *)fp12 geometry:(const struct WebCoreTextGeometry *)fp16;
- (int)misspellingLineThickness;
- (int)misspellingLinePatternWidth;
- (int)misspellingLinePatternGapWidth;
- (void)drawLineForMisspelling:(struct _NSPoint)fp8 withWidth:(int)fp16;
- (int)pointToOffset:(const struct WebCoreTextRun *)fp8 style:(const struct WebCoreTextStyle *)fp12 position:(int)fp16 reversed:(BOOL)fp20 includePartialGlyphs:(BOOL)fp24;

@end

@interface WebTextRenderer (WebInternal)
+ (void)_setAlwaysUseATSU:(BOOL)fp8;
- (void)_setIsSmallCapsRenderer:(BOOL)fp8;
- (BOOL)_isSmallCapsRenderer;
- (id)_smallCapsRenderer;
- (id)_smallCapsFont;
- (id)_substituteFontForString:(id)fp8 families:(id *)fp12;
- (id)_substituteFontForCharacters:(const unsigned short *)fp8 length:(int)fp12 families:(id *)fp16;
- (void)_convertCharacters:(const unsigned short *)fp8 length:(unsigned int)fp12 toGlyphs:(struct ATSGlyphVector *)fp16;
- (void)_convertUnicodeCharacters:(const unsigned int *)fp8 length:(unsigned int)fp12 toGlyphs:(struct ATSGlyphVector *)fp16;
- (BOOL)_computeWidthForSpace;
- (BOOL)_setupFont;
- (void)_CG_drawHighlightForRun:(const struct WebCoreTextRun *)fp8 style:(const struct WebCoreTextStyle *)fp12 geometry:(const struct WebCoreTextGeometry *)fp16;
- (void)_CG_drawRun:(const struct WebCoreTextRun *)fp8 style:(const struct WebCoreTextStyle *)fp12 geometry:(const struct WebCoreTextGeometry *)fp16;
- (unsigned short)_extendUnicodeCharacterToGlyphMapToInclude:(unsigned long)fp8;
- (void)_updateGlyphEntryForCharacter:(unsigned short)fp8 glyphID:(unsigned short)fp12 font:(id)fp16;
- (unsigned short)_extendCharacterToGlyphMapToInclude:(unsigned short)fp8;
- (struct WidthMap *)_extendGlyphToWidthMapToInclude:(unsigned short)fp8 font:(id)fp12;
- (void)_initializeATSUStyle;
- (struct OpaqueATSUTextLayout *)_createATSUTextLayoutForRun:(const struct WebCoreTextRun *)fp8 style:(const struct WebCoreTextStyle *)fp12;
- (void)_ATSU_drawHighlightForRun:(const struct WebCoreTextRun *)fp8 style:(const struct WebCoreTextStyle *)fp12 geometry:(const struct WebCoreTextGeometry *)fp16;
- (void)_ATSU_drawRun:(const struct WebCoreTextRun *)fp8 style:(const struct WebCoreTextStyle *)fp12 geometry:(const struct WebCoreTextGeometry *)fp16;
- (int)_ATSU_pointToOffset:(const struct WebCoreTextRun *)fp8 style:(const struct WebCoreTextStyle *)fp12 position:(int)fp16 reversed:(BOOL)fp20 includePartialGlyphs:(BOOL)fp24;
- (int)_CG_pointToOffset:(const struct WebCoreTextRun *)fp8 style:(const struct WebCoreTextStyle *)fp12 position:(int)fp16 reversed:(BOOL)fp20 includePartialGlyphs:(BOOL)fp24;
@end
