/*
SRSearchEngineShelf.m

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "SRSearchEngineShelf.h"

#import "SRConstants.h"

@implementation SRSearchEngineShelf

//--------------------------------------------------------------//
#pragma mark -- Initialize --
//--------------------------------------------------------------//

- (void)didLoad
{
    // Create buttons
    _contextButton = [[NSClassFromString(@"HMMenuButton") alloc] initWithFrame:NSMakeRect(0, 0, 31, 19)];
    [_contextButton setButtonType:NSMomentaryChangeButton];
    [_contextButton setBezelStyle:NSRegularSquareBezelStyle];
    [_contextButton setBordered:NO];
    [_contextButton setImage:[NSImage imageNamed:@"shelfContext"]];
    [_contextButton setSelectedImage:[NSImage imageNamed:@"shelfPressedBackgroundL"]];
    [_contextButton setMenu:_contextMenu];
    
    // Configure outline
    [_outlineView setAutoresizesOutlineColumn:NO];
    
    // Set image text cell
    NSTableColumn*  column;
    id              cell, oldCell;
    
    cell = [[NSClassFromString(@"HMImageTextFieldCell") alloc] init];
    column = [_outlineView tableColumnWithIdentifier:@"title"];
    oldCell = [column dataCell];
    [cell setFont:[oldCell font]];
    [column setDataCell:cell];
    [cell release];
    
    cell = [[NSClassFromString(@"HMButtonCell") alloc] init];
    column = [_outlineView tableColumnWithIdentifier:@"on"];
    oldCell = [column dataCell];
    [cell setBezelStyle:[oldCell bezelStyle]]; 
    [cell setButtonType:NSSwitchButton];
    [cell setControlSize:[oldCell controlSize]];
    [cell setTitle:[oldCell title]];
    [cell setImagePosition:[oldCell imagePosition]];
    [column setDataCell:cell];
    [cell release];
    
    cell = [[NSClassFromString(@"HMImageTextFieldCell") alloc] init];
    column = [_outlineView tableColumnWithIdentifier:@"key"];
    oldCell = [column dataCell];
    [cell setFont:[oldCell font]];
    [column setDataCell:cell];
    [cell release];
    
    cell = [[NSClassFromString(@"HMImageTextFieldCell") alloc] init];
    column = [_outlineView tableColumnWithIdentifier:@"template"];
    oldCell = [column dataCell];
    [cell setFont:[oldCell font]];
    [column setDataCell:cell];
    [cell release];
    
    // Configure split view
    [_splitView setSplitType:HMSplitWide];
    
    // Configure tree controller
    NSSortDescriptor*   sortDescriptor;
    sortDescriptor = [[NSSortDescriptor alloc] initWithKey:@"index" ascending:YES];
    [_searchEngineTreeController setSortDescriptors:[NSArray arrayWithObject:sortDescriptor]];
    [sortDescriptor release];
}

- (void)dealloc
{
    [_contextButton release], _contextButton = nil;
    
    [super dealloc];
}

//--------------------------------------------------------------//
#pragma mark -- Bar buttons --
//--------------------------------------------------------------//

- (NSArray*)rightBarButtons
{
    return [NSArray arrayWithObjects:_contextButton, nil];
}

//--------------------------------------------------------------//
#pragma mark -- NSOutlineView delegate --
//--------------------------------------------------------------//

- (void)outlineView:(NSOutlineView*)outlineView 
        willDisplayCell:(id)cell 
        forTableColumn:(NSTableColumn*)column 
        item:(id)item
{
    // History outline
    if (outlineView == _outlineView) {
        // Get column identifier
        id  identifier;
        identifier = [column identifier];
        
        // For title column
        if ([identifier isEqualToString:@"title"]) {
            // Set image
            if ([item respondsToSelector:@selector(observedObject)]) {
                id  observedObject;
                observedObject = [item performSelector:@selector(observedObject)];
                
                NSString*   type;
                type = [observedObject valueForKey:@"type"];
                if ([type isEqualToString:SRSearchEngineTypeEngine]) {
                    [cell setImage:[NSImage imageNamed:@"searchEngine"]];
                    [cell setSeparator:NO];
                }
                else if ([type isEqualToString:SRSearchEngineTypeFolder]) {
                    [cell setImage:[NSImage imageNamed:@"genericFolder"]];
                    [cell setSeparator:NO];
                }
                else if ([type isEqualToString:SRSearchEngineTypeSeparator]) {
                    [cell setImage:nil];
                    [cell setSeparator:YES];
                }
                else {
                    [cell setImage:nil];
                    [cell setSeparator:NO];
                }
            }
            
            return;
        }
        
        // For on, key and template column
        if ([identifier isEqualToString:@"on"] || 
            [identifier isEqualToString:@"key"]|| 
            [identifier isEqualToString:@"template"])
        {
            // Set separator
            if ([item respondsToSelector:@selector(observedObject)]) {
                id  observedObject;
                observedObject = [item performSelector:@selector(observedObject)];
                
                NSString*   type;
                type = [observedObject valueForKey:@"type"];
                if ([type isEqualToString:SRSearchEngineTypeSeparator]) {
                    [cell setImage:nil];
                    [cell setSeparator:YES];
                }
                else {
                    [cell setImage:nil];
                    [cell setSeparator:NO];
                }
            }
        }
    }
}

@end
