/*
RSSController.h

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>
#import <WebKit/WebKit.h>
#import "HMDTFoundation.h"
#import "HMDTAppKit.h"

enum {
    RSSListStyle = 0, 
    RSSTableStyle = 1, 
};

@class HMButton;
@class HMSplitView;
@class RSSBar;

@interface RSSController : NSObject
{
    id          _feed;
    
    HMButton*   _listButton;
    HMButton*   _tableButton;
    
    IBOutlet NSArrayController* _itemArrayController;
    IBOutlet NSView*            _view;
    IBOutlet RSSBar*            _rssBar;
    IBOutlet NSView*            _lowerView;
    
    IBOutlet NSView*            _listView;
    IBOutlet HMSplitView*       _listSplitView;
    IBOutlet NSTableView*       _listTableView;
    IBOutlet WebView*           _listWebView;
    
    IBOutlet NSView*            _tableView;
    IBOutlet WebView*           _tableWebView;
}

// View
- (NSView*)view;

// Display style
- (void)setDisplayStyle:(int)displayStyle;

// WebDataSource loading
- (void)finishedLoadingWithDataSource:(WebDataSource*)dataSource;

// Feed
- (NSString*)title;
- (NSString*)link;

// Persistent stack
- (NSManagedObjectContext*)managedObjectContext;

@end
