/*
SRBookmarkProxy.h

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>
#import <WebKit/WebKit.h>

@protocol SRBrowserController

// Open page with URL string
- (id)openURLString:(NSString*)URLString;
- (id)openURLString:(NSString*)URLString atIndex:(int)index;
- (id)openInNewTabURLString:(NSString*)URLString;
- (id)openInNewTabURLString:(NSString*)URLString select:(BOOL)select;
- (id)openInNewWindowURLString:(NSString*)URLString;
- (id)openInNewBackgroundWindowURLString:(NSString*)URLString;
- (id)openInNewTabsURLStrings:(NSArray*)URLStrings select:(BOOL)select;

// Open page with bookmark
- (id)openBookmark:(id)bookmark;
- (id)openInNewTabBookmark:(id)bookmark;
- (id)openInNewTabBookmark:(id)bookmark select:(BOOL)select;
- (id)openInNewWindowBookmark:(id)bookmark;
- (id)openInNewBackgroundWindowBookmark:(id)bookmark;
- (id)openInTabsBookmark:(id)bookmark;
- (id)openInTabsBookmarks:(NSArray*)bookmarks;

// Opening page with history
- (id)openHistory:(WebHistoryItem*)historyItem;
- (id)openHistory:(WebHistoryItem*)historyItem atIndex:(int)index;
- (id)openInNewTabHistory:(WebHistoryItem*)historyItem;
- (id)openInNewTabHistory:(WebHistoryItem*)historyItem select:(BOOL)select;
- (id)openInNewWindowHistory:(WebHistoryItem*)historyItem;
- (id)openInNewBackgroundWindowHistory:(WebHistoryItem*)historyItem;
- (id)openInTabsHistory:(NSArray*)historyItems;

@end
