/*
SRPlugInView.m

Author: Makoto Kinoshita

Copyright 2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "SRAppController.h"
#import "SRWebHistory.h"

#import "SRPlugIn.h"
#import "SRPlugInRepresentation.h"
#import "SRPlugInView.h"

@implementation SRPlugInView

//--------------------------------------------------------------//
#pragma mark -- Initialize --
//--------------------------------------------------------------//

- (id)initWithFrame:(NSRect)frame
{
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    // Configure itself
    [self setAutoresizingMask:NSViewWidthSizable | NSViewHeightSizable];
    
    return self;
}

//--------------------------------------------------------------//
#pragma mark -- Drawing --
//--------------------------------------------------------------//

- (void)drawRect:(NSRect)rect
{
    // Fill with background
    NSDrawWindowBackground(rect);
}

- (void)_layoutIfNeeded
{
    [self layout];
}

//--------------------------------------------------------------//
#pragma mark -- WebDocumentView protocol --
//--------------------------------------------------------------//

- (void)setDataSource:(WebDataSource*)dataSource
{
    if (_dataSource != dataSource) {
        _dataSource = dataSource;
    }
}

- (void)dataSourceUpdated:(WebDataSource*)dataSource
{
    if (_dataSource != dataSource) {
        _dataSource = dataSource;
    }
}

- (void)setNeedsLayout:(BOOL)flag
{
}

- (void)layout
{
    // Update its frame
    NSRect  frame, parentFrame;
    frame = [self frame];
    parentFrame = [[self superview] frame];
    if (!NSEqualSizes(frame.size, parentFrame.size)) {
        frame.origin = NSZeroPoint;
        frame.size = parentFrame.size;
        [self setFrame:frame];
    }
    
    // Check subviews
    if ([[self subviews] count] > 0) {
        return;
    }
    
    // Get plug-in
    SRPlugInRepresentation* representation;
    SRPlugIn*               plugIn;
    representation = [_dataSource representation];
    plugIn = [representation plugIn];
    if (!plugIn) {
        return;
    }
    
    // Set controllers
    [plugIn setAppController:[SRAppController sharedInstance]];
    
    id  browserController;
    browserController = [[self window] windowController];
    if ([browserController conformsToProtocol:@protocol(SRBrowserController)]) {
        [plugIn setBrowserController:browserController];
    }
    //[plugIn setPageController:[]];
    [plugIn setWebHistory:[SRWebHistory sharedInstance]];
    
    [plugIn loadMainNib];
    [plugIn didLoad];
    
    // Add plug-in view
    NSView* view;
    view = [plugIn mainView];
    
    NSRect  rect;
    rect.origin = NSZeroPoint;
    rect.size = frame.size;
    [view setFrame:rect];
    [self addSubview:view];
}

- (void)viewDidMoveToHostWindow
{
}

- (void)viewWillMoveToHostWindow:(NSWindow*)hostWindow
{
}

@end
