/*
SRTabExposeController.h

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>
#import <WebKit/WebKit.h>
#import "HMDTFoundation.h"
#import "HMDTAppKit.h"

@class SRBrowserController;

@interface SRExposeTitle : HMGLText
{
    NSAttributedString* _titleAttr;
    NSAttributedString* _subTitleAttr;
    NSSize              _size;
}

// Title
- (void)setTitle:(NSString*)title subTitle:(NSString*)subTitle;

// Drawing
- (void)drawTextureInWindowFrame:(NSRect)windowFrame screenFrame:(NSRect)screenFrame;

@end

@interface SRExposeView : HMGLView
{
    NSMutableArray* _images;
    SRExposeTitle*  _title;
    
    int             _selectedIndex;
    int             _lastIndex;
}

// Accessors
- (NSArray*)images;
- (void)setImages:(NSArray*)images;
- (void)setSelectedIndex:(int)selectedIndex;

@end

enum {
    SRTabExposeExposingIn = 0, 
    SRTabExposeExposing, 
    SRTabExposeExposingOut, 
    SRTabExposeDeexpose, 
};

@interface SRTabExposeController : NSObject
{
    SRBrowserController*    _browserController;
    
    NSWindow*               _exposeWindow;
    SRExposeView*           _exposeView;
    
    NSMutableArray*         _currentFrames;
    NSMutableArray*         _finalFrames;
    float                   _progress;
    
    NSRect                  _origFrame;
    int                     _exposeState;
    NSTimeInterval          _duration;
}

// Controller
- (SRBrowserController*)browserController;
- (void)setBrowserController:(SRBrowserController*)browserController;

// Expose
+ (BOOL)isExposing;
+ (SRTabExposeController*)currentController;
- (void)startExposingIn;
- (void)startExposingOut;
- (NSArray*)currentFrames;
- (NSArray*)finalFrames;
- (float)progress;

- (void)expose;
- (void)deexpose;
- (void)deexposeAndSelectAtIndex:(int)index;
- (int)exposeState;

- (void)mouseMoved:(NSEvent*)event;

@end
