/*
SRPageInfoController.h

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>
#import <WebKit/WebKit.h>
#import "HMDTFoundation.h"
#import "HMDTAppKit.h"
#import "HMDTWebKit.h"

@class SRPageController;

@interface SRPageInfoController : NSWindowController
{
    NSMutableArray*                 _profiles;
    BOOL                            _isInitialized;
    
    NSMatrix*                       _imagesMatrix;
    NSMutableArray*                 _images;
    
    NSAttributedString*             _htmlSourceString;
    
    IBOutlet NSObjectController*    _objectController;
    
    IBOutlet HMSplitView*           _splitView;
    IBOutlet HMTableView*           _profileTableView;
    IBOutlet NSView*                _infoView;
    
    IBOutlet NSView*                _generalView;
    IBOutlet NSTreeController*      _httpHeaderTreeController;
    IBOutlet NSOutlineView*         _httpHeaderOutlineView;
    
    IBOutlet NSView*                _linksView;
    IBOutlet NSArrayController*     _linksArrayController;
    IBOutlet HMSplitView*           _linksSplitView;
    IBOutlet NSView*                _linksTableView;

    IBOutlet NSView*                _cssView;
    IBOutlet NSArrayController*     _cssArrayController;
    IBOutlet HMSplitView*           _cssSplitView;
    IBOutlet NSTableView*           _cssTableView;
    IBOutlet NSTextView*            _cssTextView;
    
    IBOutlet NSView*                _javaScriptView;
    IBOutlet NSArrayController*     _javaScriptArrayController;
    IBOutlet HMSplitView*           _javaScriptSplitView;
    IBOutlet NSTableView*           _javaScriptTableView;
    IBOutlet NSTextView*            _javaScriptTextView;
    
    IBOutlet NSView*                _imagesView;
    IBOutlet NSObjectController*    _imagesObjectController;
    IBOutlet NSMutableDictionary*   _imagesContent;
    IBOutlet HMSplitView*           _imagesSplitView;
    IBOutlet NSScrollView*          _imagesScrollView;
    
    IBOutlet NSView*                _sourceView;
    IBOutlet NSTextView*            _sourceTextView;
}

// Initialize
+ (SRPageInfoController*)pageInfoControllerWithPageController:(SRPageController*)pageController;

// Page info handling
- (NSString*)URLString;

- (NSString*)profileTitle;
- (void)setProfileWithTitle:(NSString*)title;

- (void)setPageInfoWithPageController:(SRPageController*)pageController;

@end
