/*
HMWebKitEx.m

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "HMWebKitEx.h"

@implementation WebFrame (Resources)

- (void)_addSubresourcesWithWebFrame:(WebFrame*)webFrame intoArray:(NSMutableArray*)subresources
{
    // Get subresources
    NSArray*    sub;
    sub = [[webFrame dataSource] subresources];
    if ([sub count] > 0) {
        // Add subresources
        [subresources addObjectsFromArray:sub];
    }
    
    // Find in children
    NSEnumerator*   enumerator;
    WebFrame*       child;
    enumerator = [[webFrame childFrames] objectEnumerator];
    while (child = [enumerator nextObject]) {
        [self _addSubresourcesWithWebFrame:child intoArray:subresources];
    }
}

- (NSArray*)subresources
{
    // Collect all subresources
    NSMutableArray* subresources;
    subresources = [NSMutableArray array];
    [self _addSubresourcesWithWebFrame:self intoArray:subresources];
    
    return subresources;
}

@end

#pragma mark -

@implementation WebPreferences (Preferences)

- (BOOL)isPlugInsEnabled
{
    return [self arePlugInsEnabled];
}

@end

#pragma mark -

@implementation WebURLsWithTitles (NSURLExtras)

+ (id)_web_userVisibleURLStringsFromPasteboard:(NSPasteboard*)pboard
{
    // Get property list
    id  propertyList;
    propertyList = [pboard propertyListForType:@"WebURLsWithTitlesPboardType"];
    if (!propertyList || ![propertyList isKindOfClass:[NSArray class]]) {
        return nil;
    }
    
    // Get URL strings
    NSArray*    URLStrings;
    URLStrings = [propertyList objectAtIndex:0];
    if (!URLStrings || ![URLStrings isKindOfClass:[NSArray class]]) {
        return nil;
    }
    
    return URLStrings;
}

@end

#pragma mark -

@implementation WebView (DocumentText)

- (NSString*)_selectedStringOfChildFrame:(WebFrame*)frame
{
    // Get document view
    id  documentView;
    documentView = [[frame frameView] documentView];
    if (documentView) {
        // Get selected string
        if ([documentView respondsToSelector:@selector(selectedString)]) {
            NSString*   selectedString;
            selectedString = [documentView selectedString];
            if (selectedString && [selectedString length] > 0) {
                return selectedString;
            }
        }
    }
    
    // Find in child frames
    NSArray*    childFrames;
    childFrames = [frame childFrames];
    if (!childFrames) {
        return nil;
    }
    
    NSEnumerator*   enumerator;
    WebFrame*       childFrame;
    enumerator = [childFrames objectEnumerator];
    while (childFrame = [enumerator nextObject]) {
        NSString*   selectedString;
        selectedString = [self _selectedStringOfChildFrame:childFrame];
        if (selectedString && [selectedString length] > 0) {
            return selectedString;
        }
    }
    
    return nil;
}

- (NSString*)selectedString
{
    return [self _selectedStringOfChildFrame:[self mainFrame]];
}

@end
