/*
HMTabView.h

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>
#import "HMSplitView.h"

@class HMTabView;
@class HMTabViewItem;
@class HMTabItemGroupView;

typedef enum _HMTabViewPosition {
    HMTabViewTop = 0, 
    HMTabViewLeft = 1, 
    HMTabViewRight = 2, 
    HMTabViewBottom = 3, 
} HMTabViewPosition;

@interface HMTabSplitView : HMSplitView
{
    HMTabView*  _tabView;
}

// Tab view
- (HMTabView*)tabView;
- (void)setTabView:(HMTabView*)tabView;

@end

@interface HMTabView : NSView
{
    NSMutableArray*     _tabViewItems;
    HMTabViewPosition   _tabViewPosition;
    id                  _delegate;
    BOOL                _hasThumbnail;
    BOOL                _isTabItemViewShown;
    BOOL                _isAnimating;
    BOOL                _stopLayout;
    int                 _tabViewHigh;
    
    HMTabSplitView*     _splitView;
    
    NSTabView*          _tabView;
    
    NSScrollView*       _scrollView;
    HMTabItemGroupView* _tabItemGroupView;
}

// Line color
+ (NSColor*)lineColorWithWindow:(NSWindow*)window;
+ (NSColor*)highlightLineColorWithWindow:(NSWindow*)window;

// Tab items
- (void)addTabViewItem:(HMTabViewItem*)tabViewItem;
- (void)insertTabViewItem:(HMTabViewItem*)tabViewItem atIndex:(int)index;
- (void)removeTabViewItem:(HMTabViewItem*)tabViewItem;
- (void)moveTabViewItemAtIndex:(int)index toIndex:(int)toIndex;

- (int)indexOfTabViewItem:(HMTabViewItem*)tabViewItem;
- (int)indexOfTabViewItemWithIdentifier:(id)identifier;
- (int)numberOfTabViewItems;
- (HMTabViewItem*)tabViewItemAtIndex:(int)index;
- (NSArray*)tabViewItems;

- (int)indexOfCloseButton:(NSButton*)closeButton;

// Tab selection
- (void)selectTabViewItem:(HMTabViewItem*)tabViewItem;
- (void)selectTabViewItemAtIndex:(int)index;
- (void)selectTabViewItemWithIdentifier:(id)identifier;
- (HMTabViewItem*)selectedTabViewItem;
- (int)indexOfSelectedTabViewItem;

// Tab position
- (HMTabViewPosition)tabViewPosition;
- (void)setTabViewPoision:(HMTabViewPosition)tabViewPosition;

// Separator and tab
- (BOOL)hasThumbnail;
- (void)setHasThumbnail:(BOOL)hasThumbnail;
- (BOOL)isTabItemViewShown;
- (void)setTabItemViewShown:(BOOL)isShown;
- (int)tabItemViewHigh;
- (void)setTabItemViewHigh:(int)high;

// Delegate
- (id)delegate;
- (void)setDelegate:(id)delegate;

// Subviews
- (HMTabItemGroupView*)tabItemGroupView;
- (NSTabView*)nsTabView;
- (HMSplitView*)splitView;

// Layout
- (void)updateLayout;

@end

@interface NSObject (HMTabViewDelegate)
- (BOOL)hmTabView:(HMTabView*)tabView shouldSelectTabViewItem:(HMTabViewItem*)tabViewItem;
- (void)hmTabView:(HMTabView*)tabView willSelectTabViewItem:(HMTabViewItem*)tabViewItem;
- (void)hmTabView:(HMTabView*)tabView didSelectTabViewItem:(HMTabViewItem*)tabViewItem;
- (void)hmTabViewDidChangeNumberOfTabViewItems:(HMTabView*)tabView;
- (void)hmTabViewDidMoveTabViewItems:(HMTabView*)tabView;

- (void)hmTabViewStartDragging:(HMTabView*)tabView;
- (void)hmTabViewEndDragging:(HMTabView*)tabView;

- (void)hmTabView:(HMTabView*)tabView insertPboard:(NSPasteboard*)pboard atTabIndex:(int)index;

@end
