/*
HMOutlineView.m

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "HMOutlineView.h"

@implementation HMOutlineView

//--------------------------------------------------------------//
#pragma mark -- Initialize --
//--------------------------------------------------------------//

- (void)_init
{
    // Initialize instance variables
    _wantsLiveResizeToUseCachedImage = YES;
}

- (id)initWithFrame:(NSRect)frame
{
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    // Common init
    [self _init];
    
    return self;
}

- (id)initWithCoder:(NSCoder*)coder
{
    self = [super initWithCoder:coder];
    if (!self) {
        return nil;
    }
    
    // Common init
    [self _init];
    
    return self;
}

- (void)dealloc
{
    [_indexSet release], _indexSet = nil;
    
    [super dealloc];
}

//--------------------------------------------------------------//
#pragma mark -- Live resize --
//--------------------------------------------------------------//

- (BOOL)wantsLiveResizeToUseCachedImage
{
    return _wantsLiveResizeToUseCachedImage;
}

- (void)setWantsLiveResizeToUseCachedImage:(BOOL)flag
{
    _wantsLiveResizeToUseCachedImage = flag;
}

- (BOOL)_wantsLiveResizeToUseCachedImage
{
    return _wantsLiveResizeToUseCachedImage;
}

//--------------------------------------------------------------//
#pragma mark -- Previous selected row indexes --
//--------------------------------------------------------------//

- (NSIndexSet*)previousSelectedRowIndexes
{
    return _indexSet;
}

//--------------------------------------------------------------//
#pragma mark -- Cell attributes --
//--------------------------------------------------------------//

- (NSRect)frameOfCellAtColumn:(int)column row:(int)row
{
    // Invoke super
    NSRect  cellFrame;
    cellFrame = [super frameOfCellAtColumn:column row:row];
    
    // Invoke delegate
    id  delegate;
    delegate = [self delegate];
    if ([delegate respondsToSelector:@selector(hmOutlineView:frameOfCellAtColumn:row:proposedFrame:)]) {
        NSRect  frame;
        frame = cellFrame;
        if ([delegate hmOutlineView:self frameOfCellAtColumn:column row:row proposedFrame:&frame]) {
            return frame;
        }
    }
    
    return cellFrame;
}

//--------------------------------------------------------------//
#pragma mark -- NSResponder override --
//--------------------------------------------------------------//

- (void)mouseDown:(NSEvent*)event
{
    // Keep selected rows
    [_indexSet release], _indexSet = nil;
    _indexSet = [[self selectedRowIndexes] copy];
    
    // Invoke super
    [super mouseDown:event];
}

@end
