/*
SRXMLNode.h

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Foundation/Foundation.h>

typedef enum {
	SRXMLInvalidKind = 0,
	SRXMLDocumentKind,
	SRXMLElementKind,
	SRXMLAttributeKind,
	SRXMLNamespaceKind,
	SRXMLProcessingInstructionKind,
	SRXMLCommentKind,
	SRXMLTextKind,
	SRXMLDTDKind,
	SRXMLEntityDeclarationKind,
	SRXMLAttributeDeclarationKind,
	SRXMLElementDeclarationKind,
	SRXMLNotationDeclarationKind
} SRXMLNodeKind;

@class SRXMLDocument;
@class SRXMLNodePrivate;

@interface SRXMLNode : NSObject
{
	SRXMLNodePrivate*	_nodePrivate;
}

// Initialize
+ (id)document;
- (id)initWithKind:(SRXMLNodeKind)kind;
- (id)initWithKind:(SRXMLNodeKind)kind options:(unsigned int)options;

// Node attributes
- (SRXMLNodeKind)kind;
- (NSString*)name;
- (void)setName:(NSString*)name;
- (NSString*)stringValue;
- (void)setStringValue:(NSString*)string;
- (NSString*)URI;
- (void)_setURI:(NSString*)URI;

// Tree navigation
- (SRXMLNode*)childAtIndex:(unsigned int)index;
- (unsigned int)childCount;
- (NSArray*)children;
- (SRXMLDocument*)rootDocument;

// Node output
- (NSString*)XMLString;
- (NSString*)XMLStringWithOptions:(unsigned int)options;

// Query executions
- (NSArray*)nodesForXPath:(NSString*)xpath error:(NSError**)error;
- (NSString*)XPath;

// Namespace handling
- (NSString*)prefix;

// Extension
- (SRXMLNode*)singleNodeForXPath:(NSString*)XPath;
- (NSString*)stringValueForXPath:(NSString*)XPath;

@end
