/*
SRView.m

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "SRView.h"

@implementation SRView

#pragma mark -
//--------------------------------------------------------------//
// Delegate
//--------------------------------------------------------------//

- (id)delegate
{
    return _delegate;
}

- (void)setDelegate:(id)delegate
{
    _delegate = delegate;
}

#pragma mark -
//--------------------------------------------------------------//
// View hierarchy
//--------------------------------------------------------------//

- (void)viewWillMoveToSuperview:(NSView*)newSuperview
{
    if (_delegate && [_delegate respondsToSelector:@selector(view:willMoveToSuperview:)]) {
        [_delegate view:self willMoveToSuperview:newSuperview];
    }
}

- (void)viewDidMoveToSuperview
{
    if (_delegate && [_delegate respondsToSelector:@selector(viewDidMoveToSuperview:)]) {
        [_delegate viewDidMoveToSuperview:self];
    }
}

- (void)viewWillMoveToWindow:(NSWindow*)newWindow
{
    if (_delegate && [_delegate respondsToSelector:@selector(view:willMoveToWindow:)]) {
        [_delegate view:self willMoveToWindow:newWindow];
    }
}

- (void)viewDidMoveToWindow
{
    if (_delegate && [_delegate respondsToSelector:@selector(viewDidMoveToWindow:)]) {
        [_delegate viewDidMoveToWindow:self];
    }
}

- (void)willRemoveSubview:(NSView*)subview
{
    if (_delegate && [_delegate respondsToSelector:@selector(view:willRemoveSubview:)]) {
        [_delegate view:self willRemoveSubview:subview];
    }
}

@end
