/*
SRSelectableImageCell.m

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "SRSelectableImageCell.h"

@implementation SRSelectableImageCell

//--------------------------------------------------------------//
#pragma mark --  NSCell methods --
//--------------------------------------------------------------//

 - (BOOL)isSelectable
 {
    return YES;
 }
 
 - (void)setState:(int)state
 {
    [super setState:state];
    
    if (state == NSOnState) {
        // Perform action
        [_target performSelector:_action withObject:self];
    }
 }
 
- (void)drawInteriorWithFrame:(NSRect)frame inView:(NSView*)controlView
{
    [super drawInteriorWithFrame:frame inView:controlView];
    
    if ([self state] == NSOnState) {
        static NSColor* _borderColor = nil;
        if (!_borderColor) {
            _borderColor = [[NSColor colorWithCalibratedRed:0.48f green:0.63f blue:0.77f alpha:1.0f] retain];
        }
        [_borderColor set];
        
        NSFrameRectWithWidth(frame, 1.7);
    }
}

//--------------------------------------------------------------//
#pragma mark --  Accessors --
//--------------------------------------------------------------//

- (id)target
{
    return _target;
}

- (void)setTarget:(id)target
{
    _target = target;
}

- (SEL)action
{
    return _action;
}

- (void)setAction:(SEL)action
{
    _action = action;
}

@end
