/*
SRProgressIndicator.m

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "SRProgressIndicator.h"

@implementation SRProgressIndicator

#pragma mark -
//--------------------------------------------------------------//
// Initialize
//--------------------------------------------------------------//

- (id)initWithFrame:(NSRect)frame
{
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    // Initialize instance variables
    _value = 0.0;
    _minValue = 0.0;
    _maxValue = 1.0;
    
    return self;
}

//--------------------------------------------------------------//
// Advancing
//--------------------------------------------------------------//

- (double)doubleValue
{
    return _value;
}

- (void)setDoubleValue:(double)value
{
    if (value < _minValue) {
        _value = _minValue;
    }
    else if (value > _maxValue) {
        _value = _maxValue;
    }
    else {
        _value = value;
    }
}

- (double)minValue;
{
    return _minValue;
}

- (void)setMinValue:(double)minValue
{
    if (minValue > _maxValue) {
        _minValue = _maxValue;
    }
    else {
        _minValue = minValue;
    }
    
    if (_value < _minValue) {
        _value = _minValue;
    }
}

- (double)maxValue;
{
    return _maxValue;
}

- (void)setMaxValue:(double)maxValue
{
    if (maxValue < _minValue) {
        _maxValue = _minValue;
    }
    else {
        _maxValue = maxValue;
    }
    
    if (_value > _maxValue) {
        _value = _maxValue;
    }
}

//--------------------------------------------------------------//
// Drawing
//--------------------------------------------------------------//

- (void)drawRect:(NSRect)frame
{
    // Inset frame of this view
    frame = NSInsetRect(frame, 1.5f, 1.5f);
    float   x, y, w, h;
    x = frame.origin.x;
    y = frame.origin.y;
    w = frame.size.width;
    h = frame.size.height;
    
    NSBezierPath*   path;
    
#if 0
    // Background
    path = [NSBezierPath bezierPath];
    [path moveToPoint:NSMakePoint(x + w/2 , y + h)];
    [path curveToPoint:NSMakePoint(x + w, y + h/2) 
            controlPoint1:NSMakePoint(x + w*3/4, y + h) 
            controlPoint2:NSMakePoint(x + w, y + h*3/4)];
    [path curveToPoint:NSMakePoint(x + w/2, y) 
            controlPoint1:NSMakePoint(x + w, y + h*1/4) 
            controlPoint2:NSMakePoint(x + w*3/4, y)];
    [path curveToPoint:NSMakePoint(x, y + h/2) 
            controlPoint1:NSMakePoint(x + w*1/4, y) 
            controlPoint2:NSMakePoint(x, y + h*1/4)];
    [path curveToPoint:NSMakePoint(x + w/2, y + h) 
            controlPoint1:NSMakePoint(x, y + h*3/4) 
            controlPoint2:NSMakePoint(x + w*1/4, y + h)];
    [[NSColor whiteColor] set];
    [path fill];
#endif

    // Foreground
    NSPoint center = { x + w/2, y + h/2 };
    
    float   endAngle;
    if (_maxValue == _minValue) {
        endAngle = 0.0;
    }
    else {
        float   ratio;
        ratio = ((_value - _minValue) / (_maxValue - _minValue));
        if (ratio < 0.25f) {
            endAngle = 90 - 360 * ratio;
        }
        else {
            endAngle = 450 - 360 * ratio; //360 - (360 * (ratio - 0.25));
        }
    }
    
    path = [NSBezierPath bezierPath];
    [path moveToPoint:center];
    [path lineToPoint:NSMakePoint(x + w/2, y + h)];
    [path appendBezierPathWithArcWithCenter:center 
            radius:w/2 
            startAngle:90.0f 
            endAngle:endAngle
     clockwise:YES];
    [path lineToPoint:center];
    
    static NSColor* _progressColorAqua = nil;
    static NSColor* _progressColorMetal = nil;
    if (!_progressColorAqua) {
        _progressColorAqua = [[NSColor colorWithDeviceRed:0.0f green:0.0f blue:1.0f alpha:0.4f] retain];
        _progressColorMetal = [[NSColor colorWithDeviceRed:1.0f green:1.0f blue:1.0f alpha:0.5f] retain];
    }
    if ([[self window] styleMask] & NSTexturedBackgroundWindowMask) {
        [_progressColorMetal set];
    }
    else {
        [_progressColorAqua set];
    }
    
    [path fill];
}

@end
