/*
SRContextButton.m

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "SRContextButton.h"

@implementation SRContextButton

- (void)mouseDown:(NSEvent*)event
{
    // Check delegate
    if (!delegate || ![delegate respondsToSelector:@selector(contextButton:menuForEvent:)]) {
        [super mouseDown:event];
        return;
    }
    
    // Get menu
    NSMenu* menu;
    menu = [delegate contextButton:self menuForEvent:event];
    if (!menu) {
        [super mouseDown:event];
        return;
    }
    
    // Make itself highlighted
    [[self cell] setHighlighted:YES];
    
    // Create event
    if (_eventForMenu) {
        [_eventForMenu release];
    }
    
    NSView* contentView;
    NSPoint point;
    contentView = [[self window] contentView];
    point = [contentView convertPoint:[self frame].origin fromView:self];
    if ([contentView isFlipped]) {
        point.y = [contentView frame].size.height - point.y;
    }
    //point.y = [[[self window] contentView] frame].size.height - point.y;
    
    _eventForMenu = [[NSEvent mouseEventWithType:[event type] 
            location:[event locationInWindow] 
            //location:point 
            modifierFlags:[event modifierFlags] 
            timestamp:[event timestamp] 
            windowNumber:[event windowNumber] 
            context:[event context] 
            eventNumber:[event eventNumber] 
            clickCount:[event clickCount] 
            pressure:[event pressure]] retain];
    
    // Register notification
    [[NSNotificationCenter defaultCenter] 
            addObserver:self 
            selector:@selector(menuDidEnedTracking:) 
            name:NSMenuDidEndTrackingNotification 
            object:menu];
    
    // Show popup
    [NSMenu popUpContextMenu:menu withEvent:_eventForMenu forView:self];
}

- (void)menuDidEnedTracking:(NSNotification*)notification
{
    // Clear highlight
    [[self cell] setHighlighted:NO];
    
    // Release event
    if (_eventForMenu) {
        [_eventForMenu release];
    }
    _eventForMenu = nil;
}

@end
