/*
SRObjRuntime.m

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "SRObjcRuntime.h"

void SRPoseAsClass(
        Class klass, NSString* superClassName, NSString* newClassName)
{
    NSAutoreleasePool*  pool;
    pool = [[NSAutoreleasePool alloc] init];
    
    struct objc_class*  newClass;
    struct objc_class*  rootClass;
    struct objc_class*  superClass;
    struct objc_class*  metaClass;
    
    // Get super class
    superClass = (struct objc_class*)objc_lookUpClass([superClassName cString]);
    if (!superClass) {
        // Error
        NSLog(@"Can't find class %@", superClassName);
        return;
    }
    
    // Check specified new class is not existed
    if (objc_lookUpClass([newClassName cString])) {
        // Error
        NSLog(@"Class %@ is already existed", newClassName);
        return;
    }
    
    // Get root class
    rootClass = superClass;
    while (rootClass->super_class != nil) {
        rootClass = rootClass->super_class;
    }
    
    // Allocate memory for new class
    newClass = calloc(2, sizeof(struct objc_class));
    metaClass = &newClass[1];
    
    // Setup class
    newClass->isa = metaClass;
    newClass->info = CLS_CLASS;
    metaClass->info = CLS_META;
    newClass->name = [newClassName cString];
    metaClass->name = newClass->name;
    
    // Setup methods
    newClass->methodLists = calloc(1, sizeof(struct objc_method_list*));
    metaClass->methodLists = calloc(1, sizeof(struct objc_method_list*));
    
    void*   iterator = 0;
    struct objc_method_list*    methodList;
    
    // Add instance methods
    methodList = class_nextMethodList(klass, &iterator);
    while (methodList != NULL) {
        class_addMethods(newClass, methodList);
        methodList = class_nextMethodList(klass, &iterator);
    }
    
    // Add class methods
    methodList = class_nextMethodList([klass class]->isa, &iterator);
    while (methodList != NULL) {
        class_addMethods(metaClass, methodList);
        methodList = class_nextMethodList(klass, &iterator);
    }
    
    // Setup super class
    newClass->super_class = superClass;
    metaClass->super_class = superClass->isa;
    metaClass->isa = (void*)rootClass->isa;
    
    newClass->instance_size = superClass->instance_size;
    newClass->ivars = NULL;
    metaClass->instance_size = metaClass->super_class->instance_size;
    metaClass->ivars = NULL;
    
    // Register new class
    objc_addClass(newClass);
    
    // Pose as WebViewImage
    class_poseAs(newClass, superClass);
    
    [pool release];
}
