/*
SRRSSManager.h

Author: Makoto Kinoshita

Copyright 2004 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>
#import <WebKit/WebKit.h>
#import "SRError.h"

// Notifications
extern NSString*    SRRSSWillStartRefresh;
extern NSString*    SRRSSProgressRefresh;
extern NSString*    SRRSSDidEndRefresh;
extern NSString*    SRRSSItemsRemovedAll;
extern NSString*    SRRSSItemsPreviewed;
extern NSString*    SRRSSFeedsDidChanged;

@class SRBookmark;

@interface SRRSSManager : NSObject
{
    BOOL                    _isSyndicationWorking;
    int                     _newComingArticles;
    
    NSMutableArray*         _RSSChannels;
    NSMutableArray*         _RSSItems;
    NSMutableArray*         _notUpdateFeeds;
    
    NSMutableDictionary*    _cachedChannelDict;
    
    NSTask*                 _RSSTask;
    NSTimer*                _updateTimer;
}

// Initialzie
+ (SRRSSManager*)sharedInstance;

// Application support folder
+ (NSString*)feedsFolderPath;
+ (NSString*)feedsFilePath;
+ (NSString*)notUpdateFeedsFilePath;

// RSS syndication
- (BOOL)isRSSSyndicationWorking;
- (void)launchRSSSyndicationWithArguments:(NSArray*)arguments;
- (void)refreshFeeds:(NSArray*)feedURLs;
- (void)refreshAllFeeds;
- (void)stopRefresh;
- (void)deleteAllItems;
- (void)terminateRSSSyndication;

// RSS channels and items
- (NSMutableArray*)channels;
- (NSMutableArray*)items;
+ (NSMutableDictionary*)channelWithDocumentIdentifier:(NSString*)identifier channels:(NSArray*)channels;
- (NSMutableDictionary*)channelWithDocumentIdentifier:(NSString*)identifier;
+ (NSMutableDictionary*)itemWithItemIdentifier:(NSString*)identifier channel:(NSDictionary*)channel;
- (NSMutableDictionary*)itemWithLink:(NSString*)link items:(NSArray*)items;
- (void)makeItemsPreviewed:(NSArray*)items;
- (NSMutableArray*)notUpdateFeeds;

- (NSMutableDictionary*)channelWithDocumentId:(NSString*)documentId;
- (NSMutableDictionary*)itemWithItemId:(NSString*)itemId documentId:(NSString*)documentId;

+ (int)numberOfNotPreviewedImtesWithChannel:(NSDictionary*)channel;
- (int)numberOfNotPreviewedItems;
- (int)numberOfNewComingArticles;

// Persistence
- (void)reloadFeeds;
- (void)saveFeeds;
- (void)loadNotUpdateFeeds;
- (void)seveNotUpdateFeeds;

// RSS auto update
- (void)restartUpdateTimer;
- (void)cancelUpdateTimer;

@end
